/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRQueryChunk;
import net.sf.jasperreports.engine.base.JRBaseQuery;
import net.sf.jasperreports.engine.design.JRDesignQueryChunk;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import net.sf.jasperreports.engine.util.JRQueryChunkHandler;
import net.sf.jasperreports.engine.util.JRQueryParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRDesignQuery
extends JRBaseQuery
implements JRChangeEventsSupport {
    private transient JRPropertyChangeSupport eventSupport;
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_LANGUAGE = "language";
    public static final String PROPERTY_TEXT = "text";
    protected List<JRQueryChunk> chunks = new ArrayList<JRQueryChunk>();
    private final transient JRQueryChunkHandler chunkAdder = new JRQueryChunkHandler(){

        public void handleParameterChunk(String text) {
            JRDesignQuery.this.addParameterChunk(text);
        }

        public void handleParameterClauseChunk(String text) {
            JRDesignQuery.this.addParameterClauseChunk(text);
        }

        public void handleTextChunk(String text) {
            JRDesignQuery.this.addTextChunk(text);
        }

        public void handleClauseChunk(String[] tokens) {
            JRDesignQuery.this.addClauseChunk(tokens);
        }
    };

    @Override
    public JRQueryChunk[] getChunks() {
        JRQueryChunk[] chunkArray = null;
        if (this.chunks != null && this.chunks.size() > 0) {
            chunkArray = new JRQueryChunk[this.chunks.size()];
            this.chunks.toArray(chunkArray);
        }
        return chunkArray;
    }

    public void setChunks(List<JRQueryChunk> chunks) {
        this.chunks = chunks;
    }

    public void addChunk(JRDesignQueryChunk chunk) {
        this.chunks.add(chunk);
    }

    public void addTextChunk(String text) {
        JRDesignQueryChunk chunk = new JRDesignQueryChunk();
        chunk.setType((byte)1);
        chunk.setText(text);
        this.chunks.add(chunk);
    }

    public void addParameterChunk(String text) {
        JRDesignQueryChunk chunk = new JRDesignQueryChunk();
        chunk.setType((byte)2);
        chunk.setText(text);
        this.chunks.add(chunk);
    }

    public void addParameterClauseChunk(String text) {
        JRDesignQueryChunk chunk = new JRDesignQueryChunk();
        chunk.setType((byte)3);
        chunk.setText(text);
        this.chunks.add(chunk);
    }

    public void addClauseChunk(String[] tokens) {
        JRDesignQueryChunk chunk = new JRDesignQueryChunk();
        chunk.setType((byte)4);
        chunk.setTokens(tokens);
        this.chunks.add(chunk);
    }

    public void setText(String text) {
        String old = this.getText();
        this.chunks = new ArrayList<JRQueryChunk>();
        JRQueryParser.instance().parse(text, this.chunkAdder);
        this.getEventSupport().firePropertyChange(PROPERTY_TEXT, old, this.getText());
    }

    public void setLanguage(String language) {
        String oldValue = this.language;
        this.language = language;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_LANGUAGE, oldValue, this.language);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        JRDesignQuery jRDesignQuery = this;
        synchronized (jRDesignQuery) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    protected PropertyChangeSupport getPropertyChangeSupport() {
        return this.getEventSupport();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPropertyChangeSupport().addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String propName, PropertyChangeListener l) {
        this.getPropertyChangeSupport().addPropertyChangeListener(propName, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.getPropertyChangeSupport().removePropertyChangeListener(l);
    }

    public void removePropertyChangeListener(String propName, PropertyChangeListener l) {
        this.getPropertyChangeSupport().removePropertyChangeListener(propName, l);
    }

    @Override
    public Object clone() {
        JRDesignQuery clone = (JRDesignQuery)super.clone();
        clone.chunks = JRCloneUtils.cloneList(this.chunks);
        clone.eventSupport = null;
        return clone;
    }
}

