/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxFontInfo;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.util.JRFontUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XlsxFontHelper
extends BaseHelper {
    private Map<String, Integer> fontCache = new HashMap<String, Integer>();
    private Map<String, String> fontMap;
    private String exporterKey;
    private boolean isFontSizeFixEnabled;

    public XlsxFontHelper(Writer writer, Map<String, String> fontMap, String exporterKey, boolean isFontSizeFixEnabled) {
        super(writer);
        this.fontMap = fontMap;
        this.exporterKey = exporterKey;
        this.isFontSizeFixEnabled = isFontSizeFixEnabled;
    }

    public int getFont(JRExporterGridCell gridCell, Locale locale) {
        Object fontInfo;
        JRFont font;
        JRFont jRFont = font = gridCell.getElement() instanceof JRFont ? (JRFont)((Object)gridCell.getElement()) : null;
        if (font == null) {
            return -1;
        }
        String fontName = font.getFontName();
        if (this.fontMap != null && this.fontMap.containsKey(fontName)) {
            fontName = this.fontMap.get(fontName);
        } else {
            FontFamily family;
            String exportFont;
            fontInfo = JRFontUtil.getFontInfo(fontName, locale);
            if (fontInfo != null && (exportFont = (family = ((FontInfo)fontInfo).getFontFamily()).getExportFont(this.exporterKey)) != null) {
                fontName = exportFont;
            }
        }
        fontInfo = new XlsxFontInfo(gridCell, fontName);
        Integer fontIndex = this.fontCache.get(((XlsxFontInfo)fontInfo).getId());
        if (fontIndex == null) {
            fontIndex = this.fontCache.size();
            this.export((XlsxFontInfo)fontInfo);
            this.fontCache.put(((XlsxFontInfo)fontInfo).getId(), fontIndex);
        }
        return fontIndex;
    }

    private void export(XlsxFontInfo fontInfo) {
        this.write("<font><sz val=\"" + (this.isFontSizeFixEnabled ? fontInfo.fontSize - 1 : fontInfo.fontSize) + "\"/>" + "<color rgb=\"" + fontInfo.color + "\"/>" + "<name val=\"" + fontInfo.fontName + "\"/>" + "<b val=\"" + fontInfo.isBold + "\"/>" + "<i val=\"" + fontInfo.isItalic + "\"/>" + "<u val=\"" + (fontInfo.isUnderline ? "single" : "none") + "\"/>" + "<strike val=\"" + fontInfo.isStrikeThrough + "\"/>" + "<family val=\"2\"/></font>\n");
    }
}

