/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.servlets;

import java.awt.Dimension;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRTypeSniffer;
import net.sf.jasperreports.web.WebReportContext;

public class ImageServlet
extends HttpServlet {
    private static final long serialVersionUID = 10200L;
    public static final String REQUEST_PARAMETER_IMAGE_NAME = "image";

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        byte[] imageData = null;
        String imageMimeType = null;
        String imageName = request.getParameter(REQUEST_PARAMETER_IMAGE_NAME);
        if ("px".equals(imageName)) {
            try {
                JRRenderable pxRenderer = JRImageRenderer.getInstance("net/sf/jasperreports/engine/images/pixel.GIF");
                imageData = pxRenderer.getImageData();
                imageMimeType = "image/gif";
            }
            catch (JRException e) {
                throw new ServletException((Throwable)e);
            }
        }
        WebReportContext webReportContext = WebReportContext.getInstance(request, false);
        if (webReportContext == null) {
            throw new ServletException("No web report context found.");
        }
        JasperPrint jasperPrint = (JasperPrint)webReportContext.getParameterValue("net.sf.jasperreports.web.jasper_print");
        if (jasperPrint == null) {
            throw new ServletException("No JasperPrint found in report context.");
        }
        List<JasperPrint> jasperPrintList = Collections.singletonList(jasperPrint);
        JRPrintImage image = JRHtmlExporter.getImage(jasperPrintList, imageName);
        JRRenderable renderer = image.getRenderer();
        if (renderer.getType() == 1) {
            renderer = new JRWrappingSvgRenderer(renderer, new Dimension(image.getWidth(), image.getHeight()), ModeEnum.OPAQUE == image.getModeValue() ? image.getBackcolor() : null);
        }
        imageMimeType = JRTypeSniffer.getImageMimeType(renderer.getImageType());
        try {
            imageData = renderer.getImageData();
        }
        catch (JRException e) {
            throw new ServletException((Throwable)e);
        }
        if (imageData != null && imageData.length > 0) {
            if (imageMimeType != null) {
                response.setHeader("Content-Type", imageMimeType);
            }
            response.setContentLength(imageData.length);
            ServletOutputStream ouputStream = response.getOutputStream();
            ouputStream.write(imageData, 0, imageData.length);
            ouputStream.flush();
            ouputStream.close();
        }
    }
}

