/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.Store;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DiskStore
implements Store {
    private static final Log LOG = LogFactory.getLog((String)(class$net$sf$ehcache$store$DiskStore == null ? (class$net$sf$ehcache$store$DiskStore = DiskStore.class$("net.sf.ehcache.store.DiskStore")) : class$net$sf$ehcache$store$DiskStore).getName());
    private static final int MS_PER_SECOND = 1000;
    private final String name;
    private boolean active;
    private RandomAccessFile randomAccessFile;
    private HashMap diskElements;
    private ArrayList freeSpace;
    private final Map spool;
    private Thread spoolThread;
    private Thread expiryThread;
    private long expiryThreadInterval;
    private final Cache cache;
    private final boolean persistent;
    private final String diskPath;
    private File dataFile;
    private File indexFile;
    private int status = 1;
    private long totalSize;
    static /* synthetic */ Class class$net$sf$ehcache$store$DiskStore;

    public DiskStore(Cache cache, String diskPath) {
        this.cache = cache;
        this.name = cache.getName();
        this.diskPath = diskPath;
        this.diskElements = new HashMap();
        this.freeSpace = new ArrayList();
        this.spool = new HashMap();
        this.expiryThreadInterval = cache.getDiskExpiryThreadIntervalSeconds();
        this.persistent = cache.isDiskPersistent();
        try {
            this.initialiseFiles();
            this.active = true;
            this.spoolThread = new SpoolThread();
            this.spoolThread.start();
            if (!cache.isEternal()) {
                this.expiryThread = new ExpiryThread();
                this.expiryThread.start();
            }
            this.status = 2;
        }
        catch (Exception e) {
            this.dispose();
            LOG.error((Object)(this.name + "Cache: Could not create disk store"), (Throwable)e);
        }
    }

    private void initialiseFiles() throws Exception {
        File diskDir = new File(this.diskPath);
        if (diskDir.exists() && !diskDir.isDirectory()) {
            throw new Exception("Store directory \"" + diskDir.getCanonicalPath() + "\" exists and is not a directory.");
        }
        if (!diskDir.exists() && !diskDir.mkdirs()) {
            throw new Exception("Could not create cache directory \"" + diskDir.getCanonicalPath() + "\".");
        }
        this.dataFile = new File(diskDir, this.getDataFileName());
        if (this.persistent) {
            this.indexFile = new File(diskDir, this.getIndexFileName());
            this.readIndex();
            if (this.diskElements == null) {
                LOG.debug((Object)("Index file dirty or empty. Deleting data file " + this.getDataFileName()));
                this.dataFile.delete();
            }
        } else {
            LOG.debug((Object)("Deleting data file " + this.getDataFileName()));
            this.dataFile.delete();
        }
        this.randomAccessFile = new RandomAccessFile(this.dataFile, "rw");
    }

    private void checkActive() throws CacheException {
        if (!this.active) {
            throw new CacheException(this.name + " Cache: The Disk store is not active.");
        }
    }

    public int getCacheType() {
        return 2;
    }

    public String getName() {
        return this.name;
    }

    public synchronized int getStatus() {
        return 2;
    }

    public synchronized Element get(Serializable key) throws IOException {
        try {
            this.checkActive();
            Element element = (Element)this.spool.remove(key);
            if (element != null) {
                element.updateAccessStatistics();
                return element;
            }
            DiskElement diskElement = (DiskElement)this.diskElements.get(key);
            if (diskElement == null) {
                return null;
            }
            this.randomAccessFile.seek(diskElement.position);
            byte[] buffer = new byte[diskElement.payloadSize];
            this.randomAccessFile.readFully(buffer);
            ByteArrayInputStream instr = new ByteArrayInputStream(buffer);
            ObjectInputStream objstr = new ObjectInputStream(instr);
            element = (Element)objstr.readObject();
            element.updateAccessStatistics();
            return element;
        }
        catch (Exception e) {
            LOG.error((Object)(this.name + "Cache: Could not read disk store element for key " + key), (Throwable)e);
            return null;
        }
    }

    public synchronized Element getQuiet(Serializable key) throws IOException {
        try {
            this.checkActive();
            Element element = (Element)this.spool.remove(key);
            if (element != null) {
                return element;
            }
            DiskElement diskElement = (DiskElement)this.diskElements.get(key);
            if (diskElement == null) {
                return null;
            }
            this.randomAccessFile.seek(diskElement.position);
            byte[] buffer = new byte[diskElement.payloadSize];
            this.randomAccessFile.readFully(buffer);
            ByteArrayInputStream instr = new ByteArrayInputStream(buffer);
            ObjectInputStream objstr = new ObjectInputStream(instr);
            element = (Element)objstr.readObject();
            return element;
        }
        catch (Exception e) {
            LOG.error((Object)(this.name + "Cache: Could not read disk store element for key " + key), (Throwable)e);
            return null;
        }
    }

    public synchronized Object[] getKeyArray() {
        Set elementKeySet = this.diskElements.keySet();
        Set spoolKeySet = this.spool.keySet();
        HashSet allKeysSet = new HashSet(elementKeySet.size() + spoolKeySet.size());
        allKeysSet.addAll(elementKeySet);
        allKeysSet.addAll(spoolKeySet);
        return allKeysSet.toArray();
    }

    public synchronized int getSize() {
        try {
            this.checkActive();
            return this.diskElements.size() + this.spool.size();
        }
        catch (Exception e) {
            LOG.error((Object)(this.name + "Cache: Could not determine size of disk store."), (Throwable)e);
            return 0;
        }
    }

    public synchronized void put(Element entry) throws IOException {
        try {
            this.checkActive();
            this.spool.put(entry.getKey(), entry);
            this.notifyAll();
        }
        catch (Exception e) {
            LOG.error((Object)(this.name + "Cache: Could not write disk store element for " + entry.getKey()), (Throwable)e);
        }
    }

    public synchronized boolean remove(Serializable key) throws IOException {
        try {
            this.checkActive();
            Object spoolValue = this.spool.remove(key);
            if (spoolValue != null) {
                return true;
            }
            DiskElement element = (DiskElement)this.diskElements.remove(key);
            if (element != null) {
                this.freeBlock(element);
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)(this.name + "Cache: Could not remove disk store entry for " + key), (Throwable)e);
        }
        return false;
    }

    private void freeBlock(DiskElement element) {
        this.totalSize -= (long)element.payloadSize;
        element.payloadSize = 0;
        this.freeSpace.add(element);
    }

    public synchronized void removeAll() throws IOException {
        try {
            this.checkActive();
            this.spool.clear();
            this.diskElements.clear();
            this.freeSpace.clear();
            this.totalSize = 0L;
            this.randomAccessFile.setLength(0L);
            if (this.persistent) {
                this.indexFile.delete();
                this.indexFile.createNewFile();
            }
        }
        catch (Exception e) {
            LOG.error((Object)(this.name + " Cache: Could not rebuild disk store"), (Throwable)e);
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        if (!this.active) {
            return;
        }
        try {
            block8: {
                try {
                    if (this.expiryThread != null) {
                        this.expiryThread.interrupt();
                    }
                    if (this.persistent) {
                        this.flushSpool();
                        this.writeIndex();
                    }
                    this.spool.clear();
                    this.diskElements.clear();
                    this.freeSpace.clear();
                    if (this.randomAccessFile != null) {
                        this.randomAccessFile.close();
                    }
                    if (this.persistent) break block8;
                    LOG.debug((Object)("Deleting file " + this.dataFile.getName()));
                    this.dataFile.delete();
                }
                catch (Exception e) {
                    LOG.error((Object)(this.name + "Cache: Could not shut down disk cache"), (Throwable)e);
                    Object var3_2 = null;
                    this.active = false;
                    this.randomAccessFile = null;
                    this.notifyAll();
                }
            }
            Object var3_1 = null;
            this.active = false;
            this.randomAccessFile = null;
            this.notifyAll();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.active = false;
            this.randomAccessFile = null;
            this.notifyAll();
            throw throwable;
        }
    }

    public synchronized boolean isSpoolEmpty() {
        return !this.active || this.spool.size() == 0;
    }

    private synchronized void spoolThreadMain() {
        while (true) {
            if (this.active && this.spool.size() == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            if (!this.active) {
                return;
            }
            try {
                this.flushSpool();
                continue;
            }
            catch (IOException e) {
                LOG.error((Object)(this.name + "Cache: Could not write elements to disk cache"), (Throwable)e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void flushSpool() throws IOException {
        try {
            Iterator iterator = this.spool.values().iterator();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                Serializable key = element.getKey();
                DiskElement oldBlock = (DiskElement)this.diskElements.remove(key);
                if (oldBlock != null) {
                    this.freeBlock(oldBlock);
                }
                ByteArrayOutputStream outstr = new ByteArrayOutputStream();
                ObjectOutputStream objstr = new ObjectOutputStream(outstr);
                objstr.writeObject(element);
                objstr.close();
                byte[] buffer = outstr.toByteArray();
                DiskElement diskElement = this.findFreeBlock(buffer.length);
                if (diskElement == null) {
                    diskElement = new DiskElement();
                    diskElement.position = this.randomAccessFile.length();
                    diskElement.blockSize = buffer.length;
                }
                this.randomAccessFile.seek(diskElement.position);
                this.randomAccessFile.write(buffer);
                if (this.cache.isEternal()) {
                    diskElement.expiryTime = Long.MAX_VALUE;
                } else {
                    long timeToLive = element.getCreationTime() + this.cache.getTimeToLiveSeconds() * 1000L;
                    long timeToIdle = element.getLastAccessTime() + this.cache.getTimeToIdleSeconds() * 1000L;
                    diskElement.expiryTime = Math.max(timeToLive, timeToIdle);
                }
                diskElement.payloadSize = buffer.length;
                this.totalSize += (long)buffer.length;
                this.diskElements.put(key, diskElement);
            }
        }
        finally {
            this.spool.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeIndex() throws IOException {
        ObjectOutputStream objectOutputStream = null;
        try {
            FileOutputStream fout = new FileOutputStream(this.indexFile);
            objectOutputStream = new ObjectOutputStream(fout);
            objectOutputStream.writeObject(this.diskElements);
            objectOutputStream.writeObject(this.freeSpace);
        }
        finally {
            objectOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private synchronized void readIndex() throws IOException {
        block29: {
            ObjectInputStream objectInputStream = null;
            FileInputStream fin = null;
            if (this.indexFile.exists()) {
                fin = new FileInputStream(this.indexFile);
                objectInputStream = new ObjectInputStream(fin);
                this.diskElements = (HashMap)objectInputStream.readObject();
                this.freeSpace = (ArrayList)objectInputStream.readObject();
                Object var5_3 = null;
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    } else if (fin != null) {
                        fin.close();
                    }
                }
                catch (IOException e2) {
                    LOG.error((Object)"Problem closing the index file.");
                }
                this.createNewIndexFile();
                {
                    break block29;
                    catch (StreamCorruptedException e) {
                        LOG.error((Object)"Corrupt index file. Creating new index.");
                        Object var5_4 = null;
                        try {
                            if (objectInputStream != null) {
                                objectInputStream.close();
                            } else if (fin != null) {
                                fin.close();
                            }
                        }
                        catch (IOException e2) {
                            LOG.error((Object)"Problem closing the index file.");
                        }
                        this.createNewIndexFile();
                        break block29;
                    }
                    catch (IOException e) {
                        LOG.error((Object)"IOException reading index. Creating new index. ");
                        Object var5_5 = null;
                        try {
                            if (objectInputStream != null) {
                                objectInputStream.close();
                            } else if (fin != null) {
                                fin.close();
                            }
                        }
                        catch (IOException e2) {
                            LOG.error((Object)"Problem closing the index file.");
                        }
                        this.createNewIndexFile();
                        break block29;
                    }
                    catch (ClassNotFoundException e) {
                        LOG.error((Object)"Class loading problem reading index. Creating new index. ", (Throwable)e);
                        Object var5_6 = null;
                        try {
                            if (objectInputStream != null) {
                                objectInputStream.close();
                            } else if (fin != null) {
                                fin.close();
                            }
                        }
                        catch (IOException e2) {
                            LOG.error((Object)"Problem closing the index file.");
                        }
                        this.createNewIndexFile();
                        break block29;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    try {
                        if (objectInputStream != null) {
                            objectInputStream.close();
                        } else if (fin != null) {
                            fin.close();
                        }
                    }
                    catch (IOException e2) {
                        LOG.error((Object)"Problem closing the index file.");
                    }
                    this.createNewIndexFile();
                    throw throwable;
                }
            }
            this.createNewIndexFile();
        }
    }

    private void createNewIndexFile() throws IOException {
        if (this.indexFile.exists()) {
            this.indexFile.delete();
            LOG.debug((Object)("Index file " + this.indexFile + " deleted."));
        }
        if (!this.indexFile.createNewFile()) {
            throw new IOException("Index file " + this.indexFile + " could not created.");
        }
        LOG.debug((Object)("Index file " + this.indexFile + " created successfully"));
    }

    private void expiryThreadMain() {
        block3: {
            long expiryThreadIntervalMillis = this.expiryThreadInterval * 1000L;
            try {
                while (this.active) {
                    Thread.sleep(expiryThreadIntervalMillis);
                    this.expireElements();
                }
            }
            catch (InterruptedException e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Object)(this.name + "Cache: Expiry thread interrupted on Disk Store."));
            }
        }
    }

    private synchronized void expireElements() {
        long now = System.currentTimeMillis();
        Iterator<Object> iterator = this.spool.values().iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (!this.cache.isExpired(element)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.name + "Cache: Removing expired spool element " + element.getKey() + " from Disk Store"));
            }
            iterator.remove();
        }
        iterator = this.diskElements.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            DiskElement element = (DiskElement)entry.getValue();
            if (now < element.expiryTime) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.name + "Cache: Removing expired spool element " + entry.getKey() + " from Disk Store"));
            }
            iterator.remove();
            this.freeBlock(element);
        }
    }

    private DiskElement findFreeBlock(int length) {
        for (int i = 0; i < this.freeSpace.size(); ++i) {
            DiskElement element = (DiskElement)this.freeSpace.get(i);
            if (element.blockSize < length) continue;
            this.freeSpace.remove(i);
            return element;
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ dataFile = ").append(this.dataFile.getAbsolutePath()).append(", active=").append(this.active).append(", totalSize=").append(this.totalSize).append(", status=").append(this.status).append(", expiryThreadInterval = ").append(this.expiryThreadInterval).append(" ]");
        return sb.toString();
    }

    public long getTotalFileSize() {
        return this.getDataFileSize() + this.getIndexFileSize();
    }

    public long getDataFileSize() {
        return this.dataFile.length();
    }

    public float calculateDataFileSparseness() {
        return 1.0f - (float)this.getUsedDataSize() / (float)this.getDataFileSize();
    }

    public long getUsedDataSize() {
        return this.totalSize;
    }

    public long getIndexFileSize() {
        if (this.indexFile == null) {
            return 0L;
        }
        return this.indexFile.length();
    }

    public String getDataFileName() {
        return this.name + ".data";
    }

    public String getDataFilePath() {
        return this.diskPath;
    }

    public String getIndexFileName() {
        return this.name + ".index";
    }

    public boolean isExpiryThreadAlive() {
        if (this.expiryThread == null) {
            return false;
        }
        return this.expiryThread.isAlive();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ExpiryThread
    extends Thread {
        public ExpiryThread() {
            super("Store " + DiskStore.this.name + " Expiry Thread");
            this.setDaemon(true);
        }

        public void run() {
            DiskStore.this.expiryThreadMain();
        }
    }

    private class SpoolThread
    extends Thread {
        public SpoolThread() {
            super("Store " + DiskStore.this.name + " Spool Thread");
            this.setDaemon(true);
        }

        public void run() {
            DiskStore.this.spoolThreadMain();
        }
    }

    private static class DiskElement
    implements Serializable {
        private long position;
        private int payloadSize;
        private int blockSize;
        private long expiryTime;

        private DiskElement() {
        }
    }
}

