/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.map;

import com.jaspersoft.ireport.components.map.MapIcon;
import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.widgets.JRDesignElementWidget;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import net.sf.jasperreports.components.map.StandardMapComponent;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignElement;

public class MapComponentWidget
extends JRDesignElementWidget {
    private MapIcon mapIcon = null;

    public MapComponentWidget(AbstractReportObjectScene scene, JRDesignElement element) {
        super(scene, element);
        if (((JRDesignComponentElement)element).getComponent() instanceof StandardMapComponent) {
            StandardMapComponent c = (StandardMapComponent)((JRDesignComponentElement)element).getComponent();
            c.getEventSupport().addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("latitudeExpression") || evt.getPropertyName().equals("longitudeExpression") || evt.getPropertyName().equals("zoomExpression")) {
            this.updateBounds();
            this.repaint();
            this.revalidate(true);
            this.getSelectionWidget().updateBounds();
            this.getSelectionWidget().revalidate(true);
            this.getScene().validate();
        }
        super.propertyChange(evt);
    }

    protected void paintWidgetImplementation() {
        if (this.mapIcon == null && ((JRDesignComponentElement)this.getElement()).getComponent() instanceof StandardMapComponent) {
            this.mapIcon = new MapIcon();
        }
        if (this.mapIcon != null && this.mapIcon.getIcon(200) != null) {
            Graphics2D gr = this.getScene().getGraphics();
            Rectangle r = this.getPreferredBounds();
            AffineTransform af = gr.getTransform();
            AffineTransform new_af = (AffineTransform)af.clone();
            AffineTransform translate = AffineTransform.getTranslateInstance(this.getBorder().getInsets().left + r.x, this.getBorder().getInsets().top + r.y);
            new_af.concatenate(translate);
            gr.setTransform(new_af);
            JRDesignElement e = this.getElement();
            Shape oldClip = gr.getClip();
            Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, e.getWidth(), e.getHeight());
            gr.clip(rect);
            gr.setPaint(new GradientPaint(0.0f, e.getHeight(), new Color(255, 255, 255, 63), e.getWidth(), 0.0f, new Color(200, 200, 200, 63)));
            gr.fillRect(0, 0, e.getWidth(), e.getHeight());
            if (e.getWidth() > 10) {
                Image img_to_paint = this.mapIcon.getIcon(Math.min(this.mapIcon.getIcon().getIconWidth(), e.getWidth()), Math.min(this.mapIcon.getIcon().getIconHeight(), e.getHeight())).getImage();
                Composite oldComposite = gr.getComposite();
                gr.setComposite(AlphaComposite.getInstance(3, 0.5f));
                try {
                    gr.drawImage(img_to_paint, e.getWidth() / 2 - img_to_paint.getWidth(null) / 2, e.getHeight() / 2 - img_to_paint.getHeight(null) / 2, null);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                gr.setComposite(oldComposite);
            }
            gr.setClip(oldClip);
            gr.setTransform(af);
        }
    }
}

