/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.xam;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.UndoableEditListener;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.dom.DocumentModelAccess;
import org.netbeans.modules.xml.xam.dom.ElementIdentity;
import org.netbeans.modules.xml.xdm.XDMModel;
import org.netbeans.modules.xml.xdm.diff.NodeInfo;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.NodeImpl;
import org.netbeans.modules.xml.xdm.nodes.Token;
import org.netbeans.modules.xml.xdm.visitor.NodeByPositionVisitor;
import org.netbeans.modules.xml.xdm.visitor.PathFromRootVisitor;
import org.netbeans.modules.xml.xdm.visitor.PositionFinderVisitor;
import org.netbeans.modules.xml.xdm.visitor.XPathFinder;
import org.netbeans.modules.xml.xdm.xam.XDMListener;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XDMAccess
extends DocumentModelAccess {
    private XDMModel xdmModel;
    private AbstractDocumentModel model;
    private XDMListener xdmListener;

    public XDMAccess(AbstractDocumentModel abstractDocumentModel) {
        this.xdmModel = new XDMModel(abstractDocumentModel.getModelSource());
        this.xdmModel.setPretty(true);
        this.model = abstractDocumentModel;
        this.xdmListener = new XDMListener(this.model);
        this.xdmModel.setQNameValuedAttributes(abstractDocumentModel.getQNameValuedAttributes());
    }

    public org.w3c.dom.Document getDocumentRoot() {
        return this.getReferenceModel().getCurrentDocument();
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.xdmModel.removeUndoableEditListener(undoableEditListener);
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.xdmModel.addUndoableEditListener(undoableEditListener);
    }

    public AbstractDocumentModel getModel() {
        return this.model;
    }

    public XDMModel getReferenceModel() {
        return this.xdmModel;
    }

    public void flush() {
        this.xdmModel.flush();
    }

    public void prepareForUndoRedo() {
        this.xdmListener.startSync();
    }

    public void finishUndoRedo() {
        this.xdmListener.endSync();
    }

    public void prepareSync() {
        this.xdmModel.prepareSync();
    }

    public Model.State sync() throws IOException {
        if (this.model.getRootComponent() == null) {
            this.xdmModel.sync();
            if (this.xdmModel.getStatus() == XDMModel.Status.STABLE) {
                org.netbeans.modules.xml.xdm.nodes.Element element = (org.netbeans.modules.xml.xdm.nodes.Element)org.netbeans.modules.xml.xdm.nodes.Element.class.cast(this.xdmModel.getDocument().getDocumentElement());
                if (element == null) {
                    throw new IOException("Cannot create model from non-XML document");
                }
                if (this.model.createRootComponent((Element)element) == null) {
                    throw new IOException("Cannot create model with " + new QName(element.getNamespaceURI(), element.getLocalName()));
                }
            }
        } else {
            boolean bl = true;
            try {
                this.xdmListener.startSync();
                this.xdmModel.sync();
                bl = false;
                this.xdmListener.endSync();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                IOException iOException = new IOException();
                iOException.initCause(illegalArgumentException);
                throw iOException;
            }
            finally {
                if (bl) {
                    this.xdmListener.endSync(false);
                }
            }
        }
        return this.xdmModel.getStatus() == XDMModel.Status.STABLE ? Model.State.VALID : Model.State.NOT_WELL_FORMED;
    }

    public boolean areSameNodes(org.w3c.dom.Node node, org.w3c.dom.Node node2) {
        if (!(node instanceof NodeImpl) || !(node2 instanceof NodeImpl)) {
            return false;
        }
        NodeImpl nodeImpl = (NodeImpl)node;
        NodeImpl nodeImpl2 = (NodeImpl)node2;
        boolean bl = nodeImpl.isEquivalentNode(nodeImpl2);
        return bl;
    }

    private boolean compareTokens(NodeImpl nodeImpl, NodeImpl nodeImpl2) {
        List<Token> list = nodeImpl.getTokens();
        List<Token> list2 = nodeImpl2.getTokens();
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getValue().equals(list2.get(i).getValue())) continue;
            return false;
        }
        NamedNodeMap namedNodeMap = nodeImpl.getAttributes();
        NamedNodeMap namedNodeMap2 = nodeImpl2.getAttributes();
        if (namedNodeMap.getLength() != namedNodeMap2.getLength()) {
            return false;
        }
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            List<Token> list3 = ((NodeImpl)namedNodeMap.item(i)).getTokens();
            List<Token> list4 = ((NodeImpl)namedNodeMap2.item(i)).getTokens();
            if (list3.size() != list4.size()) {
                return false;
            }
            for (int j = 0; j < list3.size(); ++j) {
                if (list3.get(j).getValue().equals(list4.get(j).getValue())) continue;
                return false;
            }
        }
        return true;
    }

    public int getElementIndexOf(org.w3c.dom.Node node, Element element) {
        if (element == null) {
            return -1;
        }
        int n = -1;
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            org.w3c.dom.Node node2 = node.getChildNodes().item(i);
            if (!(node2 instanceof org.netbeans.modules.xml.xdm.nodes.Element)) continue;
            ++n;
            if (!this.areSameNodes(node2, element)) continue;
            return n;
        }
        return -1;
    }

    private boolean noMutations() {
        return this.model.inSync() && !this.model.startedFiringEvents() || this.model.inUndoRedo();
    }

    public void setAttribute(Element element, String string, String string2, DocumentModelAccess.NodeUpdater nodeUpdater) {
        if (this.noMutations()) {
            return;
        }
        if (element instanceof Node) {
            org.netbeans.modules.xml.xdm.nodes.Element element2 = (org.netbeans.modules.xml.xdm.nodes.Element)element;
            if (element2.isInTree()) {
                nodeUpdater.updateReference(this.xdmModel.setAttribute(element2, string, string2));
            } else {
                element2.setAttribute(string, string2);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void removeAttribute(Element element, String string, DocumentModelAccess.NodeUpdater nodeUpdater) {
        if (this.noMutations()) {
            return;
        }
        if (element instanceof Node) {
            org.netbeans.modules.xml.xdm.nodes.Element element2 = (org.netbeans.modules.xml.xdm.nodes.Element)element;
            if (element2.isInTree()) {
                nodeUpdater.updateReference(this.xdmModel.removeAttribute(element2, string));
            } else {
                element2.removeAttribute(string);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void appendChild(org.w3c.dom.Node node, org.w3c.dom.Node node2, DocumentModelAccess.NodeUpdater nodeUpdater) {
        if (this.noMutations()) {
            return;
        }
        if (node instanceof Node && node2 instanceof Node) {
            Node node3 = (Node)node;
            if (node3.isInTree()) {
                nodeUpdater.updateReference(this.xdmModel.append(node3, (Node)node2));
            } else {
                node3.appendChild(node2);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void insertBefore(org.w3c.dom.Node node, org.w3c.dom.Node node2, org.w3c.dom.Node node3, DocumentModelAccess.NodeUpdater nodeUpdater) {
        if (this.noMutations()) {
            return;
        }
        if (node instanceof Node && node2 instanceof Node && node3 instanceof Node) {
            Node node4 = (Node)node;
            if (node4.isInTree()) {
                nodeUpdater.updateReference(this.xdmModel.insertBefore(node4, (Node)node2, (Node)node3));
            } else {
                node4.insertBefore(node2, node3);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void removeChild(org.w3c.dom.Node node, org.w3c.dom.Node node2, DocumentModelAccess.NodeUpdater nodeUpdater) {
        if (this.noMutations()) {
            return;
        }
        if (node instanceof Node && node2 instanceof Node) {
            Node node3 = (Node)node;
            if (node3.isInTree()) {
                nodeUpdater.updateReference(this.xdmModel.remove(node3, (Node)node2));
            } else {
                node3.removeChild(node2);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void removeChildren(org.w3c.dom.Node node, Collection<org.w3c.dom.Node> collection, DocumentModelAccess.NodeUpdater nodeUpdater) {
        if (this.noMutations()) {
            return;
        }
        if (node instanceof Node) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (org.w3c.dom.Node object : collection) {
                if (object instanceof Node) {
                    arrayList.add((Node)object);
                    continue;
                }
                throw new IllegalArgumentException();
            }
            Node node2 = (Node)node;
            if (node2.isInTree()) {
                nodeUpdater.updateReference(this.xdmModel.removeChildNodes(node2, arrayList));
            } else {
                for (Node node3 : arrayList) {
                    node2.removeChild(node3);
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void replaceChild(org.w3c.dom.Node node, org.w3c.dom.Node node2, org.w3c.dom.Node node3, DocumentModelAccess.NodeUpdater nodeUpdater) {
        if (this.noMutations()) {
            return;
        }
        Node node4 = (Node)node;
        if (node4.isInTree()) {
            nodeUpdater.updateReference(this.xdmModel.replaceChild(node4, (Node)node2, (Node)node3));
        } else {
            node4.replaceChild(node3, node2);
        }
    }

    public void setText(Element element, String string, DocumentModelAccess.NodeUpdater nodeUpdater) {
        if (this.noMutations()) {
            return;
        }
        org.netbeans.modules.xml.xdm.nodes.Element element2 = (org.netbeans.modules.xml.xdm.nodes.Element)element;
        if (element2.isInTree()) {
            nodeUpdater.updateReference(this.xdmModel.setTextValue(element2, string));
        } else {
            while (element2.hasChildNodes()) {
                element2.removeChild(element2.getLastChild());
            }
            element2.appendChild(this.xdmModel.getCurrentDocument().createTextNode(string));
        }
    }

    public String getXmlFragment(Element element) {
        if (element instanceof org.netbeans.modules.xml.xdm.nodes.Element) {
            org.netbeans.modules.xml.xdm.nodes.Element element2 = (org.netbeans.modules.xml.xdm.nodes.Element)element;
            return element2.getXmlFragmentText();
        }
        throw new IllegalArgumentException();
    }

    public void setXmlFragment(Element element, String string, DocumentModelAccess.NodeUpdater nodeUpdater) throws IOException {
        if (this.noMutations()) {
            return;
        }
        org.netbeans.modules.xml.xdm.nodes.Element element2 = (org.netbeans.modules.xml.xdm.nodes.Element)element;
        if (element2.isInTree()) {
            nodeUpdater.updateReference(this.xdmModel.setXmlFragmentText(element2, string));
        } else {
            element2.setXmlFragmentText(string);
        }
    }

    public void setPrefix(Element element, String string) {
        if (this.noMutations()) {
            return;
        }
        org.netbeans.modules.xml.xdm.nodes.Element element2 = (org.netbeans.modules.xml.xdm.nodes.Element)element;
        if (!element2.isInTree()) {
            element2.setPrefix(string);
        }
    }

    public int findPosition(org.w3c.dom.Node node) {
        return new PositionFinderVisitor().findPosition(this.xdmModel.getDocument(), (Node)node);
    }

    public org.netbeans.modules.xml.xdm.nodes.Element getContainingElement(int n) {
        try {
            return new NodeByPositionVisitor(this.xdmModel.getDocument()).getContainingElement(n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Element duplicate(Element element) {
        return (Element)((Object)((org.netbeans.modules.xml.xdm.nodes.Element)element).copy());
    }

    public Map<QName, String> getAttributeMap(Element element) {
        AttributeMap<QName, String> attributeMap = new AttributeMap<QName, String>();
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attribute attribute = (Attribute)namedNodeMap.item(i);
            if (attribute.isXmlnsAttribute()) continue;
            QName qName = AbstractDocumentComponent.getQName((org.w3c.dom.Node)attribute);
            ((AttributeMap)attributeMap).addKey(qName);
            attributeMap.put(qName, attribute.getValue());
        }
        return attributeMap;
    }

    public List<Element> getPathFromRoot(org.w3c.dom.Document document, Element element) {
        List<Node> list = new PathFromRootVisitor().findPath(document, element);
        if (list == null) {
            return null;
        }
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Node node : list) {
            if (!(node instanceof org.netbeans.modules.xml.xdm.nodes.Element)) break;
            arrayList.add(0, (org.netbeans.modules.xml.xdm.nodes.Element)node);
        }
        return arrayList;
    }

    public String getXPath(org.w3c.dom.Document document, Element element) {
        return XPathFinder.getXpath((Document)document, (Node)((Object)element));
    }

    public org.w3c.dom.Node findNode(org.w3c.dom.Document document, String string) {
        return new XPathFinder().findNode((Document)document, string);
    }

    public List<org.w3c.dom.Node> findNodes(org.w3c.dom.Document document, String string) {
        return XDMListener.toDomNodes(new XPathFinder().findNodes((Document)document, string));
    }

    public XDMModel getXDMModel() {
        return this.xdmModel;
    }

    public ElementIdentity getElementIdentity() {
        return this.getXDMModel().getElementIdentity();
    }

    public void addMergeEventHandler(PropertyChangeListener propertyChangeListener) {
        this.xdmModel.addPropertyChangeListener(propertyChangeListener);
    }

    public void removeMergeEventHandler(PropertyChangeListener propertyChangeListener) {
        this.xdmModel.removePropertyChangeListener(propertyChangeListener);
    }

    public org.w3c.dom.Node getOldEventParentNode(PropertyChangeEvent propertyChangeEvent) {
        NodeInfo nodeInfo = (NodeInfo)propertyChangeEvent.getOldValue();
        return nodeInfo != null ? nodeInfo.getParent() : null;
    }

    public org.w3c.dom.Node getOldEventNode(PropertyChangeEvent propertyChangeEvent) {
        NodeInfo nodeInfo = (NodeInfo)propertyChangeEvent.getOldValue();
        return nodeInfo != null ? nodeInfo.getNode() : null;
    }

    public org.w3c.dom.Node getNewEventParentNode(PropertyChangeEvent propertyChangeEvent) {
        NodeInfo nodeInfo = (NodeInfo)propertyChangeEvent.getNewValue();
        return nodeInfo != null ? nodeInfo.getParent() : null;
    }

    public org.w3c.dom.Node getNewEventNode(PropertyChangeEvent propertyChangeEvent) {
        NodeInfo nodeInfo = (NodeInfo)propertyChangeEvent.getNewValue();
        return nodeInfo != null ? nodeInfo.getNode() : null;
    }

    public String getIndentation() {
        return this.xdmModel.getIndentation();
    }

    public void setIndentation(String string) {
        this.xdmModel.setIndentation(string);
    }

    public void reorderChildren(Element element, int[] nArray, DocumentModelAccess.NodeUpdater nodeUpdater) {
        if (this.noMutations()) {
            return;
        }
        org.netbeans.modules.xml.xdm.nodes.Element element2 = (org.netbeans.modules.xml.xdm.nodes.Element)element;
        if (element2.isInTree()) {
            nodeUpdater.updateReference(this.xdmModel.reorderChildren(element2, nArray));
        } else {
            element2.reorderChildren(nArray);
        }
    }

    public String getCurrentDocumentText() {
        return this.xdmModel.getCurrentDocumentText();
    }

    public void addQNameValuedAttributes(Map<QName, List<QName>> map) {
        HashMap<QName, List<QName>> hashMap = new HashMap<QName, List<QName>>(this.xdmModel.getQNameValuedAttributes());
        hashMap.putAll(map);
        this.xdmModel.setQNameValuedAttributes(hashMap);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AttributeKeySet<E>
    extends HashSet<E> {
        List<E> keys = new ArrayList();

        public AttributeKeySet(List<E> list) {
            this.keys = list;
        }

        @Override
        public boolean isEmpty() {
            return this.keys.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.keys.contains(object);
        }

        @Override
        public Iterator iterator() {
            return this.keys.iterator();
        }

        @Override
        public int size() {
            return this.keys.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AttributeMap<K, V>
    extends HashMap<K, V> {
        List<K> keys = new ArrayList<K>();

        @Override
        public AttributeKeySet<K> keySet() {
            return new AttributeKeySet<K>(this.keys);
        }

        private void addKey(K k) {
            this.keys.add(k);
        }
    }
}

