/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.editors.box;

import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;

public class CompoundStroke
implements Stroke {
    public static final int ADD = 0;
    public static final int DIFFERENCE = 3;
    public static final int INTERSECT = 2;
    public static final int SUBTRACT = 1;
    private int operation = 0;
    private Stroke stroke1;
    private Stroke stroke2;

    public CompoundStroke() {
    }

    public CompoundStroke(Stroke stroke1, Stroke stroke2, int operation) {
        this.stroke1 = stroke1;
        this.stroke2 = stroke2;
        this.operation = operation;
    }

    public Shape createStrokedShape(Shape shape) {
        if (this.stroke1 == null) {
            throw new IllegalArgumentException("stroke1 is null");
        }
        if (this.stroke2 == null) {
            throw new IllegalArgumentException("stroke2 is null");
        }
        Area area1 = new Area(this.stroke1.createStrokedShape(shape));
        Area area2 = new Area(this.stroke2.createStrokedShape(shape));
        switch (this.operation) {
            case 0: {
                area1.add(area2);
                break;
            }
            case 1: {
                area1.subtract(area2);
                break;
            }
            case 2: {
                area1.intersect(area2);
                break;
            }
            case 3: {
                area1.exclusiveOr(area2);
            }
        }
        return area1;
    }

    public int getOperation() {
        return this.operation;
    }

    public Stroke getStroke1() {
        return this.stroke1;
    }

    public Stroke getStroke2() {
        return this.stroke2;
    }

    public void setOperation(int operation) {
        this.operation = operation;
    }

    public void setStroke1(Stroke stroke1) {
        this.stroke1 = stroke1;
    }

    public void setStroke2(Stroke stroke2) {
        this.stroke2 = stroke2;
    }
}

