/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRCalculable;
import net.sf.jasperreports.engine.fill.JRDoubleIncrementerFactory;

final class JRDoubleCountIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRDoubleCountIncrementer mainInstance = new JRDoubleCountIncrementer();

    private JRDoubleCountIncrementer() {
    }

    public static JRDoubleCountIncrementer getInstance() {
        return mainInstance;
    }

    public Object increment(JRCalculable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        Number value = (Number)variable.getIncrementedValue();
        if (value == null || variable.isInitialized()) {
            value = JRDoubleIncrementerFactory.ZERO;
        }
        if (expressionValue == null) {
            return value;
        }
        return new Double(value.doubleValue() + 1.0);
    }

    public Object combine(JRCalculable calculable, JRCalculable calculableValue, AbstractValueProvider valueProvider) {
        Number value = (Number)calculable.getIncrementedValue();
        Number combineValue = (Number)calculableValue.getValue();
        if (value == null || calculable.isInitialized()) {
            value = JRDoubleIncrementerFactory.ZERO;
        }
        if (combineValue == null) {
            return value;
        }
        return new Double(value.doubleValue() + combineValue.doubleValue());
    }

    public Object initialValue() {
        return JRDoubleIncrementerFactory.ZERO;
    }
}

