/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;

public final class JRExpressionUtil {
    private static final Pattern SIMPLE_EXPRESSION_PATTERN = Pattern.compile("\\s*\"([^\"]*((?<=\\\\)\"[^\"]*)*)\"\\s*");
    private static final int SIMPLE_EXPRESSION_TEXT_GROUP = 1;
    private static final Pattern TEXT_QUOTE_PATTERN = Pattern.compile("\\\\\"");
    private static final String TEXT_QUOTE_REPLACEMENT = "\"";

    public static String getExpressionText(JRExpression exp) {
        return exp == null ? null : exp.getText();
    }

    public static String getSimpleExpressionText(JRExpression expression) {
        String chunk;
        Matcher matcher;
        JRExpressionChunk[] chunks;
        String value = null;
        if (expression != null && (chunks = expression.getChunks()) != null && chunks.length == 1 && chunks[0].getType() == 1 && (matcher = SIMPLE_EXPRESSION_PATTERN.matcher(chunk = chunks[0].getText())).matches()) {
            String text = matcher.group(1);
            value = TEXT_QUOTE_PATTERN.matcher(text).replaceAll(TEXT_QUOTE_REPLACEMENT);
        }
        return value;
    }

    private JRExpressionUtil() {
    }
}

