/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.DataInput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.antlr.runtime.TokenRewriteStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManager;

public class Context {
    private Path resFile;
    private Path resDir;
    private FileSystem resFs;
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.Context");
    private Path[] resDirPaths;
    private int resDirFilesNum;
    boolean initialized;
    String originalTracker = null;
    private Map<String, ContentSummary> pathToCS = new ConcurrentHashMap<String, ContentSummary>();
    private final Path nonLocalScratchPath;
    private final String localScratchDir;
    private final Map<String, String> fsScratchDirs = new HashMap<String, String>();
    private Configuration conf;
    protected int pathid = 10000;
    protected boolean explain = false;
    private TokenRewriteStream tokenRewriteStream;
    String executionId;
    protected List<HiveLock> hiveLocks;
    protected HiveLockManager hiveLockMgr;
    private boolean needLockMgr;
    private static final String MR_PREFIX = "-mr-";
    private static final String EXT_PREFIX = "-ext-";
    private static final String LOCAL_PREFIX = "-local-";

    public Context(Configuration conf) throws IOException {
        this(conf, Context.generateExecutionId());
    }

    public Context(Configuration conf, String executionId) {
        this.conf = conf;
        this.executionId = executionId;
        this.nonLocalScratchPath = new Path(HiveConf.getVar(conf, HiveConf.ConfVars.SCRATCHDIR), executionId);
        this.localScratchDir = System.getProperty("java.io.tmpdir") + "/" + System.getProperty("user.name") + "/" + executionId;
    }

    public void setExplain(boolean value) {
        this.explain = value;
    }

    public boolean getExplain() {
        return this.explain;
    }

    private String getScratchDir(String scheme, String authority, boolean mkdir, String scratchDir) {
        String fileSystem = scheme + ":" + authority;
        String dir = this.fsScratchDirs.get(fileSystem);
        if (dir == null) {
            Path dirPath = new Path(scheme, authority, scratchDir);
            if (mkdir) {
                try {
                    FileSystem fs = dirPath.getFileSystem(this.conf);
                    dirPath = new Path(fs.makeQualified(dirPath).toString());
                    if (!fs.mkdirs(dirPath)) {
                        throw new RuntimeException("Cannot make directory: " + dirPath.toString());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            dir = dirPath.toString();
            this.fsScratchDirs.put(fileSystem, dir);
        }
        return dir;
    }

    public String getLocalScratchDir(boolean mkdir) {
        try {
            LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
            URI uri = fs.getUri();
            return this.getScratchDir(uri.getScheme(), uri.getAuthority(), mkdir, this.localScratchDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getMRScratchDir() {
        if (this.isLocalOnlyExecutionMode()) {
            return this.getLocalScratchDir(!this.explain);
        }
        try {
            Path dir = FileUtils.makeQualified(this.nonLocalScratchPath, this.conf);
            URI uri = dir.toUri();
            return this.getScratchDir(uri.getScheme(), uri.getAuthority(), !this.explain, uri.getPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Error while making MR scratch directory - check filesystem config (" + e.getCause() + ")", e);
        }
    }

    private String getExternalScratchDir(URI extURI) {
        return this.getScratchDir(extURI.getScheme(), extURI.getAuthority(), !this.explain, this.nonLocalScratchPath.toUri().getPath());
    }

    private void removeScratchDir() {
        for (Map.Entry<String, String> entry : this.fsScratchDirs.entrySet()) {
            try {
                Path p = new Path(entry.getValue());
                p.getFileSystem(this.conf).delete(p, true);
            }
            catch (Exception e) {
                LOG.warn((Object)("Error Removing Scratch: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            }
        }
        this.fsScratchDirs.clear();
    }

    private String nextPathId() {
        return Integer.toString(this.pathid++);
    }

    public boolean isMRTmpFileURI(String uriStr) {
        return uriStr.indexOf(this.executionId) != -1 && uriStr.indexOf(MR_PREFIX) != -1;
    }

    public String getMRTmpFileURI() {
        return this.getMRScratchDir() + "/" + MR_PREFIX + this.nextPathId();
    }

    public String localizeMRTmpFileURI(String originalURI) {
        Path o = new Path(originalURI);
        Path mrbase = new Path(this.getMRScratchDir());
        URI relURI = mrbase.toUri().relativize(o.toUri());
        if (relURI.equals(o.toUri())) {
            throw new RuntimeException("Invalid URI: " + originalURI + ", cannot relativize against" + mrbase.toString());
        }
        return this.getLocalScratchDir(!this.explain) + "/" + relURI.getPath();
    }

    public String getLocalTmpFileURI() {
        return this.getLocalScratchDir(true) + "/" + LOCAL_PREFIX + this.nextPathId();
    }

    public String getExternalTmpFileURI(URI extURI) {
        return this.getExternalScratchDir(extURI) + "/" + EXT_PREFIX + this.nextPathId();
    }

    public Path getResFile() {
        return this.resFile;
    }

    public void setResFile(Path resFile) {
        this.resFile = resFile;
        this.resDir = null;
        this.resDirPaths = null;
        this.resDirFilesNum = 0;
    }

    public Path getResDir() {
        return this.resDir;
    }

    public void setResDir(Path resDir) {
        this.resDir = resDir;
        this.resFile = null;
        this.resDirFilesNum = 0;
        this.resDirPaths = null;
    }

    public void clear() throws IOException {
        FileSystem fs;
        if (this.resDir != null) {
            try {
                fs = this.resDir.getFileSystem(this.conf);
                fs.delete(this.resDir, true);
            }
            catch (IOException e) {
                LOG.info((Object)("Context clear error: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            }
        }
        if (this.resFile != null) {
            try {
                fs = this.resFile.getFileSystem(this.conf);
                fs.delete(this.resFile, false);
            }
            catch (IOException e) {
                LOG.info((Object)("Context clear error: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            }
        }
        this.removeScratchDir();
        this.originalTracker = null;
        this.setNeedLockMgr(false);
    }

    public DataInput getStream() {
        try {
            if (!this.initialized) {
                this.initialized = true;
                if (this.resFile == null && this.resDir == null) {
                    return null;
                }
                if (this.resFile != null) {
                    return this.resFile.getFileSystem(this.conf).open(this.resFile);
                }
                this.resFs = this.resDir.getFileSystem(this.conf);
                FileStatus status = this.resFs.getFileStatus(this.resDir);
                assert (status.isDir());
                FileStatus[] resDirFS = this.resFs.globStatus(new Path(this.resDir + "/*"));
                this.resDirPaths = new Path[resDirFS.length];
                int pos = 0;
                for (FileStatus resFS : resDirFS) {
                    if (resFS.isDir()) continue;
                    this.resDirPaths[pos++] = resFS.getPath();
                }
                if (pos == 0) {
                    return null;
                }
                return this.resFs.open(this.resDirPaths[this.resDirFilesNum++]);
            }
            return this.getNextStream();
        }
        catch (FileNotFoundException e) {
            LOG.info((Object)("getStream error: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return null;
        }
        catch (IOException e) {
            LOG.info((Object)("getStream error: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return null;
        }
    }

    private DataInput getNextStream() {
        try {
            if (this.resDir != null && this.resDirFilesNum < this.resDirPaths.length && this.resDirPaths[this.resDirFilesNum] != null) {
                return this.resFs.open(this.resDirPaths[this.resDirFilesNum++]);
            }
        }
        catch (FileNotFoundException e) {
            LOG.info((Object)("getNextStream error: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return null;
        }
        catch (IOException e) {
            LOG.info((Object)("getNextStream error: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return null;
        }
        return null;
    }

    private static boolean strEquals(String str1, String str2) {
        return StringUtils.equals(str1, str2);
    }

    public void setTokenRewriteStream(TokenRewriteStream tokenRewriteStream) {
        assert (this.tokenRewriteStream == null);
        this.tokenRewriteStream = tokenRewriteStream;
    }

    public TokenRewriteStream getTokenRewriteStream() {
        return this.tokenRewriteStream;
    }

    public static String generateExecutionId() {
        Random rand = new Random();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss_SSS");
        String executionId = "hive_" + format.format(new Date()) + "_" + Math.abs(rand.nextLong());
        return executionId;
    }

    public boolean isLocalOnlyExecutionMode() {
        return HiveConf.getVar(this.conf, HiveConf.ConfVars.HADOOPJT).equals("local");
    }

    public List<HiveLock> getHiveLocks() {
        return this.hiveLocks;
    }

    public void setHiveLocks(List<HiveLock> hiveLocks) {
        this.hiveLocks = hiveLocks;
    }

    public HiveLockManager getHiveLockMgr() {
        return this.hiveLockMgr;
    }

    public void setHiveLockMgr(HiveLockManager hiveLockMgr) {
        this.hiveLockMgr = hiveLockMgr;
    }

    public void setOriginalTracker(String originalTracker) {
        this.originalTracker = originalTracker;
    }

    public void restoreOriginalTracker() {
        if (this.originalTracker != null) {
            HiveConf.setVar(this.conf, HiveConf.ConfVars.HADOOPJT, this.originalTracker);
            this.originalTracker = null;
        }
    }

    public void addCS(String path, ContentSummary cs) {
        this.pathToCS.put(path, cs);
    }

    public ContentSummary getCS(String path) {
        return this.pathToCS.get(path);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void localizeKeys(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String path = entry.getKey();
            if (!this.isMRTmpFileURI(path)) continue;
            Object val = entry.getValue();
            map.remove(path);
            map.put(this.localizeMRTmpFileURI(path), val);
        }
    }

    public void localizePaths(List<String> paths) {
        Iterator<String> iter = paths.iterator();
        ArrayList<String> toAdd = new ArrayList<String>();
        while (iter.hasNext()) {
            String path = iter.next();
            if (!this.isMRTmpFileURI(path)) continue;
            iter.remove();
            toAdd.add(this.localizeMRTmpFileURI(path));
        }
        paths.addAll(toAdd);
    }

    public boolean isNeedLockMgr() {
        return this.needLockMgr;
    }

    public void setNeedLockMgr(boolean needLockMgr) {
        this.needLockMgr = needLockMgr;
    }
}

