/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

public class ReadEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Table t;
    private Partition p;
    private String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setP(Partition p) {
        this.p = p;
    }

    public void setT(Table t) {
        this.t = t;
    }

    public Partition getP() {
        return this.p;
    }

    public Table getT() {
        return this.t;
    }

    public ReadEntity() {
    }

    public ReadEntity(Table t) {
        this.t = t;
        this.p = null;
        this.name = this.computeName();
    }

    public ReadEntity(Partition p) {
        this.t = p.getTable();
        this.p = p;
        this.name = this.computeName();
    }

    private String computeName() {
        if (this.p != null) {
            return this.p.getTable().getDbName() + "@" + this.p.getTable().getTableName() + "@" + this.p.getName();
        }
        return this.t.getDbName() + "@" + this.t.getTableName();
    }

    public Type getType() {
        return this.p == null ? Type.TABLE : Type.PARTITION;
    }

    public Map<String, String> getParameters() {
        if (this.p != null) {
            return this.p.getParameters();
        }
        return this.t.getParameters();
    }

    public URI getLocation() {
        if (this.p != null) {
            return this.p.getDataLocation();
        }
        return this.t.getDataLocation();
    }

    public Partition getPartition() {
        return this.p;
    }

    public Table getTable() {
        return this.t;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof ReadEntity) {
            ReadEntity ore = (ReadEntity)o;
            return this.toString().equalsIgnoreCase(ore.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static enum Type {
        TABLE,
        PARTITION;

    }
}

