/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.index.compact;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.index.AbstractIndexHandler;
import org.apache.hadoop.hive.ql.index.compact.IndexMetadataChangeTask;
import org.apache.hadoop.hive.ql.index.compact.IndexMetadataChangeWork;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;

public class CompactIndexHandler
extends AbstractIndexHandler {
    private Configuration configuration;

    @Override
    public void analyzeIndexDefinition(org.apache.hadoop.hive.metastore.api.Table baseTable, Index index, org.apache.hadoop.hive.metastore.api.Table indexTable) throws HiveException {
        StorageDescriptor storageDesc = index.getSd();
        if (this.usesIndexTable() && indexTable != null) {
            StorageDescriptor indexTableSd = storageDesc.deepCopy();
            List indexTblCols = indexTableSd.getCols();
            FieldSchema bucketFileName = new FieldSchema("_bucketname", "string", "");
            indexTblCols.add(bucketFileName);
            FieldSchema offSets = new FieldSchema("_offsets", "array<bigint>", "");
            indexTblCols.add(offSets);
            indexTable.setSd(indexTableSd);
        }
    }

    @Override
    public List<Task<?>> generateIndexBuildTaskList(Table baseTbl, Index index, List<Partition> indexTblPartitions, List<Partition> baseTblPartitions, Table indexTbl, Set<ReadEntity> inputs, Set<WriteEntity> outputs) throws HiveException {
        try {
            TableDesc desc = Utilities.getTableDesc(indexTbl);
            ArrayList<Partition> newBaseTblPartitions = new ArrayList<Partition>();
            ArrayList indexBuilderTasks = new ArrayList();
            if (!baseTbl.isPartitioned()) {
                Task<?> indexBuilder = this.getIndexBuilderMapRedTask(inputs, outputs, index.getSd().getCols(), false, new PartitionDesc(desc, null), indexTbl.getTableName(), new PartitionDesc(Utilities.getTableDesc(baseTbl), null), baseTbl.getTableName(), indexTbl.getDbName());
                indexBuilderTasks.add(indexBuilder);
            } else {
                for (int i = 0; i < indexTblPartitions.size(); ++i) {
                    Partition indexPart = indexTblPartitions.get(i);
                    Partition basePart = null;
                    for (int j = 0; j < baseTblPartitions.size(); ++j) {
                        if (!baseTblPartitions.get(j).getName().equals(indexPart.getName())) continue;
                        basePart = baseTblPartitions.get(j);
                        newBaseTblPartitions.add(baseTblPartitions.get(j));
                        break;
                    }
                    if (basePart == null) {
                        throw new RuntimeException("Partitions of base table and index table are inconsistent.");
                    }
                    Task<?> indexBuilder = this.getIndexBuilderMapRedTask(inputs, outputs, index.getSd().getCols(), true, new PartitionDesc(indexPart), indexTbl.getTableName(), new PartitionDesc(basePart), baseTbl.getTableName(), indexTbl.getDbName());
                    indexBuilderTasks.add(indexBuilder);
                }
            }
            return indexBuilderTasks;
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    private Task<?> getIndexBuilderMapRedTask(Set<ReadEntity> inputs, Set<WriteEntity> outputs, List<FieldSchema> indexField, boolean partitioned, PartitionDesc indexTblPartDesc, String indexTableName, PartitionDesc baseTablePartDesc, String baseTableName, String dbName) {
        String indexCols = HiveUtils.getUnparsedColumnNamesFromFieldSchema(indexField);
        StringBuilder command = new StringBuilder();
        LinkedHashMap<String, String> partSpec = indexTblPartDesc.getPartSpec();
        command.append("INSERT OVERWRITE TABLE " + HiveUtils.unparseIdentifier(indexTableName));
        if (partitioned && indexTblPartDesc != null) {
            command.append(" PARTITION ( ");
            List<String> ret = this.getPartKVPairStringArray(partSpec);
            for (int i = 0; i < ret.size(); ++i) {
                String partKV = ret.get(i);
                command.append(partKV);
                if (i >= ret.size() - 1) continue;
                command.append(",");
            }
            command.append(" ) ");
        }
        command.append(" SELECT ");
        command.append(indexCols);
        command.append(",");
        command.append(VirtualColumn.FILENAME.getName());
        command.append(",");
        command.append(" collect_set (");
        command.append(VirtualColumn.BLOCKOFFSET.getName());
        command.append(") ");
        command.append(" FROM " + HiveUtils.unparseIdentifier(baseTableName));
        LinkedHashMap<String, String> basePartSpec = baseTablePartDesc.getPartSpec();
        if (basePartSpec != null) {
            command.append(" WHERE ");
            List<String> pkv = this.getPartKVPairStringArray(basePartSpec);
            for (int i = 0; i < pkv.size(); ++i) {
                String partKV = pkv.get(i);
                command.append(partKV);
                if (i >= pkv.size() - 1) continue;
                command.append(" AND ");
            }
        }
        command.append(" GROUP BY ");
        command.append(indexCols + ", " + VirtualColumn.FILENAME.getName());
        Driver driver = new Driver(new HiveConf(this.getConf(), CompactIndexHandler.class));
        driver.compile(command.toString());
        Task<? extends Serializable> rootTask = driver.getPlan().getRootTasks().get(0);
        inputs.addAll(driver.getPlan().getInputs());
        outputs.addAll(driver.getPlan().getOutputs());
        IndexMetadataChangeWork indexMetaChange = new IndexMetadataChangeWork(partSpec, indexTableName, dbName);
        IndexMetadataChangeTask indexMetaChangeTsk = new IndexMetadataChangeTask();
        indexMetaChangeTsk.setWork(indexMetaChange);
        rootTask.addDependentTask(indexMetaChangeTsk);
        return rootTask;
    }

    private List<String> getPartKVPairStringArray(LinkedHashMap<String, String> partSpec) {
        ArrayList<String> ret = new ArrayList<String>(partSpec.size());
        Iterator<Map.Entry<String, String>> iter = partSpec.entrySet().iterator();
        while (iter.hasNext()) {
            StringBuilder sb = new StringBuilder();
            Map.Entry<String, String> p = iter.next();
            sb.append(HiveUtils.unparseIdentifier(p.getKey()));
            sb.append(" = ");
            sb.append("'");
            sb.append(p.getValue());
            sb.append("'");
            ret.add(sb.toString());
        }
        return ret;
    }

    @Override
    public boolean usesIndexTable() {
        return true;
    }

    public Configuration getConf() {
        return this.configuration;
    }

    public void setConf(Configuration conf) {
        this.configuration = conf;
    }
}

