/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.CombineHiveRecordReader;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.io.IOPrepareCache;
import org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;

public class CombineHiveInputFormat<K extends WritableComparable, V extends Writable>
extends HiveInputFormat<K, V> {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hive.ql.io.CombineHiveInputFormat");

    @Override
    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        HadoopShims.InputSplitShim[] iss;
        this.init(job);
        LinkedHashMap<String, ArrayList<String>> pathToAliases = this.mrwork.getPathToAliases();
        LinkedHashMap<String, Operator<? extends Serializable>> aliasToWork = this.mrwork.getAliasToWork();
        HadoopShims.CombineFileInputFormatShim combine = ShimLoader.getHadoopShims().getCombineFileInputFormat();
        if (combine == null) {
            return super.getSplits(job, numSplits);
        }
        if (combine.getInputPathsShim(job).length == 0) {
            throw new IOException("No input paths specified in job");
        }
        ArrayList<CombineHiveInputSplit> result = new ArrayList<CombineHiveInputSplit>();
        Path[] paths = combine.getInputPathsShim(job);
        HashMap<CombinePathInputFormat, CombineFilter> poolMap = new HashMap<CombinePathInputFormat, CombineFilter>();
        HashSet<Path> poolSet = new HashSet<Path>();
        for (Path path : paths) {
            PartitionDesc part = HiveFileFormatUtils.getPartitionDescFromPathRecursively(this.pathToPartitionInfo, path, IOPrepareCache.get().allocatePartitionDescMap());
            TableDesc tableDesc = part.getTableDesc();
            if (tableDesc != null && tableDesc.isNonNative()) {
                return super.getSplits(job, numSplits);
            }
            Class<? extends InputFormat> inputFormatClass = part.getInputFileFormatClass();
            String inputFormatClassName = inputFormatClass.getName();
            InputFormat<WritableComparable, Writable> inputFormat = CombineHiveInputFormat.getInputFormatFromCache(inputFormatClass, job);
            if (this.mrwork != null && !this.mrwork.getHadoopSupportsSplittable()) {
                FileSystem inpFs = path.getFileSystem((Configuration)job);
                if (inputFormat instanceof TextInputFormat) {
                    LinkedList<Path> dirs = new LinkedList<Path>();
                    FileStatus fStats = inpFs.getFileStatus(path);
                    if (fStats.isDir()) {
                        dirs.offer(path);
                    } else if (new CompressionCodecFactory((Configuration)job).getCodec(path) != null) {
                        return super.getSplits(job, numSplits);
                    }
                    while (dirs.peek() != null) {
                        Path tstPath = (Path)dirs.remove();
                        FileStatus[] fStatus = inpFs.listStatus(tstPath);
                        for (int idx = 0; idx < fStatus.length; ++idx) {
                            if (fStatus[idx].isDir()) {
                                dirs.offer(fStatus[idx].getPath());
                                continue;
                            }
                            if (new CompressionCodecFactory((Configuration)job).getCodec(fStatus[idx].getPath()) == null) continue;
                            return super.getSplits(job, numSplits);
                        }
                    }
                }
            }
            if (inputFormat instanceof SymlinkTextInputFormat) {
                return super.getSplits(job, numSplits);
            }
            Path filterPath = path;
            if (this.mrwork.isMapperCannotSpanPartns() && !path.getFileSystem((Configuration)job).getFileStatus(path).isDir()) {
                filterPath = path.getParent();
            }
            CombineFilter f = null;
            List<Operator<? extends Serializable>> opList = null;
            boolean done = false;
            if (!this.mrwork.isMapperCannotSpanPartns()) {
                opList = HiveFileFormatUtils.doGetAliasesFromPath(pathToAliases, aliasToWork, filterPath);
                f = (CombineFilter)poolMap.get(new CombinePathInputFormat(opList, inputFormatClassName));
            } else {
                if (poolSet.contains(filterPath)) {
                    LOG.info((Object)("CombineHiveInputSplit: pool is already created for " + path + "; using filter path " + filterPath));
                    done = true;
                }
                poolSet.add(filterPath);
            }
            if (done) continue;
            if (f == null) {
                f = new CombineFilter(filterPath);
                LOG.info((Object)("CombineHiveInputSplit creating pool for " + path + "; using filter path " + filterPath));
                combine.createPool(job, f);
                if (this.mrwork.isMapperCannotSpanPartns()) continue;
                poolMap.put(new CombinePathInputFormat(opList, inputFormatClassName), f);
                continue;
            }
            LOG.info((Object)("CombineHiveInputSplit: pool is already created for " + path + "; using filter path " + filterPath));
            f.addPath(filterPath);
        }
        for (HadoopShims.InputSplitShim is : iss = combine.getSplits(job, 1)) {
            CombineHiveInputSplit csplit = new CombineHiveInputSplit(job, is);
            result.add(csplit);
        }
        LOG.info((Object)("number of splits " + result.size()));
        return result.toArray(new CombineHiveInputSplit[result.size()]);
    }

    @Override
    public RecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        if (!(split instanceof CombineHiveInputSplit)) {
            return super.getRecordReader(split, job, reporter);
        }
        CombineHiveInputSplit hsplit = (CombineHiveInputSplit)split;
        String inputFormatClassName = null;
        Class inputFormatClass = null;
        try {
            inputFormatClassName = hsplit.inputFormatClassName();
            inputFormatClass = job.getClassByName(inputFormatClassName);
        }
        catch (Exception e) {
            throw new IOException("cannot find class " + inputFormatClassName);
        }
        this.pushProjectionsAndFilters(job, inputFormatClass, hsplit.getPath(0).toString(), hsplit.getPath(0).toUri().getPath());
        return ShimLoader.getHadoopShims().getCombineFileInputFormat().getRecordReader(job, ((CombineHiveInputSplit)split).getInputSplitShim(), reporter, CombineHiveRecordReader.class);
    }

    static class CombineFilter
    implements PathFilter {
        private List<String> pStrings = new ArrayList<String>();

        public CombineFilter(Path p) {
            this.addPath(p);
        }

        public void addPath(Path p) {
            String pString = p.toUri().getPath().toString() + File.separator;
            this.pStrings.add(pString);
        }

        public boolean accept(Path path) {
            for (String pString : this.pStrings) {
                if (path.toString().indexOf(pString) != 0) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append("PathFilter: ");
            for (String pString : this.pStrings) {
                s.append(pString + " ");
            }
            return s.toString();
        }
    }

    private static class CombinePathInputFormat {
        private List<Operator<? extends Serializable>> opList;
        private String inputFormatClassName;

        public CombinePathInputFormat(List<Operator<? extends Serializable>> opList, String inputFormatClassName) {
            this.opList = opList;
            this.inputFormatClassName = inputFormatClassName;
        }

        public boolean equals(Object o) {
            if (o instanceof CombinePathInputFormat) {
                CombinePathInputFormat mObj = (CombinePathInputFormat)o;
                if (mObj == null) {
                    return false;
                }
                return ((Object)this.opList).equals(mObj.opList) && this.inputFormatClassName.equals(mObj.inputFormatClassName);
            }
            return false;
        }

        public int hashCode() {
            return this.opList == null ? 0 : ((Object)this.opList).hashCode();
        }
    }

    public static class CombineHiveInputSplit
    implements HadoopShims.InputSplitShim {
        String inputFormatClassName;
        HadoopShims.InputSplitShim inputSplitShim;

        public CombineHiveInputSplit() throws IOException {
            this(ShimLoader.getHadoopShims().getCombineFileInputFormat().getInputSplitShim());
        }

        public CombineHiveInputSplit(HadoopShims.InputSplitShim inputSplitShim) throws IOException {
            this(inputSplitShim.getJob(), inputSplitShim);
        }

        public CombineHiveInputSplit(JobConf job, HadoopShims.InputSplitShim inputSplitShim) throws IOException {
            this.inputSplitShim = inputSplitShim;
            if (job != null) {
                LinkedHashMap<String, PartitionDesc> pathToPartitionInfo = Utilities.getMapRedWork((Configuration)job).getPathToPartitionInfo();
                Path[] ipaths = inputSplitShim.getPaths();
                if (ipaths.length > 0) {
                    PartitionDesc part = HiveFileFormatUtils.getPartitionDescFromPathRecursively(pathToPartitionInfo, ipaths[0], IOPrepareCache.get().getPartitionDescMap());
                    this.inputFormatClassName = part.getInputFileFormatClass().getName();
                }
            }
        }

        public HadoopShims.InputSplitShim getInputSplitShim() {
            return this.inputSplitShim;
        }

        public String inputFormatClassName() {
            return this.inputFormatClassName;
        }

        public void setInputFormatClassName(String inputFormatClassName) {
            this.inputFormatClassName = inputFormatClassName;
        }

        @Override
        public JobConf getJob() {
            return this.inputSplitShim.getJob();
        }

        @Override
        public long getLength() {
            return this.inputSplitShim.getLength();
        }

        @Override
        public long[] getStartOffsets() {
            return this.inputSplitShim.getStartOffsets();
        }

        @Override
        public long[] getLengths() {
            return this.inputSplitShim.getLengths();
        }

        @Override
        public long getOffset(int i) {
            return this.inputSplitShim.getOffset(i);
        }

        @Override
        public long getLength(int i) {
            return this.inputSplitShim.getLength(i);
        }

        @Override
        public int getNumPaths() {
            return this.inputSplitShim.getNumPaths();
        }

        @Override
        public Path getPath(int i) {
            return this.inputSplitShim.getPath(i);
        }

        @Override
        public Path[] getPaths() {
            return this.inputSplitShim.getPaths();
        }

        @Override
        public String[] getLocations() throws IOException {
            return this.inputSplitShim.getLocations();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(((Object)this.inputSplitShim).toString());
            sb.append("InputFormatClass: " + this.inputFormatClassName);
            sb.append("\n");
            return sb.toString();
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.inputSplitShim.readFields(in);
            this.inputFormatClassName = in.readUTF();
        }

        @Override
        public void write(DataOutput out) throws IOException {
            this.inputSplitShim.write(out);
            if (this.inputFormatClassName == null) {
                LinkedHashMap<String, PartitionDesc> pathToPartitionInfo = Utilities.getMapRedWork((Configuration)this.getJob()).getPathToPartitionInfo();
                PartitionDesc part = HiveFileFormatUtils.getPartitionDescFromPathRecursively(pathToPartitionInfo, this.inputSplitShim.getPath(0), IOPrepareCache.get().getPartitionDescMap());
                this.inputFormatClassName = part.getInputFileFormatClass().getName();
            }
            out.writeUTF(this.inputFormatClassName);
        }
    }
}

