/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.FunctionSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.SessionState;

public final class SemanticAnalyzerFactory {
    static HashMap<Integer, HiveOperation> commandType = new HashMap();
    static HashMap<Integer, HiveOperation[]> tablePartitionCommandType = new HashMap();

    public static BaseSemanticAnalyzer get(HiveConf conf, ASTNode tree) throws SemanticException {
        if (tree.getToken() == null) {
            throw new RuntimeException("Empty Syntax Tree");
        }
        SemanticAnalyzerFactory.setSessionCommandType(commandType.get(tree.getToken().getType()));
        switch (tree.getToken().getType()) {
            case 160: {
                return new ExplainSemanticAnalyzer(conf);
            }
            case 63: {
                return new LoadSemanticAnalyzer(conf);
            }
            case 83: 
            case 85: 
            case 88: 
            case 90: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 146: 
            case 158: 
            case 159: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 213: 
            case 216: {
                return new DDLSemanticAnalyzer(conf);
            }
            case 92: {
                HiveOperation commandType = null;
                Integer type = ((ASTNode)tree.getChild(1)).getToken().getType();
                commandType = tree.getChild(0).getChildCount() > 1 ? tablePartitionCommandType.get(type)[1] : tablePartitionCommandType.get(type)[0];
                SemanticAnalyzerFactory.setSessionCommandType(commandType);
                return new DDLSemanticAnalyzer(conf);
            }
            case 155: 
            case 156: {
                return new FunctionSemanticAnalyzer(conf);
            }
        }
        return new SemanticAnalyzer(conf);
    }

    private static void setSessionCommandType(HiveOperation commandType) {
        if (SessionState.get() != null) {
            SessionState.get().setCommandType(commandType);
        }
    }

    private SemanticAnalyzerFactory() {
    }

    static {
        commandType.put(160, HiveOperation.EXPLAIN);
        commandType.put(63, HiveOperation.LOAD);
        commandType.put(83, HiveOperation.CREATEDATABASE);
        commandType.put(122, HiveOperation.DROPDATABASE);
        commandType.put(121, HiveOperation.SWITCHDATABASE);
        commandType.put(84, HiveOperation.CREATETABLE);
        commandType.put(123, HiveOperation.DROPTABLE);
        commandType.put(90, HiveOperation.DESCTABLE);
        commandType.put(91, HiveOperation.DESCFUNCTION);
        commandType.put(112, HiveOperation.MSCK);
        commandType.put(94, HiveOperation.ALTERTABLE_ADDCOLS);
        commandType.put(96, HiveOperation.ALTERTABLE_REPLACECOLS);
        commandType.put(95, HiveOperation.ALTERTABLE_RENAMECOL);
        commandType.put(93, HiveOperation.ALTERTABLE_RENAME);
        commandType.put(98, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(97, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(100, HiveOperation.ALTERTABLE_TOUCH);
        commandType.put(101, HiveOperation.ALTERTABLE_ARCHIVE);
        commandType.put(102, HiveOperation.ALTERTABLE_UNARCHIVE);
        commandType.put(108, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(104, HiveOperation.ALTERTABLE_SERIALIZER);
        commandType.put(103, HiveOperation.ALTERTABLE_SERDEPROPERTIES);
        commandType.put(146, HiveOperation.ALTERTABLE_CLUSTER_SORT);
        commandType.put(113, HiveOperation.SHOWDATABASES);
        commandType.put(114, HiveOperation.SHOWTABLES);
        commandType.put(117, HiveOperation.SHOW_TABLESTATUS);
        commandType.put(115, HiveOperation.SHOWFUNCTIONS);
        commandType.put(211, HiveOperation.SHOWINDEXES);
        commandType.put(116, HiveOperation.SHOWPARTITIONS);
        commandType.put(118, HiveOperation.SHOWLOCKS);
        commandType.put(155, HiveOperation.CREATEFUNCTION);
        commandType.put(156, HiveOperation.DROPFUNCTION);
        commandType.put(157, HiveOperation.CREATEVIEW);
        commandType.put(158, HiveOperation.DROPVIEW);
        commandType.put(85, HiveOperation.CREATEINDEX);
        commandType.put(88, HiveOperation.DROPINDEX);
        commandType.put(110, HiveOperation.ALTERINDEX_REBUILD);
        commandType.put(111, HiveOperation.ALTERINDEX_PROPS);
        commandType.put(159, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(5, HiveOperation.QUERY);
        commandType.put(119, HiveOperation.LOCKTABLE);
        commandType.put(120, HiveOperation.UNLOCKTABLE);
        commandType.put(185, HiveOperation.CREATEROLE);
        commandType.put(186, HiveOperation.DROPROLE);
        commandType.put(187, HiveOperation.GRANT_PRIVILEGE);
        commandType.put(188, HiveOperation.REVOKE_PRIVILEGE);
        commandType.put(189, HiveOperation.SHOW_GRANT);
        commandType.put(208, HiveOperation.GRANT_ROLE);
        commandType.put(209, HiveOperation.REVOKE_ROLE);
        commandType.put(210, HiveOperation.SHOW_ROLE_GRANT);
        commandType.put(216, HiveOperation.ALTERDATABASE);
        commandType.put(213, HiveOperation.DESCDATABASE);
        tablePartitionCommandType.put(99, new HiveOperation[]{HiveOperation.ALTERTABLE_PROTECTMODE, HiveOperation.ALTERPARTITION_PROTECTMODE});
        tablePartitionCommandType.put(106, new HiveOperation[]{HiveOperation.ALTERTABLE_FILEFORMAT, HiveOperation.ALTERPARTITION_FILEFORMAT});
        tablePartitionCommandType.put(107, new HiveOperation[]{HiveOperation.ALTERTABLE_LOCATION, HiveOperation.ALTERPARTITION_LOCATION});
    }
}

