/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@Description(name="hour", value="_FUNC_(date) - Returns the hour of date", extended="date is a string in the format of 'yyyy-MM-dd HH:mm:ss' or 'HH:mm:ss'.\nExample:\n   > SELECT _FUNC_('2009-07-30 12:58:59') FROM src LIMIT 1;\n  12\n  > SELECT _FUNC_('12:58:59') FROM src LIMIT 1;\n  12")
public class UDFHour
extends UDF {
    private final SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final SimpleDateFormat formatter2 = new SimpleDateFormat("HH:mm:ss");
    private final Calendar calendar = Calendar.getInstance();
    private IntWritable result = new IntWritable();

    public IntWritable evaluate(Text dateString) {
        if (dateString == null) {
            return null;
        }
        try {
            Date date = null;
            try {
                date = this.formatter1.parse(dateString.toString());
            }
            catch (ParseException e) {
                date = this.formatter2.parse(dateString.toString());
            }
            this.calendar.setTime(date);
            this.result.set(this.calendar.get(11));
            return this.result;
        }
        catch (ParseException e) {
            return null;
        }
    }
}

