/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.AlterHandler;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;

public class HiveAlterHandler
implements AlterHandler {
    private Configuration hiveConf;
    private static final Log LOG = LogFactory.getLog((String)HiveAlterHandler.class.getName());

    public Configuration getConf() {
        return this.hiveConf;
    }

    public void setConf(Configuration conf) {
        this.hiveConf = conf;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void alterTable(RawStore msdb, Warehouse wh, String dbname, String name, Table newt) throws InvalidOperationException, MetaException {
        if (newt == null) {
            throw new InvalidOperationException("New table is invalid: " + newt);
        }
        if (!MetaStoreUtils.validateName(newt.getTableName())) throw new InvalidOperationException(newt.getTableName() + " is not a valid object name");
        if (!MetaStoreUtils.validateColNames(newt.getSd().getCols())) {
            throw new InvalidOperationException(newt.getTableName() + " is not a valid object name");
        }
        Path srcPath = null;
        FileSystem srcFs = null;
        Path destPath = null;
        FileSystem destFs = null;
        boolean success = false;
        String oldTblLoc = null;
        String newTblLoc = null;
        boolean moveData = false;
        boolean rename = false;
        Table oldt = null;
        try {
            msdb.openTransaction();
            name = name.toLowerCase();
            dbname = dbname.toLowerCase();
            if (!newt.getTableName().equalsIgnoreCase(name) || !newt.getDbName().equalsIgnoreCase(dbname)) {
                if (msdb.getTable(newt.getDbName(), newt.getTableName()) != null) {
                    throw new InvalidOperationException("new table " + newt.getDbName() + "." + newt.getTableName() + " already exists");
                }
                rename = true;
            }
            if ((oldt = msdb.getTable(dbname, name)) == null) {
                throw new InvalidOperationException("table " + newt.getDbName() + "." + newt.getTableName() + " doesn't exist");
            }
            if (oldt.getPartitionKeys().size() != newt.getPartitionKeys().size()) throw new InvalidOperationException("partition keys can not be changed.");
            if (!oldt.getPartitionKeys().containsAll(newt.getPartitionKeys())) {
                throw new InvalidOperationException("partition keys can not be changed.");
            }
            if (rename && (oldt.getSd().getLocation().compareTo(newt.getSd().getLocation()) == 0 || StringUtils.isEmpty((String)newt.getSd().getLocation())) && !MetaStoreUtils.isExternalTable(oldt)) {
                newTblLoc = wh.getDefaultTablePath(newt.getDbName(), newt.getTableName()).toString();
                newt.getSd().setLocation(newTblLoc);
                oldTblLoc = oldt.getSd().getLocation();
                moveData = true;
                srcPath = new Path(oldTblLoc);
                srcFs = wh.getFs(srcPath);
                destPath = new Path(newTblLoc);
                destFs = wh.getFs(destPath);
                if (srcFs != destFs) {
                    throw new InvalidOperationException("table new location " + destPath + " is on a different file system than the old location " + srcPath + ". This operation is not supported");
                }
                try {
                    srcFs.exists(srcPath);
                    if (destFs.exists(destPath)) {
                        throw new InvalidOperationException("New location for this table " + newt.getDbName() + "." + newt.getTableName() + " already exists : " + destPath);
                    }
                }
                catch (IOException e) {
                    Warehouse.closeFs(srcFs);
                    Warehouse.closeFs(destFs);
                    throw new InvalidOperationException("Unable to access new location " + destPath + " for table " + newt.getDbName() + "." + newt.getTableName());
                }
                List<Partition> parts = msdb.getPartitions(dbname, name, 0);
                for (Partition part : parts) {
                    String oldPartLoc = part.getSd().getLocation();
                    Path oldPartLocPath = new Path(oldPartLoc);
                    String oldTblLocPath = new Path(oldTblLoc).toUri().getPath();
                    String newTblLocPath = new Path(newTblLoc).toUri().getPath();
                    if (!oldPartLoc.contains(oldTblLocPath)) continue;
                    Path newPartLocPath = null;
                    URI oldUri = oldPartLocPath.toUri();
                    String newPath = oldUri.getPath().replace(oldTblLocPath, newTblLocPath);
                    newPartLocPath = new Path(oldUri.getScheme(), oldUri.getAuthority(), newPath);
                    part.getSd().setLocation(newPartLocPath.toString());
                    msdb.alterPartition(dbname, name, part);
                }
            }
            msdb.alterTable(dbname, name, newt);
            success = msdb.commitTransaction();
            if (!success) {
                msdb.rollbackTransaction();
            }
            if (!success) return;
            if (!moveData) return;
        }
        catch (InvalidObjectException e) {
            try {
                LOG.debug((Object)e);
                throw new InvalidOperationException("Unable to change partition or table. Check metastore logs for detailed stack." + e.getMessage());
            }
            catch (Throwable throwable) {
                if (!success) {
                    msdb.rollbackTransaction();
                }
                if (!success) throw throwable;
                if (!moveData) throw throwable;
                try {
                    if (!srcFs.exists(srcPath)) throw throwable;
                    srcFs.rename(srcPath, destPath);
                    throw throwable;
                }
                catch (IOException e2) {
                    boolean revertMetaDataTransaction = false;
                    try {
                        msdb.openTransaction();
                        msdb.alterTable(dbname, newt.getTableName(), oldt);
                        revertMetaDataTransaction = msdb.commitTransaction();
                        throw new InvalidOperationException("Unable to access old location " + srcPath + " for table " + dbname + "." + name);
                    }
                    catch (Exception e1) {
                        LOG.error((Object)"Reverting metadata opeation failed During HDFS operation failed", (Throwable)e1);
                        if (revertMetaDataTransaction) throw new InvalidOperationException("Unable to access old location " + srcPath + " for table " + dbname + "." + name);
                        msdb.rollbackTransaction();
                    }
                    throw new InvalidOperationException("Unable to access old location " + srcPath + " for table " + dbname + "." + name);
                }
            }
        }
        try {
            if (!srcFs.exists(srcPath)) return;
            srcFs.rename(srcPath, destPath);
            return;
        }
        catch (IOException e) {
            boolean revertMetaDataTransaction = false;
            try {
                msdb.openTransaction();
                msdb.alterTable(dbname, newt.getTableName(), oldt);
                revertMetaDataTransaction = msdb.commitTransaction();
                throw new InvalidOperationException("Unable to access old location " + srcPath + " for table " + dbname + "." + name);
            }
            catch (Exception e1) {
                LOG.error((Object)"Reverting metadata opeation failed During HDFS operation failed", (Throwable)e1);
                if (revertMetaDataTransaction) throw new InvalidOperationException("Unable to access old location " + srcPath + " for table " + dbname + "." + name);
                msdb.rollbackTransaction();
            }
            throw new InvalidOperationException("Unable to access old location " + srcPath + " for table " + dbname + "." + name);
        }
    }
}

