/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.thrift.TException;

public interface IMetaStoreClient {
    public void close();

    public List<String> getDatabases(String var1) throws MetaException, TException;

    public List<String> getAllDatabases() throws MetaException, TException;

    public List<String> getTables(String var1, String var2) throws MetaException, TException, UnknownDBException;

    public List<String> getAllTables(String var1) throws MetaException, TException, UnknownDBException;

    public void dropTable(String var1, String var2, boolean var3, boolean var4) throws MetaException, TException, NoSuchObjectException;

    @Deprecated
    public void dropTable(String var1, boolean var2) throws MetaException, UnknownTableException, TException, NoSuchObjectException;

    public void dropTable(String var1, String var2) throws MetaException, TException, NoSuchObjectException;

    public boolean tableExists(String var1, String var2) throws MetaException, TException, UnknownDBException;

    @Deprecated
    public boolean tableExists(String var1) throws MetaException, TException, UnknownDBException;

    @Deprecated
    public Table getTable(String var1) throws MetaException, TException, NoSuchObjectException;

    public Database getDatabase(String var1) throws NoSuchObjectException, MetaException, TException;

    public Table getTable(String var1, String var2) throws MetaException, TException, NoSuchObjectException;

    public Partition appendPartition(String var1, String var2, List<String> var3) throws InvalidObjectException, AlreadyExistsException, MetaException, TException;

    public Partition appendPartition(String var1, String var2, String var3) throws InvalidObjectException, AlreadyExistsException, MetaException, TException;

    public Partition add_partition(Partition var1) throws InvalidObjectException, AlreadyExistsException, MetaException, TException;

    public Partition getPartition(String var1, String var2, List<String> var3) throws NoSuchObjectException, MetaException, TException;

    public Partition getPartition(String var1, String var2, String var3) throws MetaException, UnknownTableException, NoSuchObjectException, TException;

    public Partition getPartitionWithAuthInfo(String var1, String var2, List<String> var3, String var4, List<String> var5) throws MetaException, UnknownTableException, NoSuchObjectException, TException;

    public List<Partition> listPartitions(String var1, String var2, short var3) throws NoSuchObjectException, MetaException, TException;

    public List<Partition> listPartitions(String var1, String var2, List<String> var3, short var4) throws NoSuchObjectException, MetaException, TException;

    public List<String> listPartitionNames(String var1, String var2, short var3) throws MetaException, TException;

    public List<String> listPartitionNames(String var1, String var2, List<String> var3, short var4) throws MetaException, TException;

    public List<Partition> listPartitionsWithAuthInfo(String var1, String var2, short var3, String var4, List<String> var5) throws MetaException, TException, NoSuchObjectException;

    public List<Partition> listPartitionsWithAuthInfo(String var1, String var2, List<String> var3, short var4, String var5, List<String> var6) throws MetaException, TException, NoSuchObjectException;

    public void createTable(Table var1) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException;

    public void alter_table(String var1, String var2, Table var3) throws InvalidOperationException, MetaException, TException;

    public void createDatabase(Database var1) throws InvalidObjectException, AlreadyExistsException, MetaException, TException;

    public void dropDatabase(String var1) throws NoSuchObjectException, InvalidOperationException, MetaException, TException;

    public void dropDatabase(String var1, boolean var2, boolean var3) throws NoSuchObjectException, InvalidOperationException, MetaException, TException;

    public void alterDatabase(String var1, Database var2) throws NoSuchObjectException, MetaException, TException;

    public boolean dropPartition(String var1, String var2, List<String> var3, boolean var4) throws NoSuchObjectException, MetaException, TException;

    public boolean dropPartition(String var1, String var2, String var3, boolean var4) throws NoSuchObjectException, MetaException, TException;

    public void alter_partition(String var1, String var2, Partition var3) throws InvalidOperationException, MetaException, TException;

    public List<FieldSchema> getFields(String var1, String var2) throws MetaException, TException, UnknownTableException, UnknownDBException;

    public List<FieldSchema> getSchema(String var1, String var2) throws MetaException, TException, UnknownTableException, UnknownDBException;

    public String getConfigValue(String var1, String var2) throws TException, ConfigValSecurityException;

    public List<String> partitionNameToVals(String var1) throws MetaException, TException;

    public Map<String, String> partitionNameToSpec(String var1) throws MetaException, TException;

    public void createIndex(Index var1, Table var2) throws InvalidObjectException, MetaException, NoSuchObjectException, TException, AlreadyExistsException;

    public void alter_index(String var1, String var2, String var3, Index var4) throws InvalidOperationException, MetaException, TException;

    public Index getIndex(String var1, String var2, String var3) throws MetaException, UnknownTableException, NoSuchObjectException, TException;

    public List<Index> listIndexes(String var1, String var2, short var3) throws NoSuchObjectException, MetaException, TException;

    public List<String> listIndexNames(String var1, String var2, short var3) throws MetaException, TException;

    public boolean dropIndex(String var1, String var2, String var3, boolean var4) throws NoSuchObjectException, MetaException, TException;

    public boolean create_role(Role var1) throws MetaException, TException;

    public boolean drop_role(String var1) throws MetaException, TException;

    public List<String> listRoleNames() throws MetaException, TException;

    public boolean grant_role(String var1, String var2, PrincipalType var3, String var4, PrincipalType var5, boolean var6) throws MetaException, TException;

    public boolean revoke_role(String var1, String var2, PrincipalType var3) throws MetaException, TException;

    public List<Role> list_roles(String var1, PrincipalType var2) throws MetaException, TException;

    public PrincipalPrivilegeSet get_privilege_set(HiveObjectRef var1, String var2, List<String> var3) throws MetaException, TException;

    public List<HiveObjectPrivilege> list_privileges(String var1, PrincipalType var2, HiveObjectRef var3) throws MetaException, TException;

    public boolean grant_privileges(PrivilegeBag var1) throws MetaException, TException;

    public boolean revoke_privileges(PrivilegeBag var1) throws MetaException, TException;

    public String getDelegationTokenWithSignature(String var1, String var2) throws MetaException, TException;

    public String getDelegationToken(String var1) throws MetaException, TException;

    public long renewDelegationToken(String var1) throws MetaException, TException;

    public void cancelDelegationToken(String var1) throws MetaException, TException;
}

