/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.mongodb.importer;

import com.jaspersoft.mongodb.connection.MongoDbConnection;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.util.JSON;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import net.sf.jasperreports.engine.JRException;
import org.apache.log4j.Logger;
import org.springframework.core.io.Resource;

public class MongoDbSimpleImporter {
    private final Logger logger = Logger.getLogger(MongoDbSimpleImporter.class);

    public MongoDbSimpleImporter(String mongoURI, String collectionName, Resource scriptResource) throws JRException {
        this(mongoURI, null, null, collectionName, scriptResource);
    }

    public MongoDbSimpleImporter(String mongoURI, String username, String password, String collectionName, Resource scriptResource) throws JRException {
        MongoDbConnection connection = new MongoDbConnection(mongoURI, username, password);
        this.populate(connection, collectionName, scriptResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populate(MongoDbConnection connection, String collectionName, Resource scriptResource) throws JRException {
        DBCollection collection = null;
        DB mongoDatabase = null;
        try {
            mongoDatabase = connection.getMongoDatabase();
            if (!mongoDatabase.collectionExists(collectionName)) {
                this.logger.info((Object)("Collection \"" + collectionName + "\" doesn't exist"));
                BasicDBObject options = new BasicDBObject("capped", (Object)false);
                collection = mongoDatabase.createCollection(collectionName, (DBObject)options);
            } else {
                this.logger.info((Object)("Collection \"" + collectionName + "\" exists"));
                collection = mongoDatabase.getCollectionFromString(collectionName);
                collection.drop();
                this.logger.info((Object)("Collection \"" + collectionName + "\" was cleaned up"));
            }
        }
        catch (MongoException e) {
            e.printStackTrace();
        }
        if (mongoDatabase == null) {
            throw new JRException("Failed connection to mongoDB database: " + connection.getMongoURIObject().getDatabase());
        }
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader reader = null;
        try {
            String currentLine;
            inputStreamReader = new InputStreamReader(scriptResource.getInputStream());
            reader = new BufferedReader(inputStreamReader);
            StringBuilder stringBuilder = new StringBuilder();
            while ((currentLine = reader.readLine()) != null) {
                stringBuilder.append(currentLine);
            }
            Object parseResult = JSON.parse((String)stringBuilder.toString());
            if (!(parseResult instanceof BasicDBList)) {
                throw new JRException("Unsupported type: " + parseResult.getClass().getName() + ". It must be a list");
            }
            BasicDBList list = (BasicDBList)parseResult;
            ArrayList<DBObject> objectsList = new ArrayList<DBObject>();
            for (int index = 0; index < list.size(); ++index) {
                objectsList.add((DBObject)list.get(index));
            }
            collection.insert(objectsList);
            this.logger.info((Object)("Collection count: " + collection.count() + "\nSuccessfully populated collection: " + collectionName));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

