/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.support.ResourceEditorRegistrar;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.context.Lifecycle;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.ContextStartedEvent;
import org.springframework.context.event.ContextStoppedEvent;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.context.support.ApplicationContextAwareProcessor;
import org.springframework.context.support.ContextTypeMatchClassLoader;
import org.springframework.context.support.DelegatingMessageSource;
import org.springframework.core.JdkVersion;
import org.springframework.core.OrderComparator;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public abstract class AbstractApplicationContext
extends DefaultResourceLoader
implements ConfigurableApplicationContext,
DisposableBean {
    public static final String MESSAGE_SOURCE_BEAN_NAME = "messageSource";
    public static final String APPLICATION_EVENT_MULTICASTER_BEAN_NAME = "applicationEventMulticaster";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ApplicationContext parent;
    private final List beanFactoryPostProcessors = new ArrayList();
    private String displayName = ObjectUtils.identityToString(this);
    private long startupDate;
    private boolean active = false;
    private final Object activeMonitor = new Object();
    private final Object startupShutdownMonitor = new Object();
    private Thread shutdownHook;
    private ResourcePatternResolver resourcePatternResolver;
    private MessageSource messageSource;
    private ApplicationEventMulticaster applicationEventMulticaster;
    private List applicationListeners = new ArrayList();
    static /* synthetic */ Class class$org$springframework$core$PriorityOrdered;
    static /* synthetic */ Class class$org$springframework$core$Ordered;

    public AbstractApplicationContext() {
        this((ApplicationContext)null);
    }

    public AbstractApplicationContext(ApplicationContext parent) {
        this.parent = parent;
        this.resourcePatternResolver = this.getResourcePatternResolver();
    }

    public ApplicationContext getParent() {
        return this.parent;
    }

    public AutowireCapableBeanFactory getAutowireCapableBeanFactory() throws IllegalStateException {
        return this.getBeanFactory();
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public long getStartupDate() {
        return this.startupDate;
    }

    public void publishEvent(ApplicationEvent event) {
        Assert.notNull(event, "Event must not be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Publishing event in context [" + ObjectUtils.identityToString(this) + "]: " + event));
        }
        this.getApplicationEventMulticaster().multicastEvent(event);
        if (this.parent != null) {
            this.parent.publishEvent(event);
        }
    }

    private ApplicationEventMulticaster getApplicationEventMulticaster() throws IllegalStateException {
        if (this.applicationEventMulticaster == null) {
            throw new IllegalStateException("ApplicationEventMulticaster not initialized - call 'refresh' before multicasting events via the context: " + this);
        }
        return this.applicationEventMulticaster;
    }

    protected ResourcePatternResolver getResourcePatternResolver() {
        return new PathMatchingResourcePatternResolver(this);
    }

    public void setParent(ApplicationContext parent) {
        this.parent = parent;
    }

    public void addBeanFactoryPostProcessor(BeanFactoryPostProcessor beanFactoryPostProcessor) {
        this.beanFactoryPostProcessors.add(beanFactoryPostProcessor);
    }

    public List getBeanFactoryPostProcessors() {
        return this.beanFactoryPostProcessors;
    }

    public void addApplicationListener(ApplicationListener listener) {
        this.applicationListeners.add(listener);
    }

    public List getApplicationListeners() {
        return this.applicationListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws BeansException, IllegalStateException {
        Object object = this.startupShutdownMonitor;
        synchronized (object) {
            this.prepareRefresh();
            ConfigurableListableBeanFactory beanFactory = this.obtainFreshBeanFactory();
            this.prepareBeanFactory(beanFactory);
            try {
                this.postProcessBeanFactory(beanFactory);
                this.invokeBeanFactoryPostProcessors(beanFactory);
                this.registerBeanPostProcessors(beanFactory);
                this.initMessageSource();
                this.initApplicationEventMulticaster();
                this.initLifecycleDependentBeans();
                this.onRefresh();
                this.registerListeners();
                this.finishBeanFactoryInitialization(beanFactory);
                this.finishRefresh();
            }
            catch (BeansException ex) {
                beanFactory.destroySingletons();
                this.cancelRefresh(ex);
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareRefresh() {
        this.startupDate = System.currentTimeMillis();
        Object object = this.activeMonitor;
        synchronized (object) {
            this.active = true;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Refreshing " + this));
        }
    }

    protected ConfigurableListableBeanFactory obtainFreshBeanFactory() {
        this.refreshBeanFactory();
        ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Bean factory for application context [" + ObjectUtils.identityToString(this) + "]: " + ObjectUtils.identityToString(beanFactory)));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(beanFactory.getBeanDefinitionCount() + " beans defined in " + this));
        }
        return beanFactory;
    }

    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.setBeanClassLoader(this.getClassLoader());
        beanFactory.addPropertyEditorRegistrar(new ResourceEditorRegistrar(this));
        beanFactory.addBeanPostProcessor(new ApplicationContextAwareProcessor(this));
        beanFactory.ignoreDependencyInterface(ResourceLoaderAware.class);
        beanFactory.ignoreDependencyInterface(ApplicationEventPublisherAware.class);
        beanFactory.ignoreDependencyInterface(MessageSourceAware.class);
        beanFactory.ignoreDependencyInterface(ApplicationContextAware.class);
        beanFactory.registerResolvableDependency(BeanFactory.class, beanFactory);
        beanFactory.registerResolvableDependency(ResourceLoader.class, this);
        beanFactory.registerResolvableDependency(ApplicationEventPublisher.class, this);
        beanFactory.registerResolvableDependency(ApplicationContext.class, this);
        if (beanFactory.containsBean("loadTimeWeaver") && JdkVersion.isAtLeastJava15()) {
            try {
                Class ltwapClass = ClassUtils.forName("org.springframework.context.weaving.LoadTimeWeaverAwareProcessor", this.getClass().getClassLoader());
                BeanPostProcessor ltwap = (BeanPostProcessor)BeanUtils.instantiateClass(ltwapClass);
                ((BeanFactoryAware)((Object)ltwap)).setBeanFactory(beanFactory);
                beanFactory.addBeanPostProcessor(ltwap);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException("Spring's LoadTimeWeaverAwareProcessor class is not available");
            }
            beanFactory.setTempClassLoader(new ContextTypeMatchClassLoader(beanFactory.getBeanClassLoader()));
        }
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
    }

    protected void invokeBeanFactoryPostProcessors(ConfigurableListableBeanFactory beanFactory) {
        Iterator it = this.getBeanFactoryPostProcessors().iterator();
        while (it.hasNext()) {
            BeanFactoryPostProcessor factoryProcessor = (BeanFactoryPostProcessor)it.next();
            factoryProcessor.postProcessBeanFactory(beanFactory);
        }
        String[] postProcessorNames = beanFactory.getBeanNamesForType(BeanFactoryPostProcessor.class, true, false);
        ArrayList<Object> priorityOrderedPostProcessors = new ArrayList<Object>();
        ArrayList<String> orderedPostProcessorNames = new ArrayList<String>();
        ArrayList<String> nonOrderedPostProcessorNames = new ArrayList<String>();
        for (int i = 0; i < postProcessorNames.length; ++i) {
            if (this.isTypeMatch(postProcessorNames[i], class$org$springframework$core$PriorityOrdered == null ? AbstractApplicationContext.class$("org.springframework.core.PriorityOrdered") : class$org$springframework$core$PriorityOrdered)) {
                priorityOrderedPostProcessors.add(beanFactory.getBean(postProcessorNames[i]));
                continue;
            }
            if (this.isTypeMatch(postProcessorNames[i], class$org$springframework$core$Ordered == null ? AbstractApplicationContext.class$("org.springframework.core.Ordered") : class$org$springframework$core$Ordered)) {
                orderedPostProcessorNames.add(postProcessorNames[i]);
                continue;
            }
            nonOrderedPostProcessorNames.add(postProcessorNames[i]);
        }
        Collections.sort(priorityOrderedPostProcessors, new OrderComparator());
        this.invokeBeanFactoryPostProcessors(beanFactory, priorityOrderedPostProcessors);
        ArrayList<Object> orderedPostProcessors = new ArrayList<Object>();
        Iterator it2 = orderedPostProcessorNames.iterator();
        while (it2.hasNext()) {
            String postProcessorName = (String)it2.next();
            orderedPostProcessors.add(this.getBean(postProcessorName));
        }
        Collections.sort(orderedPostProcessors, new OrderComparator());
        this.invokeBeanFactoryPostProcessors(beanFactory, orderedPostProcessors);
        ArrayList<Object> nonOrderedPostProcessors = new ArrayList<Object>();
        Iterator it3 = nonOrderedPostProcessorNames.iterator();
        while (it3.hasNext()) {
            String postProcessorName = (String)it3.next();
            nonOrderedPostProcessors.add(this.getBean(postProcessorName));
        }
        this.invokeBeanFactoryPostProcessors(beanFactory, nonOrderedPostProcessors);
    }

    private void invokeBeanFactoryPostProcessors(ConfigurableListableBeanFactory beanFactory, List postProcessors) {
        Iterator it = postProcessors.iterator();
        while (it.hasNext()) {
            BeanFactoryPostProcessor postProcessor = (BeanFactoryPostProcessor)it.next();
            postProcessor.postProcessBeanFactory(beanFactory);
        }
    }

    protected void registerBeanPostProcessors(ConfigurableListableBeanFactory beanFactory) {
        String[] postProcessorNames = beanFactory.getBeanNamesForType(BeanPostProcessor.class, true, false);
        int beanProcessorTargetCount = beanFactory.getBeanPostProcessorCount() + 1 + postProcessorNames.length;
        beanFactory.addBeanPostProcessor(new BeanPostProcessorChecker(beanFactory, beanProcessorTargetCount));
        ArrayList<Object> priorityOrderedPostProcessors = new ArrayList<Object>();
        ArrayList<String> orderedPostProcessorNames = new ArrayList<String>();
        ArrayList<String> nonOrderedPostProcessorNames = new ArrayList<String>();
        for (int i = 0; i < postProcessorNames.length; ++i) {
            if (this.isTypeMatch(postProcessorNames[i], class$org$springframework$core$PriorityOrdered == null ? AbstractApplicationContext.class$("org.springframework.core.PriorityOrdered") : class$org$springframework$core$PriorityOrdered)) {
                priorityOrderedPostProcessors.add(beanFactory.getBean(postProcessorNames[i]));
                continue;
            }
            if (this.isTypeMatch(postProcessorNames[i], class$org$springframework$core$Ordered == null ? AbstractApplicationContext.class$("org.springframework.core.Ordered") : class$org$springframework$core$Ordered)) {
                orderedPostProcessorNames.add(postProcessorNames[i]);
                continue;
            }
            nonOrderedPostProcessorNames.add(postProcessorNames[i]);
        }
        Collections.sort(priorityOrderedPostProcessors, new OrderComparator());
        this.registerBeanPostProcessors(beanFactory, priorityOrderedPostProcessors);
        ArrayList<Object> orderedPostProcessors = new ArrayList<Object>();
        Iterator it = orderedPostProcessorNames.iterator();
        while (it.hasNext()) {
            String postProcessorName = (String)it.next();
            orderedPostProcessors.add(this.getBean(postProcessorName));
        }
        Collections.sort(orderedPostProcessors, new OrderComparator());
        this.registerBeanPostProcessors(beanFactory, orderedPostProcessors);
        ArrayList<Object> nonOrderedPostProcessors = new ArrayList<Object>();
        Iterator it2 = nonOrderedPostProcessorNames.iterator();
        while (it2.hasNext()) {
            String postProcessorName = (String)it2.next();
            nonOrderedPostProcessors.add(this.getBean(postProcessorName));
        }
        this.registerBeanPostProcessors(beanFactory, nonOrderedPostProcessors);
    }

    private void registerBeanPostProcessors(ConfigurableListableBeanFactory beanFactory, List postProcessors) {
        Iterator it = postProcessors.iterator();
        while (it.hasNext()) {
            BeanPostProcessor postProcessor = (BeanPostProcessor)it.next();
            beanFactory.addBeanPostProcessor(postProcessor);
        }
    }

    protected void initMessageSource() {
        ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
        if (beanFactory.containsLocalBean(MESSAGE_SOURCE_BEAN_NAME)) {
            HierarchicalMessageSource hms;
            this.messageSource = (MessageSource)beanFactory.getBean(MESSAGE_SOURCE_BEAN_NAME, MessageSource.class);
            if (this.parent != null && this.messageSource instanceof HierarchicalMessageSource && (hms = (HierarchicalMessageSource)this.messageSource).getParentMessageSource() == null) {
                hms.setParentMessageSource(this.getInternalParentMessageSource());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using MessageSource [" + this.messageSource + "]"));
            }
        } else {
            DelegatingMessageSource dms = new DelegatingMessageSource();
            dms.setParentMessageSource(this.getInternalParentMessageSource());
            this.messageSource = dms;
            beanFactory.registerSingleton(MESSAGE_SOURCE_BEAN_NAME, this.messageSource);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Unable to locate MessageSource with name 'messageSource': using default [" + this.messageSource + "]"));
            }
        }
    }

    protected void initApplicationEventMulticaster() {
        ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
        if (beanFactory.containsLocalBean(APPLICATION_EVENT_MULTICASTER_BEAN_NAME)) {
            this.applicationEventMulticaster = (ApplicationEventMulticaster)beanFactory.getBean(APPLICATION_EVENT_MULTICASTER_BEAN_NAME, ApplicationEventMulticaster.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using ApplicationEventMulticaster [" + this.applicationEventMulticaster + "]"));
            }
        } else {
            this.applicationEventMulticaster = new SimpleApplicationEventMulticaster();
            beanFactory.registerSingleton(APPLICATION_EVENT_MULTICASTER_BEAN_NAME, this.applicationEventMulticaster);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Unable to locate ApplicationEventMulticaster with name 'applicationEventMulticaster': using default [" + this.applicationEventMulticaster + "]"));
            }
        }
    }

    protected void initLifecycleDependentBeans() {
        String[] lifecycleBeans = this.getBeanNamesForType(Lifecycle.class, false, false);
        for (int i = 0; i < lifecycleBeans.length; ++i) {
            String[] dependsOn;
            BeanDefinition bd;
            String beanName = lifecycleBeans[i];
            if (!this.getBeanFactory().containsBeanDefinition(beanName) || !((bd = this.getBeanFactory().getBeanDefinition(beanName)) instanceof AbstractBeanDefinition) || (dependsOn = ((AbstractBeanDefinition)bd).getDependsOn()) == null) continue;
            for (int j = 0; j < dependsOn.length; ++j) {
                this.getBeanFactory().registerDependentBean(dependsOn[j], beanName);
            }
        }
    }

    protected void onRefresh() throws BeansException {
    }

    protected void registerListeners() {
        Iterator it = this.getApplicationListeners().iterator();
        while (it.hasNext()) {
            this.addListener((ApplicationListener)it.next());
        }
        Collection listenerBeans = this.getBeansOfType(ApplicationListener.class, true, false).values();
        Iterator it2 = listenerBeans.iterator();
        while (it2.hasNext()) {
            this.addListener((ApplicationListener)it2.next());
        }
    }

    protected void addListener(ApplicationListener listener) {
        this.getApplicationEventMulticaster().addApplicationListener(listener);
    }

    protected void finishBeanFactoryInitialization(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.setTempClassLoader(null);
        beanFactory.preInstantiateSingletons();
    }

    protected void finishRefresh() {
        this.publishEvent(new ContextRefreshedEvent(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelRefresh(BeansException ex) {
        Object object = this.activeMonitor;
        synchronized (object) {
            this.active = false;
        }
    }

    public void registerShutdownHook() {
        if (this.shutdownHook == null) {
            this.shutdownHook = new Thread(){

                public void run() {
                    AbstractApplicationContext.this.doClose();
                }
            };
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    public void destroy() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.startupShutdownMonitor;
        synchronized (object) {
            this.doClose();
            if (this.shutdownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() {
        if (this.isActive()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Closing " + this));
            }
            try {
                this.publishEvent(new ContextClosedEvent(this));
            }
            catch (Throwable ex) {
                this.logger.error((Object)"Exception thrown from ApplicationListener handling ContextClosedEvent", ex);
            }
            this.stop();
            this.destroyBeans();
            this.closeBeanFactory();
            this.onClose();
            Object object = this.activeMonitor;
            synchronized (object) {
                this.active = false;
            }
        }
    }

    protected void destroyBeans() {
        this.getBeanFactory().destroySingletons();
    }

    protected void onClose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        Object object = this.activeMonitor;
        synchronized (object) {
            return this.active;
        }
    }

    public Object getBean(String name) throws BeansException {
        return this.getBeanFactory().getBean(name);
    }

    public Object getBean(String name, Class requiredType) throws BeansException {
        return this.getBeanFactory().getBean(name, requiredType);
    }

    public Object getBean(String name, Object[] args) throws BeansException {
        return this.getBeanFactory().getBean(name, args);
    }

    public boolean containsBean(String name) {
        return this.getBeanFactory().containsBean(name);
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return this.getBeanFactory().isSingleton(name);
    }

    public boolean isPrototype(String name) throws NoSuchBeanDefinitionException {
        return this.getBeanFactory().isPrototype(name);
    }

    public boolean isTypeMatch(String name, Class targetType) throws NoSuchBeanDefinitionException {
        return this.getBeanFactory().isTypeMatch(name, targetType);
    }

    public Class getType(String name) throws NoSuchBeanDefinitionException {
        return this.getBeanFactory().getType(name);
    }

    public String[] getAliases(String name) {
        return this.getBeanFactory().getAliases(name);
    }

    public boolean containsBeanDefinition(String name) {
        return this.getBeanFactory().containsBeanDefinition(name);
    }

    public int getBeanDefinitionCount() {
        return this.getBeanFactory().getBeanDefinitionCount();
    }

    public String[] getBeanDefinitionNames() {
        return this.getBeanFactory().getBeanDefinitionNames();
    }

    public String[] getBeanNamesForType(Class type) {
        return this.getBeanFactory().getBeanNamesForType(type);
    }

    public String[] getBeanNamesForType(Class type, boolean includePrototypes, boolean allowEagerInit) {
        return this.getBeanFactory().getBeanNamesForType(type, includePrototypes, allowEagerInit);
    }

    public Map getBeansOfType(Class type) throws BeansException {
        return this.getBeanFactory().getBeansOfType(type);
    }

    public Map getBeansOfType(Class type, boolean includePrototypes, boolean allowEagerInit) throws BeansException {
        return this.getBeanFactory().getBeansOfType(type, includePrototypes, allowEagerInit);
    }

    public BeanFactory getParentBeanFactory() {
        return this.getParent();
    }

    public boolean containsLocalBean(String name) {
        return this.getBeanFactory().containsLocalBean(name);
    }

    protected BeanFactory getInternalParentBeanFactory() {
        return this.getParent() instanceof ConfigurableApplicationContext ? ((ConfigurableApplicationContext)this.getParent()).getBeanFactory() : this.getParent();
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        return this.getMessageSource().getMessage(code, args, defaultMessage, locale);
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        return this.getMessageSource().getMessage(code, args, locale);
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        return this.getMessageSource().getMessage(resolvable, locale);
    }

    private MessageSource getMessageSource() throws IllegalStateException {
        if (this.messageSource == null) {
            throw new IllegalStateException("MessageSource not initialized - call 'refresh' before accessing messages via the context: " + this);
        }
        return this.messageSource;
    }

    protected MessageSource getInternalParentMessageSource() {
        return this.getParent() instanceof AbstractApplicationContext ? ((AbstractApplicationContext)this.getParent()).messageSource : this.getParent();
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        return this.resourcePatternResolver.getResources(locationPattern);
    }

    public void start() {
        Map lifecycleBeans = this.getLifecycleBeans();
        Iterator it = new HashSet(lifecycleBeans.keySet()).iterator();
        while (it.hasNext()) {
            String beanName = (String)it.next();
            this.doStart(lifecycleBeans, beanName);
        }
        this.publishEvent(new ContextStartedEvent(this));
    }

    public void stop() {
        Map lifecycleBeans = this.getLifecycleBeans();
        Iterator it = new HashSet(lifecycleBeans.keySet()).iterator();
        while (it.hasNext()) {
            String beanName = (String)it.next();
            this.doStop(lifecycleBeans, beanName);
        }
        this.publishEvent(new ContextStoppedEvent(this));
    }

    public boolean isRunning() {
        Iterator it = this.getLifecycleBeans().values().iterator();
        while (it.hasNext()) {
            Lifecycle lifecycle = (Lifecycle)it.next();
            if (lifecycle.isRunning()) continue;
            return false;
        }
        return true;
    }

    private Map getLifecycleBeans() {
        ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
        String[] beanNames = beanFactory.getBeanNamesForType(Lifecycle.class, false, false);
        HashMap<String, Object> beans = new HashMap<String, Object>(beanNames.length);
        for (int i = 0; i < beanNames.length; ++i) {
            Object bean = beanFactory.getSingleton(beanNames[i]);
            if (bean == null) continue;
            beans.put(beanNames[i], bean);
        }
        return beans;
    }

    private void doStart(Map lifecycleBeans, String beanName) {
        Lifecycle bean = (Lifecycle)lifecycleBeans.get(beanName);
        if (bean != null) {
            String[] dependenciesForBean = this.getBeanFactory().getDependenciesForBean(beanName);
            for (int i = 0; i < dependenciesForBean.length; ++i) {
                this.doStart(lifecycleBeans, dependenciesForBean[i]);
            }
            if (!bean.isRunning()) {
                bean.start();
            }
            lifecycleBeans.remove(beanName);
        }
    }

    private void doStop(Map lifecycleBeans, String beanName) {
        Lifecycle bean = (Lifecycle)lifecycleBeans.get(beanName);
        if (bean != null) {
            String[] dependentBeans = this.getBeanFactory().getDependentBeans(beanName);
            for (int i = 0; i < dependentBeans.length; ++i) {
                this.doStop(lifecycleBeans, dependentBeans[i]);
            }
            if (bean.isRunning()) {
                bean.stop();
            }
            lifecycleBeans.remove(beanName);
        }
    }

    protected abstract void refreshBeanFactory() throws BeansException, IllegalStateException;

    protected abstract void closeBeanFactory();

    public abstract ConfigurableListableBeanFactory getBeanFactory() throws IllegalStateException;

    public String toString() {
        StringBuffer sb = new StringBuffer(ObjectUtils.identityToString(this));
        sb.append(": display name [").append(this.getDisplayName());
        sb.append("]; startup date [").append(new Date(this.getStartupDate()));
        sb.append("]; ");
        ApplicationContext parent = this.getParent();
        if (parent == null) {
            sb.append("root of context hierarchy");
        } else {
            sb.append("parent: ").append(ObjectUtils.identityToString(parent));
        }
        return sb.toString();
    }

    static {
        ContextClosedEvent.class.getName();
    }

    private class BeanPostProcessorChecker
    implements BeanPostProcessor {
        private final ConfigurableListableBeanFactory beanFactory;
        private final int beanPostProcessorTargetCount;

        public BeanPostProcessorChecker(ConfigurableListableBeanFactory beanFactory, int beanPostProcessorTargetCount) {
            this.beanFactory = beanFactory;
            this.beanPostProcessorTargetCount = beanPostProcessorTargetCount;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) {
            if (!(bean instanceof BeanPostProcessor) && this.beanFactory.getBeanPostProcessorCount() < this.beanPostProcessorTargetCount && AbstractApplicationContext.this.logger.isInfoEnabled()) {
                AbstractApplicationContext.this.logger.info((Object)("Bean '" + beanName + "' is not eligible for getting processed by all " + "BeanPostProcessors (for example: not eligible for auto-proxying)"));
            }
            return bean;
        }
    }
}

