/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class ColumnInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String internalName;
    private String alias = null;
    private String tabAlias;
    private boolean isVirtualCol;
    private transient ObjectInspector objectInspector;
    private boolean isHiddenVirtualCol;

    public ColumnInfo() {
    }

    public ColumnInfo(String internalName, TypeInfo type, String tabAlias, boolean isVirtualCol) {
        this(internalName, type, tabAlias, isVirtualCol, false);
    }

    public ColumnInfo(String internalName, Class type, String tabAlias, boolean isVirtualCol) {
        this(internalName, TypeInfoFactory.getPrimitiveTypeInfoFromPrimitiveWritable(type), tabAlias, isVirtualCol, false);
    }

    public ColumnInfo(String internalName, TypeInfo type, String tabAlias, boolean isVirtualCol, boolean isHiddenVirtualCol) {
        this(internalName, TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(type), tabAlias, isVirtualCol, isHiddenVirtualCol);
    }

    public ColumnInfo(String internalName, ObjectInspector objectInspector, String tabAlias, boolean isVirtualCol) {
        this(internalName, objectInspector, tabAlias, isVirtualCol, false);
    }

    public ColumnInfo(String internalName, ObjectInspector objectInspector, String tabAlias, boolean isVirtualCol, boolean isHiddenVirtualCol) {
        this.internalName = internalName;
        this.objectInspector = objectInspector;
        this.tabAlias = tabAlias;
        this.isVirtualCol = isVirtualCol;
        this.isHiddenVirtualCol = isHiddenVirtualCol;
    }

    public TypeInfo getType() {
        return TypeInfoUtils.getTypeInfoFromObjectInspector(this.objectInspector);
    }

    public ObjectInspector getObjectInspector() {
        return this.objectInspector;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public void setType(TypeInfo type) {
        this.objectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(type);
    }

    public void setInternalName(String internalName) {
        this.internalName = internalName;
    }

    public String getTabAlias() {
        return this.tabAlias;
    }

    public boolean getIsVirtualCol() {
        return this.isVirtualCol;
    }

    public boolean isHiddenVirtualCol() {
        return this.isHiddenVirtualCol;
    }

    public String toString() {
        return this.internalName + ": " + this.objectInspector.getTypeName();
    }

    public void setAlias(String col_alias) {
        this.alias = col_alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setTabAlias(String tabAlias) {
        this.tabAlias = tabAlias;
    }

    public void setVirtualCol(boolean isVirtualCol) {
        this.isVirtualCol = isVirtualCol;
    }

    public void setHiddenVirtualCol(boolean isHiddenVirtualCol) {
        this.isHiddenVirtualCol = isHiddenVirtualCol;
    }
}

