/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.persistence.AbstractRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.RowContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBooleanObjectInspector;
import org.apache.hadoop.io.BooleanWritable;

public abstract class CommonJoinOperator<T extends JoinDesc>
extends Operator<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Log LOG = LogFactory.getLog((String)CommonJoinOperator.class.getName());
    protected transient int numAliases;
    protected transient Map<Byte, List<ExprNodeEvaluator>> joinValues;
    protected transient Map<Byte, List<ExprNodeEvaluator>> joinFilters;
    protected transient Map<Byte, List<ObjectInspector>> joinValuesObjectInspectors;
    protected transient Map<Byte, List<ObjectInspector>> joinFilterObjectInspectors;
    protected transient Map<Byte, List<ObjectInspector>> joinValuesStandardObjectInspectors;
    protected transient Map<Byte, List<ObjectInspector>> rowContainerStandardObjectInspectors;
    protected transient Byte[] order;
    protected transient JoinCondDesc[] condn;
    public transient boolean noOuterJoin;
    protected transient Object[] dummyObj;
    protected transient RowContainer<ArrayList<Object>>[] dummyObjVectors;
    protected transient int totalSz;
    private transient Map<Integer, Set<String>> posToAliasMap;
    transient LazyBinarySerDe[] spillTableSerDe;
    protected transient Map<Byte, TableDesc> spillTableDesc;
    HashMap<Byte, AbstractRowContainer<ArrayList<Object>>> storage;
    int joinEmitInterval = -1;
    int joinCacheSize = 0;
    int nextSz = 0;
    transient Byte lastAlias = null;
    transient boolean handleSkewJoin = false;
    protected transient int countAfterReport;
    protected transient int heartbeatInterval;
    protected static final int NOTSKIPBIGTABLE = -1;
    Configuration hconf;
    transient boolean newGroupStarted = false;
    protected transient Byte alias;
    transient Object[] forwardCache;

    public CommonJoinOperator() {
    }

    public CommonJoinOperator(CommonJoinOperator<T> clone) {
        this.joinEmitInterval = clone.joinEmitInterval;
        this.joinCacheSize = clone.joinCacheSize;
        this.nextSz = clone.nextSz;
        this.childOperators = clone.childOperators;
        this.parentOperators = clone.parentOperators;
        this.counterNames = clone.counterNames;
        this.counterNameToEnum = clone.counterNameToEnum;
        this.done = clone.done;
        this.operatorId = clone.operatorId;
        this.storage = clone.storage;
        this.condn = clone.condn;
        this.conf = clone.getConf();
        this.setSchema(clone.getSchema());
        this.alias = clone.alias;
        this.beginTime = clone.beginTime;
        this.inputRows = clone.inputRows;
        this.childOperatorsArray = clone.childOperatorsArray;
        this.childOperatorsTag = clone.childOperatorsTag;
        this.colExprMap = clone.colExprMap;
        this.counters = clone.counters;
        this.dummyObj = clone.dummyObj;
        this.dummyObjVectors = clone.dummyObjVectors;
        this.forwardCache = clone.forwardCache;
        this.groupKeyObject = clone.groupKeyObject;
        this.handleSkewJoin = clone.handleSkewJoin;
        this.hconf = clone.hconf;
        this.id = clone.id;
        this.inputObjInspectors = clone.inputObjInspectors;
        this.inputRows = clone.inputRows;
        this.noOuterJoin = clone.noOuterJoin;
        this.numAliases = clone.numAliases;
        this.operatorId = clone.operatorId;
        this.posToAliasMap = clone.posToAliasMap;
        this.spillTableDesc = clone.spillTableDesc;
        this.statsMap = clone.statsMap;
        this.joinFilters = clone.joinFilters;
        this.joinFilterObjectInspectors = clone.joinFilterObjectInspectors;
    }

    protected static <T extends JoinDesc> ObjectInspector getJoinOutputObjectInspector(Byte[] order, Map<Byte, List<ObjectInspector>> aliasToObjectInspectors, T conf) {
        ArrayList<ObjectInspector> structFieldObjectInspectors = new ArrayList<ObjectInspector>();
        for (Byte alias : order) {
            List<ObjectInspector> oiList = aliasToObjectInspectors.get(alias);
            structFieldObjectInspectors.addAll(oiList);
        }
        StandardStructObjectInspector joinOutputObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(conf.getOutputColumnNames(), structFieldObjectInspectors);
        return joinOutputObjectInspector;
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        this.handleSkewJoin = ((JoinDesc)this.conf).getHandleSkewJoin();
        this.hconf = hconf;
        this.heartbeatInterval = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVESENDHEARTBEAT);
        this.countAfterReport = 0;
        this.totalSz = 0;
        this.storage = new HashMap();
        this.numAliases = ((JoinDesc)this.conf).getExprs().size();
        this.joinValues = new HashMap<Byte, List<ExprNodeEvaluator>>();
        this.joinFilters = new HashMap<Byte, List<ExprNodeEvaluator>>();
        this.order = ((JoinDesc)this.conf).getTagOrder();
        this.condn = ((JoinDesc)this.conf).getConds();
        this.noOuterJoin = ((JoinDesc)this.conf).isNoOuterJoin();
        this.totalSz = JoinUtil.populateJoinKeyValue(this.joinValues, ((JoinDesc)this.conf).getExprs(), this.order, -1);
        this.joinFilters = new HashMap<Byte, List<ExprNodeEvaluator>>();
        JoinUtil.populateJoinKeyValue(this.joinFilters, ((JoinDesc)this.conf).getFilters(), this.order, -1);
        this.joinValuesObjectInspectors = JoinUtil.getObjectInspectorsFromEvaluators(this.joinValues, this.inputObjInspectors, -1);
        this.joinFilterObjectInspectors = JoinUtil.getObjectInspectorsFromEvaluators(this.joinFilters, this.inputObjInspectors, -1);
        this.joinValuesStandardObjectInspectors = JoinUtil.getStandardObjectInspectors(this.joinValuesObjectInspectors, -1);
        if (this.noOuterJoin) {
            this.rowContainerStandardObjectInspectors = this.joinValuesStandardObjectInspectors;
        } else {
            HashMap<Byte, List<ObjectInspector>> rowContainerObjectInspectors = new HashMap<Byte, List<ObjectInspector>>();
            for (Byte alias : this.order) {
                ArrayList<WritableBooleanObjectInspector> rcOIs = new ArrayList<WritableBooleanObjectInspector>();
                rcOIs.addAll((Collection)this.joinValuesObjectInspectors.get(alias));
                rcOIs.add(PrimitiveObjectInspectorFactory.writableBooleanObjectInspector);
                rowContainerObjectInspectors.put(alias, rcOIs);
            }
            this.rowContainerStandardObjectInspectors = JoinUtil.getStandardObjectInspectors(rowContainerObjectInspectors, -1);
        }
        this.dummyObj = new Object[this.numAliases];
        this.dummyObjVectors = new RowContainer[this.numAliases];
        this.joinEmitInterval = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEJOINEMITINTERVAL);
        this.joinCacheSize = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEJOINCACHESIZE);
        byte pos = 0;
        for (Byte alias : this.order) {
            int sz = ((JoinDesc)this.conf).getExprs().get(alias).size();
            ArrayList<BooleanWritable> nr = new ArrayList<BooleanWritable>(sz);
            for (int j = 0; j < sz; ++j) {
                nr.add(null);
            }
            if (!this.noOuterJoin) {
                nr.add(new BooleanWritable(false));
            }
            this.dummyObj[pos] = nr;
            RowContainer values = JoinUtil.getRowContainer(hconf, this.rowContainerStandardObjectInspectors.get(pos), alias, 1, this.spillTableDesc, (JoinDesc)this.conf, this.noOuterJoin);
            values.add((ArrayList)this.dummyObj[pos]);
            this.dummyObjVectors[pos] = values;
            RowContainer rc = JoinUtil.getRowContainer(hconf, this.rowContainerStandardObjectInspectors.get(pos), alias, this.joinCacheSize, this.spillTableDesc, (JoinDesc)this.conf, this.noOuterJoin);
            this.storage.put(pos, rc);
            pos = (byte)(pos + 1);
        }
        this.forwardCache = new Object[this.totalSz];
        this.outputObjInspector = CommonJoinOperator.getJoinOutputObjectInspector(this.order, this.joinValuesStandardObjectInspectors, (JoinDesc)this.conf);
        LOG.info((Object)("JOIN " + ((StructObjectInspector)this.outputObjInspector).getTypeName() + " totalsz = " + this.totalSz));
    }

    @Override
    public void startGroup() throws HiveException {
        LOG.trace((Object)"Join: Starting new group");
        this.newGroupStarted = true;
        for (AbstractRowContainer<ArrayList<Object>> alw : this.storage.values()) {
            alw.clear();
        }
    }

    protected int getNextSize(int sz) {
        if (sz >= 100000) {
            return sz + 100000;
        }
        return 2 * sz;
    }

    private void createForwardJoinObject(IntermediateObject intObj, boolean[] nullsArr) throws HiveException {
        int p = 0;
        for (int i = 0; i < this.numAliases; ++i) {
            Byte alias = this.order[i];
            int sz = this.joinValues.get(alias).size();
            if (nullsArr[i]) {
                for (int j = 0; j < sz; ++j) {
                    this.forwardCache[p++] = null;
                }
                continue;
            }
            ArrayList<Object> obj = intObj.getObjs()[i];
            for (int j = 0; j < sz; ++j) {
                this.forwardCache[p++] = obj.get(j);
            }
        }
        this.forward(this.forwardCache, this.outputObjInspector);
        this.countAfterReport = 0;
    }

    private void copyOldArray(boolean[] src, boolean[] dest) {
        for (int i = 0; i < src.length; ++i) {
            dest[i] = src[i];
        }
    }

    private ArrayList<boolean[]> joinObjectsInnerJoin(ArrayList<boolean[]> resNulls, ArrayList<boolean[]> inputNulls, ArrayList<Object> newObj, IntermediateObject intObj, int left, boolean newObjNull) {
        if (newObjNull) {
            return resNulls;
        }
        for (boolean[] oldNulls : inputNulls) {
            boolean oldObjNull = oldNulls[left];
            if (oldObjNull) continue;
            boolean[] newNulls = new boolean[intObj.getCurSize()];
            this.copyOldArray(oldNulls, newNulls);
            newNulls[oldNulls.length] = false;
            resNulls.add(newNulls);
        }
        return resNulls;
    }

    private ArrayList<boolean[]> joinObjectsLeftSemiJoin(ArrayList<boolean[]> resNulls, ArrayList<boolean[]> inputNulls, ArrayList<Object> newObj, IntermediateObject intObj, int left, boolean newObjNull) {
        if (newObjNull) {
            return resNulls;
        }
        for (boolean[] oldNulls : inputNulls) {
            boolean oldObjNull = oldNulls[left];
            if (oldObjNull) continue;
            boolean[] newNulls = new boolean[intObj.getCurSize()];
            this.copyOldArray(oldNulls, newNulls);
            newNulls[oldNulls.length] = false;
            resNulls.add(newNulls);
        }
        return resNulls;
    }

    private ArrayList<boolean[]> joinObjectsLeftOuterJoin(ArrayList<boolean[]> resNulls, ArrayList<boolean[]> inputNulls, ArrayList<Object> newObj, IntermediateObject intObj, int left, boolean newObjNull) {
        int filterIndex = this.joinValues.get(this.order[left]).size();
        if (filterIndex < intObj.getObjs()[left].size()) {
            newObjNull = newObjNull || ((BooleanWritable)intObj.getObjs()[left].get(filterIndex)).get();
        }
        for (boolean[] oldNulls : inputNulls) {
            boolean oldObjNull = oldNulls[left];
            boolean[] newNulls = new boolean[intObj.getCurSize()];
            this.copyOldArray(oldNulls, newNulls);
            newNulls[oldNulls.length] = oldObjNull ? true : newObjNull;
            resNulls.add(newNulls);
        }
        return resNulls;
    }

    private ArrayList<boolean[]> joinObjectsRightOuterJoin(ArrayList<boolean[]> resNulls, ArrayList<boolean[]> inputNulls, ArrayList<Object> newObj, IntermediateObject intObj, int left, boolean newObjNull, boolean firstRow) {
        if (newObjNull) {
            return resNulls;
        }
        if (inputNulls.isEmpty() && firstRow) {
            boolean[] newNulls = new boolean[intObj.getCurSize()];
            for (int i = 0; i < intObj.getCurSize() - 1; ++i) {
                newNulls[i] = true;
            }
            newNulls[intObj.getCurSize() - 1] = newObjNull;
            resNulls.add(newNulls);
            return resNulls;
        }
        boolean allOldObjsNull = firstRow;
        for (boolean[] oldNulls : inputNulls) {
            if (oldNulls[left]) continue;
            allOldObjsNull = false;
            break;
        }
        if (((BooleanWritable)newObj.get(newObj.size() - 1)).get()) {
            allOldObjsNull = true;
        }
        for (boolean[] oldNulls : inputNulls) {
            boolean[] newNulls;
            boolean oldObjNull;
            boolean bl = oldObjNull = oldNulls[left] || allOldObjsNull;
            if (!oldObjNull) {
                newNulls = new boolean[intObj.getCurSize()];
                this.copyOldArray(oldNulls, newNulls);
                newNulls[oldNulls.length] = newObjNull;
                resNulls.add(newNulls);
                continue;
            }
            if (!allOldObjsNull) continue;
            newNulls = new boolean[intObj.getCurSize()];
            for (int i = 0; i < intObj.getCurSize() - 1; ++i) {
                newNulls[i] = true;
            }
            newNulls[oldNulls.length] = newObjNull;
            resNulls.add(newNulls);
            return resNulls;
        }
        return resNulls;
    }

    private ArrayList<boolean[]> joinObjectsFullOuterJoin(ArrayList<boolean[]> resNulls, ArrayList<boolean[]> inputNulls, ArrayList<Object> newObj, IntermediateObject intObj, int left, boolean newObjNull, boolean firstRow) {
        if (newObjNull) {
            for (boolean[] oldNulls : inputNulls) {
                boolean[] newNulls = new boolean[intObj.getCurSize()];
                this.copyOldArray(oldNulls, newNulls);
                newNulls[oldNulls.length] = newObjNull;
                resNulls.add(newNulls);
            }
            return resNulls;
        }
        if (inputNulls.isEmpty() && firstRow) {
            boolean[] newNulls = new boolean[intObj.getCurSize()];
            for (int i = 0; i < intObj.getCurSize() - 1; ++i) {
                newNulls[i] = true;
            }
            newNulls[intObj.getCurSize() - 1] = newObjNull;
            resNulls.add(newNulls);
            return resNulls;
        }
        boolean allOldObjsNull = firstRow;
        for (boolean[] oldNulls : inputNulls) {
            if (oldNulls[left]) continue;
            allOldObjsNull = false;
            break;
        }
        if (((BooleanWritable)newObj.get(newObj.size() - 1)).get()) {
            allOldObjsNull = true;
        }
        boolean rhsPreserved = false;
        for (boolean[] oldNulls : inputNulls) {
            boolean[] newNulls;
            boolean oldObjNull;
            boolean bl = oldObjNull = oldNulls[left] || ((BooleanWritable)intObj.getObjs()[left].get(this.joinValues.get(this.order[left]).size())).get() || allOldObjsNull;
            if (!oldObjNull) {
                newNulls = new boolean[intObj.getCurSize()];
                this.copyOldArray(oldNulls, newNulls);
                newNulls[oldNulls.length] = newObjNull;
                resNulls.add(newNulls);
                continue;
            }
            if (!oldObjNull) continue;
            newNulls = new boolean[intObj.getCurSize()];
            this.copyOldArray(oldNulls, newNulls);
            newNulls[oldNulls.length] = true;
            resNulls.add(newNulls);
            if (!allOldObjsNull || rhsPreserved) continue;
            newNulls = new boolean[intObj.getCurSize()];
            for (int i = 0; i < oldNulls.length; ++i) {
                newNulls[i] = true;
            }
            newNulls[oldNulls.length] = false;
            resNulls.add(newNulls);
            rhsPreserved = true;
        }
        return resNulls;
    }

    private ArrayList<boolean[]> joinObjects(ArrayList<boolean[]> inputNulls, ArrayList<Object> newObj, IntermediateObject intObj, int joinPos, boolean firstRow) {
        boolean newObjNull;
        ArrayList<boolean[]> resNulls = new ArrayList<boolean[]>();
        boolean bl = newObjNull = newObj == this.dummyObj[joinPos];
        if (joinPos == 0) {
            if (newObjNull) {
                return null;
            }
            boolean[] nulls = new boolean[]{newObjNull};
            resNulls.add(nulls);
            return resNulls;
        }
        int left = this.condn[joinPos - 1].getLeft();
        int type = this.condn[joinPos - 1].getType();
        if ((type == 2 || type == 3) && !newObjNull && inputNulls == null && firstRow) {
            boolean[] newNulls = new boolean[intObj.getCurSize()];
            for (int i = 0; i < newNulls.length - 1; ++i) {
                newNulls[i] = true;
            }
            newNulls[newNulls.length - 1] = false;
            resNulls.add(newNulls);
            return resNulls;
        }
        if (inputNulls == null) {
            return null;
        }
        if (type == 0) {
            return this.joinObjectsInnerJoin(resNulls, inputNulls, newObj, intObj, left, newObjNull);
        }
        if (type == 1) {
            return this.joinObjectsLeftOuterJoin(resNulls, inputNulls, newObj, intObj, left, newObjNull);
        }
        if (type == 2) {
            return this.joinObjectsRightOuterJoin(resNulls, inputNulls, newObj, intObj, left, newObjNull, firstRow);
        }
        if (type == 5) {
            return this.joinObjectsLeftSemiJoin(resNulls, inputNulls, newObj, intObj, left, newObjNull);
        }
        assert (type == 3);
        return this.joinObjectsFullOuterJoin(resNulls, inputNulls, newObj, intObj, left, newObjNull, firstRow);
    }

    private void genObject(ArrayList<boolean[]> inputNulls, int aliasNum, IntermediateObject intObj, boolean firstRow) throws HiveException {
        boolean childFirstRow = firstRow;
        boolean skipping = false;
        if (aliasNum < this.numAliases) {
            AbstractRowContainer<ArrayList<Object>> aliasRes = this.storage.get(this.order[aliasNum]);
            ArrayList<Object> newObj = aliasRes.first();
            while (newObj != null) {
                if (aliasNum > 0 && this.condn[aliasNum - 1].getType() == 5 && newObj != this.dummyObj[aliasNum]) {
                    skipping = true;
                }
                intObj.pushObj(newObj);
                ArrayList<boolean[]> newNulls = this.joinObjects(inputNulls, newObj, intObj, aliasNum, childFirstRow);
                this.genObject(newNulls, aliasNum + 1, intObj, firstRow);
                intObj.popObj();
                firstRow = false;
                if (!skipping) {
                    newObj = aliasRes.next();
                    continue;
                }
                break;
            }
        } else {
            if (inputNulls == null) {
                return;
            }
            for (boolean[] nullsVec : inputNulls) {
                this.createForwardJoinObject(intObj, nullsVec);
            }
        }
    }

    @Override
    public void endGroup() throws HiveException {
        LOG.trace((Object)("Join Op: endGroup called: numValues=" + this.numAliases));
        this.checkAndGenObject();
    }

    private void genUniqueJoinObject(int aliasNum, int forwardCachePos) throws HiveException {
        AbstractRowContainer<ArrayList<Object>> alias = this.storage.get(this.order[aliasNum]);
        ArrayList<Object> row = alias.first();
        while (row != null) {
            int sz = this.joinValues.get(this.order[aliasNum]).size();
            int p = forwardCachePos;
            for (int j = 0; j < sz; ++j) {
                this.forwardCache[p++] = row.get(j);
            }
            if (aliasNum == this.numAliases - 1) {
                this.forward(this.forwardCache, this.outputObjInspector);
                this.countAfterReport = 0;
            } else {
                this.genUniqueJoinObject(aliasNum + 1, p);
            }
            row = alias.next();
        }
    }

    private void genAllOneUniqueJoinObject() throws HiveException {
        int p = 0;
        for (int i = 0; i < this.numAliases; ++i) {
            int sz = this.joinValues.get(this.order[i]).size();
            ArrayList<Object> obj = this.storage.get(this.order[i]).first();
            for (int j = 0; j < sz; ++j) {
                this.forwardCache[p++] = obj.get(j);
            }
        }
        this.forward(this.forwardCache, this.outputObjInspector);
        this.countAfterReport = 0;
    }

    protected void checkAndGenObject() throws HiveException {
        if (this.condn[0].getType() == 4) {
            boolean preserve = false;
            boolean hasNulls = false;
            boolean allOne = true;
            for (int i = 0; i < this.numAliases; ++i) {
                Byte alias = this.order[i];
                AbstractRowContainer<ArrayList<Object>> alw = this.storage.get(alias);
                if (alw.size() != 1) {
                    allOne = false;
                }
                if (alw.size() == 0) {
                    alw.add((ArrayList)this.dummyObj[i]);
                    hasNulls = true;
                    continue;
                }
                if (!this.condn[i].getPreserved()) continue;
                preserve = true;
            }
            if (hasNulls && !preserve) {
                return;
            }
            if (allOne) {
                LOG.info((Object)"calling genAllOneUniqueJoinObject");
                this.genAllOneUniqueJoinObject();
                LOG.info((Object)"called genAllOneUniqueJoinObject");
            } else {
                LOG.trace((Object)"calling genUniqueJoinObject");
                this.genUniqueJoinObject(0, 0);
                LOG.trace((Object)"called genUniqueJoinObject");
            }
        } else {
            boolean mayHasMoreThanOne = false;
            boolean hasEmpty = false;
            block1: for (int i = 0; i < this.numAliases; ++i) {
                Byte alias = this.order[i];
                AbstractRowContainer<ArrayList<Object>> alw = this.storage.get(alias);
                if (this.noOuterJoin) {
                    if (alw.size() == 0) {
                        LOG.trace((Object)("No data for alias=" + i));
                        return;
                    }
                    if (alw.size() <= 1) continue;
                    mayHasMoreThanOne = true;
                    continue;
                }
                if (alw.size() == 0) {
                    hasEmpty = true;
                    alw.add((ArrayList)this.dummyObj[i]);
                    continue;
                }
                if (!hasEmpty && alw.size() == 1) {
                    ArrayList<Object> row = alw.first();
                    int numValues = this.joinValues.get(alias).size();
                    if (row != this.dummyObj[alias] && (row.size() <= numValues || !((BooleanWritable)row.get(numValues)).get())) continue;
                    hasEmpty = true;
                    continue;
                }
                mayHasMoreThanOne = true;
                if (hasEmpty) continue;
                int numValues = this.joinValues.get(alias).size();
                ArrayList<Object> row = alw.first();
                while (row != null) {
                    if (row == this.dummyObj[alias] || row.size() > numValues && ((BooleanWritable)row.get(numValues)).get()) {
                        hasEmpty = true;
                        continue block1;
                    }
                    row = alw.next();
                }
            }
            if (!hasEmpty && !mayHasMoreThanOne) {
                LOG.trace((Object)"calling genAllOneUniqueJoinObject");
                this.genAllOneUniqueJoinObject();
                LOG.trace((Object)"called genAllOneUniqueJoinObject");
            } else if (!hasEmpty) {
                LOG.trace((Object)"calling genUniqueJoinObject");
                this.genUniqueJoinObject(0, 0);
                LOG.trace((Object)"called genUniqueJoinObject");
            } else {
                LOG.trace((Object)"calling genObject");
                this.genObject(null, 0, new IntermediateObject(new ArrayList[this.numAliases], 0), true);
                LOG.trace((Object)"called genObject");
            }
        }
    }

    protected void reportProgress() {
        ++this.countAfterReport;
        if (this.countAfterReport % this.heartbeatInterval == 0 && this.reporter != null) {
            this.reporter.progress();
            this.countAfterReport = 0;
        }
    }

    protected static Boolean isFiltered(Object row, List<ExprNodeEvaluator> filters, List<ObjectInspector> ois) throws HiveException {
        Boolean ret = false;
        for (int j = 0; j < filters.size(); ++j) {
            Object condition = filters.get(j).evaluate(row);
            ret = (Boolean)((PrimitiveObjectInspector)ois.get(j)).getPrimitiveJavaObject(condition);
            if (ret != null && ret.booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        LOG.trace((Object)"Join Op close");
        for (AbstractRowContainer<ArrayList<Object>> alw : this.storage.values()) {
            if (alw == null) continue;
            alw.clear();
        }
        this.storage.clear();
    }

    @Override
    public String getName() {
        return "JOIN";
    }

    public Map<Integer, Set<String>> getPosToAliasMap() {
        return this.posToAliasMap;
    }

    public void setPosToAliasMap(Map<Integer, Set<String>> posToAliasMap) {
        this.posToAliasMap = posToAliasMap;
    }

    public static class IntermediateObject {
        ArrayList<Object>[] objs;
        int curSize;

        public IntermediateObject(ArrayList<Object>[] objs, int curSize) {
            this.objs = objs;
            this.curSize = curSize;
        }

        public ArrayList<Object>[] getObjs() {
            return this.objs;
        }

        public int getCurSize() {
            return this.curSize;
        }

        public void pushObj(ArrayList<Object> newObj) {
            this.objs[this.curSize++] = newObj;
        }

        public void popObj() {
            --this.curSize;
        }

        public Object topObj() {
            return this.objs[this.curSize - 1];
        }
    }
}

