/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.log;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.ReflectionUtils;

public class PerfLogger {
    public static final String ACQUIRE_READ_WRITE_LOCKS = "acquireReadWriteLocks";
    public static final String COMPILE = "compile";
    public static final String DO_AUTHORIZATION = "doAuthorization";
    public static final String DRIVER_EXECUTE = "Driver.execute";
    public static final String RELEASE_LOCKS = "releaseLocks";
    public static final String PRUNE_LISTING = "prune-listing";
    public static final String PARTITION_RETRIEVING = "partition-retrieving";
    public static final String PRE_HOOK = "PreHook.";
    public static final String POST_HOOK = "PostHook.";
    public static final String FAILURE_HOOK = "FailureHook.";
    protected static final ThreadLocal<PerfLogger> perfLogger = new ThreadLocal();
    protected final Map<String, Long> perfKeyMaps = new HashMap<String, Long>();
    private static final Log LOG = LogFactory.getLog((String)PerfLogger.class.getName());

    protected PerfLogger() {
    }

    public static PerfLogger getPerfLogger() {
        return PerfLogger.getPerfLogger(false);
    }

    public static PerfLogger getPerfLogger(boolean resetPerfLogger) {
        if (perfLogger.get() == null || resetPerfLogger) {
            if (SessionState.get() == null) {
                perfLogger.set(new PerfLogger());
            } else {
                HiveConf conf = SessionState.get().getConf();
                try {
                    perfLogger.set((PerfLogger)ReflectionUtils.newInstance((Class)conf.getClassByName(conf.getVar(HiveConf.ConfVars.HIVE_PERF_LOGGER)), (Configuration)conf));
                }
                catch (ClassNotFoundException e) {
                    LOG.error((Object)("Performance Logger Class not found:" + e.getMessage()));
                    perfLogger.set(new PerfLogger());
                }
            }
        }
        return perfLogger.get();
    }

    public void PerfLogBegin(Log _log, String method) {
        long startTime = System.currentTimeMillis();
        _log.info((Object)("<PERFLOG method=" + method + ">"));
        this.perfKeyMaps.put(method, new Long(startTime));
    }

    public long PerfLogEnd(Log _log, String method) {
        Long startTime = this.perfKeyMaps.get(method);
        long endTime = System.currentTimeMillis();
        long duration = -1L;
        StringBuilder sb = new StringBuilder("</PERFLOG method=").append(method);
        if (startTime != null) {
            sb.append(" start=").append(startTime);
        }
        sb.append(" end=").append(endTime);
        if (startTime != null) {
            duration = endTime - startTime;
            sb.append(" duration=").append(duration);
        }
        sb.append(">");
        _log.info((Object)sb);
        return duration;
    }

    public void close(Log _log, QueryPlan queryPlan) {
    }
}

