/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.MapRedTask;
import org.apache.hadoop.hive.ql.exec.MoveTask;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.rcfile.merge.MergeWork;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.GenMRProcContext;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.ErrorMsg;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.plan.ConditionalResolverMergeFiles;
import org.apache.hadoop.hive.ql.plan.ConditionalWork;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExtractDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.LoadFileDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class GenMRFileSink1
implements NodeProcessor {
    private static final Log LOG = LogFactory.getLog((String)GenMRFileSink1.class.getName());

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx opProcCtx, Object ... nodeOutputs) throws SemanticException {
        GenMRProcContext ctx = (GenMRProcContext)opProcCtx;
        ParseContext parseCtx = ctx.getParseCtx();
        boolean chDir = false;
        Task<? extends Serializable> currTask = ctx.getCurrTask();
        FileSinkOperator fsOp = (FileSinkOperator)nd;
        boolean isInsertTable = ((FileSinkDesc)fsOp.getConf()).getTableInfo().getTableName() != null && parseCtx.getQB().getParseInfo().isInsertToTable();
        HiveConf hconf = parseCtx.getConf();
        if (ctx.getMvTask() != null && !ctx.getMvTask().isEmpty()) {
            List<Task<? extends Serializable>> mvTasks = ctx.getMvTask();
            if (ctx.getSeenFileSinkOps() == null || !ctx.getSeenFileSinkOps().contains(nd)) {
                MoveTask mvTask = (MoveTask)this.findMoveTask(mvTasks, fsOp);
                if (isInsertTable && hconf.getBoolVar(HiveConf.ConfVars.HIVESTATSAUTOGATHER)) {
                    this.addStatsTask(fsOp, mvTask, currTask, parseCtx.getConf());
                }
                if (mvTask != null && !mvTask.isLocal()) {
                    boolean mergeMapRed;
                    MapredWork currWork = (MapredWork)currTask.getWork();
                    boolean mergeMapOnly = hconf.getBoolVar(HiveConf.ConfVars.HIVEMERGEMAPFILES) && currWork.getReducer() == null;
                    boolean bl = mergeMapRed = hconf.getBoolVar(HiveConf.ConfVars.HIVEMERGEMAPREDFILES) && currWork.getReducer() != null;
                    if (mergeMapOnly || mergeMapRed) {
                        chDir = true;
                    }
                }
            }
        }
        String finalName = this.processFS(nd, stack, opProcCtx, chDir);
        if (chDir && finalName != null) {
            this.createMergeJob((FileSinkOperator)nd, ctx, finalName);
        }
        return null;
    }

    private void addStatsTask(FileSinkOperator nd, MoveTask mvTask, Task<? extends Serializable> currTask, HiveConf hconf) {
        MoveWork mvWork = (MoveWork)mvTask.getWork();
        StatsWork statsWork = null;
        if (mvWork.getLoadTableWork() != null) {
            statsWork = new StatsWork(mvWork.getLoadTableWork());
        } else if (mvWork.getLoadFileWork() != null) {
            statsWork = new StatsWork(mvWork.getLoadFileWork());
        }
        assert (statsWork != null) : "Error when genereting StatsTask";
        MapredWork mrWork = (MapredWork)currTask.getWork();
        statsWork.setAggKey(((FileSinkDesc)nd.getConf()).getStatsAggPrefix());
        Task<StatsWork> statsTask = TaskFactory.get(statsWork, hconf, new Task[0]);
        ((FileSinkDesc)nd.getConf()).setGatherStats(true);
        mrWork.setGatheringStats(true);
        mvTask.addDependentTask(statsTask);
        statsTask.subscribeFeed(mvTask);
    }

    private void createMapReduce4Merge(FileSinkOperator fsOp, GenMRProcContext ctx, String finalName) throws SemanticException {
        Task<? extends Serializable> currTask = ctx.getCurrTask();
        RowSchema inputRS = fsOp.getSchema();
        ArrayList<ExprNodeDesc> keyCols = new ArrayList<ExprNodeDesc>();
        keyCols.add(TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc("rand", new ExprNodeDesc[0]));
        ArrayList<ExprNodeDesc> valueCols = new ArrayList<ExprNodeDesc>();
        for (ColumnInfo ci : inputRS.getSignature()) {
            valueCols.add(new ExprNodeColumnDesc(ci.getType(), ci.getInternalName(), ci.getTabAlias(), ci.getIsVirtualCol()));
        }
        Operator<TableScanDesc> tsMerge = OperatorFactory.get(TableScanDesc.class, inputRS);
        ArrayList<String> outputColumns = new ArrayList<String>();
        for (int i = 0; i < valueCols.size(); ++i) {
            outputColumns.add(SemanticAnalyzer.getColumnInternalName(i));
        }
        ReduceSinkDesc rsDesc = PlanUtils.getReduceSinkDesc(new ArrayList<ExprNodeDesc>(), valueCols, outputColumns, false, -1, -1, -1);
        OperatorFactory.getAndMakeChild(rsDesc, inputRS, tsMerge);
        ParseContext parseCtx = ctx.getParseCtx();
        FileSinkDesc fsConf = (FileSinkDesc)fsOp.getConf();
        RowResolver out_rwsch = new RowResolver();
        RowResolver interim_rwsch = ctx.getParseCtx().getOpParseCtx().get(fsOp).getRowResolver();
        Integer pos = 0;
        for (ColumnInfo colInfo : interim_rwsch.getColumnInfos()) {
            String[] info = interim_rwsch.reverseLookup(colInfo.getInternalName());
            out_rwsch.put(info[0], info[1], new ColumnInfo(pos.toString(), colInfo.getType(), info[0], colInfo.getIsVirtualCol(), colInfo.isHiddenVirtualCol()));
            pos = pos + 1;
        }
        Operator<ExtractDesc> extract = OperatorFactory.getAndMakeChild(new ExtractDesc(new ExprNodeColumnDesc(TypeInfoFactory.stringTypeInfo, Utilities.ReduceField.VALUE.toString(), "", false)), new RowSchema(out_rwsch.getColumnInfos()), new Operator[0]);
        TableDesc ts = (TableDesc)fsConf.getTableInfo().clone();
        fsConf.getTableInfo().getProperties().remove("partition_columns");
        FileSinkDesc newFSD = new FileSinkDesc(finalName, ts, parseCtx.getConf().getBoolVar(HiveConf.ConfVars.COMPRESSRESULT));
        FileSinkOperator newOutput = (FileSinkOperator)OperatorFactory.getAndMakeChild(newFSD, inputRS, extract);
        HiveConf conf = parseCtx.getConf();
        MapredWork cplan = this.createMergeTask(conf, tsMerge, fsConf);
        cplan.setReducer(extract);
        MoveWork dummyMv = new MoveWork(null, null, null, new LoadFileDesc(fsConf.getDirName(), finalName, true, null, null), false);
        ConditionalTask cndTsk = this.createCondTask(conf, currTask, dummyMv, cplan, fsConf.getDirName());
        this.LinkMoveTask(ctx, newOutput, cndTsk);
    }

    private void createMergeJob(FileSinkOperator fsOp, GenMRProcContext ctx, String finalName) throws SemanticException {
        ParseContext parseCtx = ctx.getParseCtx();
        HiveConf conf = parseCtx.getConf();
        if (conf.getBoolVar(HiveConf.ConfVars.HIVEMERGEMAPONLY) && Utilities.supportCombineFileInputFormat()) {
            this.createMap4Merge(fsOp, ctx, finalName);
            LOG.info((Object)"use CombineHiveInputformat for the merge job");
        } else {
            if (((FileSinkDesc)fsOp.getConf()).getDynPartCtx() != null) {
                throw new SemanticException(ErrorMsg.DYNAMIC_PARTITION_MERGE.getMsg());
            }
            this.createMapReduce4Merge(fsOp, ctx, finalName);
            LOG.info((Object)"use HiveInputFormat for the merge job");
        }
    }

    private void createMap4Merge(FileSinkOperator fsInput, GenMRProcContext ctx, String finalName) throws SemanticException {
        MapredWork cplan;
        ParseContext parseCtx = ctx.getParseCtx();
        FileSinkDesc fsInputDesc = (FileSinkDesc)fsInput.getConf();
        RowSchema inputRS = fsInput.getSchema();
        Operator<TableScanDesc> tsMerge = OperatorFactory.get(TableScanDesc.class, inputRS);
        TableDesc ts = (TableDesc)fsInputDesc.getTableInfo().clone();
        FileSinkDesc fsOutputDesc = new FileSinkDesc(finalName, ts, parseCtx.getConf().getBoolVar(HiveConf.ConfVars.COMPRESSRESULT));
        FileSinkOperator fsOutput = (FileSinkOperator)OperatorFactory.getAndMakeChild(fsOutputDesc, inputRS, tsMerge);
        DynamicPartitionCtx dpCtx = fsInputDesc.getDynPartCtx();
        if (dpCtx != null && dpCtx.getNumDPCols() > 0) {
            ArrayList<ColumnInfo> signature = inputRS.getSignature();
            String tblAlias = fsInputDesc.getTableInfo().getTableName();
            LinkedHashMap<String, String> colMap = new LinkedHashMap<String, String>();
            StringBuilder partCols = new StringBuilder();
            for (String dpCol : dpCtx.getDPColNames()) {
                ColumnInfo colInfo = new ColumnInfo(dpCol, TypeInfoFactory.stringTypeInfo, tblAlias, true);
                signature.add(colInfo);
                colMap.put(dpCol, dpCol);
                partCols.append(dpCol).append('/');
            }
            partCols.setLength(partCols.length() - 1);
            inputRS.setSignature(signature);
            DynamicPartitionCtx dpCtx2 = new DynamicPartitionCtx(dpCtx);
            dpCtx2.setInputToDPCols(colMap);
            fsOutputDesc.setDynPartCtx(dpCtx2);
            fsInputDesc.getTableInfo().getProperties().setProperty("partition_columns", partCols.toString());
        } else {
            fsInputDesc.getTableInfo().getProperties().remove("partition_columns");
        }
        MapRedTask currTask = (MapRedTask)ctx.getCurrTask();
        MoveWork dummyMv = new MoveWork(null, null, null, new LoadFileDesc(fsInputDesc.getDirName(), finalName, true, null, null), false);
        if (parseCtx.getConf().getBoolVar(HiveConf.ConfVars.HIVEMERGERCFILEBLOCKLEVEL) && fsInputDesc.getTableInfo().getInputFileFormatClass().equals(RCFileInputFormat.class)) {
            String inputFormatClass = parseCtx.getConf().getVar(HiveConf.ConfVars.HIVEMERGEINPUTFORMATBLOCKLEVEL);
            try {
                Class<?> c = Class.forName(inputFormatClass);
                LOG.info((Object)"RCFile format- Using block level merge");
                cplan = this.createRCFileMergeTask(fsInputDesc, finalName, dpCtx != null && dpCtx.getNumDPCols() > 0);
            }
            catch (ClassNotFoundException e) {
                String msg = "Illegal input format class: " + inputFormatClass;
                throw new SemanticException(msg);
            }
        } else {
            cplan = this.createMergeTask(ctx.getConf(), tsMerge, fsInputDesc);
        }
        cplan.setInputformat("org.apache.hadoop.hive.ql.io.CombineHiveInputFormat");
        ConditionalTask cndTsk = this.createCondTask(ctx.getConf(), ctx.getCurrTask(), dummyMv, cplan, fsInputDesc.getDirName());
        ConditionalResolverMergeFiles.ConditionalResolverMergeFilesCtx mrCtx = (ConditionalResolverMergeFiles.ConditionalResolverMergeFilesCtx)cndTsk.getResolverCtx();
        mrCtx.setDPCtx(fsInputDesc.getDynPartCtx());
        this.LinkMoveTask(ctx, fsOutput, cndTsk);
    }

    private void LinkMoveTask(GenMRProcContext ctx, FileSinkOperator newOutput, ConditionalTask cndTsk) {
        List<Task<? extends Serializable>> mvTasks = ctx.getMvTask();
        Task<? extends Serializable> mvTask = this.findMoveTask(mvTasks, newOutput);
        if (mvTask != null) {
            for (Task<? extends Serializable> tsk : cndTsk.getListTasks()) {
                tsk.addDependentTask(mvTask);
            }
        }
    }

    private MapredWork createMergeTask(HiveConf conf, Operator<? extends Serializable> topOp, FileSinkDesc fsDesc) {
        ArrayList<String> aliases = new ArrayList<String>();
        String inputDir = fsDesc.getDirName();
        TableDesc tblDesc = fsDesc.getTableInfo();
        aliases.add(inputDir);
        MapredWork cplan = GenMapRedUtils.getMapRedWorkFromConf(conf);
        cplan.getPathToAliases().put(inputDir, aliases);
        cplan.getPathToPartitionInfo().put(inputDir, new PartitionDesc(tblDesc, null));
        cplan.setNumReduceTasks(0);
        cplan.getAliasToWork().put(inputDir, topOp);
        cplan.setMapperCannotSpanPartns(true);
        return cplan;
    }

    private MapredWork createRCFileMergeTask(FileSinkDesc fsInputDesc, String finalName, boolean hasDynamicPartitions) throws SemanticException {
        String inputDir = fsInputDesc.getDirName();
        TableDesc tblDesc = fsInputDesc.getTableInfo();
        if (tblDesc.getInputFileFormatClass().equals(RCFileInputFormat.class)) {
            ArrayList<String> inputDirs = new ArrayList<String>();
            if (!hasDynamicPartitions) {
                inputDirs.add(inputDir);
            }
            MergeWork work = new MergeWork(inputDirs, finalName, hasDynamicPartitions);
            LinkedHashMap<String, ArrayList<String>> pathToAliases = new LinkedHashMap<String, ArrayList<String>>();
            pathToAliases.put(inputDir, (ArrayList)inputDirs.clone());
            work.setMapperCannotSpanPartns(true);
            work.setPathToAliases(pathToAliases);
            work.setAliasToWork(new LinkedHashMap<String, Operator<? extends Serializable>>());
            if (hasDynamicPartitions) {
                work.getPathToPartitionInfo().put(inputDir, new PartitionDesc(tblDesc, null));
            }
            return work;
        }
        throw new SemanticException("createRCFileMergeTask called on non-RCFile table");
    }

    private ConditionalTask createCondTask(HiveConf conf, Task<? extends Serializable> currTask, MoveWork mvWork, MapredWork mergeWork, String inputPath) {
        Task<MapredWork> mergeTask = TaskFactory.get(mergeWork, conf, new Task[0]);
        Task<MoveWork> moveTask = TaskFactory.get(mvWork, conf, new Task[0]);
        ArrayList<Serializable> listWorks = new ArrayList<Serializable>();
        listWorks.add(mvWork);
        listWorks.add(mergeWork);
        ConditionalWork cndWork = new ConditionalWork(listWorks);
        ArrayList<Task<? extends Serializable>> listTasks = new ArrayList<Task<? extends Serializable>>();
        listTasks.add(moveTask);
        listTasks.add(mergeTask);
        ConditionalTask cndTsk = (ConditionalTask)TaskFactory.get(cndWork, conf, new Task[0]);
        cndTsk.setListTasks(listTasks);
        cndTsk.setResolver(new ConditionalResolverMergeFiles());
        ConditionalResolverMergeFiles.ConditionalResolverMergeFilesCtx mrCtx = new ConditionalResolverMergeFiles.ConditionalResolverMergeFilesCtx(listTasks, inputPath);
        cndTsk.setResolverCtx(mrCtx);
        currTask.addDependentTask(cndTsk);
        return cndTsk;
    }

    private Task<? extends Serializable> findMoveTask(List<Task<? extends Serializable>> mvTasks, FileSinkOperator fsOp) {
        for (Task<? extends Serializable> mvTsk : mvTasks) {
            MoveWork mvWork = (MoveWork)mvTsk.getWork();
            String srcDir = null;
            if (mvWork.getLoadFileWork() != null) {
                srcDir = mvWork.getLoadFileWork().getSourceDir();
            } else if (mvWork.getLoadTableWork() != null) {
                srcDir = mvWork.getLoadTableWork().getSourceDir();
            }
            if (srcDir == null || !srcDir.equalsIgnoreCase(((FileSinkDesc)fsOp.getConf()).getDirName())) continue;
            return mvTsk;
        }
        return null;
    }

    private String processFS(Node nd, Stack<Node> stack, NodeProcessorCtx opProcCtx, boolean chDir) throws SemanticException {
        FileSinkOperator fsOp = (FileSinkOperator)nd;
        if (fsOp.getParentOperators().size() == 1 && fsOp.getParentOperators().get(0) instanceof MapJoinOperator) {
            return null;
        }
        GenMRProcContext ctx = (GenMRProcContext)opProcCtx;
        List<FileSinkOperator> seenFSOps = ctx.getSeenFileSinkOps();
        if (seenFSOps == null) {
            seenFSOps = new ArrayList<FileSinkOperator>();
        }
        if (!seenFSOps.contains(fsOp)) {
            seenFSOps.add(fsOp);
        }
        ctx.setSeenFileSinkOps(seenFSOps);
        Task<? extends Serializable> currTask = ctx.getCurrTask();
        String dest = null;
        if (chDir) {
            dest = ((FileSinkDesc)fsOp.getConf()).getDirName();
            ParseContext parseCtx = ctx.getParseCtx();
            Context baseCtx = parseCtx.getContext();
            String tmpDir = baseCtx.getExternalTmpFileURI(new Path(dest).toUri());
            ((FileSinkDesc)fsOp.getConf()).setDirName(tmpDir);
        }
        Task<? extends Serializable> mvTask = null;
        if (!chDir) {
            mvTask = this.findMoveTask(ctx.getMvTask(), fsOp);
        }
        Operator<? extends Serializable> currTopOp = ctx.getCurrTopOp();
        String currAliasId = ctx.getCurrAliasId();
        HashMap<Operator<? extends Serializable>, Task<? extends Serializable>> opTaskMap = ctx.getOpTaskMap();
        List<Operator<? extends Serializable>> seenOps = ctx.getSeenOps();
        List<Task<? extends Serializable>> rootTasks = ctx.getRootTasks();
        if (mvTask != null) {
            currTask.addDependentTask(mvTask);
        }
        if (currTopOp != null) {
            Task<? extends Serializable> mapTask = opTaskMap.get(null);
            if (mapTask == null) {
                assert (!seenOps.contains(currTopOp));
                seenOps.add(currTopOp);
                GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, (MapredWork)currTask.getWork(), false, ctx);
                opTaskMap.put(null, currTask);
                rootTasks.add(currTask);
            } else {
                if (!seenOps.contains(currTopOp)) {
                    seenOps.add(currTopOp);
                    GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, (MapredWork)mapTask.getWork(), false, ctx);
                }
                assert (mapTask == currTask) : "mapTask.id = " + mapTask.getId() + "; currTask.id = " + currTask.getId();
            }
            return dest;
        }
        UnionOperator currUnionOp = ctx.getCurrUnionOp();
        if (currUnionOp != null) {
            opTaskMap.put(null, currTask);
            GenMapRedUtils.initUnionPlan(ctx, currTask, false);
            return dest;
        }
        AbstractMapJoinOperator<? extends MapJoinDesc> currMapJoinOp = ctx.getCurrMapJoinOp();
        if (currMapJoinOp != null) {
            opTaskMap.put(null, currTask);
            GenMRProcContext.GenMRMapJoinCtx mjCtx = ctx.getMapJoinCtx(currMapJoinOp);
            MapredWork plan = (MapredWork)currTask.getWork();
            String taskTmpDir = mjCtx.getTaskTmpDir();
            TableDesc tt_desc = mjCtx.getTTDesc();
            assert (plan.getPathToAliases().get(taskTmpDir) == null);
            plan.getPathToAliases().put(taskTmpDir, new ArrayList());
            plan.getPathToAliases().get(taskTmpDir).add(taskTmpDir);
            plan.getPathToPartitionInfo().put(taskTmpDir, new PartitionDesc(tt_desc, null));
            plan.getAliasToWork().put(taskTmpDir, mjCtx.getRootMapJoinOp());
            return dest;
        }
        return dest;
    }
}

