/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.util.ReflectionUtils;

@Description(name="reflect", value="_FUNC_(class,method[,arg1[,arg2..]]) calls method with reflection", extended="Use this UDF to call Java methods by matching the argument signature\n")
@UDFType(deterministic=false)
public class GenericUDFReflect
extends GenericUDF {
    PrimitiveObjectInspector[] argumentOIs;
    StringObjectInspector classNameOI;
    StringObjectInspector methodNameOI;
    Class<?>[] parameterJavaClasses;
    Class<?>[] parameterJavaTypes;
    Object[] parameterJavaValues;
    Class<?> c;
    Object o;
    Method m;
    Object className;
    Object methodName;
    String result;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        int i;
        if (arguments.length < 2) {
            throw new UDFArgumentLengthException("The function GenericUDFReflect(class,method[,arg1[,arg2]...]) accepts 2 or more arguments.");
        }
        for (i = 0; i < 2; ++i) {
            if (arguments[i] instanceof StringObjectInspector) continue;
            throw new UDFArgumentTypeException(i, "The first 2 parameters of GenericUDFReflect(class,method[,arg1[,arg2]...]) should be string.");
        }
        this.classNameOI = (StringObjectInspector)ObjectInspectorUtils.getStandardObjectInspector(arguments[0]);
        this.methodNameOI = (StringObjectInspector)ObjectInspectorUtils.getStandardObjectInspector(arguments[1]);
        this.parameterJavaClasses = new Class[arguments.length - 2];
        this.parameterJavaTypes = new Class[arguments.length - 2];
        for (i = 2; i < arguments.length; ++i) {
            if (arguments[i].getCategory() != ObjectInspector.Category.PRIMITIVE) {
                throw new UDFArgumentTypeException(i, "The parameters of GenericUDFReflect(class,method[,arg1[,arg2]...]) must be primitive (int, double, string, etc).");
            }
            PrimitiveObjectInspector.PrimitiveCategory category = ((PrimitiveObjectInspector)arguments[i]).getPrimitiveCategory();
            PrimitiveObjectInspectorUtils.PrimitiveTypeEntry t = PrimitiveObjectInspectorUtils.getTypeEntryFromPrimitiveCategory(category);
            this.parameterJavaClasses[i - 2] = t.primitiveJavaClass;
            this.parameterJavaTypes[i - 2] = t.primitiveJavaType;
        }
        this.parameterJavaValues = new Object[arguments.length - 2];
        this.argumentOIs = new PrimitiveObjectInspector[arguments.length];
        for (i = 0; i < arguments.length; ++i) {
            this.argumentOIs[i] = (PrimitiveObjectInspector)arguments[i];
        }
        return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(PrimitiveObjectInspector.PrimitiveCategory.STRING);
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        boolean classNameChanged = false;
        PrimitiveObjectInspector newClassNameOI = this.argumentOIs[0];
        Object newClassName = arguments[0].get();
        if (this.className == null || ObjectInspectorUtils.compare(this.className, this.classNameOI, newClassName, newClassNameOI) != 0) {
            this.className = ObjectInspectorUtils.copyToStandardObject(newClassName, newClassNameOI);
            String classNameString = this.classNameOI.getPrimitiveJavaObject(this.className);
            try {
                this.c = Class.forName(classNameString);
            }
            catch (ClassNotFoundException ex) {
                throw new HiveException("UDFReflect evaluate ", ex);
            }
            try {
                this.o = null;
                this.o = ReflectionUtils.newInstance(this.c, null);
            }
            catch (Exception e) {
                // empty catch block
            }
            classNameChanged = true;
        }
        PrimitiveObjectInspector newMethodNameOI = this.argumentOIs[1];
        Object newMethodName = arguments[1].get();
        if (this.methodName == null || ObjectInspectorUtils.compare(this.methodName, this.methodNameOI, newMethodName, newMethodNameOI) != 0 || classNameChanged) {
            this.methodName = ObjectInspectorUtils.copyToStandardObject(newMethodName, newMethodNameOI);
            String methodNameString = this.methodNameOI.getPrimitiveJavaObject(this.methodName);
            try {
                this.m = this.c.getMethod(methodNameString, this.parameterJavaClasses);
            }
            catch (SecurityException e) {
                throw new HiveException("UDFReflect getMethod ", e);
            }
            catch (NoSuchMethodException e) {
                try {
                    this.m = this.c.getMethod(methodNameString, this.parameterJavaTypes);
                }
                catch (SecurityException ex) {
                    throw new HiveException("UDFReflect getMethod ", ex);
                }
                catch (NoSuchMethodException ex) {
                    throw new HiveException("UDFReflect getMethod ", ex);
                }
            }
        }
        for (int i = 2; i < arguments.length; ++i) {
            this.parameterJavaValues[i - 2] = this.argumentOIs[i].getPrimitiveJavaObject(arguments[i].get());
        }
        try {
            this.result = String.valueOf(this.m.invoke(this.o, this.parameterJavaValues));
            return this.result;
        }
        catch (IllegalArgumentException e1) {
            System.err.println("UDFReflect evaluate " + e1 + " method = " + this.m + " args = " + Arrays.asList(this.parameterJavaValues));
        }
        catch (IllegalAccessException e1) {
            System.err.println("UDFReflect evaluate " + e1 + " method = " + this.m + " args = " + Arrays.asList(this.parameterJavaValues));
        }
        catch (InvocationTargetException e1) {
            System.err.println("UDFReflect evaluate " + e1 + " method = " + this.m + " args = " + Arrays.asList(this.parameterJavaValues));
        }
        return null;
    }

    @Override
    public String getDisplayString(String[] children) {
        StringBuilder sb = new StringBuilder();
        sb.append("reflect(");
        for (int i = 0; i < children.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(children[i]);
        }
        sb.append(')');
        return sb.toString();
    }
}

