/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazyInteger;
import org.apache.hadoop.hive.serde2.lazy.LazyLong;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazyTimestamp;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;

public final class LazyUtils {
    private static byte[] trueBytes = new byte[]{116, 114, 117, 101};
    private static byte[] falseBytes = new byte[]{102, 97, 108, 115, 101};

    public static int digit(int b, int radix) {
        int r = -1;
        if (b >= 48 && b <= 57) {
            r = b - 48;
        } else if (b >= 65 && b <= 90) {
            r = b - 65 + 10;
        } else if (b >= 97 && b <= 122) {
            r = b - 97 + 10;
        }
        if (r >= radix) {
            r = -1;
        }
        return r;
    }

    public static int compare(byte[] b1, int start1, int length1, byte[] b2, int start2, int length2) {
        int min = Math.min(length1, length2);
        for (int i = 0; i < min; ++i) {
            if (b1[start1 + i] == b2[start2 + i]) continue;
            if (b1[start1 + i] < b2[start2 + i]) {
                return -1;
            }
            return 1;
        }
        if (length1 < length2) {
            return -1;
        }
        if (length1 > length2) {
            return 1;
        }
        return 0;
    }

    public static String convertToString(byte[] bytes, int start, int length) {
        try {
            return Text.decode((byte[])bytes, (int)start, (int)length);
        }
        catch (CharacterCodingException e) {
            return null;
        }
    }

    private static void writeEscaped(OutputStream out, byte[] bytes, int start, int len, boolean escaped, byte escapeChar, boolean[] needsEscape) throws IOException {
        if (escaped) {
            int end = start + len;
            for (int i = start; i <= end; ++i) {
                if (i != end && (bytes[i] < 0 || !needsEscape[bytes[i]])) continue;
                if (i > start) {
                    out.write(bytes, start, i - start);
                }
                start = i;
                if (i >= len) continue;
                out.write(escapeChar);
            }
        } else {
            out.write(bytes, 0, len);
        }
    }

    public static void writePrimitiveUTF8(OutputStream out, Object o, PrimitiveObjectInspector oi, boolean escaped, byte escapeChar, boolean[] needsEscape) throws IOException {
        switch (oi.getPrimitiveCategory()) {
            case BOOLEAN: {
                boolean b = ((BooleanObjectInspector)oi).get(o);
                if (b) {
                    out.write(trueBytes, 0, trueBytes.length);
                    break;
                }
                out.write(falseBytes, 0, falseBytes.length);
                break;
            }
            case BYTE: {
                LazyInteger.writeUTF8(out, ((ByteObjectInspector)oi).get(o));
                break;
            }
            case SHORT: {
                LazyInteger.writeUTF8(out, ((ShortObjectInspector)oi).get(o));
                break;
            }
            case INT: {
                LazyInteger.writeUTF8(out, ((IntObjectInspector)oi).get(o));
                break;
            }
            case LONG: {
                LazyLong.writeUTF8(out, ((LongObjectInspector)oi).get(o));
                break;
            }
            case FLOAT: {
                float f = ((FloatObjectInspector)oi).get(o);
                ByteBuffer b = Text.encode((String)String.valueOf(f));
                out.write(b.array(), 0, b.limit());
                break;
            }
            case DOUBLE: {
                double d = ((DoubleObjectInspector)oi).get(o);
                ByteBuffer b = Text.encode((String)String.valueOf(d));
                out.write(b.array(), 0, b.limit());
                break;
            }
            case STRING: {
                Text t = ((StringObjectInspector)oi).getPrimitiveWritableObject(o);
                LazyUtils.writeEscaped(out, t.getBytes(), 0, t.getLength(), escaped, escapeChar, needsEscape);
                break;
            }
            case BINARY: {
                BytesWritable bw = ((BinaryObjectInspector)oi).getPrimitiveWritableObject(o);
                byte[] toEncode = new byte[bw.getLength()];
                System.arraycopy(bw.getBytes(), 0, toEncode, 0, bw.getLength());
                byte[] toWrite = Base64.encodeBase64((byte[])toEncode);
                out.write(toWrite, 0, toWrite.length);
                break;
            }
            case TIMESTAMP: {
                LazyTimestamp.writeUTF8(out, ((TimestampObjectInspector)oi).getPrimitiveWritableObject(o));
                break;
            }
            default: {
                throw new RuntimeException("Hive internal error.");
            }
        }
    }

    public static int hashBytes(byte[] data, int start, int len) {
        int hash = 1;
        for (int i = start; i < len; ++i) {
            hash = 31 * hash + data[i];
        }
        return hash;
    }

    public static void extractColumnInfo(Properties tbl, LazySimpleSerDe.SerDeParameters serdeParams, String serdeName) throws SerDeException {
        String columnNameProperty = tbl.getProperty("columns");
        String columnTypeProperty = tbl.getProperty("columns.types");
        serdeParams.columnNames = columnNameProperty != null && columnNameProperty.length() > 0 ? Arrays.asList(columnNameProperty.split(",")) : new ArrayList<String>();
        if (columnTypeProperty == null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < serdeParams.columnNames.size(); ++i) {
                if (i > 0) {
                    sb.append(":");
                }
                sb.append("string");
            }
            columnTypeProperty = sb.toString();
        }
        serdeParams.columnTypes = TypeInfoUtils.getTypeInfosFromTypeString(columnTypeProperty);
        if (serdeParams.columnNames.size() != serdeParams.columnTypes.size()) {
            throw new SerDeException(serdeName + ": columns has " + serdeParams.columnNames.size() + " elements while columns.types has " + serdeParams.columnTypes.size() + " elements!");
        }
    }

    private LazyUtils() {
    }
}

