/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.StreamIn;

public class StreamInJavaImpl
implements StreamIn {
    private static final int CHARBUF_SIZE = 16;
    private int[] charbuf = new int[16];
    private int bufpos;
    private Reader reader;
    private boolean endOfStream;
    private boolean pushed;
    private int curcol;
    private int lastcol;
    private int curline;
    private int tabsize;
    private int tabs;

    protected StreamInJavaImpl(InputStream inputStream, String string, int n) throws UnsupportedEncodingException {
        this.reader = new InputStreamReader(inputStream, string);
        this.pushed = false;
        this.tabsize = n;
        this.curline = 1;
        this.curcol = 1;
        this.endOfStream = false;
    }

    protected StreamInJavaImpl(Reader reader, int n) {
        this.reader = reader;
        this.pushed = false;
        this.tabsize = n;
        this.curline = 1;
        this.curcol = 1;
        this.endOfStream = false;
    }

    public int readCharFromStream() {
        int n;
        try {
            n = this.reader.read();
            if (n < 0) {
                this.endOfStream = true;
            }
        }
        catch (IOException iOException) {
            this.endOfStream = true;
            return -1;
        }
        return n;
    }

    public int readChar() {
        if (this.pushed) {
            int n = this.charbuf[--this.bufpos];
            if (this.bufpos == 0) {
                this.pushed = false;
            }
            if (n == 10) {
                this.curcol = 1;
                ++this.curline;
                return n;
            }
            ++this.curcol;
            return n;
        }
        this.lastcol = this.curcol++;
        if (this.tabs > 0) {
            --this.tabs;
            return 32;
        }
        int n = this.readCharFromStream();
        if (n < 0) {
            this.endOfStream = true;
            return -1;
        }
        if (n == 10) {
            this.curcol = 1;
            ++this.curline;
            return n;
        }
        if (n == 13) {
            n = this.readCharFromStream();
            if (n != 10) {
                if (n != -1) {
                    this.ungetChar(n);
                }
                n = 10;
            }
            this.curcol = 1;
            ++this.curline;
            return n;
        }
        if (n == 9) {
            this.tabs = this.tabsize - (this.curcol - 1) % this.tabsize - 1;
            ++this.curcol;
            n = 32;
            return n;
        }
        ++this.curcol;
        return n;
    }

    public void ungetChar(int n) {
        this.pushed = true;
        if (this.bufpos >= 16) {
            System.arraycopy(this.charbuf, 0, this.charbuf, 1, 15);
            --this.bufpos;
        }
        this.charbuf[this.bufpos++] = n;
        if (n == 10) {
            --this.curline;
        }
        this.curcol = this.lastcol;
    }

    public boolean isEndOfStream() {
        return this.endOfStream;
    }

    public int getCurcol() {
        return this.curcol;
    }

    public int getCurline() {
        return this.curline;
    }

    public void setLexer(Lexer lexer) {
    }
}

