/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnsupportedList<T>
implements List<T> {
    private static final Logger LOGGER = Logger.getLogger(UnsupportedList.class);

    protected UnsupportedList() {
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".size");
    }

    @Override
    public T get(int index) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".get");
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".set");
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".toArray");
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".add");
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".remove");
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".indexOf");
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".lastIndexOf");
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".subList");
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".contains");
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".toArray");
    }

    @Override
    public boolean add(T o) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".add");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".remove");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".containsAll");
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".addAll");
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".addAll");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".removeAll");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".retainAll");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".clear");
    }

    @Override
    public boolean equals(Object o) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".equals");
    }

    @Override
    public int hashCode() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".hashCode");
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".listIterator");
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".listIterator");
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".iterator");
    }

    protected class ItrUnknownSize
    extends Itr {
        public boolean hasNext() {
            try {
                UnsupportedList.this.get(this.cursor);
                return true;
            }
            catch (IndexOutOfBoundsException e) {
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ListItr
    extends Itr
    implements ListIterator<T> {
        public ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public T previous() {
            try {
                int i = this.cursor - 1;
                Object previous = UnsupportedList.this.get(i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(T o) {
            throw new UnsupportedOperationException(this.getClass().getName() + ".set");
        }

        @Override
        public void add(T o) {
            throw new UnsupportedOperationException(this.getClass().getName() + ".add");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Itr
    implements Iterator<T> {
        protected int cursor = 0;
        protected int lastRet = -1;

        @Override
        public boolean hasNext() {
            return this.cursor != UnsupportedList.this.size();
        }

        @Override
        public T next() {
            try {
                Object next = UnsupportedList.this.get(this.cursor);
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                LOGGER.error((Object)("UnsupportedList.Itr.next: cursor=" + this.cursor + ", size=" + UnsupportedList.this.size()), (Throwable)e);
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(this.getClass().getName() + ".remove");
        }
    }
}

