/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.spiderchart;

import net.sf.jasperreports.components.charts.ChartComponent;
import net.sf.jasperreports.components.charts.ChartDataset;
import net.sf.jasperreports.components.charts.ChartPlot;
import net.sf.jasperreports.components.charts.ChartSettings;
import net.sf.jasperreports.components.spiderchart.SpiderDataset;
import net.sf.jasperreports.components.spiderchart.SpiderPlot;
import net.sf.jasperreports.components.spiderchart.StandardChartSettings;
import net.sf.jasperreports.components.spiderchart.StandardSpiderDataset;
import net.sf.jasperreports.components.spiderchart.StandardSpiderPlot;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.component.BaseComponentContext;
import net.sf.jasperreports.engine.component.ComponentContext;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class SpiderChartComponent
implements ChartComponent,
JRChangeEventsSupport,
JRCloneable {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_CHART_SETTINGS = "chartSettings";
    public static final String PROPERTY_DATASET = "dataset";
    public static final String PROPERTY_PLOT = "plot";
    public static final String PROPERTY_EVALUATION_TIME = "evaluationTime";
    public static final String PROPERTY_EVALUATION_GROUP = "evaluationGroup";
    private EvaluationTimeEnum evaluationTime = EvaluationTimeEnum.NOW;
    private String evaluationGroup;
    private ChartSettings chartSettings;
    private SpiderDataset dataset;
    private SpiderPlot plot;
    private ComponentContext context;
    private transient JRPropertyChangeSupport eventSupport;

    public SpiderChartComponent() {
    }

    protected SpiderChartComponent(SpiderChartComponent chartComponent, JRBaseObjectFactory baseFactory) {
        this.evaluationTime = chartComponent.getEvaluationTime();
        this.evaluationGroup = chartComponent.getEvaluationGroup();
        this.context = new BaseComponentContext(chartComponent.getContext(), baseFactory);
        this.chartSettings = new StandardChartSettings(chartComponent.getChartSettings(), baseFactory);
        this.dataset = new StandardSpiderDataset((SpiderDataset)chartComponent.getDataset(), baseFactory);
        this.plot = new StandardSpiderPlot((SpiderPlot)chartComponent.getPlot(), baseFactory);
    }

    public ChartSettings getChartSettings() {
        return this.chartSettings;
    }

    public void setChartSettings(ChartSettings chartSettings) {
        ChartSettings old = this.chartSettings;
        this.chartSettings = chartSettings;
        this.getEventSupport().firePropertyChange(PROPERTY_CHART_SETTINGS, old, this.chartSettings);
    }

    public ChartDataset getDataset() {
        return this.dataset;
    }

    public ChartPlot getPlot() {
        return this.plot;
    }

    public void setDataset(ChartDataset dataset) {
        SpiderDataset old = this.dataset;
        this.dataset = (SpiderDataset)dataset;
        this.getEventSupport().firePropertyChange(PROPERTY_DATASET, old, this.dataset);
    }

    public void setPlot(ChartPlot plot) {
        SpiderPlot old = this.plot;
        this.plot = (SpiderPlot)plot;
        this.getEventSupport().firePropertyChange(PROPERTY_PLOT, old, this.plot);
    }

    public EvaluationTimeEnum getEvaluationTime() {
        return this.evaluationTime;
    }

    public void setEvaluationTime(EvaluationTimeEnum evaluationTime) {
        EvaluationTimeEnum old = this.evaluationTime;
        this.evaluationTime = evaluationTime;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_TIME, old, this.evaluationTime);
    }

    public String getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public void setEvaluationGroup(String evaluationGroup) {
        String old = this.evaluationGroup;
        this.evaluationGroup = evaluationGroup;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_GROUP, old, this.evaluationGroup);
    }

    public Object clone() {
        SpiderChartComponent clone = null;
        try {
            clone = (SpiderChartComponent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.chartSettings = JRCloneUtils.nullSafeClone(this.chartSettings);
        clone.dataset = JRCloneUtils.nullSafeClone(this.dataset);
        clone.plot = JRCloneUtils.nullSafeClone(this.plot);
        clone.eventSupport = null;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        SpiderChartComponent spiderChartComponent = this;
        synchronized (spiderChartComponent) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    public ComponentContext getContext() {
        return this.context;
    }

    public void setContext(ComponentContext context) {
        this.context = context;
    }
}

