/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.repo;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.sf.jasperreports.data.XmlUtil;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;
import net.sf.jasperreports.repo.CastorMapping;
import net.sf.jasperreports.repo.InputStreamResource;
import net.sf.jasperreports.repo.ObjectResource;
import net.sf.jasperreports.repo.PersistenceService;
import net.sf.jasperreports.repo.RepositoryService;
import net.sf.jasperreports.repo.Resource;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.XMLContext;
import org.xml.sax.InputSource;

public class CastorObjectPersistenceService
implements PersistenceService {
    private static volatile XMLContext xmlContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XMLContext getXmlContext() {
        if (xmlContext != null) {
            return xmlContext;
        }
        Class<CastorObjectPersistenceService> clazz = CastorObjectPersistenceService.class;
        synchronized (CastorObjectPersistenceService.class) {
            if (xmlContext != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return xmlContext;
            }
            XMLContext context = new XMLContext();
            Mapping mapping = context.createMapping();
            List<CastorMapping> castorMappings = ExtensionsEnvironment.getExtensionsRegistry().getExtensions(CastorMapping.class);
            for (CastorMapping castorMapping : castorMappings) {
                CastorObjectPersistenceService.loadMapping(mapping, castorMapping.getPath());
            }
            try {
                context.addMapping(mapping);
            }
            catch (MappingException e) {
                throw new JRRuntimeException("Failed to load Castor mappings", e);
            }
            xmlContext = context;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return xmlContext;
        }
    }

    private static void loadMapping(Mapping mapping, String mappingFile) {
        try {
            byte[] mappingFileData = JRLoader.loadBytesFromResource(mappingFile);
            InputSource mappingSource = new InputSource(new ByteArrayInputStream(mappingFileData));
            mapping.loadMapping(mappingSource);
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource load(String uri, RepositoryService repositoryService) {
        InputStream is;
        ObjectResource resource = null;
        InputStreamResource isResource = repositoryService.getResource(uri, InputStreamResource.class);
        InputStream inputStream = is = isResource == null ? null : isResource.getInputStream();
        if (is != null) {
            resource = new ObjectResource();
            try {
                resource.setValue(XmlUtil.read(is, this.getXmlContext()));
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return resource;
    }

    public void save(Resource resource, String uri, RepositoryService repositoryService) {
    }
}

