/*
 * iReport - Visual Designer for JasperReports.
 * Copyright (C) 2002 - 2009 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 *
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 *
 * This program is part of iReport.
 *
 * iReport is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * iReport is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with iReport. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.ireport.designer.tools;

import com.jaspersoft.ireport.designer.menu.OpenQueryDialogAction;
import com.jaspersoft.ireport.designer.menu.ZoomInAction;
import com.jaspersoft.ireport.designer.menu.ZoomOutAction;
import com.jaspersoft.ireport.designer.actions.CompileReportAction;
import com.jaspersoft.ireport.designer.toolbars.TextElementsToolbar;
import javax.swing.JToolBar;
import org.openide.util.actions.SystemAction;

/**
 *
 * @author  gtoffoli
 */
public class JrxmlEditorToolbar extends JToolBar {
    
    /** Creates new form JrxmlEditorToolbar */
    public JrxmlEditorToolbar() {
        initComponents();
        add(new TextElementsToolbar());
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jSeparator1 = new javax.swing.JToolBar.Separator();
        btnOpenQuery = add(SystemAction.get(OpenQueryDialogAction.class));
        btnZoomIn = add(SystemAction.get(ZoomInAction.class));
        btnZoomOut = add(SystemAction.get(ZoomOutAction.class));
        jSeparator3 = new javax.swing.JToolBar.Separator();
        btnCompile = add(SystemAction.get(CompileReportAction.class));
        jSeparator2 = new javax.swing.JToolBar.Separator();

        setBorder(null);
        setRollover(true);
        add(jSeparator1);

        btnOpenQuery.setText(org.openide.util.NbBundle.getMessage(JrxmlEditorToolbar.class, "JrxmlEditorToolbar.btnOpenQuery.text")); // NOI18N
        btnOpenQuery.setFocusable(false);
        btnOpenQuery.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        btnOpenQuery.setMaximumSize(new java.awt.Dimension(23, 23));
        btnOpenQuery.setMinimumSize(new java.awt.Dimension(23, 23));
        btnOpenQuery.setPreferredSize(new java.awt.Dimension(23, 23));
        btnOpenQuery.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        add(btnOpenQuery);

        btnZoomIn.setText(org.openide.util.NbBundle.getMessage(JrxmlEditorToolbar.class, "JrxmlEditorToolbar.btnZoomIn.text")); // NOI18N
        btnZoomIn.setFocusable(false);
        btnZoomIn.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        btnZoomIn.setMaximumSize(new java.awt.Dimension(23, 23));
        btnZoomIn.setMinimumSize(new java.awt.Dimension(23, 23));
        btnZoomIn.setPreferredSize(new java.awt.Dimension(23, 23));
        btnZoomIn.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        add(btnZoomIn);

        btnZoomOut.setText(org.openide.util.NbBundle.getMessage(JrxmlEditorToolbar.class, "JrxmlEditorToolbar.btnZoomOut.text")); // NOI18N
        btnZoomOut.setFocusable(false);
        btnZoomOut.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        btnZoomOut.setMaximumSize(new java.awt.Dimension(23, 23));
        btnZoomOut.setMinimumSize(new java.awt.Dimension(23, 23));
        btnZoomOut.setPreferredSize(new java.awt.Dimension(23, 23));
        btnZoomOut.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        add(btnZoomOut);
        add(jSeparator3);

        btnCompile.setText(org.openide.util.NbBundle.getMessage(JrxmlEditorToolbar.class, "JrxmlEditorToolbar.btnCompile.text")); // NOI18N
        btnCompile.setFocusable(false);
        btnCompile.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        btnCompile.setMaximumSize(new java.awt.Dimension(23, 23));
        btnCompile.setMinimumSize(new java.awt.Dimension(23, 23));
        btnCompile.setPreferredSize(new java.awt.Dimension(23, 23));
        btnCompile.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        add(btnCompile);
        add(jSeparator2);
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnCompile;
    private javax.swing.JButton btnOpenQuery;
    private javax.swing.JButton btnZoomIn;
    private javax.swing.JButton btnZoomOut;
    private javax.swing.JToolBar.Separator jSeparator1;
    private javax.swing.JToolBar.Separator jSeparator2;
    private javax.swing.JToolBar.Separator jSeparator3;
    // End of variables declaration//GEN-END:variables
    
}
