/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import java.text.MessageFormat;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.dlg.AddViewDialog;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.ViewListNodeInfo;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;

public class CreateViewAction
extends DatabaseAction {
    static final long serialVersionUID = -1640355770860785644L;

    public void performAction(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length <= 0) {
            return;
        }
        Node node = nodeArray[0];
        try {
            DatabaseNodeInfo databaseNodeInfo = (DatabaseNodeInfo)node.getCookie(DatabaseNodeInfo.class);
            if (!databaseNodeInfo.getDriverSpecification().areViewsSupported()) {
                String string = MessageFormat.format(CreateViewAction.bundle().getString("MSG_ViewsAreNotSupported"), databaseNodeInfo.getConnection().getMetaData().getDatabaseProductName().trim());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 1));
                return;
            }
            ViewListNodeInfo viewListNodeInfo = (ViewListNodeInfo)databaseNodeInfo.getParent(this.nodename);
            Specification specification = (Specification)viewListNodeInfo.getSpecification();
            AddViewDialog addViewDialog = new AddViewDialog(specification, databaseNodeInfo);
            if (addViewDialog.run()) {
                viewListNodeInfo.addView(addViewDialog.getViewName());
            }
        }
        catch (Exception exception) {
            DbUtilities.reportError(CreateViewAction.bundle().getString("ERR_UnableToCreateView"), exception.getMessage());
        }
    }
}

