/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.connection.gui;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.connection.JRXlsxDataSourceConnection;
import com.jaspersoft.ireport.designer.connection.gui.ExcelColumnEditor;
import com.jaspersoft.ireport.designer.connection.gui.TableExcelNumberCellRenderer;
import com.jaspersoft.ireport.designer.tools.FieldPatternDialog;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XlsxDataSourceConnectionEditor
extends JPanel
implements IReportConnectionEditor {
    private IReportConnection iReportConnection = null;
    private boolean init = false;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JButton jButtonDateFormat;
    private JButton jButtonDeleteParameter;
    private JButton jButtonFilename;
    private JButton jButtonGetColumns;
    private JButton jButtonNewParameter;
    private JButton jButtonNumberFormat;
    private JCheckBox jCheckBoxDateFormat;
    private JCheckBox jCheckBoxFirstRowAsHeader;
    private JCheckBox jCheckBoxNumberFormat;
    private JLabel jLabel15;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel6;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JPanel jPanelXLS;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JTextField jTextFieldDateFormat;
    private JTextField jTextFieldFilename;
    private JTextField jTextFieldNumberFormat;

    public XlsxDataSourceConnectionEditor() {
        this.initComponents();
        this.jTextFieldDateFormat.setText(new SimpleDateFormat().toPattern());
        this.jTextFieldNumberFormat.setText(new DecimalFormat().toPattern());
        this.jTable1.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                XlsxDataSourceConnectionEditor.this.jButtonDeleteParameter.setEnabled(XlsxDataSourceConnectionEditor.this.jTable1.getSelectedRow() >= 0);
            }
        });
        this.jTable1.getColumnModel().getColumn(1).setCellRenderer(new TableExcelNumberCellRenderer());
        this.jTable1.getColumnModel().getColumn(1).setCellEditor(new ExcelColumnEditor());
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jPanelXLS = new JPanel();
        this.jLabel15 = new JLabel();
        this.jTextFieldFilename = new JTextField();
        this.jButtonFilename = new JButton();
        this.jPanel11 = new JPanel();
        this.jPanel8 = new JPanel();
        this.jPanel9 = new JPanel();
        this.jButtonNewParameter = new JButton();
        this.jButtonDeleteParameter = new JButton();
        this.jPanel10 = new JPanel();
        this.jButtonGetColumns = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel6 = new JPanel();
        this.jCheckBoxDateFormat = new JCheckBox();
        this.jTextFieldDateFormat = new JTextField();
        this.jButtonDateFormat = new JButton();
        this.jCheckBoxNumberFormat = new JCheckBox();
        this.jTextFieldNumberFormat = new JTextField();
        this.jButtonNumberFormat = new JButton();
        this.jCheckBoxFirstRowAsHeader = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.jPanelXLS.setPreferredSize(new Dimension(1, 30));
        this.jPanelXLS.setLayout(new GridBagLayout());
        this.jLabel15.setText("Excel file");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanelXLS.add((Component)this.jLabel15, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanelXLS.add((Component)this.jTextFieldFilename, gridBagConstraints);
        this.jButtonFilename.setText("Browse");
        this.jButtonFilename.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonFilename.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XlsxDataSourceConnectionEditor.this.jButtonFilenameActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 27;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanelXLS.add((Component)this.jButtonFilename, gridBagConstraints);
        this.jPanel11.setLayout(new GridBagLayout());
        this.jPanel8.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Column names"));
        this.jPanel8.setLayout(new GridBagLayout());
        this.jPanel9.setPreferredSize(new Dimension(71, 200));
        this.jPanel9.setLayout(new GridBagLayout());
        this.jButtonNewParameter.setText("Add");
        this.jButtonNewParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XlsxDataSourceConnectionEditor.this.jButtonNewParameterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.jPanel9.add((Component)this.jButtonNewParameter, gridBagConstraints);
        this.jButtonDeleteParameter.setText("Delete");
        this.jButtonDeleteParameter.setEnabled(false);
        this.jButtonDeleteParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XlsxDataSourceConnectionEditor.this.jButtonDeleteParameterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanel9.add((Component)this.jButtonDeleteParameter, gridBagConstraints);
        this.jPanel10.setLayout(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel9.add((Component)this.jPanel10, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 4);
        this.jPanel8.add((Component)this.jPanel9, gridBagConstraints);
        this.jButtonGetColumns.setText("Get columns name from the first row of the file");
        this.jButtonGetColumns.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XlsxDataSourceConnectionEditor.this.jButtonGetColumnsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 7, 3);
        this.jPanel8.add((Component)this.jButtonGetColumns, gridBagConstraints);
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{"Column Name", "Column Index"}){
            Class[] types;
            {
                this.types = new Class[]{String.class, Integer.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.jPanel8.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel11.add((Component)this.jPanel8, gridBagConstraints);
        this.jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Other"));
        this.jPanel6.setLayout(new GridBagLayout());
        this.jCheckBoxDateFormat.setText("Use custom date format");
        this.jCheckBoxDateFormat.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxDateFormat.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxDateFormat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XlsxDataSourceConnectionEditor.this.jCheckBoxDateFormatActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel6.add((Component)this.jCheckBoxDateFormat, gridBagConstraints);
        this.jTextFieldDateFormat.setEnabled(false);
        this.jTextFieldDateFormat.setPreferredSize(new Dimension(100, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel6.add((Component)this.jTextFieldDateFormat, gridBagConstraints);
        this.jButtonDateFormat.setText("Date format");
        this.jButtonDateFormat.setEnabled(false);
        this.jButtonDateFormat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XlsxDataSourceConnectionEditor.this.jButtonDateFormatActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel6.add((Component)this.jButtonDateFormat, gridBagConstraints);
        this.jCheckBoxNumberFormat.setText("Use custom number format");
        this.jCheckBoxNumberFormat.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxNumberFormat.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxNumberFormat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XlsxDataSourceConnectionEditor.this.jCheckBoxNumberFormatActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel6.add((Component)this.jCheckBoxNumberFormat, gridBagConstraints);
        this.jTextFieldNumberFormat.setEnabled(false);
        this.jTextFieldNumberFormat.setPreferredSize(new Dimension(100, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel6.add((Component)this.jTextFieldNumberFormat, gridBagConstraints);
        this.jButtonNumberFormat.setText("Number format");
        this.jButtonNumberFormat.setEnabled(false);
        this.jButtonNumberFormat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XlsxDataSourceConnectionEditor.this.jButtonNumberFormatActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel6.add((Component)this.jButtonNumberFormat, gridBagConstraints);
        this.jCheckBoxFirstRowAsHeader.setText("Skip the first line (the column names will be read from the first line)");
        this.jCheckBoxFirstRowAsHeader.setActionCommand("Skip the first line (column names will be read from the first line)");
        this.jCheckBoxFirstRowAsHeader.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxFirstRowAsHeader.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxFirstRowAsHeader.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XlsxDataSourceConnectionEditor.this.jCheckBoxFirstRowAsHeaderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel6.add((Component)this.jCheckBoxFirstRowAsHeader, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel11.add((Component)this.jPanel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelXLS.add((Component)this.jPanel11, gridBagConstraints);
        this.add((Component)this.jPanelXLS, "Center");
    }

    private void jCheckBoxNumberFormatActionPerformed(ActionEvent evt) {
        this.jTextFieldNumberFormat.setEnabled(this.jCheckBoxNumberFormat.isSelected());
        this.jButtonNumberFormat.setEnabled(this.jCheckBoxNumberFormat.isSelected());
        if (!this.jCheckBoxNumberFormat.isSelected()) {
            this.jTextFieldNumberFormat.setText(new DecimalFormat().toPattern());
        }
    }

    private void jButtonNumberFormatActionPerformed(ActionEvent evt) {
        FieldPatternDialog fpd = new FieldPatternDialog((Dialog)((JDialog)SwingUtilities.getWindowAncestor(this)), true);
        fpd.setOnlyNumbers(true);
        fpd.setVisible(true);
        if (fpd.getDialogResult() == 0) {
            this.jTextFieldNumberFormat.setText(fpd.getPattern());
        }
    }

    private void jButtonFilenameActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser(IReportManager.getInstance().getCurrentDirectory());
        jfc.setDialogTitle(I18n.getString("XlsxDataSourceConnectionEditor.DialogTitle.SelectFile"));
        jfc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName();
                return filename.toLowerCase().endsWith(".xlsx") || file.isDirectory();
            }

            public String getDescription() {
                return "Excel *.xlsx";
            }
        });
        jfc.setMultiSelectionEnabled(false);
        jfc.setDialogType(0);
        if (jfc.showOpenDialog(this) == 0) {
            File file = jfc.getSelectedFile();
            try {
                this.jTextFieldFilename.setText(file.getAbsolutePath());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    private void jButtonDateFormatActionPerformed(ActionEvent evt) {
        FieldPatternDialog fpd = new FieldPatternDialog((Dialog)((JDialog)SwingUtilities.getWindowAncestor(this)), true);
        fpd.setOnlyDate(true);
        fpd.setVisible(true);
        if (fpd.getDialogResult() == 0) {
            this.jTextFieldDateFormat.setText(fpd.getPattern());
        }
    }

    private void jCheckBoxDateFormatActionPerformed(ActionEvent evt) {
        this.jTextFieldDateFormat.setEnabled(this.jCheckBoxDateFormat.isSelected());
        this.jButtonDateFormat.setEnabled(this.jCheckBoxDateFormat.isSelected());
        if (!this.jCheckBoxDateFormat.isSelected()) {
            this.jTextFieldDateFormat.setText(new SimpleDateFormat().toPattern());
        }
    }

    private void jButtonNewParameterActionPerformed(ActionEvent evt) {
        DefaultTableModel dtm = (DefaultTableModel)this.jTable1.getModel();
        int index = 0;
        for (int i = 0; i < dtm.getRowCount(); ++i) {
            Integer ix = (Integer)this.jTable1.getValueAt(i, 1);
            if (index > ix) continue;
            ++index;
        }
        dtm.addRow(new Object[]{"COLUMN_" + index, new Integer(index)});
    }

    private void jButtonDeleteParameterActionPerformed(ActionEvent evt) {
        DefaultTableModel dtm = (DefaultTableModel)this.jTable1.getModel();
        while (this.jTable1.getSelectedRowCount() > 0) {
            dtm.removeRow(this.jTable1.getSelectedRow());
        }
    }

    private void jButtonGetColumnsActionPerformed(ActionEvent evt) {
        try {
            if (this.jTextFieldFilename.getText().length() > 0) {
                XSSFWorkbook workbook = new XSSFWorkbook((InputStream)new FileInputStream(new File(this.jTextFieldFilename.getText())));
                Sheet sheet = workbook.getSheetAt(0);
                DefaultTableModel dtm = (DefaultTableModel)this.jTable1.getModel();
                dtm.setRowCount(0);
                Row row = sheet.getRow(0);
                HashMap columnNames = new HashMap();
                for (int columnIndex = 0; columnIndex < row.getLastCellNum(); ++columnIndex) {
                    Cell cell = row.getCell(columnIndex);
                    String columnName = "";
                    columnName = cell != null ? cell.toString() : "COLUMN_" + columnIndex;
                    if (columnName == null || columnName.trim().length() <= 0) continue;
                    dtm.addRow(new Object[]{columnName, new Integer(columnIndex)});
                }
                this.jTable1.updateUI();
                this.jCheckBoxFirstRowAsHeader.setSelected(true);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), I18n.getString("XlsxDataSourceConnectionEditor.Message.Exception"), 0);
        }
    }

    private void jCheckBoxFirstRowAsHeaderActionPerformed(ActionEvent evt) {
    }

    public void setIReportConnection(IReportConnection c) {
        this.iReportConnection = c;
        if (this.iReportConnection instanceof JRXlsxDataSourceConnection) {
            JRXlsxDataSourceConnection con = (JRXlsxDataSourceConnection)this.iReportConnection;
            this.jTextFieldFilename.setText(con.getFilename());
            if (con.getCustomDateFormat().length() > 0) {
                this.jCheckBoxDateFormat.setSelected(true);
                this.jTextFieldDateFormat.setText(con.getCustomDateFormat());
                this.jTextFieldDateFormat.setEnabled(true);
                this.jButtonDateFormat.setEnabled(true);
            }
            if (con.getCustomNumberFormat().length() > 0) {
                this.jCheckBoxNumberFormat.setSelected(true);
                this.jTextFieldNumberFormat.setText(con.getCustomNumberFormat());
                this.jTextFieldNumberFormat.setEnabled(true);
                this.jButtonNumberFormat.setEnabled(true);
            }
            this.jCheckBoxFirstRowAsHeader.setSelected(con.isUseFirstRowAsHeader());
            DefaultTableModel dtm = (DefaultTableModel)this.jTable1.getModel();
            for (int i = 0; i < con.getColumnNames().size(); ++i) {
                dtm.addRow(new Object[]{con.getColumnNames().get(i), con.getColumnIndexes().get(i)});
            }
            if (dtm.getRowCount() > 0) {
                this.jTable1.setRowSelectionInterval(0, 0);
            }
        }
    }

    public IReportConnection getIReportConnection() {
        JRXlsxDataSourceConnection irConn = new JRXlsxDataSourceConnection();
        irConn.setFilename(this.jTextFieldFilename.getText().trim());
        irConn.setCustomDateFormat(this.jCheckBoxDateFormat.isSelected() ? this.jTextFieldDateFormat.getText() : "");
        irConn.setCustomNumberFormat(this.jCheckBoxNumberFormat.isSelected() ? this.jTextFieldNumberFormat.getText() : "");
        irConn.setUseFirstRowAsHeader(this.jCheckBoxFirstRowAsHeader.isSelected());
        ArrayList<String> columnsNames = new ArrayList<String>();
        ArrayList<Integer> columnsIndexes = new ArrayList<Integer>();
        DefaultTableModel dtm = (DefaultTableModel)this.jTable1.getModel();
        for (int i = 0; i < dtm.getRowCount(); ++i) {
            columnsNames.add((String)this.jTable1.getValueAt(i, 0));
            columnsIndexes.add((Integer)this.jTable1.getValueAt(i, 1));
        }
        irConn.setColumnNames(columnsNames);
        irConn.setColumnIndexes(columnsIndexes);
        if (columnsNames.isEmpty() && JOptionPane.showConfirmDialog(this, I18n.getString("XlsxDataSourceConnectionEditor.Dialog.Confirm"), "", 1) != 0) {
            return null;
        }
        this.iReportConnection = irConn;
        return this.iReportConnection;
    }
}

