/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.options.jasperreports;

import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.jdesktop.layout.GroupLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRPropertyDialog
extends JDialog {
    private String originalName = null;
    private List<String> existingPropertiesNames = new ArrayList<String>();
    private String propertyName = null;
    private String propertyValue = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JLabel jLabelSpecialCharacters;
    private JSeparator jSeparator1;
    private JTextField jTextFieldName;
    private JTextField jTextFieldName1;
    private int dialogResult;

    public JRPropertyDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public JRPropertyDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public void initAll() {
        this.initComponents();
        this.applyI18n();
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JRPropertyDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, I18n.getString("Global.Pane.Escape"));
        this.getRootPane().getActionMap().put(I18n.getString("Global.Pane.Escape"), escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabel4 = new JLabel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jTextFieldName1 = new JTextField();
        this.jLabelSpecialCharacters = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.setTitle("Add property");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JRPropertyDialog.this.closeDialog(evt);
            }
        });
        this.jLabel1.setText("Property name");
        this.jLabel1.setMaximumSize(new Dimension(1000, 100));
        this.jLabel1.setMinimumSize(new Dimension(100, 15));
        this.jLabel1.setPreferredSize(new Dimension(100, 15));
        this.jLabel4.setText("Property value");
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRPropertyDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRPropertyDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jLabelSpecialCharacters.setText("<html>Special characters:<br><b>\\n</b>\tfor newline<br><b>\\r</b>\tfor carriage return<br><b>\\t</b>\tfor tab and<br><b>\\\\</b>\tfor a single backslash");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jTextFieldName, -1, 491, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel4, -2, 242, -2)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jTextFieldName1, -1, 491, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabelSpecialCharacters))).addContainerGap()).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(383, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel).addContainerGap()).add((Component)this.jSeparator1, -1, 511, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1, -2, -1, -2).add(2, 2, 2).add((Component)this.jTextFieldName, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.jTextFieldName1, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabelSpecialCharacters).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK)).addContainerGap()));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 527) / 2, (screenSize.height - 262) / 2, 527, 262);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTextFieldName.getText().trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("JRPropertyDialog.Message.Warning"), I18n.getString("JRPropertyDialog.Message.Warning2"), 2);
            return;
        }
        if (this.getExistingPropertiesNames() != null) {
            String name = this.jTextFieldName.getText().trim();
            if (this.getExistingPropertiesNames().contains(name) && (this.originalName == null || !this.originalName.equals(name))) {
                JOptionPane.showMessageDialog(this, I18n.getString("JRPropertyDialog.Message.warning3"), I18n.getString("JRPropertyDialog.Message.Warning4"), 2);
                return;
            }
        }
        this.propertyName = this.jTextFieldName.getText().trim();
        this.propertyValue = this.jTextFieldName1.getText();
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public static void main(String[] args) {
        new JRPropertyDialog((Frame)new JFrame(), true).setVisible(true);
    }

    public void setPropertyName(String name) {
        this.jTextFieldName.setText(name);
        this.originalName = name;
    }

    public void setPropertyValue(String value) {
        this.jTextFieldName1.setText(value);
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void applyI18n() {
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    public List<String> getExistingPropertiesNames() {
        return this.existingPropertiesNames;
    }

    public void setExistingPropertiesNames(List<String> existingPropertiesNames) {
        this.existingPropertiesNames = existingPropertiesNames;
    }
}

