/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.styles;

import com.jaspersoft.ireport.designer.outline.nodes.AbstractStyleNode;
import com.jaspersoft.ireport.locale.I18n;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class ResetStyleAction
extends NodeAction {
    protected void performAction(Node[] nodes) {
        for (Node node : nodes) {
            JRBaseStyle style = ((AbstractStyleNode)node).getStyle();
            Node.PropertySet[] sets = node.getPropertySets();
            for (int i = 0; i < sets.length; ++i) {
                Node.Property[] pp = sets[i].getProperties();
                for (int j = 0; j < pp.length; ++j) {
                    if (!pp[j].supportsDefaultValue() || pp[j].isDefaultValue()) continue;
                    try {
                        pp[j].restoreDefaultValue();
                        continue;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected boolean enable(Node[] nodes) {
        if (nodes.length == 0) {
            return false;
        }
        for (Node node : nodes) {
            if (node instanceof AbstractStyleNode) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return I18n.getString("ResetStyleAction.name");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

