/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import mondrian.calc.Calc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Exp;
import mondrian.olap.fun.AggregateFunDef;
import mondrian.rolap.RolapCalculation;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapEvaluatorRoot;
import mondrian.rolap.RolapMember;

class RolapMemberCalculation
implements RolapCalculation {
    private final RolapMember member;
    private final int solveOrder;
    private Boolean containsAggregateFunction;

    public RolapMemberCalculation(RolapMember member) {
        this.member = member;
        this.solveOrder = this.member.getSolveOrder();
        assert (member.isEvaluated());
    }

    public int hashCode() {
        return this.member.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof RolapMemberCalculation && this.member == ((RolapMemberCalculation)obj).member;
    }

    public RolapEvaluator pushSelf(RolapEvaluator evaluator) {
        RolapMember defaultMember = evaluator.root.defaultMembers[this.getHierarchyOrdinal()];
        RolapEvaluator evaluator2 = evaluator.push(defaultMember);
        evaluator2.setExpanding(this.member);
        return evaluator2;
    }

    public int getSolveOrder() {
        return this.solveOrder;
    }

    public int getHierarchyOrdinal() {
        return this.member.getHierarchy().getOrdinalInCube();
    }

    public Calc getCompiledExpression(RolapEvaluatorRoot root) {
        Exp exp = this.member.getExpression();
        return root.getCompiled(exp, true, null);
    }

    public boolean isCalculatedInQuery() {
        return this.member.isCalculatedInQuery();
    }

    public boolean containsAggregateFunction() {
        if (this.containsAggregateFunction == null) {
            this.containsAggregateFunction = RolapMemberCalculation.foundAggregateFunction(this.member.getExpression());
        }
        return this.containsAggregateFunction;
    }

    private static boolean foundAggregateFunction(Exp exp) {
        if (exp instanceof ResolvedFunCall) {
            ResolvedFunCall resolvedFunCall = (ResolvedFunCall)exp;
            if (resolvedFunCall.getFunDef() instanceof AggregateFunDef) {
                return true;
            }
            for (Exp argExp : resolvedFunCall.getArgs()) {
                if (!RolapMemberCalculation.foundAggregateFunction(argExp)) continue;
                return true;
            }
        }
        return false;
    }
}

