/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.CreateFunctionDesc;
import org.apache.hadoop.hive.ql.plan.DropFunctionDesc;
import org.apache.hadoop.hive.ql.plan.FunctionWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.util.StringUtils;

public class FunctionTask
extends Task<FunctionWork> {
    private static final long serialVersionUID = 1L;
    private static final transient Log LOG = LogFactory.getLog(FunctionTask.class);
    transient HiveConf conf;

    @Override
    public void initialize(HiveConf conf, QueryPlan queryPlan, DriverContext ctx) {
        super.initialize(conf, queryPlan, ctx);
        this.conf = conf;
    }

    @Override
    public int execute(DriverContext driverContext) {
        CreateFunctionDesc createFunctionDesc = ((FunctionWork)this.work).getCreateFunctionDesc();
        if (createFunctionDesc != null) {
            return this.createFunction(createFunctionDesc);
        }
        DropFunctionDesc dropFunctionDesc = ((FunctionWork)this.work).getDropFunctionDesc();
        if (dropFunctionDesc != null) {
            return this.dropFunction(dropFunctionDesc);
        }
        return 0;
    }

    private int createFunction(CreateFunctionDesc createFunctionDesc) {
        try {
            Class<?> udfClass = this.getUdfClass(createFunctionDesc);
            boolean registered = FunctionRegistry.registerTemporaryFunction(createFunctionDesc.getFunctionName(), udfClass);
            if (registered) {
                return 0;
            }
            this.console.printError("FAILED: Class " + createFunctionDesc.getClassName() + " does not implement UDF, GenericUDF, or UDAF");
            return 1;
        }
        catch (ClassNotFoundException e) {
            this.console.printError("FAILED: Class " + createFunctionDesc.getClassName() + " not found");
            LOG.info((Object)("create function: " + StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
    }

    private int dropFunction(DropFunctionDesc dropFunctionDesc) {
        try {
            FunctionRegistry.unregisterTemporaryUDF(dropFunctionDesc.getFunctionName());
            return 0;
        }
        catch (HiveException e) {
            LOG.info((Object)("drop function: " + StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
    }

    private Class<?> getUdfClass(CreateFunctionDesc desc) throws ClassNotFoundException {
        return Class.forName(desc.getClassName(), true, JavaUtils.getClassLoader());
    }

    @Override
    public StageType getType() {
        return StageType.FUNC;
    }

    @Override
    public String getName() {
        return "FUNCTION";
    }

    @Override
    protected void localizeMRTmpFilesImpl(Context ctx) {
        throw new RuntimeException("Unexpected call");
    }
}

