/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.optimizer.GenMRProcContext;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.QBParseInfo;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;

public class GenMRTableScan1
implements NodeProcessor {
    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx opProcCtx, Object ... nodeOutputs) throws SemanticException {
        TableScanOperator op = (TableScanOperator)nd;
        GenMRProcContext ctx = (GenMRProcContext)opProcCtx;
        ParseContext parseCtx = ctx.getParseCtx();
        LinkedHashMap<Operator<? extends Serializable>, GenMRProcContext.GenMapRedCtx> mapCurrCtx = ctx.getMapCurrCtx();
        MapredWork currWork = GenMapRedUtils.getMapRedWork(parseCtx);
        Task<MapredWork> currTask = TaskFactory.get(currWork, parseCtx.getConf(), new Task[0]);
        TableScanOperator currTopOp = op;
        ctx.setCurrTask(currTask);
        ctx.setCurrTopOp(currTopOp);
        for (String alias : parseCtx.getTopOps().keySet()) {
            Operator<? extends Serializable> currOp = parseCtx.getTopOps().get(alias);
            if (currOp != op) continue;
            String currAliasId = alias;
            ctx.setCurrAliasId(currAliasId);
            mapCurrCtx.put(op, new GenMRProcContext.GenMapRedCtx(currTask, currTopOp, currAliasId));
            QBParseInfo parseInfo = parseCtx.getQB().getParseInfo();
            if (parseInfo.isAnalyzeCommand()) {
                StatsWork statsWork = new StatsWork(parseCtx.getQB().getParseInfo().getTableSpec());
                statsWork.setAggKey(((TableScanDesc)op.getConf()).getStatsAggPrefix());
                Task<StatsWork> statsTask = TaskFactory.get(statsWork, parseCtx.getConf(), new Task[0]);
                currTask.addDependentTask(statsTask);
                ctx.getRootTasks().add(currTask);
                currWork.setGatheringStats(true);
                HashSet<Partition> confirmedPartns = new HashSet<Partition>();
                BaseSemanticAnalyzer.tableSpec tblSpec = parseInfo.getTableSpec();
                if (tblSpec.specType == BaseSemanticAnalyzer.tableSpec.SpecType.STATIC_PARTITION) {
                    confirmedPartns.add(tblSpec.partHandle);
                } else if (tblSpec.specType == BaseSemanticAnalyzer.tableSpec.SpecType.DYNAMIC_PARTITION) {
                    confirmedPartns.addAll(tblSpec.partitions);
                }
                if (confirmedPartns.size() > 0) {
                    PrunedPartitionList partList = new PrunedPartitionList(confirmedPartns, new HashSet<Partition>(), null);
                    GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, currWork, false, ctx, partList);
                } else {
                    GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, currWork, false, ctx);
                }
            }
            return null;
        }
        assert (false);
        return null;
    }
}

