/*
 * iReport - Visual Designer for JasperReports.
 * Copyright (C) 2002 - 2009 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 * 
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 * 
 * This program is part of iReport.
 * 
 * iReport is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * iReport is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with iReport. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.ireport.designer.fonts;

import com.jaspersoft.ireport.designer.subreport.TableComboBoxEditor;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public final class InstallFontVisualPanel4FontMapping extends JPanel {

    /** Creates new form InstallFontVisualPanel4 */
    public InstallFontVisualPanel4FontMapping() {
        initComponents();

        jTable1.getSelectionModel().addListSelectionListener(new ListSelectionListener() {

            public void valueChanged(ListSelectionEvent e) {
                jButtonRemoveMapping.setEnabled(jTable1.getSelectedRow() >= 0);
            }
        });

        TableColumn col = jTable1.getColumnModel().getColumn(0);
        TableComboBoxEditor tcb = new TableComboBoxEditor(new java.util.Vector());
        JComboBox cb = (JComboBox)tcb.getComponent();
        cb.setEditable(true);
        cb.removeAllItems();

        Vector items = new Vector();
        items.add("html");
        items.add("xhtml");
        items.add("rtf");
        cb.setModel(new DefaultComboBoxModel(items));

        col.setCellEditor(tcb);

        jTable1.setRowHeight(20);
    }

    @Override
    public String getName() {
        return "Font Mappings";
    }

    public void storeSettings(Object settings) {

        HashMap<String,String> mappings = new HashMap<String, String>();

        for (int i=0; i<jTable1.getRowCount(); ++i)
        {

            String key = (String)jTable1.getValueAt(i, 0);
            String val = (String)jTable1.getValueAt(i, 1);
            if (key.trim().length() > 0 && val.trim().length() > 0)
            {
                mappings.put( "net.sf.jasperreports."  +key.trim(), val.trim() );
            }
        }

        ((InstallFontWizardDescriptor)settings).putProperty("mappings", mappings);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jLabel2 = new javax.swing.JLabel();
        jButtonAddMapping = new javax.swing.JButton();
        jButtonRemoveMapping = new javax.swing.JButton();

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(InstallFontVisualPanel4FontMapping.class, "InstallFontVisualPanel4FontMapping.jLabel1.text")); // NOI18N
        jLabel1.setVerticalAlignment(javax.swing.SwingConstants.TOP);

        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Export type", "Mapping"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.String.class, java.lang.String.class
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }
        });
        jScrollPane1.setViewportView(jTable1);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(InstallFontVisualPanel4FontMapping.class, "InstallFontVisualPanel4FontMapping.jLabel2.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jButtonAddMapping, org.openide.util.NbBundle.getMessage(InstallFontVisualPanel4FontMapping.class, "InstallFontVisualPanel4FontMapping.jButtonAddMapping.text")); // NOI18N
        jButtonAddMapping.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAddMappingActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(jButtonRemoveMapping, org.openide.util.NbBundle.getMessage(InstallFontVisualPanel4FontMapping.class, "InstallFontVisualPanel4FontMapping.jButtonRemoveMapping.text")); // NOI18N
        jButtonRemoveMapping.setEnabled(false);
        jButtonRemoveMapping.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonRemoveMappingActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 376, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 381, Short.MAX_VALUE)
                    .add(jLabel2)
                    .add(layout.createSequentialGroup()
                        .add(jButtonAddMapping)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jButtonRemoveMapping)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 63, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(jLabel2)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 225, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jButtonAddMapping)
                    .add(jButtonRemoveMapping))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonAddMappingActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAddMappingActionPerformed

        ((DefaultTableModel)jTable1.getModel()).addRow(new Object[]{"",""});

        
}//GEN-LAST:event_jButtonAddMappingActionPerformed

    private void jButtonRemoveMappingActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonRemoveMappingActionPerformed

        while (jTable1.getSelectedRow() >= 0) {
            ((DefaultTableModel)jTable1.getModel()).removeRow(jTable1.getSelectedRow());
        }
}//GEN-LAST:event_jButtonRemoveMappingActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonAddMapping;
    private javax.swing.JButton jButtonRemoveMapping;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTable1;
    // End of variables declaration//GEN-END:variables
}

