/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chartthemes.spring;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.List;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.type.MeterShapeEnum;
import net.sf.jasperreports.charts.type.ValueLocationEnum;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.chartthemes.spring.ChartThemesConstants;
import net.sf.jasperreports.chartthemes.spring.ChartThemesUtilities;
import net.sf.jasperreports.chartthemes.spring.GenericChartTheme;
import net.sf.jasperreports.chartthemes.spring.GradientBarRenderer3D;
import net.sf.jasperreports.chartthemes.spring.GradientXYBubbleRenderer;
import net.sf.jasperreports.chartthemes.spring.ScaledDialPointer;
import net.sf.jasperreports.chartthemes.spring.ScaledDialRange;
import net.sf.jasperreports.chartthemes.spring.ScaledDialValueIndicator;
import net.sf.jasperreports.chartthemes.spring.SquareXYAreaRenderer;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAnchor;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ThermometerPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.plot.dial.DialBackground;
import org.jfree.chart.plot.dial.DialCap;
import org.jfree.chart.plot.dial.DialFrame;
import org.jfree.chart.plot.dial.DialLayer;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.plot.dial.DialScale;
import org.jfree.chart.plot.dial.DialTextAnnotation;
import org.jfree.chart.plot.dial.StandardDialFrame;
import org.jfree.chart.plot.dial.StandardDialScale;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.xy.CandlestickRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYBubbleRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLine3DRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.data.xy.DefaultHighLowDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.GradientPaintTransformType;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.StandardGradientPaintTransformer;
import org.jfree.ui.TextAnchor;

public class EyeCandySixtiesChartTheme
extends GenericChartTheme {
    public static final Color THERMOMETER_COLOR = Color.BLACK;
    public static final Color SCATTER_GRIDLINE_COLOR = new Color(196, 196, 196);

    @Override
    protected void configureChart(JFreeChart jfreeChart, JRChartPlot jrPlot) throws JRException {
        super.configureChart(jfreeChart, jrPlot);
        TextTitle title = jfreeChart.getTitle();
        if (title != null) {
            RectangleInsets padding = title.getPadding();
            double bottomPadding = Math.max(padding.getBottom(), 15.0);
            title.setPadding(padding.getTop(), padding.getLeft(), bottomPadding, padding.getRight());
        }
        GradientPaint gp = (GradientPaint)this.getDefaultValue(this.defaultChartPropertiesMap, "backgroundPaint");
        jfreeChart.setBackgroundPaint((Paint)new GradientPaint(0.0f, 0.0f, gp.getColor1(), 0.0f, (float)this.getChart().getHeight() * 0.7f, gp.getColor2(), false));
    }

    @Override
    protected void configurePlot(Plot plot, JRChartPlot jrPlot) {
        super.configurePlot(plot, jrPlot);
        if (plot instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            CategoryItemRenderer categoryRenderer = categoryPlot.getRenderer();
            CategoryDataset categoryDataset = categoryPlot.getDataset();
            if (categoryDataset != null) {
                for (int i = 0; i < categoryDataset.getRowCount(); ++i) {
                    categoryRenderer.setSeriesOutlinePaint(i, ChartThemesConstants.TRANSPARENT_PAINT);
                }
            }
            categoryPlot.setRangeGridlinePaint(ChartThemesConstants.GRAY_PAINT_134);
            categoryPlot.setRangeGridlineStroke((Stroke)new BasicStroke(1.0f));
            categoryPlot.setDomainGridlinesVisible(false);
        } else if (plot instanceof XYPlot) {
            XYPlot xyPlot = (XYPlot)plot;
            XYDataset xyDataset = xyPlot.getDataset();
            if (xyDataset != null) {
                XYItemRenderer xyItemRenderer = xyPlot.getRenderer();
                for (int i = 0; i < xyDataset.getSeriesCount(); ++i) {
                    xyItemRenderer.setSeriesOutlinePaint(i, ChartThemesConstants.TRANSPARENT_PAINT);
                }
            }
            xyPlot.setRangeGridlinePaint(ChartThemesConstants.GRAY_PAINT_134);
            xyPlot.setRangeGridlineStroke((Stroke)new BasicStroke(1.0f));
            xyPlot.setDomainGridlinesVisible(false);
            xyPlot.setRangeZeroBaselineVisible(true);
        }
    }

    @Override
    protected JFreeChart createXyAreaChart() throws JRException {
        JFreeChart jfreeChart = super.createXyAreaChart();
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        SquareXYAreaRenderer squareXyAreaRenderer = new SquareXYAreaRenderer((XYAreaRenderer)xyPlot.getRenderer());
        xyPlot.setRenderer((XYItemRenderer)squareXyAreaRenderer);
        return jfreeChart;
    }

    @Override
    protected JFreeChart createPieChart() throws JRException {
        JFreeChart jfreeChart = super.createPieChart();
        PiePlot piePlot = (PiePlot)jfreeChart.getPlot();
        if (piePlot.getLabelGenerator() != null) {
            piePlot.setLabelBackgroundPaint(ChartThemesConstants.TRANSPARENT_PAINT);
            piePlot.setLabelShadowPaint(ChartThemesConstants.TRANSPARENT_PAINT);
            piePlot.setLabelOutlinePaint(ChartThemesConstants.TRANSPARENT_PAINT);
        }
        piePlot.setShadowXOffset(5.0);
        piePlot.setShadowYOffset(10.0);
        piePlot.setShadowPaint((Paint)new GradientPaint(0.0f, this.getChart().getHeight() / 2, new Color(41, 120, 162), 0.0f, this.getChart().getHeight(), Color.white));
        PieDataset pieDataset = piePlot.getDataset();
        if (pieDataset != null) {
            for (int i = 0; i < pieDataset.getItemCount(); ++i) {
                piePlot.setSectionOutlinePaint(pieDataset.getKey(i), ChartThemesConstants.TRANSPARENT_PAINT);
            }
        }
        piePlot.setCircular(true);
        return jfreeChart;
    }

    @Override
    protected JFreeChart createPie3DChart() throws JRException {
        JFreeChart jfreeChart = super.createPie3DChart();
        PiePlot3D piePlot3D = (PiePlot3D)jfreeChart.getPlot();
        if (piePlot3D.getLabelGenerator() != null) {
            piePlot3D.setLabelBackgroundPaint(ChartThemesConstants.TRANSPARENT_PAINT);
            piePlot3D.setLabelShadowPaint(ChartThemesConstants.TRANSPARENT_PAINT);
            piePlot3D.setLabelOutlinePaint(ChartThemesConstants.TRANSPARENT_PAINT);
        }
        piePlot3D.setDarkerSides(true);
        piePlot3D.setDepthFactor(0.1);
        PieDataset pieDataset = piePlot3D.getDataset();
        if (pieDataset != null) {
            for (int i = 0; i < pieDataset.getItemCount(); ++i) {
                piePlot3D.setSectionOutlinePaint(pieDataset.getKey(i), ChartThemesConstants.TRANSPARENT_PAINT);
            }
        }
        piePlot3D.setCircular(true);
        return jfreeChart;
    }

    @Override
    protected JFreeChart createBarChart() throws JRException {
        JFreeChart jfreeChart = super.createBarChart();
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer();
        barRenderer.setItemMargin(0.0);
        barRenderer.setGradientPaintTransformer((GradientPaintTransformer)new StandardGradientPaintTransformer(GradientPaintTransformType.HORIZONTAL));
        CategoryDataset categoryDataset = categoryPlot.getDataset();
        if (categoryDataset != null) {
            for (int i = 0; i < categoryDataset.getRowCount(); ++i) {
                barRenderer.setSeriesPaint(i, (Paint)ChartThemesConstants.EYE_CANDY_SIXTIES_GRADIENT_PAINTS.get(i));
            }
        }
        return jfreeChart;
    }

    @Override
    protected JFreeChart createStackedBarChart() throws JRException {
        JFreeChart jfreeChart = super.createStackedBarChart();
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer();
        barRenderer.setItemMargin(0.0);
        barRenderer.setGradientPaintTransformer((GradientPaintTransformer)new StandardGradientPaintTransformer(GradientPaintTransformType.HORIZONTAL));
        CategoryDataset categoryDataset = categoryPlot.getDataset();
        if (categoryDataset != null) {
            for (int i = 0; i < categoryDataset.getRowCount(); ++i) {
                barRenderer.setSeriesPaint(i, (Paint)ChartThemesConstants.EYE_CANDY_SIXTIES_GRADIENT_PAINTS.get(i));
            }
        }
        return jfreeChart;
    }

    @Override
    protected JFreeChart createBar3DChart() throws JRException {
        JFreeChart jfreeChart = super.createBar3DChart();
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        BarRenderer3D barRenderer3D = (BarRenderer3D)categoryPlot.getRenderer();
        barRenderer3D = new GradientBarRenderer3D(barRenderer3D);
        categoryPlot.setRenderer((CategoryItemRenderer)barRenderer3D);
        barRenderer3D.setItemMargin(0.0);
        barRenderer3D.setWallPaint(ChartThemesConstants.TRANSPARENT_PAINT);
        barRenderer3D.setItemMargin(0.0);
        CategoryDataset categoryDataset = categoryPlot.getDataset();
        if (categoryDataset != null) {
            for (int i = 0; i < categoryDataset.getRowCount(); ++i) {
                barRenderer3D.setSeriesPaint(i, (Paint)ChartThemesConstants.EYE_CANDY_SIXTIES_GRADIENT_PAINTS.get(i));
            }
        }
        return jfreeChart;
    }

    @Override
    protected JFreeChart createStackedBar3DChart() throws JRException {
        JFreeChart jfreeChart = super.createStackedBar3DChart();
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        BarRenderer3D barRenderer3D = (BarRenderer3D)categoryPlot.getRenderer();
        barRenderer3D.setWallPaint(ChartThemesConstants.TRANSPARENT_PAINT);
        barRenderer3D.setItemMargin(0.0);
        return jfreeChart;
    }

    @Override
    protected JFreeChart createBubbleChart() throws JRException {
        JFreeChart jfreeChart = super.createBubbleChart();
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        XYBubbleRenderer bubbleRenderer = (XYBubbleRenderer)xyPlot.getRenderer();
        bubbleRenderer = new GradientXYBubbleRenderer(bubbleRenderer.getScaleType());
        xyPlot.setRenderer((XYItemRenderer)bubbleRenderer);
        XYDataset xyDataset = xyPlot.getDataset();
        if (xyDataset != null) {
            for (int i = 0; i < xyDataset.getSeriesCount(); ++i) {
                bubbleRenderer.setSeriesOutlinePaint(i, ChartThemesConstants.TRANSPARENT_PAINT);
                bubbleRenderer.setSeriesPaint(i, (Paint)ChartThemesConstants.EYE_CANDY_SIXTIES_GRADIENT_PAINTS.get(i));
            }
        }
        return jfreeChart;
    }

    @Override
    protected JFreeChart createXYBarChart() throws JRException {
        JFreeChart jfreeChart = super.createXYBarChart();
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        XYBarRenderer renderer = (XYBarRenderer)xyPlot.getRenderer();
        renderer.setMargin(0.1);
        renderer.setGradientPaintTransformer((GradientPaintTransformer)new StandardGradientPaintTransformer(GradientPaintTransformType.HORIZONTAL));
        XYDataset xyDataset = xyPlot.getDataset();
        if (xyDataset != null) {
            for (int i = 0; i < xyDataset.getSeriesCount(); ++i) {
                renderer.setSeriesPaint(i, (Paint)ChartThemesConstants.EYE_CANDY_SIXTIES_GRADIENT_PAINTS.get(i));
            }
        }
        return jfreeChart;
    }

    @Override
    protected JFreeChart createScatterChart() throws JRException {
        JFreeChart jfreeChart = super.createScatterChart();
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        xyPlot.setRangeGridlinePaint((Paint)SCATTER_GRIDLINE_COLOR);
        xyPlot.setRangeGridlineStroke((Stroke)new BasicStroke(0.75f));
        xyPlot.setDomainGridlinesVisible(true);
        xyPlot.setDomainGridlinePaint((Paint)SCATTER_GRIDLINE_COLOR);
        xyPlot.setDomainGridlineStroke((Stroke)new BasicStroke(0.75f));
        xyPlot.setRangeZeroBaselinePaint(ChartThemesConstants.GRAY_PAINT_134);
        XYLineAndShapeRenderer lineRenderer = (XYLineAndShapeRenderer)xyPlot.getRenderer();
        lineRenderer.setUseFillPaint(true);
        JRScatterPlot scatterPlot = (JRScatterPlot)this.getPlot();
        boolean isShowLines = scatterPlot.getShowLines() == null ? false : scatterPlot.getShowLines();
        lineRenderer.setBaseLinesVisible(isShowLines);
        XYDataset xyDataset = xyPlot.getDataset();
        if (xyDataset != null) {
            for (int i = 0; i < xyDataset.getSeriesCount(); ++i) {
                lineRenderer.setSeriesOutlinePaint(i, ChartThemesConstants.TRANSPARENT_PAINT);
                lineRenderer.setSeriesFillPaint(i, (Paint)ChartThemesConstants.EYE_CANDY_SIXTIES_GRADIENT_PAINTS.get(i));
                lineRenderer.setSeriesPaint(i, (Paint)ChartThemesConstants.EYE_CANDY_SIXTIES_COLORS.get(i));
            }
        }
        return jfreeChart;
    }

    @Override
    protected JFreeChart createXyLineChart() throws JRException {
        JFreeChart jfreeChart = super.createXyLineChart();
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        XYLineAndShapeRenderer lineRenderer = (XYLineAndShapeRenderer)jfreeChart.getXYPlot().getRenderer();
        XYLine3DRenderer line3DRenderer = new XYLine3DRenderer();
        line3DRenderer.setBaseToolTipGenerator(lineRenderer.getBaseToolTipGenerator());
        line3DRenderer.setURLGenerator(lineRenderer.getURLGenerator());
        line3DRenderer.setBaseStroke((Stroke)new BasicStroke(2.0f, 1, 1));
        line3DRenderer.setBaseLinesVisible(lineRenderer.getBaseLinesVisible());
        line3DRenderer.setBaseShapesVisible(lineRenderer.getBaseShapesVisible());
        BasicStroke stroke = new BasicStroke(2.0f, 1, 1);
        XYDataset xyDataset = xyPlot.getDataset();
        if (xyDataset != null) {
            for (int i = 0; i < xyDataset.getSeriesCount(); ++i) {
                line3DRenderer.setSeriesStroke(i, (Stroke)stroke);
                line3DRenderer.setSeriesLinesVisible(i, lineRenderer.getBaseLinesVisible());
                line3DRenderer.setSeriesShapesVisible(i, lineRenderer.getBaseShapesVisible());
            }
        }
        line3DRenderer.setXOffset(2.0);
        line3DRenderer.setYOffset(2.0);
        line3DRenderer.setWallPaint(ChartThemesConstants.GRAY_PAINT_134);
        xyPlot.setRenderer((XYItemRenderer)line3DRenderer);
        return jfreeChart;
    }

    @Override
    protected JFreeChart createLineChart() throws JRException {
        JFreeChart jfreeChart = super.createLineChart();
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        LineAndShapeRenderer lineRenderer = (LineAndShapeRenderer)categoryPlot.getRenderer();
        lineRenderer.setStroke((Stroke)new BasicStroke(2.0f, 1, 1));
        for (int i = 0; i < lineRenderer.getRowCount(); ++i) {
            lineRenderer.setSeriesOutlinePaint(i, ChartThemesConstants.TRANSPARENT_PAINT);
            lineRenderer.setSeriesFillPaint(i, (Paint)ChartThemesConstants.EYE_CANDY_SIXTIES_GRADIENT_PAINTS.get(i));
            lineRenderer.setSeriesPaint(i, (Paint)ChartThemesConstants.EYE_CANDY_SIXTIES_GRADIENT_PAINTS.get(i));
            lineRenderer.setSeriesShapesVisible(i, true);
        }
        return jfreeChart;
    }

    @Override
    protected JFreeChart createGanttChart() throws JRException {
        JFreeChart jfreeChart = super.createGanttChart();
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        categoryPlot.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.STANDARD);
        categoryPlot.setDomainGridlinesVisible(true);
        categoryPlot.setDomainGridlinePosition(CategoryAnchor.END);
        categoryPlot.setDomainGridlineStroke((Stroke)new BasicStroke(0.5f, 0, 0, 50.0f, new float[]{1.0f}, 0.0f));
        categoryPlot.setDomainGridlinePaint(ChartThemesConstants.GRAY_PAINT_134);
        categoryPlot.setRangeGridlinesVisible(true);
        categoryPlot.setRangeGridlineStroke((Stroke)new BasicStroke(0.5f, 0, 0, 50.0f, new float[]{1.0f}, 0.0f));
        categoryPlot.setRangeGridlinePaint(ChartThemesConstants.GRAY_PAINT_134);
        categoryPlot.getDomainAxis().setTickLabelsVisible(true);
        CategoryItemRenderer categoryRenderer = categoryPlot.getRenderer();
        categoryRenderer.setBaseItemLabelsVisible(true);
        BarRenderer barRenderer = (BarRenderer)categoryRenderer;
        barRenderer.setSeriesPaint(0, (Paint)ChartThemesConstants.EYE_CANDY_SIXTIES_COLORS.get(3));
        barRenderer.setSeriesPaint(1, (Paint)ChartThemesConstants.EYE_CANDY_SIXTIES_COLORS.get(0));
        CategoryDataset categoryDataset = categoryPlot.getDataset();
        if (categoryDataset != null) {
            for (int i = 0; i < categoryDataset.getRowCount(); ++i) {
                barRenderer.setSeriesItemLabelFont(i, categoryPlot.getDomainAxis().getTickLabelFont());
                barRenderer.setSeriesItemLabelsVisible(i, true);
            }
        }
        categoryPlot.setOutlinePaint((Paint)Color.DARK_GRAY);
        categoryPlot.setOutlineStroke((Stroke)new BasicStroke(1.5f));
        categoryPlot.setOutlineVisible(true);
        return jfreeChart;
    }

    @Override
    protected JFreeChart createMeterChart() throws JRException {
        String units;
        String label;
        MeterPlot chartPlot = new MeterPlot((ValueDataset)this.getDataset());
        JRMeterPlot jrPlot = (JRMeterPlot)this.getPlot();
        MeterShapeEnum shape = jrPlot.getShapeValue() == null ? MeterShapeEnum.DIAL : jrPlot.getShapeValue();
        switch (shape) {
            case CHORD: {
                chartPlot.setDialShape(DialShape.CHORD);
                break;
            }
            case PIE: {
                chartPlot.setDialShape(DialShape.PIE);
                break;
            }
            case CIRCLE: {
                chartPlot.setDialShape(DialShape.CIRCLE);
                break;
            }
            default: {
                return this.createDialChart();
            }
        }
        chartPlot.setDialOutlinePaint((Paint)Color.BLACK);
        int meterAngle = jrPlot.getMeterAngleInteger() == null ? 180 : jrPlot.getMeterAngleInteger();
        chartPlot.setMeterAngle(meterAngle);
        double tickInterval = jrPlot.getTickIntervalDouble() == null ? 10.0 : jrPlot.getTickIntervalDouble();
        chartPlot.setTickSize(tickInterval);
        JRFont tickLabelFont = jrPlot.getTickLabelFont();
        Integer defaultBaseFontSize = (Integer)this.getDefaultValue(this.defaultChartPropertiesMap, "baseFontSize");
        Font themeTickLabelFont = this.getFont((JRFont)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotTickLabelFont"), tickLabelFont, defaultBaseFontSize);
        chartPlot.setTickLabelFont(themeTickLabelFont);
        Color tickColor = jrPlot.getTickColor() == null ? Color.BLACK : jrPlot.getTickColor();
        chartPlot.setTickPaint((Paint)tickColor);
        int dialUnitScale = 1;
        Range range = this.convertRange(jrPlot.getDataRange());
        if (range != null) {
            chartPlot.setRange(range);
            double bound = Math.max(Math.abs(range.getUpperBound()), Math.abs(range.getLowerBound()));
            dialUnitScale = ChartThemesUtilities.getScale(bound);
            if (range.getLowerBound() == (double)((int)range.getLowerBound()) && range.getUpperBound() == (double)((int)range.getUpperBound()) && tickInterval == (double)((int)tickInterval) || dialUnitScale > 1) {
                chartPlot.setTickLabelFormat((NumberFormat)new DecimalFormat("#,##0"));
            } else if (dialUnitScale == 1) {
                chartPlot.setTickLabelFormat((NumberFormat)new DecimalFormat("#,##0.0"));
            } else if (dialUnitScale <= 0) {
                chartPlot.setTickLabelFormat((NumberFormat)new DecimalFormat("#,##0.00"));
            }
        }
        chartPlot.setTickLabelsVisible(true);
        Paint backgroundPaint = jrPlot.getOwnBackcolor() == null ? ChartThemesConstants.TRANSPARENT_PAINT : jrPlot.getOwnBackcolor();
        chartPlot.setBackgroundPaint(backgroundPaint);
        GradientPaint gp = new GradientPaint(new Point(), Color.LIGHT_GRAY, new Point(), Color.BLACK, false);
        if (jrPlot.getMeterBackgroundColor() != null) {
            chartPlot.setDialBackgroundPaint((Paint)jrPlot.getMeterBackgroundColor());
        } else {
            chartPlot.setDialBackgroundPaint((Paint)gp);
        }
        Color needlePaint = jrPlot.getNeedleColor() == null ? new Color(191, 48, 0) : jrPlot.getNeedleColor();
        chartPlot.setNeedlePaint((Paint)needlePaint);
        JRValueDisplay display = jrPlot.getValueDisplay();
        if (display != null) {
            String pattern;
            Color valueColor = display.getColor() == null ? Color.BLACK : display.getColor();
            chartPlot.setValuePaint((Paint)valueColor);
            String string = pattern = display.getMask() != null ? display.getMask() : "#,##0.####";
            if (pattern != null) {
                chartPlot.setTickLabelFormat((NumberFormat)new DecimalFormat(pattern));
            }
            JRFont displayFont = display.getFont();
            Font themeDisplayFont = this.getFont((JRFont)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotDisplayFont"), displayFont, defaultBaseFontSize);
            if (themeDisplayFont != null) {
                chartPlot.setValueFont(themeDisplayFont);
            }
        }
        String string = label = this.getChart().hasProperties() ? this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.dial.label") : null;
        if (label != null) {
            label = dialUnitScale < 0 ? new MessageFormat(label).format(new Object[]{String.valueOf(Math.pow(10.0, dialUnitScale))}) : (dialUnitScale < 3 ? new MessageFormat(label).format(new Object[]{"1"}) : new MessageFormat(label).format(new Object[]{String.valueOf((int)Math.pow(10.0, dialUnitScale - 2))}));
        }
        String string2 = units = jrPlot.getUnits() == null ? label : jrPlot.getUnits();
        if (units != null && units.length() > 0) {
            chartPlot.setUnits(units);
        }
        chartPlot.setTickPaint((Paint)Color.BLACK);
        List intervals = jrPlot.getIntervals();
        if (intervals != null && intervals.size() > 0) {
            int size = Math.min(3, intervals.size());
            int colorStep = 0;
            if (size > 3) {
                colorStep = 255 / (size - 3);
            }
            for (int i = 0; i < size; ++i) {
                JRMeterInterval interval = (JRMeterInterval)intervals.get(i);
                Color color = i < 3 ? ChartThemesConstants.AEGEAN_INTERVAL_COLORS.get(i) : new Color(255 - colorStep * (i - 3), 0 + colorStep * (i - 3), 0);
                interval.setBackgroundColor(color);
                interval.setAlpha(new Double(1.0));
                chartPlot.addInterval(this.convertInterval(interval));
            }
        }
        JFreeChart jfreeChart = new JFreeChart((String)this.evaluateExpression(this.getChart().getTitleExpression()), null, (Plot)chartPlot, this.getChart().getShowLegend() == null ? false : this.getChart().getShowLegend());
        this.configureChart(jfreeChart, this.getPlot());
        return jfreeChart;
    }

    @Override
    protected JFreeChart createThermometerChart() throws JRException {
        JRThermometerPlot jrPlot = (JRThermometerPlot)this.getPlot();
        ThermometerPlot chartPlot = new ThermometerPlot((ValueDataset)this.getDataset());
        JFreeChart jfreeChart = new JFreeChart((Plot)chartPlot);
        this.configureChart(jfreeChart, this.getPlot());
        jfreeChart.setBackgroundPaint(ChartThemesConstants.TRANSPARENT_PAINT);
        jfreeChart.setBorderVisible(false);
        Range range = this.convertRange(jrPlot.getDataRange());
        if (range != null) {
            chartPlot.setLowerBound(range.getLowerBound());
            chartPlot.setUpperBound(range.getUpperBound());
        }
        chartPlot.setGap(0);
        chartPlot.setUnits(0);
        Paint paint = jrPlot.getMercuryColor();
        if (paint != null) {
            chartPlot.setUseSubrangePaint(false);
        } else {
            paint = ChartThemesConstants.EYE_CANDY_SIXTIES_GRADIENT_PAINTS.get(0);
        }
        chartPlot.setMercuryPaint(paint);
        chartPlot.setThermometerPaint((Paint)THERMOMETER_COLOR);
        chartPlot.setThermometerStroke((Stroke)new BasicStroke(2.0f));
        chartPlot.setOutlineVisible(false);
        chartPlot.setValueFont(chartPlot.getValueFont().deriveFont(1));
        JRValueDisplay display = jrPlot.getValueDisplay();
        if (display != null) {
            if (display.getColor() != null) {
                chartPlot.setValuePaint((Paint)display.getColor());
            }
            if (display.getMask() != null) {
                chartPlot.setValueFormat((NumberFormat)new DecimalFormat(display.getMask()));
            }
            if (display.getFont() != null) {
                // empty if block
            }
        }
        ValueLocationEnum valueLocation = jrPlot.getValueLocationValue();
        switch (valueLocation) {
            case NONE: {
                chartPlot.setValueLocation(0);
                break;
            }
            case LEFT: {
                chartPlot.setValueLocation(2);
                break;
            }
            case RIGHT: {
                chartPlot.setValueLocation(1);
                break;
            }
            default: {
                chartPlot.setValueLocation(3);
            }
        }
        range = this.convertRange(jrPlot.getLowRange());
        if (range != null) {
            chartPlot.setSubrangeInfo(2, range.getLowerBound(), range.getUpperBound());
        }
        if ((range = this.convertRange(jrPlot.getMediumRange())) != null) {
            chartPlot.setSubrangeInfo(1, range.getLowerBound(), range.getUpperBound());
        }
        if ((range = this.convertRange(jrPlot.getHighRange())) != null) {
            chartPlot.setSubrangeInfo(0, range.getLowerBound(), range.getUpperBound());
        }
        return jfreeChart;
    }

    @Override
    protected JFreeChart createDialChart() throws JRException {
        String label;
        JRValueDisplay display;
        String displayVisibility;
        JRMeterPlot jrPlot = (JRMeterPlot)this.getPlot();
        GradientPaint gp = new GradientPaint(new Point(), Color.LIGHT_GRAY, new Point(), Color.BLACK, false);
        GradientPaint gp2 = new GradientPaint(new Point(), Color.GRAY, new Point(), Color.BLACK);
        DialPlot dialPlot = new DialPlot();
        if (this.getDataset() != null) {
            dialPlot.setDataset((ValueDataset)this.getDataset());
        }
        StandardDialFrame dialFrame = new StandardDialFrame();
        dialFrame.setForegroundPaint((Paint)gp2);
        dialPlot.setDialFrame((DialFrame)dialFrame);
        DialBackground db = new DialBackground((Paint)gp);
        db.setGradientPaintTransformer((GradientPaintTransformer)new StandardGradientPaintTransformer(GradientPaintTransformType.VERTICAL));
        dialPlot.setBackground((DialLayer)db);
        StandardDialScale scale = null;
        int dialUnitScale = 1;
        Range range = this.convertRange(jrPlot.getDataRange());
        if (range != null) {
            double bound = Math.max(Math.abs(range.getUpperBound()), Math.abs(range.getLowerBound()));
            dialUnitScale = ChartThemesUtilities.getScale(bound);
            double lowerBound = ChartThemesUtilities.getTruncatedValue(range.getLowerBound(), dialUnitScale);
            double upperBound = ChartThemesUtilities.getTruncatedValue(range.getUpperBound(), dialUnitScale);
            int tickCount = jrPlot.getTickCount() != null && jrPlot.getTickCount() > 1 ? jrPlot.getTickCount() : 7;
            scale = new StandardDialScale(lowerBound, upperBound, 225.0, -270.0, (upperBound - lowerBound) / (double)(tickCount - 1), 15);
            if (lowerBound == (double)((int)lowerBound) && upperBound == (double)((int)upperBound) && scale.getMajorTickIncrement() == (double)((int)scale.getMajorTickIncrement()) || dialUnitScale > 1) {
                scale.setTickLabelFormatter((NumberFormat)new DecimalFormat("#,##0"));
            } else if (dialUnitScale == 1) {
                scale.setTickLabelFormatter((NumberFormat)new DecimalFormat("#,##0.0"));
            } else if (dialUnitScale <= 0) {
                scale.setTickLabelFormatter((NumberFormat)new DecimalFormat("#,##0.00"));
            }
        } else {
            scale = new StandardDialScale();
        }
        scale.setTickRadius(0.9);
        scale.setTickLabelOffset(0.16);
        JRFont tickLabelFont = jrPlot.getTickLabelFont();
        Integer defaultBaseFontSize = (Integer)this.getDefaultValue(this.defaultChartPropertiesMap, "baseFontSize");
        Font themeTickLabelFont = this.getFont((JRFont)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotTickLabelFont"), tickLabelFont, defaultBaseFontSize);
        scale.setTickLabelFont(themeTickLabelFont);
        scale.setMajorTickStroke((Stroke)new BasicStroke(1.0f));
        scale.setMinorTickStroke((Stroke)new BasicStroke(0.3f));
        scale.setMajorTickPaint((Paint)Color.WHITE);
        scale.setMinorTickPaint((Paint)Color.WHITE);
        scale.setTickLabelsVisible(true);
        scale.setFirstTickLabelVisible(true);
        dialPlot.addScale(0, (DialScale)scale);
        List intervals = jrPlot.getIntervals();
        if (intervals != null && intervals.size() > 0) {
            int size = Math.min(3, intervals.size());
            int colorStep = 0;
            if (size > 3) {
                colorStep = 255 / (size - 3);
            }
            for (int i = 0; i < size; ++i) {
                JRMeterInterval interval = (JRMeterInterval)intervals.get(i);
                Range intervalRange = this.convertRange(interval.getDataRange());
                double intervalLowerBound = ChartThemesUtilities.getTruncatedValue(intervalRange.getLowerBound(), dialUnitScale);
                double intervalUpperBound = ChartThemesUtilities.getTruncatedValue(intervalRange.getUpperBound(), dialUnitScale);
                Color color = i < 3 ? ChartThemesConstants.AEGEAN_INTERVAL_COLORS.get(i) : new Color(255 - colorStep * (i - 3), 0 + colorStep * (i - 3), 0);
                ScaledDialRange dialRange = new ScaledDialRange(intervalLowerBound, intervalUpperBound, interval.getBackgroundColor() == null ? color : interval.getBackgroundColor(), 12.0f);
                dialRange.setInnerRadius(0.41);
                dialRange.setOuterRadius(0.41);
                dialPlot.addLayer((DialLayer)dialRange);
            }
        }
        String string = displayVisibility = (display = jrPlot.getValueDisplay()) != null && this.getChart().hasProperties() ? this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.dial.value.display.visible") : "false";
        if (Boolean.parseBoolean(displayVisibility)) {
            String pattern;
            ScaledDialValueIndicator dvi = new ScaledDialValueIndicator(0, dialUnitScale);
            dvi.setBackgroundPaint(ChartThemesConstants.TRANSPARENT_PAINT);
            dvi.setOutlinePaint(ChartThemesConstants.TRANSPARENT_PAINT);
            dvi.setPaint(Color.WHITE);
            String string2 = pattern = display.getMask() != null ? display.getMask() : "#,##0.####";
            if (pattern != null) {
                dvi.setNumberFormat(new DecimalFormat(pattern));
            }
            dvi.setRadius(0.15);
            dvi.setValueAnchor(RectangleAnchor.CENTER);
            dvi.setTextAnchor(TextAnchor.CENTER);
            dialPlot.addLayer((DialLayer)dvi);
        }
        String string3 = label = this.getChart().hasProperties() ? this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.dial.label") : null;
        if (label != null) {
            JRFont displayFont = jrPlot.getValueDisplay().getFont();
            Font themeDisplayFont = this.getFont((JRFont)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotDisplayFont"), displayFont, defaultBaseFontSize);
            label = dialUnitScale < 0 ? new MessageFormat(label).format(new Object[]{String.valueOf(Math.pow(10.0, dialUnitScale))}) : (dialUnitScale < 3 ? new MessageFormat(label).format(new Object[]{"1"}) : new MessageFormat(label).format(new Object[]{String.valueOf((int)Math.pow(10.0, dialUnitScale - 2))}));
            String[] textLines = label.split("\\n");
            for (int i = 0; i < textLines.length; ++i) {
                DialTextAnnotation dialAnnotation = new DialTextAnnotation(textLines[i]);
                dialAnnotation.setFont(themeDisplayFont);
                dialAnnotation.setPaint((Paint)Color.WHITE);
                dialAnnotation.setRadius(Math.sin(0.7853981633974483) + (double)i / 10.0);
                dialAnnotation.setAnchor(TextAnchor.CENTER);
                dialPlot.addLayer((DialLayer)dialAnnotation);
            }
        }
        Color paint = new Color(191, 48, 0);
        ScaledDialPointer needle = new ScaledDialPointer(dialUnitScale, paint, paint);
        needle.setVisible(true);
        needle.setRadius(0.91);
        dialPlot.addLayer((DialLayer)needle);
        DialCap cap = new DialCap();
        cap.setRadius(0.05);
        cap.setFillPaint((Paint)Color.DARK_GRAY);
        cap.setOutlinePaint((Paint)Color.GRAY);
        cap.setOutlineStroke((Stroke)new BasicStroke(0.5f));
        dialPlot.setCap((DialLayer)cap);
        JFreeChart jfreeChart = new JFreeChart((String)this.evaluateExpression(this.getChart().getTitleExpression()), null, (Plot)dialPlot, this.getChart().getShowLegend() == null ? false : this.getChart().getShowLegend());
        this.configureChart(jfreeChart, this.getPlot());
        jfreeChart.setBackgroundPaint(ChartThemesConstants.TRANSPARENT_PAINT);
        jfreeChart.setBorderVisible(false);
        return jfreeChart;
    }

    @Override
    protected JFreeChart createCandlestickChart() throws JRException {
        JFreeChart jfreeChart = super.createCandlestickChart();
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        CandlestickRenderer renderer = (CandlestickRenderer)xyPlot.getRenderer();
        DefaultHighLowDataset dataset = (DefaultHighLowDataset)xyPlot.getDataset();
        if (dataset != null) {
            for (int i = 0; i < dataset.getSeriesCount(); ++i) {
                renderer.setSeriesFillPaint(i, (Paint)ChartThemesConstants.EYE_CANDY_SIXTIES_COLORS.get(i));
                renderer.setSeriesPaint(i, (Paint)Color.DARK_GRAY);
            }
        }
        return jfreeChart;
    }
}

