/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.ql.io.BucketizedHiveInputSplit;
import org.apache.hadoop.hive.ql.io.BucketizedHiveRecordReader;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.InvalidInputException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class BucketizedHiveInputFormat<K extends WritableComparable, V extends Writable>
extends HiveInputFormat<K, V> {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hive.ql.io.BucketizedHiveInputFormat");

    @Override
    public RecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        BucketizedHiveInputSplit hsplit = (BucketizedHiveInputSplit)split;
        String inputFormatClassName = null;
        Class inputFormatClass = null;
        try {
            inputFormatClassName = hsplit.inputFormatClassName();
            inputFormatClass = job.getClassByName(inputFormatClassName);
        }
        catch (Exception e) {
            throw new IOException("cannot find class " + inputFormatClassName);
        }
        JobConf cloneJobConf = new JobConf((Configuration)job);
        this.pushProjectionsAndFilters(cloneJobConf, inputFormatClass, hsplit.getPath().toString(), hsplit.getPath().toUri().getPath());
        InputFormat<WritableComparable, Writable> inputFormat = BucketizedHiveInputFormat.getInputFormatFromCache(inputFormatClass, cloneJobConf);
        BucketizedHiveRecordReader rr = new BucketizedHiveRecordReader(inputFormat, hsplit, cloneJobConf, reporter);
        rr.initIOContext(hsplit, cloneJobConf, inputFormatClass);
        return rr;
    }

    protected FileStatus[] listStatus(JobConf job, Path path) throws IOException {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        ArrayList<IOException> errors = new ArrayList<IOException>();
        FileSystem fs = path.getFileSystem((Configuration)job);
        FileStatus[] matches = fs.globStatus(path);
        if (matches == null) {
            errors.add(new IOException("Input path does not exist: " + path));
        } else if (matches.length == 0) {
            errors.add(new IOException("Input Pattern " + path + " matches 0 files"));
        } else {
            for (FileStatus globStat : matches) {
                FileUtils.listStatusRecursively(fs, globStat, result);
            }
        }
        if (!errors.isEmpty()) {
            throw new InvalidInputException(errors);
        }
        LOG.info((Object)("Total input paths to process : " + result.size()));
        return result.toArray(new FileStatus[result.size()]);
    }

    @Override
    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        this.init(job);
        Path[] dirs = FileInputFormat.getInputPaths((JobConf)job);
        if (dirs.length == 0) {
            throw new IOException("No input paths specified in job");
        }
        JobConf newjob = new JobConf((Configuration)job);
        ArrayList<BucketizedHiveInputSplit> result = new ArrayList<BucketizedHiveInputSplit>();
        int numOrigSplits = 0;
        for (Path dir : dirs) {
            FileStatus[] listStatus;
            PartitionDesc part = BucketizedHiveInputFormat.getPartitionDescFromPath(this.pathToPartitionInfo, dir);
            Class<? extends InputFormat> inputFormatClass = part.getInputFileFormatClass();
            InputFormat<WritableComparable, Writable> inputFormat = BucketizedHiveInputFormat.getInputFormatFromCache(inputFormatClass, job);
            newjob.setInputFormat(inputFormat.getClass());
            for (FileStatus status : listStatus = this.listStatus(newjob, dir)) {
                LOG.info((Object)("block size: " + status.getBlockSize()));
                LOG.info((Object)("file length: " + status.getLen()));
                FileInputFormat.setInputPaths((JobConf)newjob, (Path[])new Path[]{status.getPath()});
                InputSplit[] iss = inputFormat.getSplits(newjob, 0);
                if (iss == null || iss.length <= 0) continue;
                numOrigSplits += iss.length;
                result.add(new BucketizedHiveInputSplit(iss, inputFormatClass.getName()));
            }
        }
        LOG.info((Object)(result.size() + " bucketized splits generated from " + numOrigSplits + " original splits."));
        return result.toArray(new BucketizedHiveInputSplit[result.size()]);
    }
}

