/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.mongodb.importer;

import com.jaspersoft.mongodb.connection.MongoDbConnection;
import com.jaspersoft.mongodb.importer.MongoDbImporter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import net.sf.jasperreports.engine.JRException;
import org.apache.log4j.Logger;
import org.cloudfoundry.runtime.env.CloudEnvironment;
import org.cloudfoundry.runtime.env.MongoServiceInfo;
import org.cloudfoundry.runtime.env.RdbmsServiceInfo;

public class MongoDbCloudFoundryImporter {
    private String tableName;
    private final Logger logger = Logger.getLogger(MongoDbCloudFoundryImporter.class);
    private MongoDbConnection mongoDbConnection;
    private String databaseServiceName;
    private String mongodbServiceName;
    private Connection databaseConnection;

    public MongoDbCloudFoundryImporter(String databaseServiceName, String tableName, String mongodbServiceName) throws JRException, SQLException {
        this.databaseServiceName = databaseServiceName;
        this.mongodbServiceName = mongodbServiceName;
        this.tableName = tableName;
        this.configureConnection();
        this.importData();
    }

    private void configureConnection() throws JRException, SQLException {
        CloudEnvironment cloudEnvironment = new CloudEnvironment();
        MongoServiceInfo mongoServiceInfo = (MongoServiceInfo)cloudEnvironment.getServiceInfo(this.mongodbServiceName, MongoServiceInfo.class);
        if (mongoServiceInfo == null) {
            this.logger.error((Object)("No mongodb service with name: " + this.mongodbServiceName));
            return;
        }
        this.mongoDbConnection = new MongoDbConnection("mongodb://" + mongoServiceInfo.getHost() + ":" + mongoServiceInfo.getPort() + "/" + mongoServiceInfo.getDatabase(), mongoServiceInfo.getUserName(), mongoServiceInfo.getPassword());
        System.out.println("MongoDB connection configured");
        RdbmsServiceInfo databaseServiceInfo = (RdbmsServiceInfo)cloudEnvironment.getServiceInfo(this.databaseServiceName, RdbmsServiceInfo.class);
        if (databaseServiceInfo == null) {
            this.logger.error((Object)("No database service with name: " + this.databaseServiceName));
            return;
        }
        this.databaseConnection = DriverManager.getConnection(databaseServiceInfo.getUrl(), databaseServiceInfo.getUserName(), databaseServiceInfo.getPassword());
        System.out.println("Database connection configured");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importData() {
        try {
            MongoDbImporter importer = new MongoDbImporter(this.databaseConnection, this.mongoDbConnection);
            importer.importTable(this.tableName);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        finally {
            try {
                this.databaseConnection.close();
            }
            catch (SQLException e) {
                this.logger.error((Object)e);
            }
            this.mongoDbConnection.close();
        }
    }
}

