/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.mongodb.query;

import com.jaspersoft.mongodb.MongoDbDataSource;
import com.jaspersoft.mongodb.connection.MongoDbConnection;
import com.jaspersoft.mongodb.query.MongoDbQueryWrapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import org.apache.log4j.Logger;

public class MongoDbQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Logger logger = Logger.getLogger(MongoDbQueryExecuter.class);
    private Map<String, ? extends JRValueParameter> reportParameters;
    private Map<String, Object> parameters;
    private MongoDbQueryWrapper wrapper;
    private boolean directParameters;

    public MongoDbQueryExecuter(JRDataset dataset, Map<String, ? extends JRValueParameter> parameters) throws JRException {
        this(dataset, parameters, false);
    }

    public MongoDbQueryExecuter(JRDataset dataset, Map<String, ? extends JRValueParameter> parameters, boolean directParameters) {
        super(dataset, parameters);
        this.directParameters = directParameters;
        this.reportParameters = parameters;
        this.parameters = new HashMap<String, Object>();
        this.parseQuery();
    }

    public boolean cancelQuery() throws JRException {
        logger.warn((Object)"Cancel not implemented");
        return false;
    }

    public void close() {
        this.wrapper = null;
    }

    private MongoDbConnection processConnection(JRValueParameter valueParameter) throws JRException {
        if (valueParameter == null) {
            throw new JRException("No MongoDB connection");
        }
        return (MongoDbConnection)valueParameter.getValue();
    }

    public JRDataSource createDatasource() throws JRException {
        MongoDbConnection connection = (MongoDbConnection)((Map)this.getParameterValue("REPORT_PARAMETERS_MAP")).get("REPORT_CONNECTION");
        if (connection == null) {
            logger.warn((Object)"No MongoDB connection, trying default REPORT_CONNECTION");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("REPORT_PARAMETERS_MAP: " + ((Map)this.getParameterValue("REPORT_PARAMETERS_MAP")).keySet()));
            }
            if ((connection = (MongoDbConnection)((Map)this.getParameterValue("REPORT_PARAMETERS_MAP")).get("REPORT_CONNECTION")) == null) {
                logger.warn((Object)"No MongoDB connection, trying direct access");
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Direct parameters: " + this.reportParameters.keySet()));
                }
                if ((connection = this.processConnection(this.reportParameters.get("REPORT_CONNECTION"))) == null) {
                    throw new JRException("No MongoDB connection");
                }
            }
        }
        this.wrapper = new MongoDbQueryWrapper(this.getQueryString(), connection, this.parameters);
        return new MongoDbDataSource(this.wrapper);
    }

    protected String getParameterReplacement(String parameterName) {
        Object parameterValue = this.reportParameters.get(parameterName);
        if (parameterValue == null) {
            throw new JRRuntimeException("Parameter \"" + parameterName + "\" does not exist.");
        }
        if (parameterValue instanceof JRValueParameter) {
            parameterValue = parameterValue.getValue();
        }
        return this.processParameter(parameterName, parameterValue);
    }

    private String processParameter(String parameterName, Object parameterValue) {
        if (parameterValue instanceof Collection) {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            for (Object value : (Collection)parameterValue) {
                if (value instanceof String) {
                    builder.append("'");
                    builder.append(value);
                    builder.append("'");
                } else {
                    builder.append(String.valueOf(value));
                }
                builder.append(", ");
            }
            if (builder.length() > 2) {
                builder.delete(builder.length() - 2, builder.length());
            }
            builder.append("]");
            return builder.toString();
        }
        this.parameters.put(parameterName, parameterValue);
        return this.generateParameterObject(parameterName);
    }

    private String generateParameterObject(String parameterName) {
        return "{'" + parameterName + "':null}";
    }

    public String getProcessedQueryString() {
        return this.getQueryString();
    }

    protected Object getParameterValue(String parameterName, boolean ignoreMissing) {
        try {
            return super.getParameterValue(parameterName, ignoreMissing);
        }
        catch (Exception e) {
            if (e.getMessage().endsWith("cannot be cast to net.sf.jasperreports.engine.JRValueParameter") && this.directParameters) {
                return this.reportParameters.get(parameterName);
            }
            return null;
        }
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }
}

