/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.headertoolbar.actions;

import java.util.List;
import net.sf.jasperreports.components.headertoolbar.actions.EditColumnValueData;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.components.table.util.TableUtil;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.web.commands.Command;

public class EditColumnValuesCommand
implements Command {
    private StandardTable table;
    private EditColumnValueData editColumnValueData;
    private EditColumnValueData oldEditColumnValueData;
    private JRDesignTextField textElement;

    public EditColumnValuesCommand(StandardTable table, EditColumnValueData editColumnHeaderData) {
        this.table = table;
        this.editColumnValueData = editColumnHeaderData;
    }

    @Override
    public void execute() {
        List<BaseColumn> tableColumns = TableUtil.getAllColumns(this.table);
        StandardColumn column = (StandardColumn)tableColumns.get(this.editColumnValueData.getColumnIndex());
        this.textElement = (JRDesignTextField)TableUtil.getColumnDetailTextElement(column);
        if (this.textElement != null) {
            this.oldEditColumnValueData = new EditColumnValueData();
            this.oldEditColumnValueData.setFontName(this.textElement.getFontName());
            this.oldEditColumnValueData.setFontSize(this.textElement.getFontSize());
            this.oldEditColumnValueData.setFontBold(this.textElement.isBold());
            this.oldEditColumnValueData.setFontItalic(this.textElement.isItalic());
            this.oldEditColumnValueData.setFontUnderline(this.textElement.isUnderline());
            this.oldEditColumnValueData.setFontColor(JRColorUtil.getColorHexa(this.textElement.getForecolor()));
            this.oldEditColumnValueData.setFontHAlign(this.textElement.getHorizontalAlignmentValue().getName());
            if (TableUtil.isSortableAndFilterable(this.textElement)) {
                this.oldEditColumnValueData.setFormatPattern(this.textElement.getPattern());
            }
            this.applyColumnHeaderData(this.editColumnValueData, this.textElement, true);
        }
    }

    private void applyColumnHeaderData(EditColumnValueData headerData, JRDesignTextField textElement, boolean execute) {
        textElement.setFontName(headerData.getFontName());
        textElement.setFontSize(headerData.getFontSize());
        textElement.setBold(headerData.getFontBold());
        textElement.setItalic(headerData.getFontItalic());
        textElement.setUnderline(headerData.getFontUnderline());
        textElement.setForecolor(JRColorUtil.getColor("#" + headerData.getFontColor(), textElement.getForecolor()));
        textElement.setHorizontalAlignment(HorizontalAlignEnum.getByName(headerData.getFontHAlign()));
        if (TableUtil.isSortableAndFilterable(textElement)) {
            textElement.setPattern(headerData.getFormatPattern());
        }
    }

    @Override
    public void undo() {
        if (this.oldEditColumnValueData != null) {
            this.applyColumnHeaderData(this.oldEditColumnValueData, this.textElement, false);
        }
    }

    @Override
    public void redo() {
        this.applyColumnHeaderData(this.editColumnValueData, this.textElement, true);
    }
}

