/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import rex.graphics.TupleMemberLabelPopUpActions;
import rex.utils.LanguageChangedListener;

public abstract class TupleMemberLabel
extends JLabel
implements ActionListener,
LanguageChangedListener {
    JPopupMenu popup = new JPopupMenu();

    public TupleMemberLabel(String caption) {
        super(caption);
        this.addMouseListener(new PopupListener());
    }

    public TupleMemberLabel(String caption, int horAlignment) {
        super(caption, horAlignment);
        this.addMouseListener(new PopupListener());
    }

    @Override
    public void removeAll() {
        super.removeAll();
        MouseListener[] mL = this.getMouseListeners();
        for (int i = 0; i < mL.length; ++i) {
            this.removeMouseListener(mL[i]);
        }
        this.popup.removeAll();
        this.popup = null;
    }

    abstract String[] getPopUpActionList();

    abstract void highlightHierarchy();

    abstract void toggleHierarchy();

    abstract void moveDimensionUp();

    abstract void moveDimensionFirst();

    abstract void moveDimensionLast();

    abstract void removeDimensionFromQuery();

    abstract void removeMemberFromQuery();

    abstract void keepThisMemberOnly();

    abstract void sortByMeasureAscending();

    abstract void sortByMeasureDescending();

    abstract void sortByMeasureBAscending();

    abstract void sortByMeasureBDescending();

    abstract void sendMemberToFilter();

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean i = false;
        if (e.getActionCommand().equals((String)TupleMemberLabelPopUpActions.popUpCaptions.get(TupleMemberLabelPopUpActions.MOVE_DIMENSION_UP))) {
            this.moveDimensionUp();
        } else if (e.getActionCommand().equals((String)TupleMemberLabelPopUpActions.popUpCaptions.get(TupleMemberLabelPopUpActions.MOVE_DIMENSION_FIRST))) {
            this.moveDimensionFirst();
        } else if (e.getActionCommand().equals((String)TupleMemberLabelPopUpActions.popUpCaptions.get(TupleMemberLabelPopUpActions.MOVE_DIMENSION_LAST))) {
            this.moveDimensionLast();
        } else if (e.getActionCommand().equals((String)TupleMemberLabelPopUpActions.popUpCaptions.get(TupleMemberLabelPopUpActions.REMOVE_DIMENSION_FROM_QUERY))) {
            this.removeDimensionFromQuery();
        } else if (e.getActionCommand().equals((String)TupleMemberLabelPopUpActions.popUpCaptions.get(TupleMemberLabelPopUpActions.REMOVE_MEMBER_FROM_QUERY))) {
            this.removeMemberFromQuery();
        } else if (e.getActionCommand().equals((String)TupleMemberLabelPopUpActions.popUpCaptions.get(TupleMemberLabelPopUpActions.KEEP_THIS_MEMBER_ONLY))) {
            this.keepThisMemberOnly();
        } else if (e.getActionCommand().equals((String)TupleMemberLabelPopUpActions.popUpCaptions.get(TupleMemberLabelPopUpActions.SEND_MEMBER_TO_FILTER))) {
            this.sendMemberToFilter();
        } else if (e.getActionCommand().equals((String)TupleMemberLabelPopUpActions.popUpCaptions.get(TupleMemberLabelPopUpActions.SORT_BY_THIS_ASCENDING))) {
            this.sortByMeasureAscending();
        } else if (e.getActionCommand().equals((String)TupleMemberLabelPopUpActions.popUpCaptions.get(TupleMemberLabelPopUpActions.SORT_BY_THIS_DESCENDING))) {
            this.sortByMeasureDescending();
        } else if (e.getActionCommand().equals((String)TupleMemberLabelPopUpActions.popUpCaptions.get(TupleMemberLabelPopUpActions.SORT_BY_THIS_BASCENDING))) {
            this.sortByMeasureBAscending();
        } else if (e.getActionCommand().equals((String)TupleMemberLabelPopUpActions.popUpCaptions.get(TupleMemberLabelPopUpActions.SORT_BY_THIS_BDESCENDING))) {
            this.sortByMeasureBDescending();
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() == 1) {
                TupleMemberLabel.this.highlightHierarchy();
                this.maybeShowPopup(e);
            } else if (e.getClickCount() == 2) {
                TupleMemberLabel.this.toggleHierarchy();
            }
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                TupleMemberLabel.this.popup.removeAll();
                String[] al = TupleMemberLabel.this.getPopUpActionList();
                for (int i = 0; al != null && i < al.length; ++i) {
                    JMenuItem menuItem = new JMenuItem((String)TupleMemberLabelPopUpActions.popUpCaptions.get(al[i]));
                    menuItem.addActionListener(TupleMemberLabel.this);
                    TupleMemberLabel.this.popup.add(menuItem);
                }
                TupleMemberLabel.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

