/*
 * Copyright (C) 2005 - 2008 JasperSoft Corporation.  All rights reserved. 
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 *
 *
 *
 *
 * MassiveCompilerFrame.java
 * 
 * Created on 19 maggio 2004, 6.16
 *
 */

package com.jaspersoft.ireport.addons.transformer.tool;

import com.jaspersoft.ireport.addons.transformer.BarcodeTransformer;
import com.jaspersoft.ireport.addons.transformer.CompileTransformer;
import com.jaspersoft.ireport.addons.transformer.Transformer;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import javax.swing.table.*;
import javax.swing.*;
import javax.swing.event.ListSelectionEvent;
import org.openide.util.NbBundle;
/**
 *
 * @author  Administrator
 */
public class TransformationFrame extends javax.swing.JDialog {
    
    private FindThread findThread = null;
    private CompileThread compileThread = null;
    private boolean finding = false;
    private boolean compiling = false;

    
    /** Creates new form MassiveCompilationFrame */
    public TransformationFrame(Frame parent) {
        super(parent);
        initComponents();
        
        this.setSize(550,450);
        setLocationRelativeTo(null);
        // Adjust table columns...
        DefaultTableColumnModel dtcm = (DefaultTableColumnModel)this.jTableFiles.getColumnModel();
        
        jTableFiles.getColumnModel().getColumn(0).setCellRenderer( new ImageCellRenderer());
        
        jTableFiles.setRowHeight(18);
        dtcm.getColumn(0).setWidth(18);
        dtcm.getColumn(1).setWidth(300);
        dtcm.getColumn(2).setWidth(50);
        
        dtcm.getColumn(0).setPreferredWidth(18);
        dtcm.getColumn(1).setPreferredWidth(300);
        dtcm.getColumn(2).setPreferredWidth(50);
        
        dtcm.getColumn(0).setMinWidth(18);
        dtcm.getColumn(0).setMaxWidth(18);
        //dtcm.getColumn(2).setMinWidth(300);
        //dtcm.getColumn(3).setMinWidth(50);

        jComboBoxElaborations.setRenderer(new TransformerCellRenderer());


        jComboBoxElaborations.addItem(new CompileTransformer());
        jComboBoxElaborations.addItem(new BarcodeTransformer());
        jComboBoxElaborations.setSelectedIndex(0);

        
        
        DefaultListSelectionModel dlsm =  (DefaultListSelectionModel)this.jTableFiles.getSelectionModel();
        dlsm.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e)  {
                jTableFilesListSelectionValueChanged(e);
            }
        });

    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPopupMenuFiles = new javax.swing.JPopupMenu();
        jMenuItemDetails = new javax.swing.JMenuItem();
        jMenuItemOpen = new javax.swing.JMenuItem();
        jPanel1 = new javax.swing.JPanel();
        jTextFieldPath = new javax.swing.JTextField();
        jButtonBrowse = new javax.swing.JButton();
        jCheckBoxSubDir = new javax.swing.JCheckBox();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTableFiles = new javax.swing.JTable();
        jPanel3 = new javax.swing.JPanel();
        jButtonFind = new javax.swing.JButton();
        jButtonCancelFind = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        jComboBoxElaborations = new javax.swing.JComboBox();
        jPanel5 = new javax.swing.JPanel();
        jButtonCompile = new javax.swing.JButton();
        jButtonCompileAll = new javax.swing.JButton();
        jButtonCancelCompile = new javax.swing.JButton();
        jButtonClose = new javax.swing.JButton();
        jPanelElaborationOptions = new javax.swing.JPanel();

        jMenuItemDetails.setText(org.openide.util.NbBundle.getMessage(TransformationFrame.class, "TransformationFrame.jMenuItemDetails.text")); // NOI18N
        jMenuItemDetails.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemDetailsActionPerformed(evt);
            }
        });
        jPopupMenuFiles.add(jMenuItemDetails);

        jMenuItemOpen.setText(org.openide.util.NbBundle.getMessage(TransformationFrame.class, "TransformationFrame.jMenuItemOpen.text")); // NOI18N
        jMenuItemOpen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemOpenActionPerformed(evt);
            }
        });
        jPopupMenuFiles.add(jMenuItemOpen);

        setTitle(org.openide.util.NbBundle.getMessage(TransformationFrame.class, "TransformationFrame.title")); // NOI18N
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createEtchedBorder(), org.openide.util.NbBundle.getMessage(TransformationFrame.class, "TransformationFrame.jPanel1.border.title"))); // NOI18N
        jPanel1.setMinimumSize(new java.awt.Dimension(0, 70));
        jPanel1.setPreferredSize(new java.awt.Dimension(0, 70));
        jPanel1.setLayout(new java.awt.GridBagLayout());

        jTextFieldPath.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextFieldPathActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 2, 0, 2);
        jPanel1.add(jTextFieldPath, gridBagConstraints);

        jButtonBrowse.setText(org.openide.util.NbBundle.getMessage(TransformationFrame.class, "TransformationFrame.jButtonBrowse.text")); // NOI18N
        jButtonBrowse.setMinimumSize(new java.awt.Dimension(87, 20));
        jButtonBrowse.setPreferredSize(new java.awt.Dimension(87, 20));
        jButtonBrowse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        jPanel1.add(jButtonBrowse, gridBagConstraints);

        jCheckBoxSubDir.setText(org.openide.util.NbBundle.getMessage(TransformationFrame.class, "TransformationFrame.jCheckBoxSubDir.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel1.add(jCheckBoxSubDir, gridBagConstraints);

        jTableFiles.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "", "File", "Status"
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false, false, false
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jTableFiles.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jTableFilesMouseClicked(evt);
            }
        });
        jScrollPane1.setViewportView(jTableFiles);

        jPanel3.setMinimumSize(new java.awt.Dimension(100, 10));
        jPanel3.setPreferredSize(new java.awt.Dimension(100, 10));
        jPanel3.setLayout(new java.awt.GridBagLayout());

        jButtonFind.setText(org.openide.util.NbBundle.getMessage(TransformationFrame.class, "TransformationFrame.jButtonFind.text")); // NOI18N
        jButtonFind.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFindActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        jPanel3.add(jButtonFind, gridBagConstraints);

        jButtonCancelFind.setText(org.openide.util.NbBundle.getMessage(TransformationFrame.class, "TransformationFrame.jButtonCancelFind.text")); // NOI18N
        jButtonCancelFind.setEnabled(false);
        jButtonCancelFind.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelFindActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 0, 0);
        jPanel3.add(jButtonCancelFind, gridBagConstraints);

        jLabel1.setText(org.openide.util.NbBundle.getMessage(TransformationFrame.class, "TransformationFrame.jLabel1.text")); // NOI18N

        jComboBoxElaborations.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxElaborationsActionPerformed(evt);
            }
        });

        jButtonCompile.setText(org.openide.util.NbBundle.getMessage(TransformationFrame.class, "TransformationFrame.jButtonCompile.text")); // NOI18N
        jButtonCompile.setEnabled(false);
        jButtonCompile.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCompileActionPerformed(evt);
            }
        });

        jButtonCompileAll.setText(org.openide.util.NbBundle.getMessage(TransformationFrame.class, "TransformationFrame.jButtonCompileAll.text")); // NOI18N
        jButtonCompileAll.setEnabled(false);
        jButtonCompileAll.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCompileAllActionPerformed(evt);
            }
        });

        jButtonCancelCompile.setText(org.openide.util.NbBundle.getMessage(TransformationFrame.class, "TransformationFrame.jButtonCancelCompile.text")); // NOI18N
        jButtonCancelCompile.setEnabled(false);
        jButtonCancelCompile.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelCompileActionPerformed(evt);
            }
        });

        jButtonClose.setText(org.openide.util.NbBundle.getMessage(TransformationFrame.class, "TransformationFrame.jButtonClose.text")); // NOI18N
        jButtonClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCloseActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel5Layout = new org.jdesktop.layout.GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(
            jPanel5Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel5Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel5Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jButtonClose, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jButtonCancelCompile, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jButtonCompileAll, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jButtonCompile, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel5Layout.setVerticalGroup(
            jPanel5Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel5Layout.createSequentialGroup()
                .addContainerGap()
                .add(jButtonCompile)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jButtonCompileAll)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jButtonCancelCompile)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 28, Short.MAX_VALUE)
                .add(jButtonClose))
        );

        jPanelElaborationOptions.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createEtchedBorder(), org.openide.util.NbBundle.getMessage(TransformationFrame.class, "TransformationFrame.jPanelElaborationOptions.border.title"))); // NOI18N
        jPanelElaborationOptions.setLayout(new java.awt.GridBagLayout());

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(19, 19, 19)
                .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 565, Short.MAX_VALUE)
                .add(4, 4, 4)
                .add(jPanel3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(10, 10, 10))
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .add(10, 10, 10)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 678, Short.MAX_VALUE)
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(layout.createSequentialGroup()
                                .add(jLabel1)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(jComboBoxElaborations, 0, 414, Short.MAX_VALUE))
                            .add(jPanelElaborationOptions, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 497, Short.MAX_VALUE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                        .add(jPanel5, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)))
                .add(10, 10, 10))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jPanel3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 70, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(4, 4, 4)
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 250, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(jLabel1)
                            .add(jComboBoxElaborations, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jPanelElaborationOptions, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel5, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jMenuItemOpenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemOpenActionPerformed

        if (jTableFiles.getSelectedRowCount() != 0)
            {
                Misc.openFile(((FileEntry)this.jTableFiles.getValueAt( jTableFiles.getSelectedRow(), 0)).getFile());
            }
    }//GEN-LAST:event_jMenuItemOpenActionPerformed

    private void jMenuItemDetailsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemDetailsActionPerformed
        if (jTableFiles.getSelectedRowCount() != 0)
            {
                FileDetails fd = new FileDetails(this, true);
                fd.setFileEntry( (FileEntry)this.jTableFiles.getValueAt( jTableFiles.getSelectedRow(), 0) );
                fd.setVisible(true);
            }
    }//GEN-LAST:event_jMenuItemDetailsActionPerformed

    private void jTableFilesMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jTableFilesMouseClicked
        if (evt.getButton() == evt.BUTTON1 && evt.getClickCount() == 2)
        {
            if (jTableFiles.getSelectedRowCount() != 0)
            {
                FileDetails fd = new FileDetails(this, true);
                fd.setFileEntry( (FileEntry)this.jTableFiles.getValueAt( jTableFiles.getSelectedRow(), 0) );
                fd.setVisible(true);
            }
        }
        else if (evt.getButton() == evt.BUTTON3 && evt.getClickCount() == 1)
        {
            this.jPopupMenuFiles.show(jTableFiles, evt.getPoint().x, evt.getPoint().y);
        }
    }//GEN-LAST:event_jTableFilesMouseClicked

    private void jButtonCompileAllActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCompileAllActionPerformed
        // Retrive data for compilation...
        
        compileThread = new CompileThread(this);
        compileThread.setCompileSelectedOnly(false);
        compileThread.setTransformer( (Transformer) jComboBoxElaborations.getSelectedItem());
        startCompiling();
        compileThread.start();
    }//GEN-LAST:event_jButtonCompileAllActionPerformed

    private void jButtonCancelCompileActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelCompileActionPerformed
        compileThread.stop();
        finishedCompiling();
    }//GEN-LAST:event_jButtonCancelCompileActionPerformed

    private void jButtonCompileActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCompileActionPerformed
        
        // Retrive data for compilation...
        
        compileThread = new CompileThread(this);
        compileThread.setCompileSelectedOnly(true);
        compileThread.setTransformer( (Transformer) jComboBoxElaborations.getSelectedItem());
        startCompiling();
        compileThread.start();
        
    }//GEN-LAST:event_jButtonCompileActionPerformed

    private void jButtonCloseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCloseActionPerformed
        this.setVisible(false);
    }//GEN-LAST:event_jButtonCloseActionPerformed

    private void jButtonCancelFindActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelFindActionPerformed
        
        findThread.stop();
        finishedFind();
        
    }//GEN-LAST:event_jButtonCancelFindActionPerformed

    private void jButtonFindActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFindActionPerformed

        if (jTextFieldPath.getText().length() == 0)
        {
            JOptionPane.showMessageDialog(this,
                    NbBundle.getMessage(TransformationFrame.class,"messages.transformationTool.noDir"),
                    NbBundle.getMessage(TransformationFrame.class,"messages.transformationTool.noDirCaption"), JOptionPane.WARNING_MESSAGE);
            return;
        }
        findThread = new FindThread(this);
        startFind();
        findThread.start();
        
    }//GEN-LAST:event_jButtonFindActionPerformed

    private void jButtonBrowseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonBrowseActionPerformed
        
        // Select a directory...
        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        if (jfc.showOpenDialog(null) == JFileChooser.APPROVE_OPTION)
        {
          jTextFieldPath.setText( jfc.getSelectedFile().getPath());
        }
        
    }//GEN-LAST:event_jButtonBrowseActionPerformed

    private void jTextFieldPathActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextFieldPathActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_jTextFieldPathActionPerformed
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        this.setVisible(false);
    }//GEN-LAST:event_exitForm

    private void jComboBoxElaborationsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxElaborationsActionPerformed

        jPanelElaborationOptions.removeAll();
        Transformer t = (Transformer)jComboBoxElaborations.getSelectedItem();

        if (t != null)
        {
          if (t.getComponent() != null)
          {
              GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
              gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
              gridBagConstraints.weightx = 1.0;
              gridBagConstraints.weighty = 1.0;

              jPanelElaborationOptions.add( t.getComponent(), gridBagConstraints);
          }
        }

        this.jPanelElaborationOptions.updateUI();
        
       
        SwingUtilities.invokeLater(new Runnable() {

            public void run() {

                for (int i=0; i<jTableFiles.getRowCount(); ++i)
                {
                    ((FileEntry)jTableFiles.getValueAt(i, 0)).setStatus( FileEntry.STATUS_NOT_TRANSFORMED );
                }
                jTableFiles.updateUI();

            }
        });
        
    }//GEN-LAST:event_jComboBoxElaborationsActionPerformed
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new TransformationFrame(null).setVisible(true);
    }

    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonBrowse;
    private javax.swing.JButton jButtonCancelCompile;
    private javax.swing.JButton jButtonCancelFind;
    private javax.swing.JButton jButtonClose;
    private javax.swing.JButton jButtonCompile;
    private javax.swing.JButton jButtonCompileAll;
    private javax.swing.JButton jButtonFind;
    private javax.swing.JCheckBox jCheckBoxSubDir;
    private javax.swing.JComboBox jComboBoxElaborations;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JMenuItem jMenuItemDetails;
    private javax.swing.JMenuItem jMenuItemOpen;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanelElaborationOptions;
    private javax.swing.JPopupMenu jPopupMenuFiles;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTableFiles;
    private javax.swing.JTextField jTextFieldPath;
    // End of variables declaration//GEN-END:variables
 
    
    public javax.swing.JTable getFileTable()
    {
        return jTableFiles;   
    }
    
    public String getFindDirectory()
    {
        return jTextFieldPath.getText();
    }
    
    public boolean isSearchSubDirectory()
    {
        return jCheckBoxSubDir.isSelected();
    }
    
    public void finishedFind()
    {
        finding = false;
        this.jButtonCancelFind.setEnabled(false);
        this.jButtonFind.setEnabled(true);
        this.jButtonClose.setEnabled(true);
        this.jCheckBoxSubDir.setEnabled(true);
        this.jTextFieldPath.setEditable(true);
        
        if (this.jTableFiles.getRowCount() > 0)
        {
            this.jButtonCompileAll.setEnabled(true);
            jTableFilesListSelectionValueChanged(new ListSelectionEvent(this,0,0,false));
        }
        else
        {
            this.jButtonCompileAll.setEnabled(false);
        }
        
    }
    
    public void startFind()
    {
        finding = true;
        this.jButtonCancelFind.setEnabled(true);
        this.jButtonFind.setEnabled(false);
        
        this.jButtonCompileAll.setEnabled(false);
        this.jButtonCompile.setEnabled(false);
        this.jButtonClose.setEnabled(false);
        this.jCheckBoxSubDir.setEnabled(false);
        this.jTextFieldPath.setEditable(false);

    }
    
    public void finishedCompiling()
    {
        compiling = false;
        this.jButtonCancelCompile.setEnabled(false);
        this.jButtonFind.setEnabled(true);
        this.jButtonClose.setEnabled(true); 
        
        if (this.jTableFiles.getRowCount() > 0)
        {
            this.jButtonCompileAll.setEnabled(true);
            jTableFilesListSelectionValueChanged(new ListSelectionEvent(this,0,0,false));
        }
        else
        {
            this.jButtonCompileAll.setEnabled(false);
        }
    }
    
    public void startCompiling()
    {
        compiling = true;
        this.jButtonCancelCompile.setEnabled(false);
        this.jButtonFind.setEnabled(false);
        
        this.jButtonCompileAll.setEnabled(false);
        this.jButtonCompile.setEnabled(false);
        this.jButtonClose.setEnabled(false);
    }
    
    public void jTableFilesListSelectionValueChanged(ListSelectionEvent e)
    {
        if (finding) return;
        if (this.jTableFiles.getSelectedRowCount() > 0)
        {
            this.jButtonCompile.setEnabled(true);
        }
        else
        {
            this.jButtonCompile.setEnabled(false);
        }
    }

  
}
