/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chartthemes.simple;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TimeZone;
import net.sf.jasperreports.charts.ChartContext;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRItemLabel;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRPie3DPlot;
import net.sf.jasperreports.charts.JRPiePlot;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.type.EdgeEnum;
import net.sf.jasperreports.charts.type.MeterShapeEnum;
import net.sf.jasperreports.charts.type.ScaleTypeEnum;
import net.sf.jasperreports.charts.type.ValueLocationEnum;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.chartthemes.simple.AxisSettings;
import net.sf.jasperreports.chartthemes.simple.ChartSettings;
import net.sf.jasperreports.chartthemes.simple.ChartThemeSettings;
import net.sf.jasperreports.chartthemes.simple.LegendSettings;
import net.sf.jasperreports.chartthemes.simple.PaintProvider;
import net.sf.jasperreports.chartthemes.simple.PlotSettings;
import net.sf.jasperreports.chartthemes.simple.TitleSettings;
import net.sf.jasperreports.chartthemes.spring.ChartThemesConstants;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.type.ModeEnum;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.MeterInterval;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ThermometerPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.plot.dial.DialBackground;
import org.jfree.chart.plot.dial.DialCap;
import org.jfree.chart.plot.dial.DialFrame;
import org.jfree.chart.plot.dial.DialLayer;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.plot.dial.DialPointer;
import org.jfree.chart.plot.dial.DialScale;
import org.jfree.chart.plot.dial.DialTextAnnotation;
import org.jfree.chart.plot.dial.DialValueIndicator;
import org.jfree.chart.plot.dial.StandardDialFrame;
import org.jfree.chart.plot.dial.StandardDialRange;
import org.jfree.chart.plot.dial.StandardDialScale;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer3D;
import org.jfree.chart.renderer.xy.CandlestickRenderer;
import org.jfree.chart.renderer.xy.HighLowRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYBubbleRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.gantt.GanttCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.DefaultHighLowDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jfree.ui.VerticalAlignment;

public class SimpleChartTheme
implements net.sf.jasperreports.charts.ChartTheme {
    protected ChartThemeSettings chartThemeSettings;
    protected ThreadLocal<ChartContext> threadLocalChartContext = new ThreadLocal();
    protected ThreadLocal<FontUtil> threadLocalFontUtil = new ThreadLocal();

    protected SimpleChartTheme() {
    }

    public SimpleChartTheme(ChartThemeSettings chartThemeSettings) {
        this.chartThemeSettings = chartThemeSettings;
    }

    public ChartThemeSettings getChartThemeSettings() {
        return this.chartThemeSettings;
    }

    public void setChartThemeSettings(ChartThemeSettings chartThemeSettings) {
        this.chartThemeSettings = chartThemeSettings;
    }

    public ChartSettings getChartSettings() {
        return this.getChartThemeSettings().getChartSettings();
    }

    public TitleSettings getTitleSettings() {
        return this.getChartThemeSettings().getTitleSettings();
    }

    public TitleSettings getSubtitleSettings() {
        return this.getChartThemeSettings().getSubtitleSettings();
    }

    public LegendSettings getLegendSettings() {
        return this.getChartThemeSettings().getLegendSettings();
    }

    public PlotSettings getPlotSettings() {
        return this.getChartThemeSettings().getPlotSettings();
    }

    public AxisSettings getDomainAxisSettings() {
        return this.getChartThemeSettings().getDomainAxisSettings();
    }

    public AxisSettings getRangeAxisSettings() {
        return this.getChartThemeSettings().getRangeAxisSettings();
    }

    private ChartContext getChartContext() {
        return this.threadLocalChartContext.get();
    }

    private FontUtil getFontUtil() {
        return this.threadLocalFontUtil.get();
    }

    private void setChartContext(ChartContext chartContext) {
        this.threadLocalChartContext.set(chartContext);
        this.threadLocalFontUtil.set(FontUtil.getInstance((JasperReportsContext)chartContext.getJasperReportsContext()));
    }

    protected JRChart getChart() {
        return this.getChartContext().getChart();
    }

    protected JRChartPlot getPlot() {
        return this.getChart().getPlot();
    }

    protected Dataset getDataset() {
        return this.getChartContext().getDataset();
    }

    protected Object getLabelGenerator() {
        return this.getChartContext().getLabelGenerator();
    }

    protected Locale getLocale() {
        return this.getChartContext().getLocale();
    }

    protected final Object evaluateExpression(JRExpression expression) throws JRException {
        return this.getChartContext().evaluateExpression(expression);
    }

    public JFreeChart createChart(ChartContext chartContext) throws JRException {
        this.setChartContext(chartContext);
        JFreeChart jfreeChart = null;
        switch (this.getChart().getChartType()) {
            case 1: {
                jfreeChart = this.createAreaChart();
                break;
            }
            case 3: {
                jfreeChart = this.createBarChart();
                break;
            }
            case 2: {
                jfreeChart = this.createBar3DChart();
                break;
            }
            case 4: {
                jfreeChart = this.createBubbleChart();
                break;
            }
            case 5: {
                jfreeChart = this.createCandlestickChart();
                break;
            }
            case 6: {
                jfreeChart = this.createHighLowChart();
                break;
            }
            case 7: {
                jfreeChart = this.createLineChart();
                break;
            }
            case 17: {
                jfreeChart = this.createMeterChart();
                break;
            }
            case 19: {
                break;
            }
            case 9: {
                jfreeChart = this.createPieChart();
                break;
            }
            case 8: {
                jfreeChart = this.createPie3DChart();
                break;
            }
            case 10: {
                jfreeChart = this.createScatterChart();
                break;
            }
            case 12: {
                jfreeChart = this.createStackedBarChart();
                break;
            }
            case 11: {
                jfreeChart = this.createStackedBar3DChart();
                break;
            }
            case 18: {
                jfreeChart = this.createThermometerChart();
                break;
            }
            case 16: {
                jfreeChart = this.createTimeSeriesChart();
                break;
            }
            case 13: {
                jfreeChart = this.createXyAreaChart();
                break;
            }
            case 14: {
                jfreeChart = this.createXYBarChart();
                break;
            }
            case 15: {
                jfreeChart = this.createXyLineChart();
                break;
            }
            case 20: {
                jfreeChart = this.createStackedAreaChart();
                break;
            }
            case 21: {
                jfreeChart = this.createGanttChart();
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type " + this.getChart().getChartType() + " not supported.");
            }
        }
        return jfreeChart;
    }

    protected void configureChart(JFreeChart jfreeChart, JRChartPlot jrPlot) throws JRException {
        RectangleInsets padding;
        Boolean textAntiAlias;
        ChartSettings chartSettings = this.getChartSettings();
        this.setChartBackground(jfreeChart);
        this.setChartTitle(jfreeChart);
        this.setChartSubtitles(jfreeChart);
        this.setChartLegend(jfreeChart);
        this.setChartBorder(jfreeChart);
        Boolean chartAntiAlias = chartSettings.getAntiAlias();
        if (chartAntiAlias != null) {
            jfreeChart.setAntiAlias(chartAntiAlias.booleanValue());
        }
        if ((textAntiAlias = chartSettings.getTextAntiAlias()) != null) {
            jfreeChart.setTextAntiAlias(textAntiAlias.booleanValue());
        }
        if ((padding = chartSettings.getPadding()) != null) {
            jfreeChart.setPadding(padding);
        }
        this.configurePlot(jfreeChart.getPlot(), jrPlot);
    }

    protected void configurePlot(Plot plot, JRChartPlot jrPlot) {
        Boolean plotOutlineVisible;
        RectangleInsets padding = this.getPlotSettings().getPadding();
        if (padding != null) {
            plot.setInsets(padding);
        }
        if ((plotOutlineVisible = this.getPlotSettings().getOutlineVisible()) == null || plotOutlineVisible.booleanValue()) {
            Stroke plotOutlineStroke;
            Paint outlinePaint;
            Paint paint = outlinePaint = this.getPlotSettings().getOutlinePaint() == null ? null : this.getPlotSettings().getOutlinePaint().getPaint();
            if (outlinePaint != null) {
                plot.setOutlinePaint(outlinePaint);
            }
            if ((plotOutlineStroke = this.getPlotSettings().getOutlineStroke()) != null) {
                plot.setOutlineStroke(plotOutlineStroke);
            }
            plot.setOutlineVisible(true);
        } else {
            plot.setOutlineVisible(false);
        }
        this.setPlotBackground(plot, jrPlot);
        this.setPlotDrawingDefaults(plot, jrPlot);
        if (plot instanceof CategoryPlot) {
            this.handleCategoryPlotSettings((CategoryPlot)plot, jrPlot);
        }
        if (plot instanceof XYPlot) {
            this.handleXYPlotSettings((XYPlot)plot, jrPlot);
        }
    }

    protected void configureAxis(Axis axis, JRFont labelFont, Color labelColor, JRFont tickLabelFont, Color tickLabelColor, String tickLabelMask, Boolean verticalTickLabels, Paint lineColor, AxisSettings axisSettings, Comparable<?> axisMinValue, Comparable<?> axisMaxValue) throws JRException {
        this.configureAxis(axis, labelFont, labelColor, tickLabelFont, tickLabelColor, tickLabelMask, verticalTickLabels, lineColor, axisSettings, 0, axisMinValue, axisMaxValue);
    }

    protected void configureAxis(Axis axis, JRFont labelFont, Color labelColor, JRFont tickLabelFont, Color tickLabelColor, String tickLabelMask, Boolean verticalTickLabels, Paint lineColor, AxisSettings axisSettings, int timePeriod, Comparable<?> axisMinValue, Comparable<?> axisMaxValue) throws JRException {
        Boolean axisVisible = axisSettings.getVisible();
        if (axisVisible == null || axisVisible.booleanValue()) {
            this.setAxisLine(axis, lineColor, axisSettings);
            this.setAxisLabel(axis, labelFont, labelColor, axisSettings);
            this.setAxisTickLabels(axis, tickLabelFont, tickLabelColor, tickLabelMask, axisSettings);
            this.setAxisTickMarks(axis, lineColor, axisSettings);
            this.setAxisBounds(axis, axisSettings, timePeriod, axisMinValue, axisMaxValue);
            if (verticalTickLabels != null && axis instanceof ValueAxis) {
                ((ValueAxis)axis).setVerticalTickLabels(verticalTickLabels.booleanValue());
            }
        } else {
            axis.setVisible(false);
        }
    }

    protected JFreeChart createAreaChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createAreaChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression())), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientationValue().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        JRAreaPlot areaPlot = (JRAreaPlot)this.getPlot();
        this.configureAxis((Axis)((CategoryPlot)jfreeChart.getPlot()).getDomainAxis(), areaPlot.getCategoryAxisLabelFont(), areaPlot.getCategoryAxisLabelColor(), areaPlot.getCategoryAxisTickLabelFont(), areaPlot.getCategoryAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getCategoryAxisVerticalTickLabels(), areaPlot.getOwnCategoryAxisLineColor(), this.getDomainAxisSettings(), (Comparable)this.evaluateExpression(areaPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(areaPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)((CategoryPlot)jfreeChart.getPlot()).getRangeAxis(), areaPlot.getValueAxisLabelFont(), areaPlot.getValueAxisLabelColor(), areaPlot.getValueAxisTickLabelFont(), areaPlot.getValueAxisTickLabelColor(), areaPlot.getValueAxisTickLabelMask(), areaPlot.getValueAxisVerticalTickLabels(), areaPlot.getOwnValueAxisLineColor(), this.getRangeAxisSettings(), (Comparable)this.evaluateExpression(areaPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(areaPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createBar3DChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createBarChart3D((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getValueAxisLabelExpression())), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientationValue().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRBar3DPlot bar3DPlot = (JRBar3DPlot)this.getPlot();
        BarRenderer3D barRenderer3D = new BarRenderer3D(bar3DPlot.getXOffsetDouble() == null ? 12.0 : bar3DPlot.getXOffsetDouble(), bar3DPlot.getYOffsetDouble() == null ? 8.0 : bar3DPlot.getYOffsetDouble());
        boolean isShowLabels = bar3DPlot.getShowLabels() == null ? false : bar3DPlot.getShowLabels();
        barRenderer3D.setBaseItemLabelsVisible(isShowLabels);
        if (isShowLabels) {
            JRItemLabel itemLabel = bar3DPlot.getItemLabel();
            JRBaseFont font = itemLabel != null && itemLabel.getFont() != null ? itemLabel.getFont() : new JRBaseFont((JRStyleContainer)this.getChart(), null);
            barRenderer3D.setBaseItemLabelFont(this.getFontUtil().getAwtFont((JRFont)font, this.getLocale()));
            if (itemLabel != null) {
                if (itemLabel.getColor() != null) {
                    barRenderer3D.setBaseItemLabelPaint((Paint)itemLabel.getColor());
                } else {
                    barRenderer3D.setBaseItemLabelPaint((Paint)this.getChart().getForecolor());
                }
                barRenderer3D.setBaseItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
            } else {
                barRenderer3D.setBaseItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
                barRenderer3D.setBaseItemLabelPaint((Paint)this.getChart().getForecolor());
            }
        }
        categoryPlot.setRenderer((CategoryItemRenderer)barRenderer3D);
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), bar3DPlot.getCategoryAxisLabelFont(), bar3DPlot.getCategoryAxisLabelColor(), bar3DPlot.getCategoryAxisTickLabelFont(), bar3DPlot.getCategoryAxisTickLabelColor(), bar3DPlot.getCategoryAxisTickLabelMask(), bar3DPlot.getCategoryAxisVerticalTickLabels(), bar3DPlot.getOwnCategoryAxisLineColor(), this.getDomainAxisSettings(), (Comparable)this.evaluateExpression(bar3DPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(bar3DPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), bar3DPlot.getValueAxisLabelFont(), bar3DPlot.getValueAxisLabelColor(), bar3DPlot.getValueAxisTickLabelFont(), bar3DPlot.getValueAxisTickLabelColor(), bar3DPlot.getValueAxisTickLabelMask(), bar3DPlot.getValueAxisVerticalTickLabels(), bar3DPlot.getOwnValueAxisLineColor(), this.getRangeAxisSettings(), (Comparable)this.evaluateExpression(bar3DPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(bar3DPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createBarChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createBarChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression())), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientationValue().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRBarPlot barPlot = (JRBarPlot)this.getPlot();
        boolean isShowTickMarks = barPlot.getShowTickMarks() == null ? true : barPlot.getShowTickMarks();
        boolean isShowTickLabels = barPlot.getShowTickLabels() == null ? true : barPlot.getShowTickLabels();
        categoryPlot.getDomainAxis().setTickMarksVisible(isShowTickMarks);
        categoryPlot.getDomainAxis().setTickLabelsVisible(isShowTickLabels);
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getCategoryAxisVerticalTickLabels(), barPlot.getOwnCategoryAxisLineColor(), this.getDomainAxisSettings(), (Comparable)this.evaluateExpression(barPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(barPlot.getDomainAxisMaxValueExpression()));
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(isShowTickMarks);
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(isShowTickLabels);
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getValueAxisVerticalTickLabels(), barPlot.getOwnValueAxisLineColor(), this.getRangeAxisSettings(), (Comparable)this.evaluateExpression(barPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(barPlot.getRangeAxisMaxValueExpression()));
        BarRenderer categoryRenderer = (BarRenderer)categoryPlot.getRenderer();
        boolean isShowLabels = barPlot.getShowLabels() == null ? false : barPlot.getShowLabels();
        categoryRenderer.setBaseItemLabelsVisible(isShowLabels);
        if (isShowLabels) {
            JRItemLabel itemLabel = barPlot.getItemLabel();
            JRBaseFont font = itemLabel != null && itemLabel.getFont() != null ? itemLabel.getFont() : new JRBaseFont((JRStyleContainer)this.getChart(), null);
            categoryRenderer.setBaseItemLabelFont(this.getFontUtil().getAwtFont((JRFont)font, this.getLocale()));
            if (itemLabel != null) {
                if (itemLabel.getColor() != null) {
                    categoryRenderer.setBaseItemLabelPaint((Paint)itemLabel.getColor());
                } else {
                    categoryRenderer.setBaseItemLabelPaint((Paint)this.getChart().getForecolor());
                }
                categoryRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
            } else {
                categoryRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
                categoryRenderer.setBaseItemLabelPaint((Paint)this.getChart().getForecolor());
            }
        }
        categoryRenderer.setShadowVisible(false);
        return jfreeChart;
    }

    protected JFreeChart createBubbleChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createBubbleChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRBubblePlot)this.getPlot()).getXAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRBubblePlot)this.getPlot()).getYAxisLabelExpression())), (XYZDataset)((XYZDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientationValue().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        JRBubblePlot bubblePlot = (JRBubblePlot)this.getPlot();
        byte scaleType = bubblePlot.getScaleTypeValue() == null ? ScaleTypeEnum.ON_RANGE_AXIS.getValue() : bubblePlot.getScaleTypeValue().getValue();
        XYBubbleRenderer bubbleRenderer = new XYBubbleRenderer((int)scaleType);
        xyPlot.setRenderer((XYItemRenderer)bubbleRenderer);
        this.configureAxis((Axis)xyPlot.getDomainAxis(), bubblePlot.getXAxisLabelFont(), bubblePlot.getXAxisLabelColor(), bubblePlot.getXAxisTickLabelFont(), bubblePlot.getXAxisTickLabelColor(), bubblePlot.getXAxisTickLabelMask(), bubblePlot.getXAxisVerticalTickLabels(), bubblePlot.getOwnXAxisLineColor(), this.getDomainAxisSettings(), (Comparable)this.evaluateExpression(bubblePlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(bubblePlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)xyPlot.getRangeAxis(), bubblePlot.getYAxisLabelFont(), bubblePlot.getYAxisLabelColor(), bubblePlot.getYAxisTickLabelFont(), bubblePlot.getYAxisTickLabelColor(), bubblePlot.getYAxisTickLabelMask(), bubblePlot.getYAxisVerticalTickLabels(), bubblePlot.getOwnYAxisLineColor(), this.getRangeAxisSettings(), (Comparable)this.evaluateExpression(bubblePlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(bubblePlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createCandlestickChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createCandlestickChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRCandlestickPlot)this.getPlot()).getTimeAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRCandlestickPlot)this.getPlot()).getValueAxisLabelExpression())), (OHLCDataset)((DefaultHighLowDataset)this.getDataset()), (boolean)this.isShowLegend());
        this.configureChart(jfreeChart, this.getPlot());
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        JRCandlestickPlot candlestickPlot = (JRCandlestickPlot)this.getPlot();
        CandlestickRenderer candlestickRenderer = (CandlestickRenderer)xyPlot.getRenderer();
        boolean isShowVolume = candlestickPlot.getShowVolume() == null ? true : candlestickPlot.getShowVolume();
        candlestickRenderer.setDrawVolume(isShowVolume);
        this.configureAxis((Axis)xyPlot.getDomainAxis(), candlestickPlot.getTimeAxisLabelFont(), candlestickPlot.getTimeAxisLabelColor(), candlestickPlot.getTimeAxisTickLabelFont(), candlestickPlot.getTimeAxisTickLabelColor(), candlestickPlot.getTimeAxisTickLabelMask(), candlestickPlot.getTimeAxisVerticalTickLabels(), candlestickPlot.getOwnTimeAxisLineColor(), this.getDomainAxisSettings(), (Comparable)this.evaluateExpression(candlestickPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(candlestickPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)xyPlot.getRangeAxis(), candlestickPlot.getValueAxisLabelFont(), candlestickPlot.getValueAxisLabelColor(), candlestickPlot.getValueAxisTickLabelFont(), candlestickPlot.getValueAxisTickLabelColor(), candlestickPlot.getValueAxisTickLabelMask(), candlestickPlot.getValueAxisVerticalTickLabels(), candlestickPlot.getOwnValueAxisLineColor(), this.getRangeAxisSettings(), (Comparable)this.evaluateExpression(candlestickPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(candlestickPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createHighLowChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createHighLowChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRHighLowPlot)this.getPlot()).getTimeAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRHighLowPlot)this.getPlot()).getValueAxisLabelExpression())), (OHLCDataset)((DefaultHighLowDataset)this.getDataset()), (boolean)this.isShowLegend());
        this.configureChart(jfreeChart, this.getPlot());
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        JRHighLowPlot highLowPlot = (JRHighLowPlot)this.getPlot();
        HighLowRenderer hlRenderer = (HighLowRenderer)xyPlot.getRenderer();
        boolean isShowOpenTicks = highLowPlot.getShowOpenTicks() == null ? false : highLowPlot.getShowOpenTicks();
        boolean isShowCloseTicks = highLowPlot.getShowCloseTicks() == null ? false : highLowPlot.getShowCloseTicks();
        hlRenderer.setDrawOpenTicks(isShowOpenTicks);
        hlRenderer.setDrawCloseTicks(isShowCloseTicks);
        this.configureAxis((Axis)xyPlot.getDomainAxis(), highLowPlot.getTimeAxisLabelFont(), highLowPlot.getTimeAxisLabelColor(), highLowPlot.getTimeAxisTickLabelFont(), highLowPlot.getTimeAxisTickLabelColor(), highLowPlot.getTimeAxisTickLabelMask(), highLowPlot.getTimeAxisVerticalTickLabels(), highLowPlot.getOwnTimeAxisLineColor(), this.getDomainAxisSettings(), (Comparable)this.evaluateExpression(highLowPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(highLowPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)xyPlot.getRangeAxis(), highLowPlot.getValueAxisLabelFont(), highLowPlot.getValueAxisLabelColor(), highLowPlot.getValueAxisTickLabelFont(), highLowPlot.getValueAxisTickLabelColor(), highLowPlot.getValueAxisTickLabelMask(), highLowPlot.getValueAxisVerticalTickLabels(), highLowPlot.getOwnValueAxisLineColor(), this.getRangeAxisSettings(), (Comparable)this.evaluateExpression(highLowPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(highLowPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createLineChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart freeChart = ChartFactory.createLineChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRLinePlot)this.getPlot()).getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRLinePlot)this.getPlot()).getValueAxisLabelExpression())), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientationValue().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(freeChart, this.getPlot());
        CategoryPlot categoryPlot = (CategoryPlot)freeChart.getPlot();
        JRLinePlot linePlot = (JRLinePlot)this.getPlot();
        LineAndShapeRenderer lineRenderer = (LineAndShapeRenderer)categoryPlot.getRenderer();
        boolean isShowShapes = linePlot.getShowShapes() == null ? true : linePlot.getShowShapes();
        boolean isShowLines = linePlot.getShowLines() == null ? true : linePlot.getShowLines();
        lineRenderer.setBaseShapesVisible(isShowShapes);
        lineRenderer.setBaseLinesVisible(isShowLines);
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), linePlot.getCategoryAxisLabelFont(), linePlot.getCategoryAxisLabelColor(), linePlot.getCategoryAxisTickLabelFont(), linePlot.getCategoryAxisTickLabelColor(), linePlot.getCategoryAxisTickLabelMask(), linePlot.getCategoryAxisVerticalTickLabels(), linePlot.getOwnCategoryAxisLineColor(), this.getDomainAxisSettings(), (Comparable)this.evaluateExpression(linePlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(linePlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), linePlot.getValueAxisLabelFont(), linePlot.getValueAxisLabelColor(), linePlot.getValueAxisTickLabelFont(), linePlot.getValueAxisTickLabelColor(), linePlot.getValueAxisTickLabelMask(), linePlot.getValueAxisVerticalTickLabels(), linePlot.getOwnValueAxisLineColor(), this.getRangeAxisSettings(), (Comparable)this.evaluateExpression(linePlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(linePlot.getRangeAxisMaxValueExpression()));
        return freeChart;
    }

    protected JFreeChart createPie3DChart() throws JRException {
        boolean isShowLabels;
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createPieChart3D((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (PieDataset)((PieDataset)this.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        PiePlot3D piePlot3D = (PiePlot3D)jfreeChart.getPlot();
        JRPie3DPlot jrPie3DPlot = (JRPie3DPlot)this.getPlot();
        double depthFactor = jrPie3DPlot.getDepthFactorDouble() == null ? 0.2 : jrPie3DPlot.getDepthFactorDouble();
        boolean isCircular = jrPie3DPlot.getCircular() == null ? false : jrPie3DPlot.getCircular();
        piePlot3D.setDepthFactor(depthFactor);
        piePlot3D.setCircular(isCircular);
        boolean bl = isShowLabels = jrPie3DPlot.getShowLabels() == null ? true : jrPie3DPlot.getShowLabels();
        if (isShowLabels) {
            PieSectionLabelGenerator labelGenerator = (PieSectionLabelGenerator)this.getLabelGenerator();
            JRItemLabel itemLabel = jrPie3DPlot.getItemLabel();
            if (labelGenerator != null) {
                piePlot3D.setLabelGenerator(labelGenerator);
            } else if (jrPie3DPlot.getLabelFormat() != null) {
                piePlot3D.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(jrPie3DPlot.getLabelFormat()));
            }
            if (itemLabel != null && itemLabel.getFont() != null) {
                piePlot3D.setLabelFont(this.getFontUtil().getAwtFont(itemLabel.getFont(), this.getLocale()));
            } else {
                piePlot3D.setLabelFont(this.getFontUtil().getAwtFont((JRFont)new JRBaseFont((JRStyleContainer)this.getChart(), null), this.getLocale()));
            }
            if (itemLabel != null && itemLabel.getColor() != null) {
                piePlot3D.setLabelPaint((Paint)itemLabel.getColor());
            } else {
                piePlot3D.setLabelPaint((Paint)this.getChart().getForecolor());
            }
            if (itemLabel != null && itemLabel.getBackgroundColor() != null) {
                piePlot3D.setLabelBackgroundPaint((Paint)itemLabel.getBackgroundColor());
            } else {
                piePlot3D.setLabelBackgroundPaint((Paint)this.getChart().getBackcolor());
            }
        } else {
            piePlot3D.setLabelGenerator(null);
        }
        if (jrPie3DPlot.getLegendLabelFormat() != null) {
            piePlot3D.setLegendLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(jrPie3DPlot.getLegendLabelFormat()));
        }
        return jfreeChart;
    }

    protected JFreeChart createPieChart() throws JRException {
        boolean isShowLabels;
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createPieChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (PieDataset)((PieDataset)this.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        PiePlot piePlot = (PiePlot)jfreeChart.getPlot();
        JRPiePlot jrPiePlot = (JRPiePlot)this.getPlot();
        boolean isCircular = jrPiePlot.getCircular() == null ? true : jrPiePlot.getCircular();
        piePlot.setCircular(isCircular);
        boolean bl = isShowLabels = jrPiePlot.getShowLabels() == null ? true : jrPiePlot.getShowLabels();
        if (isShowLabels) {
            PieSectionLabelGenerator labelGenerator = (PieSectionLabelGenerator)this.getLabelGenerator();
            JRItemLabel itemLabel = jrPiePlot.getItemLabel();
            if (labelGenerator != null) {
                piePlot.setLabelGenerator(labelGenerator);
            } else if (jrPiePlot.getLabelFormat() != null) {
                piePlot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(jrPiePlot.getLabelFormat()));
            }
            if (itemLabel != null && itemLabel.getFont() != null) {
                piePlot.setLabelFont(this.getFontUtil().getAwtFont(itemLabel.getFont(), this.getLocale()));
            } else {
                piePlot.setLabelFont(this.getFontUtil().getAwtFont((JRFont)new JRBaseFont((JRStyleContainer)this.getChart(), null), this.getLocale()));
            }
            if (itemLabel != null && itemLabel.getColor() != null) {
                piePlot.setLabelPaint((Paint)itemLabel.getColor());
            } else {
                piePlot.setLabelPaint((Paint)this.getChart().getForecolor());
            }
            if (itemLabel != null && itemLabel.getBackgroundColor() != null) {
                piePlot.setLabelBackgroundPaint((Paint)itemLabel.getBackgroundColor());
            } else {
                piePlot.setLabelBackgroundPaint((Paint)this.getChart().getBackcolor());
            }
        } else {
            piePlot.setLabelGenerator(null);
        }
        if (jrPiePlot.getLegendLabelFormat() != null) {
            piePlot.setLegendLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(((JRPiePlot)this.getPlot()).getLegendLabelFormat()));
        }
        return jfreeChart;
    }

    protected JFreeChart createScatterChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createScatterPlot((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRScatterPlot)this.getPlot()).getXAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRScatterPlot)this.getPlot()).getYAxisLabelExpression())), (XYDataset)((XYDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientationValue().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        XYLineAndShapeRenderer plotRenderer = (XYLineAndShapeRenderer)((XYPlot)jfreeChart.getPlot()).getRenderer();
        JRScatterPlot scatterPlot = (JRScatterPlot)this.getPlot();
        boolean isShowLines = scatterPlot.getShowLines() == null ? true : scatterPlot.getShowLines();
        boolean isShowShapes = scatterPlot.getShowShapes() == null ? true : scatterPlot.getShowShapes();
        plotRenderer.setBaseLinesVisible(isShowLines);
        plotRenderer.setBaseShapesVisible(isShowShapes);
        this.configureAxis((Axis)jfreeChart.getXYPlot().getDomainAxis(), scatterPlot.getXAxisLabelFont(), scatterPlot.getXAxisLabelColor(), scatterPlot.getXAxisTickLabelFont(), scatterPlot.getXAxisTickLabelColor(), scatterPlot.getXAxisTickLabelMask(), scatterPlot.getXAxisVerticalTickLabels(), scatterPlot.getOwnXAxisLineColor(), this.getDomainAxisSettings(), (Comparable)this.evaluateExpression(scatterPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(scatterPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)jfreeChart.getXYPlot().getRangeAxis(), scatterPlot.getYAxisLabelFont(), scatterPlot.getYAxisLabelColor(), scatterPlot.getYAxisTickLabelFont(), scatterPlot.getYAxisTickLabelColor(), scatterPlot.getYAxisTickLabelMask(), scatterPlot.getYAxisVerticalTickLabels(), scatterPlot.getOwnYAxisLineColor(), this.getRangeAxisSettings(), (Comparable)this.evaluateExpression(scatterPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(scatterPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createStackedBar3DChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createStackedBarChart3D((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getValueAxisLabelExpression())), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientationValue().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRBar3DPlot bar3DPlot = (JRBar3DPlot)this.getPlot();
        StackedBarRenderer3D stackedBarRenderer3D = new StackedBarRenderer3D(bar3DPlot.getXOffsetDouble() == null ? 12.0 : bar3DPlot.getXOffsetDouble(), bar3DPlot.getYOffsetDouble() == null ? 8.0 : bar3DPlot.getYOffsetDouble());
        stackedBarRenderer3D.setBaseItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
        stackedBarRenderer3D.setBaseItemLabelsVisible(bar3DPlot.getShowLabels());
        categoryPlot.setRenderer((CategoryItemRenderer)stackedBarRenderer3D);
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), bar3DPlot.getCategoryAxisLabelFont(), bar3DPlot.getCategoryAxisLabelColor(), bar3DPlot.getCategoryAxisTickLabelFont(), bar3DPlot.getCategoryAxisTickLabelColor(), bar3DPlot.getCategoryAxisTickLabelMask(), bar3DPlot.getCategoryAxisVerticalTickLabels(), bar3DPlot.getOwnCategoryAxisLineColor(), this.getDomainAxisSettings(), (Comparable)this.evaluateExpression(bar3DPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(bar3DPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), bar3DPlot.getValueAxisLabelFont(), bar3DPlot.getValueAxisLabelColor(), bar3DPlot.getValueAxisTickLabelFont(), bar3DPlot.getValueAxisTickLabelColor(), bar3DPlot.getValueAxisTickLabelMask(), bar3DPlot.getValueAxisVerticalTickLabels(), bar3DPlot.getOwnValueAxisLineColor(), this.getRangeAxisSettings(), (Comparable)this.evaluateExpression(bar3DPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(bar3DPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createStackedBarChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createStackedBarChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression())), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientationValue().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRBarPlot barPlot = (JRBarPlot)this.getPlot();
        boolean isShowTickMarks = barPlot.getShowTickMarks() == null ? true : barPlot.getShowTickMarks();
        boolean isShowTickLabels = barPlot.getShowTickLabels() == null ? true : barPlot.getShowTickLabels();
        boolean isShowLabels = barPlot.getShowLabels() == null ? false : barPlot.getShowLabels();
        categoryPlot.getDomainAxis().setTickMarksVisible(isShowTickMarks);
        categoryPlot.getDomainAxis().setTickLabelsVisible(isShowTickLabels);
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(isShowTickMarks);
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(isShowTickLabels);
        BarRenderer categoryRenderer = (BarRenderer)categoryPlot.getRenderer();
        categoryRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
        categoryRenderer.setBaseItemLabelsVisible(isShowLabels);
        categoryRenderer.setShadowVisible(false);
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getCategoryAxisVerticalTickLabels(), barPlot.getOwnCategoryAxisLineColor(), this.getDomainAxisSettings(), (Comparable)this.evaluateExpression(barPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(barPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getValueAxisVerticalTickLabels(), barPlot.getOwnValueAxisLineColor(), this.getRangeAxisSettings(), (Comparable)this.evaluateExpression(barPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(barPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createStackedAreaChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createStackedAreaChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression())), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientationValue().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        JRAreaPlot areaPlot = (JRAreaPlot)this.getPlot();
        this.configureAxis((Axis)((CategoryPlot)jfreeChart.getPlot()).getDomainAxis(), areaPlot.getCategoryAxisLabelFont(), areaPlot.getCategoryAxisLabelColor(), areaPlot.getCategoryAxisTickLabelFont(), areaPlot.getCategoryAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getCategoryAxisVerticalTickLabels(), areaPlot.getOwnCategoryAxisLineColor(), this.getDomainAxisSettings(), (Comparable)this.evaluateExpression(areaPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(areaPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)((CategoryPlot)jfreeChart.getPlot()).getRangeAxis(), areaPlot.getValueAxisLabelFont(), areaPlot.getValueAxisLabelColor(), areaPlot.getValueAxisTickLabelFont(), areaPlot.getValueAxisTickLabelColor(), areaPlot.getValueAxisTickLabelMask(), areaPlot.getValueAxisVerticalTickLabels(), areaPlot.getOwnValueAxisLineColor(), this.getRangeAxisSettings(), (Comparable)this.evaluateExpression(areaPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(areaPlot.getRangeAxisMaxValueExpression()));
        ((CategoryPlot)jfreeChart.getPlot()).getDomainAxis().setCategoryMargin(0.0);
        return jfreeChart;
    }

    protected JFreeChart createXyAreaChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createXYAreaChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression())), (XYDataset)((XYDataset)this.getDataset()), (PlotOrientation)this.getPlot().getOrientationValue().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        JRAreaPlot areaPlot = (JRAreaPlot)this.getPlot();
        this.configureAxis((Axis)jfreeChart.getXYPlot().getDomainAxis(), areaPlot.getCategoryAxisLabelFont(), areaPlot.getCategoryAxisLabelColor(), areaPlot.getCategoryAxisTickLabelFont(), areaPlot.getCategoryAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getCategoryAxisVerticalTickLabels(), areaPlot.getOwnCategoryAxisLineColor(), this.getDomainAxisSettings(), (Comparable)this.evaluateExpression(areaPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(areaPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)jfreeChart.getXYPlot().getRangeAxis(), areaPlot.getValueAxisLabelFont(), areaPlot.getValueAxisLabelColor(), areaPlot.getValueAxisTickLabelFont(), areaPlot.getValueAxisTickLabelColor(), areaPlot.getValueAxisTickLabelMask(), areaPlot.getValueAxisVerticalTickLabels(), areaPlot.getOwnValueAxisLineColor(), this.getRangeAxisSettings(), (Comparable)this.evaluateExpression(areaPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(areaPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createXYBarChart() throws JRException {
        IntervalXYDataset tmpDataset = (IntervalXYDataset)this.getDataset();
        boolean isDate = true;
        if (this.getChart().getDataset().getDatasetType() == 3) {
            isDate = false;
        }
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createXYBarChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression())), (boolean)isDate, (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression())), (IntervalXYDataset)tmpDataset, (PlotOrientation)this.getPlot().getOrientationValue().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        XYBarRenderer itemRenderer = (XYBarRenderer)xyPlot.getRenderer();
        itemRenderer.setBaseItemLabelGenerator((XYItemLabelGenerator)this.getLabelGenerator());
        itemRenderer.setShadowVisible(false);
        JRBarPlot barPlot = (JRBarPlot)this.getPlot();
        boolean isShowLabels = barPlot.getShowLabels() == null ? false : barPlot.getShowLabels();
        itemRenderer.setBaseItemLabelsVisible(isShowLabels);
        this.configureAxis((Axis)xyPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getCategoryAxisVerticalTickLabels(), barPlot.getOwnCategoryAxisLineColor(), this.getDomainAxisSettings(), 2, (Comparable)this.evaluateExpression(barPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(barPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)xyPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getValueAxisVerticalTickLabels(), barPlot.getOwnValueAxisLineColor(), this.getRangeAxisSettings(), 2, (Comparable)this.evaluateExpression(barPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(barPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createXyLineChart() throws JRException {
        JRLinePlot linePlot = (JRLinePlot)this.getPlot();
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createXYLineChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(linePlot.getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(linePlot.getValueAxisLabelExpression())), (XYDataset)((XYDataset)this.getDataset()), (PlotOrientation)linePlot.getOrientationValue().getOrientation(), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        this.configureAxis((Axis)jfreeChart.getXYPlot().getDomainAxis(), linePlot.getCategoryAxisLabelFont(), linePlot.getCategoryAxisLabelColor(), linePlot.getCategoryAxisTickLabelFont(), linePlot.getCategoryAxisTickLabelColor(), linePlot.getCategoryAxisTickLabelMask(), linePlot.getCategoryAxisVerticalTickLabels(), linePlot.getOwnCategoryAxisLineColor(), this.getDomainAxisSettings(), (Comparable)this.evaluateExpression(linePlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(linePlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)jfreeChart.getXYPlot().getRangeAxis(), linePlot.getValueAxisLabelFont(), linePlot.getValueAxisLabelColor(), linePlot.getValueAxisTickLabelFont(), linePlot.getValueAxisTickLabelColor(), linePlot.getValueAxisTickLabelMask(), linePlot.getValueAxisVerticalTickLabels(), linePlot.getOwnValueAxisLineColor(), this.getRangeAxisSettings(), (Comparable)this.evaluateExpression(linePlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(linePlot.getRangeAxisMaxValueExpression()));
        XYLineAndShapeRenderer lineRenderer = (XYLineAndShapeRenderer)jfreeChart.getXYPlot().getRenderer();
        boolean isShowShapes = linePlot.getShowShapes() == null ? true : linePlot.getShowShapes();
        boolean isShowLines = linePlot.getShowLines() == null ? true : linePlot.getShowLines();
        lineRenderer.setBaseShapesVisible(isShowShapes);
        lineRenderer.setBaseLinesVisible(isShowLines);
        return jfreeChart;
    }

    protected JFreeChart createTimeSeriesChart() throws JRException {
        String timeAxisLabel = (String)this.evaluateExpression(((JRTimeSeriesPlot)this.getPlot()).getTimeAxisLabelExpression());
        String valueAxisLabel = (String)this.evaluateExpression(((JRTimeSeriesPlot)this.getPlot()).getValueAxisLabelExpression());
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createTimeSeriesChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)timeAxisLabel, (String)valueAxisLabel, (XYDataset)((TimeSeriesCollection)this.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        JRTimeSeriesPlot timeSeriesPlot = (JRTimeSeriesPlot)this.getPlot();
        XYLineAndShapeRenderer lineRenderer = (XYLineAndShapeRenderer)xyPlot.getRenderer();
        boolean isShowShapes = timeSeriesPlot.getShowShapes() == null ? true : timeSeriesPlot.getShowShapes();
        boolean isShowLines = timeSeriesPlot.getShowLines() == null ? true : timeSeriesPlot.getShowLines();
        lineRenderer.setBaseLinesVisible(isShowLines);
        lineRenderer.setBaseShapesVisible(isShowShapes);
        this.configureAxis((Axis)xyPlot.getDomainAxis(), timeSeriesPlot.getTimeAxisLabelFont(), timeSeriesPlot.getTimeAxisLabelColor(), timeSeriesPlot.getTimeAxisTickLabelFont(), timeSeriesPlot.getTimeAxisTickLabelColor(), timeSeriesPlot.getTimeAxisTickLabelMask(), timeSeriesPlot.getTimeAxisVerticalTickLabels(), timeSeriesPlot.getOwnTimeAxisLineColor(), this.getDomainAxisSettings(), 2, (Comparable)this.evaluateExpression(timeSeriesPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(timeSeriesPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)xyPlot.getRangeAxis(), timeSeriesPlot.getValueAxisLabelFont(), timeSeriesPlot.getValueAxisLabelColor(), timeSeriesPlot.getValueAxisTickLabelFont(), timeSeriesPlot.getValueAxisTickLabelColor(), timeSeriesPlot.getValueAxisTickLabelMask(), timeSeriesPlot.getValueAxisVerticalTickLabels(), timeSeriesPlot.getOwnValueAxisLineColor(), this.getRangeAxisSettings(), 2, (Comparable)this.evaluateExpression(timeSeriesPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(timeSeriesPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createGanttChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createGanttChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression())), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression())), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression())), (IntervalCategoryDataset)((GanttCategoryDataset)this.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRBarPlot barPlot = (JRBarPlot)this.getPlot();
        boolean isShowTickMarks = barPlot.getShowTickMarks() == null ? true : barPlot.getShowTickMarks();
        boolean isShowTickLabels = barPlot.getShowTickLabels() == null ? true : barPlot.getShowTickLabels();
        boolean isShowLabels = barPlot.getShowLabels() == null ? false : barPlot.getShowLabels();
        categoryPlot.getDomainAxis().setTickMarksVisible(isShowTickMarks);
        categoryPlot.getDomainAxis().setTickLabelsVisible(isShowTickLabels);
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getCategoryAxisVerticalTickLabels(), barPlot.getOwnCategoryAxisLineColor(), this.getDomainAxisSettings(), (Comparable)this.evaluateExpression(barPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(barPlot.getDomainAxisMaxValueExpression()));
        ((DateAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(isShowTickMarks);
        ((DateAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(isShowTickLabels);
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getValueAxisVerticalTickLabels(), barPlot.getOwnValueAxisLineColor(), this.getRangeAxisSettings(), (Comparable)this.evaluateExpression(barPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(barPlot.getRangeAxisMaxValueExpression()));
        BarRenderer categoryRenderer = (BarRenderer)categoryPlot.getRenderer();
        categoryRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
        categoryRenderer.setBaseItemLabelsVisible(isShowLabels);
        categoryRenderer.setShadowVisible(false);
        return jfreeChart;
    }

    protected Range convertRange(JRDataRange dataRange) throws JRException {
        if (dataRange == null) {
            return null;
        }
        Number low = (Number)this.evaluateExpression(dataRange.getLowExpression());
        Number high = (Number)this.evaluateExpression(dataRange.getHighExpression());
        return new Range(low != null ? low.doubleValue() : 0.0, high != null ? high.doubleValue() : 100.0);
    }

    protected MeterInterval convertInterval(JRMeterInterval interval) throws JRException {
        String label = interval.getLabel();
        if (label == null) {
            label = "";
        }
        Range range = this.convertRange(interval.getDataRange());
        Color color = interval.getBackgroundColor() != null ? interval.getBackgroundColor() : (Color)ChartThemesConstants.TRANSPARENT_PAINT;
        float[] components = color.getRGBColorComponents(null);
        float alpha = interval.getAlphaDouble() == null ? 1.0f : interval.getAlphaDouble().floatValue();
        Color alphaColor = new Color(components[0], components[1], components[2], alpha);
        return new MeterInterval(label, range, (Paint)alphaColor, null, (Paint)alphaColor);
    }

    protected JFreeChart createMeterChart() throws JRException {
        List intervals;
        MeterShapeEnum shape;
        JRMeterPlot jrPlot = (JRMeterPlot)this.getPlot();
        MeterPlot chartPlot = new MeterPlot((ValueDataset)this.getDataset());
        MeterShapeEnum meterShapeEnum = shape = jrPlot.getShapeValue() == null ? MeterShapeEnum.PIE : jrPlot.getShapeValue();
        if (shape == MeterShapeEnum.CHORD) {
            chartPlot.setDialShape(DialShape.CHORD);
        } else if (shape == MeterShapeEnum.CIRCLE) {
            chartPlot.setDialShape(DialShape.CIRCLE);
        } else {
            if (shape == MeterShapeEnum.DIAL) {
                return this.createDialChart();
            }
            chartPlot.setDialShape(DialShape.PIE);
        }
        chartPlot.setRange(this.convertRange(jrPlot.getDataRange()));
        int meterAngle = jrPlot.getMeterAngleInteger() == null ? 180 : jrPlot.getMeterAngleInteger();
        chartPlot.setMeterAngle(meterAngle);
        String units = jrPlot.getUnits();
        if (units != null && units.length() > 0) {
            chartPlot.setUnits(units);
        }
        double tickInterval = jrPlot.getTickIntervalDouble() == null ? 10.0 : jrPlot.getTickIntervalDouble();
        chartPlot.setTickSize(tickInterval);
        Color color = jrPlot.getMeterBackgroundColor();
        if (color != null) {
            chartPlot.setDialBackgroundPaint((Paint)color);
        }
        if ((color = jrPlot.getNeedleColor()) != null) {
            chartPlot.setNeedlePaint((Paint)color);
        }
        JRBaseFont font = new JRBaseFont();
        FontUtil.copyNonNullOwnProperties((JRFont)this.getPlotSettings().getTickLabelFont(), (JRFont)font);
        FontUtil.copyNonNullOwnProperties((JRFont)jrPlot.getTickLabelFont(), (JRFont)font);
        font = new JRBaseFont((JRStyleContainer)this.getChart(), (JRFont)font);
        chartPlot.setTickLabelFont(this.getFontUtil().getAwtFont((JRFont)font, this.getLocale()));
        JRValueDisplay display = jrPlot.getValueDisplay();
        if (display != null) {
            if (display.getColor() != null) {
                chartPlot.setValuePaint((Paint)display.getColor());
            }
            if (display.getMask() != null) {
                chartPlot.setTickLabelFormat((NumberFormat)new DecimalFormat(display.getMask()));
            }
            font = new JRBaseFont();
            FontUtil.copyNonNullOwnProperties((JRFont)this.getPlotSettings().getDisplayFont(), (JRFont)font);
            FontUtil.copyNonNullOwnProperties((JRFont)jrPlot.getValueDisplay().getFont(), (JRFont)font);
            font = new JRBaseFont((JRStyleContainer)this.getChart(), (JRFont)font);
            chartPlot.setValueFont(this.getFontUtil().getAwtFont((JRFont)font, this.getLocale()));
        }
        if ((color = jrPlot.getTickColor()) != null) {
            chartPlot.setTickPaint((Paint)color);
        }
        if ((intervals = jrPlot.getIntervals()) != null) {
            for (JRMeterInterval interval : intervals) {
                if (interval == null) continue;
                chartPlot.addInterval(this.convertInterval(interval));
            }
        }
        JFreeChart jfreeChart = new JFreeChart((String)this.evaluateExpression(this.getChart().getTitleExpression()), null, (Plot)chartPlot, this.isShowLegend());
        this.configureChart(jfreeChart, this.getPlot());
        return jfreeChart;
    }

    protected JFreeChart createThermometerChart() throws JRException {
        JRValueDisplay display;
        JRThermometerPlot jrPlot = (JRThermometerPlot)this.getPlot();
        ThermometerPlot chartPlot = new ThermometerPlot((ValueDataset)this.getDataset());
        Range range = this.convertRange(jrPlot.getDataRange());
        chartPlot.setLowerBound(range.getLowerBound());
        chartPlot.setUpperBound(range.getUpperBound());
        chartPlot.setUnits(0);
        Color color = jrPlot.getMercuryColor();
        if (color != null) {
            chartPlot.setMercuryPaint((Paint)color);
            chartPlot.setUseSubrangePaint(false);
        }
        if ((display = jrPlot.getValueDisplay()) != null) {
            if (display.getColor() != null) {
                chartPlot.setValuePaint((Paint)display.getColor());
            }
            if (display.getMask() != null) {
                chartPlot.setValueFormat((NumberFormat)new DecimalFormat(display.getMask()));
            }
            if (display.getFont() != null) {
                // empty if block
            }
        }
        ValueLocationEnum valueLocation = jrPlot.getValueLocationValue();
        switch (valueLocation) {
            case NONE: {
                chartPlot.setValueLocation(0);
                break;
            }
            case LEFT: {
                chartPlot.setValueLocation(2);
                break;
            }
            case RIGHT: {
                chartPlot.setValueLocation(1);
                break;
            }
            default: {
                chartPlot.setValueLocation(3);
            }
        }
        range = this.convertRange(jrPlot.getLowRange());
        if (range != null) {
            chartPlot.setSubrangeInfo(2, range.getLowerBound(), range.getUpperBound());
        }
        if ((range = this.convertRange(jrPlot.getMediumRange())) != null) {
            chartPlot.setSubrangeInfo(1, range.getLowerBound(), range.getUpperBound());
        }
        if ((range = this.convertRange(jrPlot.getHighRange())) != null) {
            chartPlot.setSubrangeInfo(0, range.getLowerBound(), range.getUpperBound());
        }
        JFreeChart jfreeChart = new JFreeChart((Plot)chartPlot);
        this.configureChart(jfreeChart, this.getPlot());
        return jfreeChart;
    }

    protected JFreeChart createDialChart() throws JRException {
        String label;
        JRValueDisplay display;
        String displayVisibility;
        JRMeterPlot jrPlot = (JRMeterPlot)this.getPlot();
        DialPlot dialPlot = new DialPlot();
        dialPlot.setDataset((ValueDataset)this.getDataset());
        StandardDialFrame dialFrame = new StandardDialFrame();
        dialPlot.setDialFrame((DialFrame)dialFrame);
        DialBackground db = new DialBackground((Paint)jrPlot.getBackcolor());
        dialPlot.setBackground((DialLayer)db);
        Range range = this.convertRange(jrPlot.getDataRange());
        int tickCount = jrPlot.getTickCount() != null && jrPlot.getTickCount() > 1 ? jrPlot.getTickCount() : 7;
        StandardDialScale scale = new StandardDialScale(range.getLowerBound(), range.getUpperBound(), 225.0, -270.0, (range.getUpperBound() - range.getLowerBound()) / (double)(tickCount - 1), 15);
        scale.setTickRadius(0.9);
        scale.setTickLabelOffset(0.16);
        JRBaseFont font = new JRBaseFont();
        FontUtil.copyNonNullOwnProperties((JRFont)this.getPlotSettings().getTickLabelFont(), (JRFont)font);
        FontUtil.copyNonNullOwnProperties((JRFont)jrPlot.getTickLabelFont(), (JRFont)font);
        font = new JRBaseFont((JRStyleContainer)this.getChart(), (JRFont)font);
        scale.setTickLabelFont(this.getFontUtil().getAwtFont((JRFont)font, this.getLocale()));
        scale.setMajorTickStroke((Stroke)new BasicStroke(1.0f));
        scale.setMinorTickStroke((Stroke)new BasicStroke(0.3f));
        scale.setMajorTickPaint((Paint)jrPlot.getTickColor());
        scale.setMinorTickPaint((Paint)jrPlot.getTickColor());
        scale.setTickLabelsVisible(true);
        scale.setFirstTickLabelVisible(true);
        dialPlot.addScale(0, (DialScale)scale);
        List intervals = jrPlot.getIntervals();
        if (intervals != null && intervals.size() > 0) {
            int size = Math.min(3, intervals.size());
            int colorStep = 0;
            if (size > 0) {
                colorStep = 255 / size;
            }
            for (int i = 0; i < size; ++i) {
                JRMeterInterval interval = (JRMeterInterval)intervals.get(i);
                Range intervalRange = this.convertRange(interval.getDataRange());
                Color color = new Color(255 - colorStep * i, 0 + colorStep * i, 0);
                StandardDialRange dialRange = new StandardDialRange(intervalRange.getLowerBound(), intervalRange.getUpperBound(), (Paint)(interval.getBackgroundColor() == null ? color : interval.getBackgroundColor()));
                dialRange.setInnerRadius(0.41);
                dialRange.setOuterRadius(0.41);
                dialPlot.addLayer((DialLayer)dialRange);
            }
        }
        String string = displayVisibility = (display = jrPlot.getValueDisplay()) != null && this.getChart().hasProperties() ? this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.dial.value.display.visible") : "false";
        if (Boolean.parseBoolean(displayVisibility)) {
            String pattern;
            DialValueIndicator dvi = new DialValueIndicator(0);
            dvi.setBackgroundPaint(ChartThemesConstants.TRANSPARENT_PAINT);
            dvi.setOutlinePaint(ChartThemesConstants.TRANSPARENT_PAINT);
            dvi.setPaint((Paint)Color.WHITE);
            String string2 = pattern = display.getMask() != null ? display.getMask() : "#,##0.####";
            if (pattern != null) {
                dvi.setNumberFormat((NumberFormat)new DecimalFormat(pattern));
            }
            dvi.setRadius(0.15);
            dvi.setValueAnchor(RectangleAnchor.CENTER);
            dvi.setTextAnchor(TextAnchor.CENTER);
            dialPlot.addLayer((DialLayer)dvi);
        }
        String string3 = label = this.getChart().hasProperties() ? this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.dial.label") : null;
        if (label != null) {
            JRBaseFont displayFont = new JRBaseFont();
            FontUtil.copyNonNullOwnProperties((JRFont)this.getPlotSettings().getDisplayFont(), (JRFont)displayFont);
            FontUtil.copyNonNullOwnProperties((JRFont)jrPlot.getValueDisplay().getFont(), (JRFont)displayFont);
            displayFont = new JRBaseFont((JRStyleContainer)this.getChart(), (JRFont)displayFont);
            Font themeDisplayFont = this.getFontUtil().getAwtFont((JRFont)displayFont, this.getLocale());
            String[] textLines = label.split("\\n");
            for (int i = 0; i < textLines.length; ++i) {
                DialTextAnnotation dialAnnotation = new DialTextAnnotation(textLines[i]);
                dialAnnotation.setFont(themeDisplayFont);
                dialAnnotation.setPaint((Paint)jrPlot.getValueDisplay().getColor());
                dialAnnotation.setRadius(Math.sin(0.7853981633974483) + (double)i / 10.0);
                dialAnnotation.setAnchor(TextAnchor.CENTER);
                dialPlot.addLayer((DialLayer)dialAnnotation);
            }
        }
        DialPointer.Pointer needle = new DialPointer.Pointer();
        needle.setVisible(true);
        needle.setRadius(0.91);
        dialPlot.addLayer((DialLayer)needle);
        DialCap cap = new DialCap();
        cap.setRadius(0.05);
        cap.setFillPaint((Paint)Color.DARK_GRAY);
        cap.setOutlinePaint((Paint)Color.GRAY);
        cap.setOutlineStroke((Stroke)new BasicStroke(0.5f));
        dialPlot.setCap((DialLayer)cap);
        JFreeChart jfreeChart = new JFreeChart((String)this.evaluateExpression(this.getChart().getTitleExpression()), null, (Plot)dialPlot, this.isShowLegend());
        this.configureChart(jfreeChart, this.getPlot());
        return jfreeChart;
    }

    private static RectangleEdge getEdge(EdgeEnum position, RectangleEdge defaultPosition) {
        RectangleEdge edge = defaultPosition;
        if (position != null) {
            switch (position) {
                case TOP: {
                    edge = RectangleEdge.TOP;
                    break;
                }
                case BOTTOM: {
                    edge = RectangleEdge.BOTTOM;
                    break;
                }
                case LEFT: {
                    edge = RectangleEdge.LEFT;
                    break;
                }
                case RIGHT: {
                    edge = RectangleEdge.RIGHT;
                }
            }
        }
        return edge;
    }

    protected void populateSeriesColors(Paint[] colors, Paint[] colorSequence) {
        if (colors != null) {
            int size = colorSequence != null ? colorSequence.length : 0;
            System.arraycopy(colorSequence, 0, colors, 0, colorSequence.length);
            System.arraycopy(DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE, 0, colors, size, DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE.length);
        }
    }

    protected void setChartBackground(JFreeChart jfreeChart) {
        Paint backgroundPaint;
        Paint paint = backgroundPaint = this.getChartSettings().getBackgroundPaint() == null ? null : this.getChartSettings().getBackgroundPaint().getPaint();
        if (this.getChart().getOwnModeValue() != null) {
            if (this.getChart().getOwnModeValue() == ModeEnum.OPAQUE) {
                if (this.getChart().getOwnBackcolor() != null || backgroundPaint == null) {
                    backgroundPaint = this.getChart().getBackcolor();
                }
            } else {
                backgroundPaint = ChartThemesConstants.TRANSPARENT_PAINT;
            }
        }
        if (backgroundPaint != null) {
            GradientPaint gp;
            GradientPaint gradientPaint = gp = backgroundPaint instanceof GradientPaint ? (GradientPaint)backgroundPaint : null;
            if (gp != null) {
                backgroundPaint = new GradientPaint(0.0f, 0.0f, gp.getColor1(), 0.0f, (float)this.getChart().getHeight() * 0.7f, gp.getColor2(), false);
            }
            jfreeChart.setBackgroundPaint(backgroundPaint);
        }
        this.setChartBackgroundImage(jfreeChart);
    }

    protected void setChartBackgroundImage(JFreeChart jfreeChart) {
        Image backgroundImage;
        ChartSettings chartSettings = this.getChartSettings();
        Image image = backgroundImage = chartSettings.getBackgroundImage() == null ? null : chartSettings.getBackgroundImage().getImage();
        if (backgroundImage != null) {
            Float backgroundImageAlpha;
            jfreeChart.setBackgroundImage(backgroundImage);
            Integer backgroundImageAlignment = chartSettings.getBackgroundImageAlignment();
            if (backgroundImageAlignment != null) {
                jfreeChart.setBackgroundImageAlignment(backgroundImageAlignment.intValue());
            }
            if ((backgroundImageAlpha = chartSettings.getBackgroundImageAlpha()) != null) {
                jfreeChart.setBackgroundImageAlpha(backgroundImageAlpha.floatValue());
            }
        }
    }

    protected void setChartTitle(JFreeChart jfreeChart) {
        TitleSettings titleSettings = this.getTitleSettings();
        Boolean showTitle = titleSettings.getShowTitle();
        if (showTitle == null || showTitle.booleanValue()) {
            TextTitle title = jfreeChart.getTitle();
            if (title != null) {
                Paint forePaint = this.getChart().getOwnTitleColor();
                if (forePaint == null && titleSettings.getForegroundPaint() != null) {
                    forePaint = titleSettings.getForegroundPaint().getPaint();
                }
                if (forePaint == null) {
                    forePaint = this.getChart().getTitleColor();
                }
                RectangleEdge titleEdge = SimpleChartTheme.getEdge(this.getChart().getTitlePositionValue(), SimpleChartTheme.getEdge(titleSettings.getPositionValue(), RectangleEdge.TOP));
                this.handleTitleSettings(title, titleSettings, this.getChart().getTitleFont(), forePaint, titleEdge);
            }
        } else {
            jfreeChart.setTitle((TextTitle)null);
        }
    }

    protected void setChartSubtitles(JFreeChart jfreeChart) throws JRException {
        String subtitleText;
        TitleSettings subtitleSettings = this.getSubtitleSettings();
        Boolean subtitleVisibility = subtitleSettings.getShowTitle();
        if ((subtitleVisibility == null || subtitleVisibility.booleanValue()) && (subtitleText = (String)this.evaluateExpression(this.getChart().getSubtitleExpression())) != null) {
            TextTitle subtitle = new TextTitle(subtitleText);
            Color subtitleForecolor = this.getChart().getOwnSubtitleColor() != null ? this.getChart().getOwnSubtitleColor() : (subtitleSettings.getForegroundPaint() != null ? subtitleSettings.getForegroundPaint().getPaint() : this.getChart().getSubtitleColor());
            RectangleEdge subtitleEdge = SimpleChartTheme.getEdge(subtitleSettings.getPositionValue(), jfreeChart.getTitle() == null ? null : jfreeChart.getTitle().getPosition());
            this.handleTitleSettings(subtitle, subtitleSettings, this.getChart().getSubtitleFont(), subtitleForecolor, subtitleEdge);
            jfreeChart.addSubtitle((Title)subtitle);
        }
    }

    protected void setChartLegend(JFreeChart jfreeChart) {
        LegendTitle legend = jfreeChart.getLegend();
        if (legend != null) {
            RectangleInsets padding;
            VerticalAlignment vAlign;
            HorizontalAlignment hAlign;
            BlockFrame blockFrame;
            Paint backPaint;
            LegendSettings legendSettings = this.getLegendSettings();
            JRBaseFont font = new JRBaseFont();
            FontUtil.copyNonNullOwnProperties((JRFont)legendSettings.getFont(), (JRFont)font);
            FontUtil.copyNonNullOwnProperties((JRFont)this.getChart().getLegendFont(), (JRFont)font);
            font = new JRBaseFont((JRStyleContainer)this.getChart(), (JRFont)font);
            legend.setItemFont(this.getFontUtil().getAwtFont((JRFont)font, this.getLocale()));
            Paint forePaint = this.getChart().getOwnLegendColor();
            if (forePaint == null && legendSettings.getForegroundPaint() != null) {
                forePaint = legendSettings.getForegroundPaint().getPaint();
            }
            if (forePaint == null) {
                forePaint = this.getChart().getLegendColor();
            }
            if (forePaint != null) {
                legend.setItemPaint(forePaint);
            }
            if ((backPaint = this.getChart().getOwnLegendBackgroundColor()) == null && legendSettings.getBackgroundPaint() != null) {
                backPaint = legendSettings.getBackgroundPaint().getPaint();
            }
            if (backPaint == null) {
                backPaint = this.getChart().getLegendBackgroundColor();
            }
            if (backPaint != null) {
                legend.setBackgroundPaint(backPaint);
            }
            if ((blockFrame = legendSettings.getBlockFrame()) != null) {
                legend.setFrame(blockFrame);
            }
            if ((hAlign = legendSettings.getHorizontalAlignment()) != null) {
                legend.setHorizontalAlignment(hAlign);
            }
            if ((vAlign = legendSettings.getVerticalAlignment()) != null) {
                legend.setVerticalAlignment(vAlign);
            }
            if ((padding = legendSettings.getPadding()) != null) {
                legend.setPadding(padding);
            }
            legend.setPosition(SimpleChartTheme.getEdge(this.getChart().getLegendPositionValue(), SimpleChartTheme.getEdge(legendSettings.getPositionValue(), RectangleEdge.BOTTOM)));
        }
    }

    protected void setChartBorder(JFreeChart jfreeChart) {
        ChartSettings chartSettings = this.getChartSettings();
        JRLineBox lineBox = this.getChart().getLineBox();
        if (lineBox.getLeftPen().getLineWidth().floatValue() == 0.0f && lineBox.getBottomPen().getLineWidth().floatValue() == 0.0f && lineBox.getRightPen().getLineWidth().floatValue() == 0.0f && lineBox.getTopPen().getLineWidth().floatValue() == 0.0f) {
            boolean isVisible;
            boolean bl = isVisible = chartSettings.getBorderVisible() == null ? true : chartSettings.getBorderVisible();
            if (isVisible) {
                Paint paint;
                Stroke stroke = chartSettings.getBorderStroke();
                if (stroke != null) {
                    jfreeChart.setBorderStroke(stroke);
                }
                Paint paint2 = paint = chartSettings.getBorderPaint() == null ? null : chartSettings.getBorderPaint().getPaint();
                if (paint != null) {
                    jfreeChart.setBorderPaint(paint);
                }
            }
            jfreeChart.setBorderVisible(isVisible);
        }
    }

    protected void setPlotBackground(Plot plot, JRChartPlot jrPlot) {
        Image backgroundImage;
        Float foregroundAlpha;
        PlotSettings plotSettings = this.getPlotSettings();
        Paint backgroundPaint = jrPlot.getOwnBackcolor();
        if (backgroundPaint == null && plotSettings.getBackgroundPaint() != null) {
            backgroundPaint = plotSettings.getBackgroundPaint().getPaint();
        }
        if (backgroundPaint == null) {
            backgroundPaint = ChartThemesConstants.TRANSPARENT_PAINT;
        }
        plot.setBackgroundPaint(backgroundPaint);
        Float backgroundAlpha = jrPlot.getBackgroundAlphaFloat();
        if (backgroundAlpha == null) {
            backgroundAlpha = plotSettings.getBackgroundAlpha();
        }
        if (backgroundAlpha != null) {
            plot.setBackgroundAlpha(backgroundAlpha.floatValue());
        }
        if ((foregroundAlpha = jrPlot.getForegroundAlphaFloat()) == null) {
            foregroundAlpha = plotSettings.getForegroundAlpha();
        }
        if (foregroundAlpha != null) {
            plot.setForegroundAlpha(foregroundAlpha.floatValue());
        }
        Image image = backgroundImage = plotSettings.getBackgroundImage() == null ? null : plotSettings.getBackgroundImage().getImage();
        if (backgroundImage != null) {
            Float backgroundImageAlpha;
            plot.setBackgroundImage(backgroundImage);
            Integer backgroundImageAlignment = plotSettings.getBackgroundImageAlignment();
            if (backgroundImageAlignment != null) {
                plot.setBackgroundImageAlignment(backgroundImageAlignment.intValue());
            }
            if ((backgroundImageAlpha = plotSettings.getBackgroundImageAlpha()) != null) {
                plot.setBackgroundImageAlpha(backgroundImageAlpha.floatValue());
            }
        }
    }

    protected void handleCategoryPlotSettings(CategoryPlot p, JRChartPlot jrPlot) {
        Boolean rangeGridlineVisible;
        Boolean domainGridlineVisible;
        Stroke[] outlineStrokeSequence;
        Stroke[] strokeSequence;
        Paint[] outlinePaintSequence;
        PlotOrientation plotOrientation;
        boolean hasRotation;
        PlotSettings plotSettings = this.getPlotSettings();
        Double themeLabelRotation = plotSettings.getLabelRotation();
        CategoryAxis axis = p.getDomainAxis();
        boolean bl = hasRotation = jrPlot.getLabelRotationDouble() != null || themeLabelRotation != null;
        if (hasRotation) {
            double labelRotation;
            double d = labelRotation = jrPlot.getLabelRotationDouble() != null ? jrPlot.getLabelRotationDouble().doubleValue() : themeLabelRotation.doubleValue();
            if (labelRotation == 90.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_90);
            } else if (labelRotation == -90.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            } else if (labelRotation < 0.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)(-labelRotation / 180.0 * Math.PI)));
            } else if (labelRotation > 0.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.createDownRotationLabelPositions((double)(labelRotation / 180.0 * Math.PI)));
            }
        }
        PlotOrientation plotOrientation2 = plotOrientation = jrPlot.getOrientationValue() != null ? jrPlot.getOrientationValue().getOrientation() : plotSettings.getOrientation();
        if (plotOrientation != null) {
            p.setOrientation(plotOrientation);
        }
        CategoryItemRenderer categoryRenderer = p.getRenderer();
        Paint[] paintSequence = this.getPaintSequence(plotSettings, jrPlot);
        if (paintSequence != null) {
            for (int i = 0; i < paintSequence.length; ++i) {
                categoryRenderer.setSeriesPaint(i, paintSequence[i]);
            }
        }
        if ((outlinePaintSequence = this.getOutlinePaintSequence(plotSettings)) != null) {
            for (int i = 0; i < outlinePaintSequence.length; ++i) {
                categoryRenderer.setSeriesOutlinePaint(i, outlinePaintSequence[i]);
            }
        }
        if ((strokeSequence = this.getStrokeSequence(plotSettings)) != null) {
            for (int i = 0; i < strokeSequence.length; ++i) {
                categoryRenderer.setSeriesStroke(i, strokeSequence[i]);
            }
        }
        if ((outlineStrokeSequence = this.getOutlineStrokeSequence(plotSettings)) != null) {
            for (int i = 0; i < outlineStrokeSequence.length; ++i) {
                categoryRenderer.setSeriesOutlineStroke(i, outlineStrokeSequence[i]);
            }
        }
        if ((domainGridlineVisible = plotSettings.getDomainGridlineVisible()) == null || domainGridlineVisible.booleanValue()) {
            Stroke domainGridlineStroke;
            PaintProvider domainGridlinePaint = plotSettings.getDomainGridlinePaint();
            if (domainGridlinePaint != null) {
                p.setDomainGridlinePaint(domainGridlinePaint.getPaint());
            }
            if ((domainGridlineStroke = plotSettings.getDomainGridlineStroke()) != null) {
                p.setDomainGridlineStroke(domainGridlineStroke);
            }
        }
        if ((rangeGridlineVisible = plotSettings.getRangeGridlineVisible()) == null || rangeGridlineVisible.booleanValue()) {
            Stroke rangeGridlineStroke;
            PaintProvider rangeGridlinePaint = plotSettings.getRangeGridlinePaint();
            if (rangeGridlinePaint != null) {
                p.setRangeGridlinePaint(rangeGridlinePaint.getPaint());
            }
            if ((rangeGridlineStroke = plotSettings.getRangeGridlineStroke()) != null) {
                p.setRangeGridlineStroke(rangeGridlineStroke);
            }
        }
    }

    protected void handleXYPlotSettings(XYPlot p, JRChartPlot jrPlot) {
        Boolean rangeGridlineVisible;
        Boolean domainGridlineVisible;
        Stroke[] outlineStrokeSequence;
        Stroke[] strokeSequence;
        Paint[] outlinePaintSequence;
        PlotSettings plotSettings = this.getPlotSettings();
        XYItemRenderer xyItemRenderer = p.getRenderer();
        Paint[] paintSequence = this.getPaintSequence(plotSettings, jrPlot);
        if (paintSequence != null) {
            for (int i = 0; i < paintSequence.length; ++i) {
                xyItemRenderer.setSeriesPaint(i, paintSequence[i]);
            }
        }
        if ((outlinePaintSequence = this.getOutlinePaintSequence(plotSettings)) != null) {
            for (int i = 0; i < outlinePaintSequence.length; ++i) {
                xyItemRenderer.setSeriesOutlinePaint(i, outlinePaintSequence[i]);
            }
        }
        if ((strokeSequence = this.getStrokeSequence(plotSettings)) != null) {
            for (int i = 0; i < strokeSequence.length; ++i) {
                xyItemRenderer.setSeriesStroke(i, strokeSequence[i]);
            }
        }
        if ((outlineStrokeSequence = this.getOutlineStrokeSequence(plotSettings)) != null) {
            for (int i = 0; i < outlineStrokeSequence.length; ++i) {
                xyItemRenderer.setSeriesOutlineStroke(i, outlineStrokeSequence[i]);
            }
        }
        if ((domainGridlineVisible = plotSettings.getDomainGridlineVisible()) == null || domainGridlineVisible.booleanValue()) {
            Stroke domainGridlineStroke;
            PaintProvider domainGridlinePaint = plotSettings.getDomainGridlinePaint();
            if (domainGridlinePaint != null) {
                p.setDomainGridlinePaint(domainGridlinePaint.getPaint());
            }
            if ((domainGridlineStroke = plotSettings.getDomainGridlineStroke()) != null) {
                p.setDomainGridlineStroke(domainGridlineStroke);
            }
        }
        if ((rangeGridlineVisible = plotSettings.getRangeGridlineVisible()) == null || rangeGridlineVisible.booleanValue()) {
            Stroke rangeGridlineStroke;
            PaintProvider rangeGridlinePaint = plotSettings.getRangeGridlinePaint();
            if (rangeGridlinePaint != null) {
                p.setRangeGridlinePaint(rangeGridlinePaint.getPaint());
            }
            if ((rangeGridlineStroke = plotSettings.getRangeGridlineStroke()) != null) {
                p.setRangeGridlineStroke(rangeGridlineStroke);
            }
        }
    }

    protected void setPlotDrawingDefaults(Plot p, JRChartPlot jrPlot) {
        PlotSettings plotSettings = this.getPlotSettings();
        Paint[] paintSequence = this.getPaintSequence(plotSettings, jrPlot);
        Paint[] outlinePaintSequence = this.getOutlinePaintSequence(plotSettings);
        Stroke[] strokeSequence = this.getStrokeSequence(plotSettings);
        Stroke[] outlineStrokeSequence = this.getOutlineStrokeSequence(plotSettings);
        p.setDrawingSupplier((DrawingSupplier)new DefaultDrawingSupplier(paintSequence, outlinePaintSequence, strokeSequence, outlineStrokeSequence, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE));
    }

    protected void setAxisLine(Axis axis, Paint lineColor, AxisSettings axisSettings) {
        Boolean axisLineVisible = axisSettings.getLineVisible();
        if (axisLineVisible == null || axisLineVisible.booleanValue()) {
            Stroke axisLineStroke;
            Paint linePaint = lineColor;
            if (linePaint == null && axisSettings.getLinePaint() != null) {
                linePaint = axisSettings.getLinePaint().getPaint();
            }
            if (linePaint != null) {
                axis.setAxisLinePaint(linePaint);
            }
            if ((axisLineStroke = axisSettings.getLineStroke()) != null) {
                axis.setAxisLineStroke(axisLineStroke);
            }
        } else {
            axis.setAxisLineVisible(false);
        }
    }

    protected void setAxisLabel(Axis axis, JRFont labelFont, Paint labelColor, AxisSettings axisSettings) {
        Boolean axisLabelVisible = axisSettings.getLabelVisible();
        if (axisLabelVisible == null || axisLabelVisible.booleanValue()) {
            Paint labelPaint;
            Double labelAngle = axisSettings.getLabelAngle();
            if (labelAngle != null) {
                axis.setLabelAngle(labelAngle.doubleValue());
            }
            JRBaseFont font = new JRBaseFont();
            FontUtil.copyNonNullOwnProperties((JRFont)axisSettings.getLabelFont(), (JRFont)font);
            FontUtil.copyNonNullOwnProperties((JRFont)labelFont, (JRFont)font);
            font = new JRBaseFont((JRStyleContainer)this.getChart(), (JRFont)font);
            axis.setLabelFont(this.getFontUtil().getAwtFont((JRFont)font, this.getLocale()));
            RectangleInsets labelInsets = axisSettings.getLabelInsets();
            if (labelInsets != null) {
                axis.setLabelInsets(labelInsets);
            }
            Paint paint = labelColor != null ? labelColor : (labelPaint = axisSettings.getLabelPaint() != null ? axisSettings.getLabelPaint().getPaint() : null);
            if (labelPaint != null) {
                axis.setLabelPaint(labelPaint);
            }
        }
    }

    protected void setAxisTickLabels(Axis axis, JRFont tickLabelFont, Paint tickLabelColor, String tickLabelMask, AxisSettings axisSettings) {
        boolean axisTickLabelsVisible = axisSettings.getTickLabelsVisible() == null || axisSettings.getTickLabelsVisible() != false;
        axis.setTickLabelsVisible(axisTickLabelsVisible);
        if (axisTickLabelsVisible) {
            Paint tickLabelPaint;
            JRBaseFont font = new JRBaseFont();
            FontUtil.copyNonNullOwnProperties((JRFont)axisSettings.getTickLabelFont(), (JRFont)font);
            FontUtil.copyNonNullOwnProperties((JRFont)tickLabelFont, (JRFont)font);
            font = new JRBaseFont((JRStyleContainer)this.getChart(), (JRFont)font);
            axis.setTickLabelFont(this.getFontUtil().getAwtFont((JRFont)font, this.getLocale()));
            RectangleInsets tickLabelInsets = axisSettings.getTickLabelInsets();
            if (tickLabelInsets != null) {
                axis.setTickLabelInsets(tickLabelInsets);
            }
            Paint paint = tickLabelColor != null ? tickLabelColor : (tickLabelPaint = axisSettings.getTickLabelPaint() != null ? axisSettings.getTickLabelPaint().getPaint() : null);
            if (tickLabelPaint != null) {
                axis.setTickLabelPaint(tickLabelPaint);
            }
            TimeZone timeZone = this.getChartContext().getTimeZone();
            if (axis instanceof DateAxis && timeZone != null) {
                ((DateAxis)axis).setTimeZone(timeZone);
            }
            if (tickLabelMask != null) {
                if (axis instanceof NumberAxis) {
                    NumberFormat fmt = NumberFormat.getInstance();
                    if (fmt instanceof DecimalFormat) {
                        ((DecimalFormat)fmt).applyPattern(tickLabelMask);
                    }
                    ((NumberAxis)axis).setNumberFormatOverride(fmt);
                } else if (axis instanceof DateAxis) {
                    DateFormat fmt = tickLabelMask.equals("SHORT") || tickLabelMask.equals("DateFormat.SHORT") ? DateFormat.getDateInstance(3) : (tickLabelMask.equals("MEDIUM") || tickLabelMask.equals("DateFormat.MEDIUM") ? DateFormat.getDateInstance(2) : (tickLabelMask.equals("LONG") || tickLabelMask.equals("DateFormat.LONG") ? DateFormat.getDateInstance(1) : (tickLabelMask.equals("FULL") || tickLabelMask.equals("DateFormat.FULL") ? DateFormat.getDateInstance(0) : new SimpleDateFormat(tickLabelMask))));
                    if (fmt != null) {
                        if (timeZone != null) {
                            fmt.setTimeZone(timeZone);
                        }
                        ((DateAxis)axis).setDateFormatOverride(fmt);
                    } else {
                        ((DateAxis)axis).setDateFormatOverride(DateFormat.getDateTimeInstance(3, 3));
                    }
                }
            }
        }
    }

    protected void setAxisTickMarks(Axis axis, Paint lineColor, AxisSettings axisSettings) {
        boolean axisTickMarksVisible = axisSettings.getTickMarksVisible() == null || axisSettings.getTickMarksVisible() != false;
        axis.setTickMarksVisible(axisTickMarksVisible);
        if (axisTickMarksVisible) {
            Stroke tickMarkStroke;
            Paint tickMarkPaint;
            Float axisTickMarksOutsideLength;
            Float axisTickMarksInsideLength = axisSettings.getTickMarksInsideLength();
            if (axisTickMarksInsideLength != null) {
                axis.setTickMarkInsideLength(axisTickMarksInsideLength.floatValue());
            }
            if ((axisTickMarksOutsideLength = axisSettings.getTickMarksOutsideLength()) != null) {
                axis.setTickMarkInsideLength(axisTickMarksOutsideLength.floatValue());
            }
            Paint paint = tickMarkPaint = axisSettings.getTickMarksPaint() != null && axisSettings.getTickMarksPaint().getPaint() != null ? axisSettings.getTickMarksPaint().getPaint() : lineColor;
            if (tickMarkPaint != null) {
                axis.setTickMarkPaint(tickMarkPaint);
            }
            if ((tickMarkStroke = axisSettings.getTickMarksStroke()) != null) {
                axis.setTickMarkStroke(tickMarkStroke);
            }
        }
    }

    protected void setAxisBounds(Axis axis, AxisSettings axisSettings, int timePeriodUnit, Comparable<?> minValue, Comparable<?> maxValue) throws JRException {
        if (axis instanceof ValueAxis) {
            if (axis instanceof DateAxis) {
                if (minValue != null) {
                    ((DateAxis)axis).setMinimumDate((Date)minValue);
                }
                if (maxValue != null) {
                    ((DateAxis)axis).setMaximumDate((Date)maxValue);
                }
            } else {
                if (minValue != null) {
                    ((ValueAxis)axis).setLowerBound(((Number)((Object)minValue)).doubleValue());
                }
                if (maxValue != null) {
                    ((ValueAxis)axis).setUpperBound(((Number)((Object)maxValue)).doubleValue());
                }
            }
            this.calculateTickUnits(axis, axisSettings, timePeriodUnit);
        }
    }

    protected void calculateTickUnits(Axis axis, AxisSettings axisSettings, int timePeriodUnit) {
        Integer tickCount = null;
        Number tickInterval = null;
        boolean axisIntegerUnit = false;
        if (this.getChart().hasProperties()) {
            String tickCountProperty = null;
            String tickIntervalProperty = null;
            String axisIntegerUnitProperty = null;
            if (axisSettings == this.getChartThemeSettings().getRangeAxisSettings()) {
                tickCountProperty = this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.range.axis.tick.count");
                tickIntervalProperty = this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.range.axis.tick.interval");
                axisIntegerUnitProperty = this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.range.axis.integer.unit");
            } else {
                tickCountProperty = this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.domain.axis.tick.count");
                tickIntervalProperty = this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.domain.axis.tick.interval");
                axisIntegerUnitProperty = this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.domain.axis.integer.unit");
            }
            if (tickCountProperty != null && tickCountProperty.trim().length() > 0) {
                tickCount = Integer.valueOf(tickCountProperty);
            }
            if (tickIntervalProperty != null && tickIntervalProperty.trim().length() > 0) {
                tickInterval = Double.valueOf(tickIntervalProperty);
            }
            if (axisIntegerUnitProperty != null && axisIntegerUnitProperty.trim().length() > 0) {
                axisIntegerUnit = Boolean.valueOf(axisIntegerUnitProperty);
            }
        } else {
            tickCount = axisSettings.getTickCount();
            tickInterval = axisSettings.getTickInterval();
            if (axisSettings.getAxisIntegerUnit() != null) {
                axisIntegerUnit = axisSettings.getAxisIntegerUnit();
            }
        }
        if (!axisIntegerUnit && tickInterval == null && tickCount == null) {
            return;
        }
        if (axis instanceof NumberAxis) {
            NumberAxis numberAxis = (NumberAxis)axis;
            int axisRange = (int)numberAxis.getRange().getLength();
            if (axisIntegerUnit) {
                numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            } else if (axisRange > 0) {
                if (tickInterval != null) {
                    if (numberAxis.getNumberFormatOverride() != null) {
                        numberAxis.setTickUnit(new NumberTickUnit(tickInterval.doubleValue(), numberAxis.getNumberFormatOverride()));
                    } else {
                        numberAxis.setTickUnit(new NumberTickUnit(tickInterval.doubleValue()));
                    }
                } else if (tickCount != null) {
                    if (numberAxis.getNumberFormatOverride() != null) {
                        numberAxis.setTickUnit(new NumberTickUnit((double)(axisRange / tickCount), numberAxis.getNumberFormatOverride()));
                    } else {
                        numberAxis.setTickUnit(new NumberTickUnit((double)(axisRange / tickCount)));
                    }
                }
            }
        }
    }

    protected boolean isShowLegend() {
        Boolean showLegend = this.getChart().getShowLegend() == null ? (this.getLegendSettings().getShowLegend() == null ? Boolean.TRUE : this.getLegendSettings().getShowLegend()) : this.getChart().getShowLegend();
        return showLegend;
    }

    protected Paint[] getPaintSequence(PlotSettings plotSettings, JRChartPlot jrPlot) {
        List<PaintProvider> themeSeriesPaintProvider;
        Paint[] colors = null;
        SortedSet seriesColors = jrPlot.getSeriesColors();
        Paint[] colorSequence = null;
        List<PaintProvider> list = themeSeriesPaintProvider = this.getChartThemeSettings().getPlotSettings().getSeriesGradientPaintSequence() != null ? this.getChartThemeSettings().getPlotSettings().getSeriesGradientPaintSequence() : this.getChartThemeSettings().getPlotSettings().getSeriesColorSequence();
        if (seriesColors != null && seriesColors.size() > 0) {
            int seriesColorsSize = seriesColors.size();
            colors = new Paint[DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE.length + seriesColorsSize];
            JRChartPlot.JRSeriesColor[] jrColorSequence = new JRChartPlot.JRSeriesColor[seriesColorsSize];
            seriesColors.toArray(jrColorSequence);
            colorSequence = new Paint[seriesColorsSize];
            for (int i = 0; i < seriesColorsSize; ++i) {
                colorSequence[i] = jrColorSequence[i].getColor();
            }
            this.populateSeriesColors(colors, colorSequence);
        } else if (themeSeriesPaintProvider != null && !themeSeriesPaintProvider.isEmpty()) {
            colors = new Paint[DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE.length + themeSeriesPaintProvider.size()];
            colorSequence = new Paint[themeSeriesPaintProvider.size()];
            ArrayList<Paint> themeSeriesColors = new ArrayList<Paint>();
            for (int i = 0; i < themeSeriesPaintProvider.size(); ++i) {
                themeSeriesColors.add(themeSeriesPaintProvider.get(i).getPaint());
            }
            themeSeriesColors.toArray(colorSequence);
            this.populateSeriesColors(colors, colorSequence);
        } else {
            colors = DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE;
        }
        return colors;
    }

    protected Paint[] getOutlinePaintSequence(PlotSettings plotSettings) {
        List<PaintProvider> outlinePaintSequenceProvider = plotSettings.getSeriesOutlinePaintSequence();
        Paint[] outlinePaintSequence = null;
        if (outlinePaintSequenceProvider != null && !outlinePaintSequenceProvider.isEmpty()) {
            outlinePaintSequence = new Paint[outlinePaintSequenceProvider.size()];
            for (int i = 0; i < outlinePaintSequenceProvider.size(); ++i) {
                outlinePaintSequence[i] = outlinePaintSequenceProvider.get(i).getPaint();
            }
        } else {
            outlinePaintSequence = DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE;
        }
        return outlinePaintSequence;
    }

    protected Stroke[] getStrokeSequence(PlotSettings plotSettings) {
        List<Stroke> strokeSequenceList = plotSettings.getSeriesStrokeSequence();
        Stroke[] strokeSequence = null;
        strokeSequence = strokeSequenceList != null && !strokeSequenceList.isEmpty() ? strokeSequenceList.toArray(new Stroke[strokeSequenceList.size()]) : DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE;
        return strokeSequence;
    }

    protected Stroke[] getOutlineStrokeSequence(PlotSettings plotSettings) {
        List<Stroke> outlineStrokeSequenceList = this.getChartThemeSettings().getPlotSettings().getSeriesOutlineStrokeSequence();
        Stroke[] outlineStrokeSequence = null;
        outlineStrokeSequence = outlineStrokeSequenceList != null && !outlineStrokeSequenceList.isEmpty() ? outlineStrokeSequenceList.toArray(new Stroke[outlineStrokeSequenceList.size()]) : DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE;
        return outlineStrokeSequence;
    }

    protected void handleTitleSettings(TextTitle title, TitleSettings titleSettings, JRFont titleFont, Paint titleForegroundPaint, RectangleEdge titleEdge) {
        Paint backPaint;
        RectangleInsets padding;
        VerticalAlignment vAlign;
        JRBaseFont font = new JRBaseFont();
        FontUtil.copyNonNullOwnProperties((JRFont)titleSettings.getFont(), (JRFont)font);
        FontUtil.copyNonNullOwnProperties((JRFont)titleFont, (JRFont)font);
        font = new JRBaseFont((JRStyleContainer)this.getChart(), (JRFont)font);
        title.setFont(this.getFontUtil().getAwtFont((JRFont)font, this.getLocale()));
        HorizontalAlignment hAlign = titleSettings.getHorizontalAlignment();
        if (hAlign != null) {
            title.setHorizontalAlignment(hAlign);
        }
        if ((vAlign = titleSettings.getVerticalAlignment()) != null) {
            title.setVerticalAlignment(vAlign);
        }
        if ((padding = titleSettings.getPadding()) != null) {
            title.setPadding(padding);
        }
        if (titleForegroundPaint != null) {
            title.setPaint(titleForegroundPaint);
        }
        Paint paint = backPaint = titleSettings.getBackgroundPaint() != null ? titleSettings.getBackgroundPaint().getPaint() : null;
        if (backPaint != null) {
            title.setBackgroundPaint(backPaint);
        }
        if (titleEdge != null) {
            title.setPosition(titleEdge);
        }
    }
}

