/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.map.MapCompiler;
import net.sf.jasperreports.components.map.Marker;
import net.sf.jasperreports.components.map.MarkerDataset;
import net.sf.jasperreports.components.map.MarkerProperty;
import net.sf.jasperreports.components.map.StandardMarker;
import net.sf.jasperreports.components.map.StandardMarkerProperty;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class StandardMarkerDataset
implements Serializable,
MarkerDataset,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_MARKER = "marker";
    public static final String PROPERTY_DATASET_RUN = "datasetRun";
    private List<Marker> markerList = new ArrayList<Marker>();
    private JRDatasetRun datasetRun;
    private transient JRPropertyChangeSupport eventSupport;

    public StandardMarkerDataset() {
    }

    public StandardMarkerDataset(MarkerDataset dataset, JRBaseObjectFactory factory) {
        this.markerList = StandardMarkerDataset.getCompiledMarkers(dataset.getMarkers(), factory);
        this.datasetRun = factory.getDatasetRun(dataset.getDatasetRun());
    }

    private static List<Marker> getCompiledMarkers(List<Marker> markers, JRBaseObjectFactory factory) {
        if (markers == null) {
            return null;
        }
        ArrayList<Marker> compiledMarkers = new ArrayList<Marker>(markers.size());
        for (Marker marker : markers) {
            StandardMarker compiledMarker = new StandardMarker(StandardMarkerDataset.getCompiledProperties(marker.getProperties(), factory));
            compiledMarkers.add(compiledMarker);
        }
        return compiledMarkers;
    }

    private static List<MarkerProperty> getCompiledProperties(List<MarkerProperty> properties, JRBaseObjectFactory factory) {
        if (properties == null) {
            return null;
        }
        ArrayList<MarkerProperty> compiledProperties = new ArrayList<MarkerProperty>(properties.size());
        for (MarkerProperty property : properties) {
            StandardMarkerProperty compiledProperty = new StandardMarkerProperty(property.getName(), property.getValue(), factory.getExpression(property.getValueExpression()));
            compiledProperties.add(compiledProperty);
        }
        return compiledProperties;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        MapCompiler.collectExpressions(this, collector);
    }

    @Override
    public List<Marker> getMarkers() {
        return this.markerList;
    }

    public void addMarker(Marker marker) {
        this.markerList.add(marker);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_MARKER, marker, this.markerList.size() - 1);
    }

    public void addMarker(int index, Marker marker) {
        if (index >= 0 && index < this.markerList.size()) {
            this.markerList.add(index, marker);
        } else {
            this.markerList.add(marker);
            index = this.markerList.size() - 1;
        }
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_MARKER, this.markerList, index);
    }

    public Marker removeMarker(Marker marker) {
        int idx;
        if (marker != null && (idx = this.markerList.indexOf(marker)) >= 0) {
            this.markerList.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_MARKER, marker, idx);
        }
        return marker;
    }

    @Override
    public JRDatasetRun getDatasetRun() {
        return this.datasetRun;
    }

    public void setDatasetRun(JRDatasetRun datasetRun) {
        JRDatasetRun old = this.datasetRun;
        this.datasetRun = datasetRun;
        this.getEventSupport().firePropertyChange(PROPERTY_DATASET_RUN, old, this.datasetRun);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        StandardMarkerDataset standardMarkerDataset = this;
        synchronized (standardMarkerDataset) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    @Override
    public Object clone() {
        StandardMarkerDataset clone = null;
        try {
            clone = (StandardMarkerDataset)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.datasetRun = JRCloneUtils.nullSafeClone(this.datasetRun);
        clone.markerList = JRCloneUtils.cloneList(this.markerList);
        clone.eventSupport = null;
        return clone;
    }
}

