/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.table.fill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.sf.jasperreports.components.headertoolbar.HeaderLabelUtil;
import net.sf.jasperreports.components.headertoolbar.HeaderToolbarElement;
import net.sf.jasperreports.components.headertoolbar.HeaderToolbarElementUtils;
import net.sf.jasperreports.components.sort.FieldFilter;
import net.sf.jasperreports.components.sort.FilterTypesEnum;
import net.sf.jasperreports.components.sort.SortElementHtmlHandler;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.Column;
import net.sf.jasperreports.components.table.ColumnGroup;
import net.sf.jasperreports.components.table.ColumnVisitor;
import net.sf.jasperreports.components.table.TableComponent;
import net.sf.jasperreports.components.table.fill.BuiltinExpressionEvaluator;
import net.sf.jasperreports.components.table.fill.ConstantBuiltinExpression;
import net.sf.jasperreports.components.table.fill.FillColumn;
import net.sf.jasperreports.components.table.fill.TableReportDataset;
import net.sf.jasperreports.components.table.fill.TableReportGroup;
import net.sf.jasperreports.components.table.fill.TableReportScriptlet;
import net.sf.jasperreports.components.table.util.TableUtil;
import net.sf.jasperreports.engine.CompositeDatasetFilter;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.component.FillContext;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JRDesignGenericElement;
import net.sf.jasperreports.engine.design.JRDesignGenericElementParameter;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.type.PositionTypeEnum;
import net.sf.jasperreports.engine.type.PrintOrderEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;
import net.sf.jasperreports.engine.type.SortOrderEnum;
import net.sf.jasperreports.engine.type.SplitTypeEnum;
import net.sf.jasperreports.engine.type.StretchTypeEnum;
import net.sf.jasperreports.engine.type.WhenNoDataTypeEnum;
import net.sf.jasperreports.engine.type.WhenResourceMissingTypeEnum;
import net.sf.jasperreports.engine.util.StyleUtil;
import net.sf.jasperreports.web.util.JacksonUtil;

public class TableReport
implements JRReport {
    private static final String PROPERTY_UP_ARROW_CHAR = "net.sf.jasperreports.components.sort.up.arrow.char";
    private static final String PROPERTY_DOWN_ARROW_CHAR = "net.sf.jasperreports.components.sort.down.arrow.char";
    private static final String PROPERTY_FILTER_CHAR = "net.sf.jasperreports.components.filter.char";
    private static final String PROPERTY_INTERACTIVE_TABLE = "net.sf.jasperreports.components.table.interactive";
    protected static final String SUMMARY_GROUP_NAME = "__SummaryGroup";
    protected static final String HTML_CLASS_COLUMN_PREFIX = "col_";
    protected static final String HTML_CLASS_COLUMN = "column";
    private final FillContext fillContext;
    private final TableComponent table;
    private final JasperReport parentReport;
    private final TableReportDataset mainDataset;
    private final Map<JRExpression, BuiltinExpressionEvaluator> builtinEvaluators;
    private final JRSection detail;
    private final JRDesignBand title;
    private final JRDesignBand summary;
    private final JRDesignBand columnHeader;
    private final JRDesignBand pageFooter;
    private final JRDesignBand lastPageFooter;
    private final Map<Integer, String> headerHtmlClasses = new HashMap<Integer, String>();
    private final JRPropertiesUtil propertiesUtil;
    private boolean isInteractiveTable;
    private Map<Column, Boolean> columnInteractivityMapping;
    protected static final String TABLE_SCRIPTLET_NAME = "__Table";

    public TableReport(FillContext fillContext, TableComponent table, TableReportDataset mainDataset, List<FillColumn> fillColumns, Map<JRExpression, BuiltinExpressionEvaluator> builtinEvaluators) {
        this.fillContext = fillContext;
        this.table = table;
        this.parentReport = fillContext.getFiller().getJasperReport();
        this.mainDataset = mainDataset;
        this.builtinEvaluators = builtinEvaluators;
        this.propertiesUtil = JRPropertiesUtil.getInstance(fillContext.getFiller().getJasperReportsContext());
        this.isInteractiveTable = Boolean.valueOf(this.propertiesUtil.getProperty(PROPERTY_INTERACTIVE_TABLE, fillContext.getComponentElement(), this.parentReport));
        this.columnInteractivityMapping = new HashMap<Column, Boolean>();
        int interactiveColumnCount = 0;
        for (BaseColumn column : TableUtil.getAllColumns(table)) {
            boolean interactiveColumn = this.isInteractiveTable;
            if (column.getPropertiesMap().containsProperty(PROPERTY_INTERACTIVE_TABLE)) {
                interactiveColumn = Boolean.valueOf(column.getPropertiesMap().getProperty(PROPERTY_INTERACTIVE_TABLE));
            }
            if (interactiveColumn) {
                ++interactiveColumnCount;
            }
            this.columnInteractivityMapping.put((Column)column, interactiveColumn);
        }
        if (interactiveColumnCount > 0) {
            this.isInteractiveTable = true;
        }
        this.columnHeader = this.createColumnHeader(fillColumns);
        this.detail = this.wrapBand(this.createDetailBand(fillColumns), new JROrigin(BandTypeEnum.DETAIL));
        this.title = this.createTitle(fillColumns);
        this.summary = this.createSummary(fillColumns);
        this.pageFooter = this.createPageFooter(fillColumns);
        this.setGroupBands(fillColumns);
        if (this.pageFooter != null && this.summary != null) {
            this.addSummaryGroup(fillColumns);
            this.lastPageFooter = new JRDesignBand();
            this.lastPageFooter.setHeight(0);
        } else {
            this.lastPageFooter = null;
        }
    }

    protected JRDesignExpression createBuiltinExpression(BuiltinExpressionEvaluator evaluator) {
        JRDesignExpression expression = new JRDesignExpression();
        this.builtinEvaluators.put(expression, evaluator);
        return expression;
    }

    protected JRBand createDetailBand(List<FillColumn> fillColumns) {
        JRDesignBand detailBand = new JRDesignBand();
        detailBand.setSplitType(SplitTypeEnum.PREVENT);
        ReportBandInfo bandInfo = new ReportBandInfo(detailBand);
        int xOffset = 0;
        for (FillColumn subcolumn : fillColumns) {
            DetailBandCreator subVisitor = new DetailBandCreator(bandInfo, subcolumn, xOffset, 0, 0);
            subVisitor.visit();
            xOffset = subVisitor.xOffset;
        }
        return detailBand;
    }

    protected JRDesignBand createColumnHeader(List<FillColumn> fillColumns) {
        JRDesignBand columnHeader = new JRDesignBand();
        columnHeader.setSplitType(SplitTypeEnum.PREVENT);
        ReportBandInfo bandInfo = new ReportBandInfo(columnHeader);
        int xOffset = 0;
        for (FillColumn subcolumn : fillColumns) {
            ColumnHeaderCreator subVisitor = new ColumnHeaderCreator(bandInfo, subcolumn, xOffset, 0, 0, this.headerHtmlClasses, new AtomicBoolean());
            subVisitor.visit();
            xOffset = subVisitor.xOffset;
        }
        if (columnHeader.getHeight() == 0) {
            columnHeader = null;
        }
        return columnHeader;
    }

    protected JRDesignBand createPageFooter(List<FillColumn> fillColumns) {
        JRDesignBand pageFooter = new JRDesignBand();
        pageFooter.setSplitType(SplitTypeEnum.PREVENT);
        ReportBandInfo bandInfo = new ReportBandInfo(pageFooter);
        int xOffset = 0;
        for (FillColumn subcolumn : fillColumns) {
            PageFooterCreator subVisitor = new PageFooterCreator(bandInfo, subcolumn, xOffset, 0, 0);
            subVisitor.visit();
            xOffset = subVisitor.xOffset;
        }
        if (pageFooter.getHeight() == 0) {
            pageFooter = null;
        }
        return pageFooter;
    }

    protected JRDesignBand createTitle(List<FillColumn> fillColumns) {
        JRDesignBand title = new JRDesignBand();
        title.setSplitType(SplitTypeEnum.PREVENT);
        ReportBandInfo bandInfo = new ReportBandInfo(title);
        int xOffset = 0;
        for (FillColumn subcolumn : fillColumns) {
            TitleCreator subVisitor = new TitleCreator(bandInfo, subcolumn, xOffset, 0, 0);
            subVisitor.visit();
            xOffset = subVisitor.xOffset;
        }
        if (title.getHeight() == 0) {
            title = null;
        }
        return title;
    }

    protected JRDesignBand createSummary(List<FillColumn> fillColumns) {
        JRDesignBand summary = new JRDesignBand();
        summary.setSplitType(SplitTypeEnum.PREVENT);
        ReportBandInfo bandInfo = new ReportBandInfo(summary);
        int xOffset = 0;
        for (FillColumn subcolumn : fillColumns) {
            SummaryCreator subVisitor = new SummaryCreator(bandInfo, subcolumn, xOffset, 0, 0);
            subVisitor.visit();
            xOffset = subVisitor.xOffset;
        }
        if (summary.getHeight() == 0) {
            summary = null;
        }
        return summary;
    }

    protected JRBand createGroupHeader(String groupName, List<FillColumn> fillColumns) {
        JRDesignBand header = new JRDesignBand();
        header.setSplitType(SplitTypeEnum.PREVENT);
        ReportBandInfo bandInfo = new ReportBandInfo(header);
        int xOffset = 0;
        for (FillColumn subcolumn : fillColumns) {
            GroupHeaderCreator subVisitor = new GroupHeaderCreator(groupName, bandInfo, subcolumn, xOffset, 0, 0);
            subVisitor.visit();
            xOffset = subVisitor.xOffset;
        }
        if (header.getHeight() == 0) {
            header = null;
        }
        return header;
    }

    protected JRBand createGroupFooter(String groupName, List<FillColumn> fillColumns) {
        JRDesignBand footer = new JRDesignBand();
        footer.setSplitType(SplitTypeEnum.PREVENT);
        ReportBandInfo bandInfo = new ReportBandInfo(footer);
        int xOffset = 0;
        for (FillColumn subcolumn : fillColumns) {
            GroupFooterCreator subVisitor = new GroupFooterCreator(groupName, bandInfo, subcolumn, xOffset, 0, 0);
            subVisitor.visit();
            xOffset = subVisitor.xOffset;
        }
        if (footer.getHeight() == 0) {
            footer = null;
        }
        return footer;
    }

    private void setGroupBands(List<FillColumn> fillColumns) {
        TableReportGroup[] groups = this.mainDataset.getTableGroups();
        if (groups != null) {
            for (TableReportGroup group : groups) {
                JRBand footer;
                JRBand header = this.createGroupHeader(group.getName(), fillColumns);
                if (header != null) {
                    group.setGroupHeader(header);
                }
                if ((footer = this.createGroupFooter(group.getName(), fillColumns)) == null) continue;
                group.setGroupFooter(footer);
            }
        }
    }

    protected int computeTableWidth(List<FillColumn> fillColumns) {
        int width = 0;
        for (FillColumn column : fillColumns) {
            width += column.getWidth();
        }
        return width;
    }

    protected void addSummaryGroup(List<FillColumn> fillColumns) {
        JRDesignGroup summaryGroup = new JRDesignGroup();
        summaryGroup.setName(SUMMARY_GROUP_NAME);
        JRDesignBand groupFooter = new JRDesignBand();
        groupFooter.setSplitType(SplitTypeEnum.PREVENT);
        groupFooter.setHeight(this.pageFooter.getHeight());
        JRDesignFrame footerFrame = new JRDesignFrame();
        footerFrame.setX(0);
        footerFrame.setY(0);
        footerFrame.setWidth(this.computeTableWidth(fillColumns));
        footerFrame.setHeight(this.pageFooter.getHeight());
        footerFrame.getLineBox().setPadding(0);
        footerFrame.getLineBox().getPen().setLineWidth(0.0f);
        footerFrame.setRemoveLineWhenBlank(true);
        JRDesignExpression footerPrintWhen = this.createBuiltinExpression(new SummaryGroupFooterPrintWhenEvaluator());
        footerFrame.setPrintWhenExpression(footerPrintWhen);
        List<JRChild> footerElements = this.pageFooter.getChildren();
        for (JRChild child : footerElements) {
            JRChild childClone = (JRChild)child.clone(footerFrame);
            if (childClone instanceof JRElement) {
                footerFrame.addElement((JRElement)childClone);
                continue;
            }
            if (childClone instanceof JRElementGroup) {
                footerFrame.addElementGroup((JRElementGroup)childClone);
                continue;
            }
            throw new JRRuntimeException("Uknown child type " + childClone.getClass().getName());
        }
        groupFooter.addElement(footerFrame);
        ((JRDesignSection)summaryGroup.getGroupFooterSection()).addBand(groupFooter);
        this.mainDataset.addScriptlet(TABLE_SCRIPTLET_NAME, TableReportScriptlet.class);
        this.mainDataset.addFirstGroup(summaryGroup);
    }

    protected JRElement createCell(JRElementGroup parentGroup, Cell cell, int originalWidth, int width, int x, int y, Integer columnHashCode, boolean forceFrame) {
        JRElement cellElement;
        if (!forceFrame && (cellElement = this.createCellElement(parentGroup, cell, originalWidth, width, x, y, columnHashCode)) != null) {
            return cellElement;
        }
        JRDesignFrame frame = new JRDesignFrame(this);
        frame.setElementGroup(parentGroup);
        frame.setX(x);
        frame.setY(y);
        frame.setWidth(width);
        frame.setHeight(cell.getHeight());
        frame.setStretchType(StretchTypeEnum.RELATIVE_TO_TALLEST_OBJECT);
        frame.setStyle(cell.getStyle());
        frame.setStyleNameReference(cell.getStyleNameReference());
        frame.copyBox(cell.getLineBox());
        if (columnHashCode != null && this.headerHtmlClasses.get(columnHashCode) != null) {
            frame.getPropertiesMap().setProperty("net.sf.jasperreports.export.html.class", this.headerHtmlClasses.get(columnHashCode));
        }
        for (JRChild child : cell.getChildren()) {
            if (child instanceof JRElement) {
                JRElement element = (JRElement)child;
                element = (JRElement)element.clone(frame);
                if (width != originalWidth) {
                    this.scaleCellElement(element, originalWidth, width);
                    if (element instanceof JRElementGroup) {
                        JRElementGroup elementGroup = (JRElementGroup)((Object)element);
                        for (JRElement subelement : elementGroup.getElements()) {
                            this.scaleCellElement(subelement, originalWidth, width);
                        }
                    }
                }
                frame.addElement(element);
                continue;
            }
            if (child instanceof JRElementGroup) {
                JRElementGroup elementGroup = (JRElementGroup)child;
                elementGroup = (JRElementGroup)elementGroup.clone(frame);
                frame.addElementGroup(elementGroup);
                if (width == originalWidth) continue;
                for (JRElement element : elementGroup.getElements()) {
                    this.scaleCellElement(element, originalWidth, width);
                }
                continue;
            }
            throw new JRRuntimeException("Unknown JRChild type " + child.getClass().getName());
        }
        return frame;
    }

    protected JRElement createCellElement(JRElementGroup elementGroup, Cell cell, int originalWidth, int width, int x, int y, Integer columnHashCode) {
        ModeEnum cellMode;
        List<JRChild> children = cell.getChildren();
        if (children.size() != 1) {
            return null;
        }
        JRChild child = children.get(0);
        if (!(child instanceof JRStaticText) && !(child instanceof JRTextField)) {
            return null;
        }
        JRElement element = (JRElement)child;
        if (element.getX() != 0 || element.getY() != 0 || element.getWidth() != originalWidth || element.getHeight() != cell.getHeight().intValue()) {
            return null;
        }
        ModeEnum elementMode = StyleUtil.instance().resolveElementMode(element);
        if ((elementMode == null || elementMode == ModeEnum.TRANSPARENT) && (cellMode = StyleUtil.instance().resolveMode(cell)) != ModeEnum.TRANSPARENT) {
            return null;
        }
        if (StyleUtil.instance().hasBox(cell)) {
            return null;
        }
        JRElement cellElement = element.clone(elementGroup, y);
        cellElement.setX(x);
        cellElement.setWidth(width);
        cellElement.setStretchType(StretchTypeEnum.RELATIVE_TO_TALLEST_OBJECT);
        if (columnHashCode != null && this.headerHtmlClasses.get(columnHashCode) != null) {
            cellElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.html.class", this.headerHtmlClasses.get(columnHashCode));
        }
        if (width != originalWidth) {
            this.scaleCellElement(element, originalWidth, width);
        }
        return cellElement;
    }

    protected void scaleCellElement(JRElement element, Integer cellWidth, int scaledCellWidth) {
        int scaledWidth = Math.round((float)element.getWidth() * (float)scaledCellWidth / (float)cellWidth.intValue());
        element.setWidth(scaledWidth);
    }

    protected JRSection wrapBand(JRBand band, JROrigin origin) {
        JRDesignSection section = new JRDesignSection(origin);
        section.addBand(band);
        return section;
    }

    @Override
    public JRBand getBackground() {
        return null;
    }

    @Override
    public int getBottomMargin() {
        return 0;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public JRBand getColumnFooter() {
        return null;
    }

    @Override
    public JRBand getColumnHeader() {
        return this.columnHeader;
    }

    @Override
    public int getColumnSpacing() {
        return 0;
    }

    @Override
    public int getColumnWidth() {
        return this.fillContext.getComponentElement().getWidth();
    }

    @Override
    public JRDataset[] getDatasets() {
        return this.parentReport.getDatasets();
    }

    @Deprecated
    public JRBand getDetail() {
        return null;
    }

    @Override
    public JRSection getDetailSection() {
        return this.detail;
    }

    @Override
    public JRField[] getFields() {
        return this.mainDataset.getFields();
    }

    protected JRField getField(String name) {
        JRField found = null;
        for (JRField field : this.getFields()) {
            if (!name.equals(field.getName())) continue;
            found = field;
            break;
        }
        return found;
    }

    @Override
    public String getFormatFactoryClass() {
        return this.parentReport.getFormatFactoryClass();
    }

    @Override
    public JRGroup[] getGroups() {
        return this.mainDataset.getGroups();
    }

    @Override
    public String[] getImports() {
        return this.parentReport.getImports();
    }

    @Override
    public String getLanguage() {
        return this.parentReport.getLanguage();
    }

    @Override
    public JRBand getLastPageFooter() {
        return this.lastPageFooter;
    }

    @Override
    public int getLeftMargin() {
        return 0;
    }

    @Override
    public JRDataset getMainDataset() {
        return this.mainDataset;
    }

    @Override
    public String getName() {
        return this.mainDataset.getName();
    }

    @Override
    public JRBand getNoData() {
        return null;
    }

    @Override
    public OrientationEnum getOrientationValue() {
        return OrientationEnum.PORTRAIT;
    }

    @Override
    public JRBand getPageFooter() {
        return this.pageFooter;
    }

    @Override
    public JRBand getPageHeader() {
        return null;
    }

    @Override
    public int getPageHeight() {
        return this.parentReport.getPageHeight();
    }

    @Override
    public int getPageWidth() {
        return this.fillContext.getComponentElement().getWidth();
    }

    @Override
    public JRParameter[] getParameters() {
        return this.mainDataset.getParameters();
    }

    @Override
    public PrintOrderEnum getPrintOrderValue() {
        return PrintOrderEnum.VERTICAL;
    }

    @Override
    public RunDirectionEnum getColumnDirection() {
        return RunDirectionEnum.LTR;
    }

    @Override
    public String getProperty(String name) {
        return this.mainDataset.getPropertiesMap().getProperty(name);
    }

    @Override
    public String[] getPropertyNames() {
        return this.mainDataset.getPropertiesMap().getPropertyNames();
    }

    @Override
    public JRQuery getQuery() {
        return this.mainDataset.getQuery();
    }

    @Override
    public String getResourceBundle() {
        return this.mainDataset.getResourceBundle();
    }

    @Override
    public int getRightMargin() {
        return 0;
    }

    @Override
    public String getScriptletClass() {
        return this.mainDataset.getScriptletClass();
    }

    @Override
    public JRScriptlet[] getScriptlets() {
        return this.mainDataset.getScriptlets();
    }

    @Override
    public JRSortField[] getSortFields() {
        return this.mainDataset.getSortFields();
    }

    @Override
    public JRStyle[] getStyles() {
        return this.parentReport.getStyles();
    }

    @Override
    public JRBand getSummary() {
        return this.summary;
    }

    @Override
    public JRReportTemplate[] getTemplates() {
        return null;
    }

    @Override
    public JRBand getTitle() {
        return this.title;
    }

    @Override
    public int getTopMargin() {
        return 0;
    }

    @Override
    public JRVariable[] getVariables() {
        return this.mainDataset.getVariables();
    }

    protected JRVariable getVariable(String name) {
        JRVariable found = null;
        for (JRVariable var : this.getVariables()) {
            if (!name.equals(var.getName())) continue;
            found = var;
            break;
        }
        return found;
    }

    @Override
    public WhenNoDataTypeEnum getWhenNoDataTypeValue() {
        WhenNoDataTypeEnum whenNoDataType = WhenNoDataTypeEnum.NO_PAGES;
        if (this.table.getWhenNoDataType() != null) {
            switch (this.table.getWhenNoDataType()) {
                case ALL_SECTIONS_NO_DETAIL: {
                    whenNoDataType = WhenNoDataTypeEnum.ALL_SECTIONS_NO_DETAIL;
                    break;
                }
                default: {
                    whenNoDataType = WhenNoDataTypeEnum.NO_PAGES;
                }
            }
        }
        return whenNoDataType;
    }

    @Override
    public WhenResourceMissingTypeEnum getWhenResourceMissingTypeValue() {
        return this.mainDataset.getWhenResourceMissingTypeValue();
    }

    @Override
    public boolean isFloatColumnFooter() {
        return true;
    }

    @Override
    public boolean isIgnorePagination() {
        return false;
    }

    @Override
    public boolean isSummaryNewPage() {
        return false;
    }

    @Override
    public boolean isSummaryWithPageHeaderAndFooter() {
        return false;
    }

    @Override
    public boolean isTitleNewPage() {
        return false;
    }

    @Override
    public void removeProperty(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setProperty(String name, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setWhenNoDataType(WhenNoDataTypeEnum whenNoDataType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setWhenResourceMissingType(WhenResourceMissingTypeEnum whenResourceMissingType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JRStyle getDefaultStyle() {
        return this.parentReport.getDefaultStyle();
    }

    @Override
    public JRPropertiesHolder getParentProperties() {
        return null;
    }

    @Override
    public JRPropertiesMap getPropertiesMap() {
        return this.mainDataset.getPropertiesMap();
    }

    @Override
    public boolean hasProperties() {
        return this.mainDataset.hasProperties();
    }

    @Override
    public UUID getUUID() {
        return this.mainDataset.getUUID();
    }

    protected class SummaryGroupFooterPrintWhenEvaluator
    implements BuiltinExpressionEvaluator {
        private JRValueParameter tableScriptletParam;
        private TableReportScriptlet tableScriptlet;

        protected SummaryGroupFooterPrintWhenEvaluator() {
        }

        @Override
        public void init(Map<String, JRFillParameter> parametersMap, Map<String, JRFillField> fieldsMap, Map<String, JRFillVariable> variablesMap, WhenResourceMissingTypeEnum resourceMissingType) throws JRException {
            this.tableScriptletParam = parametersMap.get("__Table_SCRIPTLET");
        }

        protected void ensureValue() {
            if (this.tableScriptlet == null) {
                this.tableScriptlet = (TableReportScriptlet)this.tableScriptletParam.getValue();
            }
        }

        @Override
        public Object evaluate(DatasetExpressionEvaluator evaluator) throws JRExpressionEvalException {
            this.ensureValue();
            return this.tableScriptlet.hasDetailOnPage();
        }

        @Override
        public Object evaluateEstimated(DatasetExpressionEvaluator evaluator) throws JRExpressionEvalException {
            this.ensureValue();
            return this.tableScriptlet.hasDetailOnPage();
        }

        @Override
        public Object evaluateOld(DatasetExpressionEvaluator evaluator) throws JRExpressionEvalException {
            this.ensureValue();
            return this.tableScriptlet.hasDetailOnPage();
        }
    }

    protected class GroupFooterCreator
    extends ReverseReportBandCreator {
        private final String groupName;

        public GroupFooterCreator(String groupName, ReportBandInfo bandInfo, FillColumn fillColumn, int xOffset, int yOffset, int level) {
            super(bandInfo, fillColumn, xOffset, yOffset, level);
            this.groupName = groupName;
        }

        @Override
        protected Cell columnCell(Column column) {
            return column.getGroupFooter(this.groupName);
        }

        @Override
        protected Cell columnGroupCell(ColumnGroup group) {
            return group.getGroupFooter(this.groupName);
        }

        @Override
        protected ReportBandCreator createSubVisitor(FillColumn subcolumn, int xOffset, int yOffset, int sublevel) {
            return new GroupFooterCreator(this.groupName, this.bandInfo, subcolumn, xOffset, yOffset, sublevel);
        }
    }

    protected class GroupHeaderCreator
    extends ReportBandCreator {
        private final String groupName;

        public GroupHeaderCreator(String groupName, ReportBandInfo bandInfo, FillColumn fillColumn, int xOffset, int yOffset, int level) {
            super(bandInfo, fillColumn, xOffset, yOffset, level);
            this.groupName = groupName;
        }

        @Override
        protected Cell columnCell(Column column) {
            return column.getGroupHeader(this.groupName);
        }

        @Override
        protected Cell columnGroupCell(ColumnGroup group) {
            return group.getGroupHeader(this.groupName);
        }

        @Override
        protected ReportBandCreator createSubVisitor(FillColumn subcolumn, int xOffset, int yOffset, int sublevel) {
            return new GroupHeaderCreator(this.groupName, this.bandInfo, subcolumn, xOffset, yOffset, sublevel);
        }
    }

    protected class SummaryCreator
    extends ReverseReportBandCreator {
        public SummaryCreator(ReportBandInfo bandInfo, FillColumn fillColumn, int xOffset, int yOffset, int level) {
            super(bandInfo, fillColumn, xOffset, yOffset, level);
        }

        @Override
        protected Cell columnCell(Column column) {
            return column.getTableFooter();
        }

        @Override
        protected Cell columnGroupCell(ColumnGroup group) {
            return group.getTableFooter();
        }

        @Override
        protected ReportBandCreator createSubVisitor(FillColumn subcolumn, int xOffset, int yOffset, int sublevel) {
            return new SummaryCreator(this.bandInfo, subcolumn, xOffset, yOffset, sublevel);
        }
    }

    protected class TitleCreator
    extends ReportBandCreator {
        public TitleCreator(ReportBandInfo bandInfo, FillColumn fillColumn, int xOffset, int yOffset, int level) {
            super(bandInfo, fillColumn, xOffset, yOffset, level);
        }

        @Override
        protected Cell columnCell(Column column) {
            return column.getTableHeader();
        }

        @Override
        protected Cell columnGroupCell(ColumnGroup group) {
            return group.getTableHeader();
        }

        @Override
        protected ReportBandCreator createSubVisitor(FillColumn subcolumn, int xOffset, int yOffset, int sublevel) {
            return new TitleCreator(this.bandInfo, subcolumn, xOffset, yOffset, sublevel);
        }
    }

    protected class PageFooterCreator
    extends ReverseReportBandCreator {
        public PageFooterCreator(ReportBandInfo bandInfo, FillColumn fillColumn, int xOffset, int yOffset, int level) {
            super(bandInfo, fillColumn, xOffset, yOffset, level);
        }

        @Override
        protected Cell columnCell(Column column) {
            return column.getColumnFooter();
        }

        @Override
        protected Cell columnGroupCell(ColumnGroup group) {
            return group.getColumnFooter();
        }

        @Override
        protected ReportBandCreator createSubVisitor(FillColumn subcolumn, int xOffset, int yOffset, int sublevel) {
            return new PageFooterCreator(this.bandInfo, subcolumn, xOffset, yOffset, sublevel);
        }
    }

    protected class ColumnHeaderCreator
    extends ReportBandCreator {
        private Map<Integer, String> headerClasses;
        private final AtomicBoolean firstColumn;

        public ColumnHeaderCreator(ReportBandInfo bandInfo, FillColumn fillColumn, int xOffset, int yOffset, int level, Map<Integer, String> headerClasses, AtomicBoolean firstColumn) {
            super(bandInfo, fillColumn, xOffset, yOffset, level);
            this.headerClasses = headerClasses;
            this.firstColumn = firstColumn;
        }

        @Override
        protected Cell columnCell(Column column) {
            return column.getColumnHeader();
        }

        @Override
        protected JRDesignFrame createColumnCell(Column column, JRElementGroup parentGroup, Cell cell) {
            JRDesignFrame frame = (JRDesignFrame)this.createColumnCell(column, parentGroup, cell, true);
            this.addHeaderToolbarElement(column, frame, TableUtil.getColumnDetailTextElement(column));
            return frame;
        }

        protected JRExpression getColumnHeaderLabelExpression(Cell header) {
            List<JRChild> detailElements;
            List<JRChild> list = detailElements = header == null ? null : header.getChildren();
            if (detailElements == null || detailElements.size() != 1) {
                return null;
            }
            JRChild detailElement = detailElements.get(0);
            if (detailElement instanceof JRTextField) {
                return ((JRTextField)detailElement).getExpression();
            }
            if (detailElement instanceof JRStaticText) {
                return TableReport.this.createBuiltinExpression(new ConstantBuiltinExpression(((JRStaticText)detailElement).getText()));
            }
            return null;
        }

        protected void addHeaderToolbarElement(Column column, JRDesignFrame frame, JRTextField sortTextField) {
            int columnIndex = TableUtil.getColumnIndex(column, TableReport.this.table);
            if (sortTextField != null) {
                Cell header = column.getColumnHeader();
                JRDesignGenericElement genericElement = new JRDesignGenericElement(header.getDefaultStyleProvider());
                genericElement.setGenericType(HeaderToolbarElement.ELEMENT_TYPE);
                genericElement.setPositionType(PositionTypeEnum.FIX_RELATIVE_TO_TOP);
                genericElement.setX(0);
                genericElement.setY(0);
                genericElement.setHeight(0);
                genericElement.setWidth(0);
                genericElement.setMode(ModeEnum.TRANSPARENT);
                genericElement.setStretchType(StretchTypeEnum.RELATIVE_TO_BAND_HEIGHT);
                String name = null;
                boolean interactiveColumn = (Boolean)TableReport.this.columnInteractivityMapping.get(column);
                if (!TableUtil.isSortableAndFilterable(sortTextField)) {
                    genericElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.can.filter", Boolean.FALSE.toString());
                    genericElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.can.sort", Boolean.FALSE.toString());
                } else {
                    HeaderLabelUtil.HeaderLabelBuiltinExpression evaluator;
                    List<FieldFilter> existingFilters;
                    String serializedFilters;
                    SortFieldTypeEnum columnType;
                    genericElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.can.filter", Boolean.TRUE.toString());
                    genericElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.can.sort", Boolean.TRUE.toString());
                    JRExpressionChunk sortExpression = sortTextField.getExpression().getChunks()[0];
                    name = sortExpression.getText();
                    FilterTypesEnum filterType = null;
                    switch (sortExpression.getType()) {
                        case 3: {
                            columnType = SortFieldTypeEnum.FIELD;
                            JRField field = TableReport.this.getField(name);
                            filterType = HeaderToolbarElementUtils.getFilterType(field.getValueClass());
                            break;
                        }
                        case 4: {
                            columnType = SortFieldTypeEnum.VARIABLE;
                            JRVariable variable = TableReport.this.getVariable(name);
                            filterType = HeaderToolbarElementUtils.getFilterType(variable.getValueClass());
                            break;
                        }
                        default: {
                            throw new JRRuntimeException("Unrecognized filter expression type " + sortExpression.getType());
                        }
                    }
                    genericElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.field.or.variable", name);
                    genericElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.sortColumnType", columnType.getName());
                    if (filterType != null) {
                        genericElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.filter.type", filterType.getName());
                    }
                    genericElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.filter.pattern", sortTextField.getPattern());
                    JasperReportsContext jasperReportsContext = TableReport.this.fillContext.getFiller().getJasperReportsContext();
                    JRPropertiesUtil propUtil = JRPropertiesUtil.getInstance(jasperReportsContext);
                    String suffix = "";
                    JRSortField[] sortFields = TableReport.this.mainDataset.getSortFields();
                    if (sortFields != null) {
                        for (JRSortField sortField : sortFields) {
                            if (!sortField.getName().equals(name) || sortField.getType() != columnType) continue;
                            suffix = suffix + "" + (sortField.getOrderValue() == SortOrderEnum.ASCENDING ? propUtil.getProperty(TableReport.PROPERTY_UP_ARROW_CHAR) : (sortField.getOrderValue() == SortOrderEnum.DESCENDING ? propUtil.getProperty(TableReport.PROPERTY_DOWN_ARROW_CHAR) : ""));
                        }
                    }
                    if ((serializedFilters = TableReport.this.mainDataset.getPropertiesMap().getProperty("net.sf.jasperreports.filters")) != null && (existingFilters = JacksonUtil.getInstance(jasperReportsContext).loadList(serializedFilters, FieldFilter.class)) != null) {
                        ArrayList<FieldFilter> fieldFilters = new ArrayList<FieldFilter>();
                        SortElementHtmlHandler.getFieldFilters(new CompositeDatasetFilter(existingFilters), fieldFilters, name);
                        if (fieldFilters.size() > 0) {
                            suffix = suffix + "" + propUtil.getProperty(TableReport.PROPERTY_FILTER_CHAR);
                        }
                    }
                    if (suffix.length() > 0 && (evaluator = HeaderLabelUtil.alterHeaderLabel(frame, " " + suffix)) != null) {
                        TableReport.this.builtinEvaluators.put(evaluator.getExpression(), evaluator);
                    }
                }
                String columnName = name != null ? name : String.valueOf(columnIndex);
                String popupId = column.getUUID().toString();
                String popupColumn = columnName + "_" + columnIndex;
                if (this.firstColumn.compareAndSet(false, true)) {
                    this.addColumnLabelParameters(genericElement, TableReport.this.table);
                }
                genericElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.popupId", popupId);
                genericElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.columnIndex", Integer.toString(columnIndex));
                genericElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.sortColumnName", columnName);
                genericElement.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.tableUUID", TableReport.this.fillContext.getComponentElement().getUUID().toString());
                this.addElementParameter(genericElement, "sortColumnLabel", this.getColumnHeaderLabelExpression(header));
                frame.getPropertiesMap().setProperty("net.sf.jasperreports.export.html.class", "columnHeader header_" + columnName + "_" + column.hashCode() + (interactiveColumn ? " interactiveElement" : ""));
                frame.getPropertiesMap().setProperty("net.sf.jasperreports.export.html.popupid", popupId);
                frame.getPropertiesMap().setProperty("net.sf.jasperreports.export.html.popupcolumn", popupColumn);
                this.headerClasses.put(column.hashCode(), "column col_" + popupColumn);
                frame.addElement(genericElement);
            } else {
                String columnName = String.valueOf(columnIndex);
                String popupColumn = columnName + "_" + columnIndex;
                frame.getPropertiesMap().setProperty("net.sf.jasperreports.export.html.class", "columnHeader header_" + columnName + "_" + column.hashCode());
                frame.getPropertiesMap().setProperty("net.sf.jasperreports.export.html.popupid", column.getUUID().toString());
                frame.getPropertiesMap().setProperty("net.sf.jasperreports.export.html.popupcolumn", popupColumn);
            }
        }

        protected void addElementParameter(JRDesignGenericElement element, String name, Object value) {
            JRDesignGenericElementParameter param = new JRDesignGenericElementParameter();
            param.setName(name);
            JRDesignExpression valueExpression = TableReport.this.createBuiltinExpression(new ConstantBuiltinExpression(value));
            param.setValueExpression(valueExpression);
            element.addParameter(param);
        }

        protected void addElementParameter(JRDesignGenericElement element, String name, JRExpression expression) {
            JRDesignGenericElementParameter param = new JRDesignGenericElementParameter();
            param.setName(name);
            param.setValueExpression(expression);
            element.addParameter(param);
        }

        protected void addColumnLabelParameters(JRDesignGenericElement element, TableComponent table) {
            List<BaseColumn> columns = TableUtil.getAllColumns(table);
            int ln = columns.size();
            for (int i = 0; i < ln; ++i) {
                BaseColumn column = columns.get(i);
                JRExpression columnHeaderExpression = this.getColumnHeaderLabelExpression(column.getColumnHeader());
                boolean interactiveColumn = (Boolean)TableReport.this.columnInteractivityMapping.get(column) != false && TableUtil.getColumnDetailTextElement((Column)column) != null;
                String paramName = "column." + i + "|" + column.getUUID().toString() + "|" + interactiveColumn;
                this.addElementParameter(element, paramName, columnHeaderExpression);
            }
        }

        @Override
        protected Cell columnGroupCell(ColumnGroup group) {
            return group.getColumnHeader();
        }

        @Override
        protected ReportBandCreator createSubVisitor(FillColumn subcolumn, int xOffset, int yOffset, int sublevel) {
            return new ColumnHeaderCreator(this.bandInfo, subcolumn, xOffset, yOffset, sublevel, TableReport.this.headerHtmlClasses, this.firstColumn);
        }
    }

    protected class DetailBandCreator
    extends ReportBandCreator {
        public DetailBandCreator(ReportBandInfo bandInfo, FillColumn fillColumn, int xOffset, int yOffset, int level) {
            super(bandInfo, fillColumn, xOffset, yOffset, level);
        }

        @Override
        protected Cell columnCell(Column column) {
            return column.getDetailCell();
        }

        @Override
        protected Cell columnGroupCell(ColumnGroup group) {
            return null;
        }

        @Override
        protected ReportBandCreator createSubVisitor(FillColumn subcolumn, int xOffset, int yOffset, int sublevel) {
            return new DetailBandCreator(this.bandInfo, subcolumn, xOffset, yOffset, sublevel);
        }

        @Override
        protected boolean isEmpty(Cell cell) {
            if (super.isEmpty(cell)) {
                return true;
            }
            List<JRChild> children = cell.getChildren();
            return cell.getHeight() == 0 && (children == null || children.isEmpty());
        }
    }

    protected abstract class ReverseReportBandCreator
    extends ReportBandCreator {
        public ReverseReportBandCreator(ReportBandInfo bandInfo, FillColumn fillColumn, int xOffset, int yOffset, int level) {
            super(bandInfo, fillColumn, xOffset, yOffset, level);
        }

        @Override
        public Void visitColumnGroup(ColumnGroup columnGroup) {
            Cell cell = this.columnGroupCell(columnGroup);
            int rowSpan = cell == null ? 0 : (cell.getRowSpan() == null ? 1 : cell.getRowSpan());
            int origXOffset = this.xOffset;
            int origYOffset = this.yOffset;
            for (FillColumn subcolumn : this.fillColumn.getSubcolumns()) {
                ReportBandCreator subVisitor = this.createSubVisitor(subcolumn, this.xOffset, origYOffset, this.level + rowSpan);
                subVisitor.visit();
                this.xOffset = subVisitor.xOffset;
                if (subVisitor.yOffset <= this.yOffset) continue;
                this.yOffset = subVisitor.yOffset;
            }
            if (cell != null) {
                int rowLevel = this.level + rowSpan - 1;
                JRDesignElementGroup elementGroup = this.bandInfo.getRowElementGroup(rowLevel);
                JRElement cellElement = TableReport.this.createCell(elementGroup, cell, columnGroup.getWidth(), this.fillColumn.getWidth(), origXOffset, this.yOffset, null, false);
                elementGroup.addElement(cellElement);
                this.bandInfo.elementAdded(cellElement);
                this.yOffset += cell.getHeight().intValue();
            }
            return null;
        }
    }

    protected abstract class ReportBandCreator
    implements ColumnVisitor<Void> {
        final ReportBandInfo bandInfo;
        final FillColumn fillColumn;
        int xOffset;
        int yOffset;
        int level;

        public ReportBandCreator(ReportBandInfo bandInfo, FillColumn fillColumn, int xOffset, int yOffset, int level) {
            this.bandInfo = bandInfo;
            this.fillColumn = fillColumn;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.level = level;
        }

        protected boolean isEmpty(Cell cell) {
            return cell == null;
        }

        @Override
        public Void visitColumn(Column column) {
            Cell cell = this.columnCell(column);
            if (!this.isEmpty(cell)) {
                int rowSpan = cell.getRowSpan() == null ? 1 : cell.getRowSpan();
                int rowLevel = this.level + rowSpan - 1;
                JRDesignElementGroup elementGroup = this.bandInfo.getRowElementGroup(rowLevel);
                JRElement cellElement = this.createColumnCell(column, elementGroup, cell);
                elementGroup.addElement(cellElement);
                this.bandInfo.elementAdded(cellElement);
                this.yOffset += cell.getHeight().intValue();
            }
            this.xOffset += column.getWidth().intValue();
            return null;
        }

        protected abstract Cell columnCell(Column var1);

        protected JRElement createColumnCell(Column column, JRElementGroup parentGroup, Cell cell) {
            return this.createColumnCell(column, parentGroup, cell, false);
        }

        protected JRElement createColumnCell(Column column, JRElementGroup parentGroup, Cell cell, boolean forceFrame) {
            return TableReport.this.createCell(parentGroup, cell, column.getWidth(), this.fillColumn.getWidth(), this.xOffset, this.yOffset, column.hashCode(), forceFrame);
        }

        @Override
        public Void visitColumnGroup(ColumnGroup columnGroup) {
            Cell cell = this.columnGroupCell(columnGroup);
            int cellHeight = 0;
            int sublevel = this.level;
            if (cell != null) {
                int rowSpan = cell.getRowSpan() == null ? 1 : cell.getRowSpan();
                int rowLevel = this.level + rowSpan - 1;
                JRDesignElementGroup elementGroup = this.bandInfo.getRowElementGroup(rowLevel);
                JRElement cellElement = TableReport.this.createCell(elementGroup, cell, columnGroup.getWidth(), this.fillColumn.getWidth(), this.xOffset, this.yOffset, null, false);
                elementGroup.addElement(cellElement);
                this.bandInfo.elementAdded(cellElement);
                cellHeight = cell.getHeight();
                sublevel += rowSpan;
            }
            for (FillColumn subcolumn : this.fillColumn.getSubcolumns()) {
                ReportBandCreator subVisitor = this.createSubVisitor(subcolumn, this.xOffset, this.yOffset + cellHeight, sublevel);
                subVisitor.visit();
                this.xOffset = subVisitor.xOffset;
            }
            return null;
        }

        protected abstract Cell columnGroupCell(ColumnGroup var1);

        protected abstract ReportBandCreator createSubVisitor(FillColumn var1, int var2, int var3, int var4);

        public void visit() {
            this.fillColumn.getTableColumn().visitColumn(this);
        }
    }

    protected class ReportBandInfo {
        final JRDesignBand band;
        final List<JRDesignElementGroup> rowGroups = new ArrayList<JRDesignElementGroup>();

        ReportBandInfo(JRDesignBand band) {
            this.band = band;
        }

        protected void elementAdded(JRElement element) {
            if (this.band.getHeight() < element.getHeight() + element.getY()) {
                this.band.setHeight(element.getHeight() + element.getY());
            }
        }

        JRDesignElementGroup getRowElementGroup(int rowLevel) {
            int rowCount = this.rowGroups.size();
            if (rowLevel >= rowCount) {
                for (int level = rowCount; level <= rowLevel; ++level) {
                    JRDesignElementGroup group = new JRDesignElementGroup();
                    this.band.addElementGroup(group);
                    this.rowGroups.add(group);
                }
            }
            return this.rowGroups.get(rowLevel);
        }
    }
}

