/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.analytics.dataset;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.analytics.dataset.DataLevelBucket;
import net.sf.jasperreports.engine.analytics.dataset.DataLevelBucketProperty;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.type.SortOrderEnum;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class BaseDataLevelBucket
implements DataLevelBucket,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected String valueClassName;
    protected String valueClassRealName;
    protected Class<?> valueClass;
    protected SortOrderEnum orderValue = SortOrderEnum.ASCENDING;
    protected JRExpression expression;
    protected JRExpression comparatorExpression;
    protected List<DataLevelBucketProperty> bucketProperties;

    protected BaseDataLevelBucket() {
        this.bucketProperties = new ArrayList<DataLevelBucketProperty>();
    }

    public BaseDataLevelBucket(DataLevelBucket bucket, JRBaseObjectFactory factory) {
        factory.put(bucket, this);
        this.valueClassName = bucket.getValueClassName();
        this.orderValue = bucket.getOrderValue();
        this.expression = factory.getExpression(bucket.getExpression());
        this.comparatorExpression = factory.getExpression(bucket.getComparatorExpression());
        List<DataLevelBucketProperty> properties = bucket.getBucketProperties();
        this.bucketProperties = new ArrayList<DataLevelBucketProperty>(properties.size());
        for (DataLevelBucketProperty property : properties) {
            this.bucketProperties.add(factory.getDataLevelBucketProperty(property));
        }
    }

    @Override
    public String getValueClassName() {
        return this.valueClassName;
    }

    @Override
    public SortOrderEnum getOrderValue() {
        return this.orderValue;
    }

    @Override
    public JRExpression getExpression() {
        return this.expression;
    }

    @Override
    public JRExpression getComparatorExpression() {
        return this.comparatorExpression;
    }

    @Override
    public Class<?> getValueClass() {
        String className;
        if (this.valueClass == null && (className = this.getValueClassRealName()) != null) {
            try {
                this.valueClass = JRClassLoader.loadClassForName(className);
            }
            catch (ClassNotFoundException e) {
                throw new JRRuntimeException("Could not load bucket value class", e);
            }
        }
        return this.valueClass;
    }

    private String getValueClassRealName() {
        if (this.valueClassRealName == null) {
            this.valueClassRealName = JRClassLoader.getClassRealName(this.valueClassName);
        }
        return this.valueClassRealName;
    }

    @Override
    public List<DataLevelBucketProperty> getBucketProperties() {
        return this.bucketProperties;
    }

    @Override
    public Object clone() {
        BaseDataLevelBucket clone = null;
        try {
            clone = (BaseDataLevelBucket)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.expression = JRCloneUtils.nullSafeClone(this.expression);
        clone.comparatorExpression = JRCloneUtils.nullSafeClone(this.comparatorExpression);
        clone.bucketProperties = JRCloneUtils.cloneList(this.bucketProperties);
        return clone;
    }
}

