/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.expressions.functions;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import net.sf.jasperreports.expressions.annotations.JRExprFunction;
import net.sf.jasperreports.expressions.annotations.JRExprFunctionCategories;
import net.sf.jasperreports.expressions.annotations.JRExprFunctionParameter;
import net.sf.jasperreports.expressions.annotations.JRExprFunctionParameters;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.LocalTime;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.Weeks;
import org.joda.time.Years;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class DateTimeFunctions {
    @JRExprFunction(name="TODAY", description="Returns the current date as date object.")
    @JRExprFunctionCategories(value={"DATE_TIME"})
    public static Date TODAY() {
        return new Date();
    }

    @JRExprFunction(name="NOW", description="Returns the current instant as date object.")
    @JRExprFunctionCategories(value={"DATE_TIME"})
    public static Date NOW() {
        return new Date();
    }

    @JRExprFunction(name="YEAR", description="Returns the year of a given date. Date object can be a String, long value (millis) or Date instance itself.")
    @JRExprFunctionCategories(value={"DATE_TIME"})
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Date object", description="The object representing the date.")})
    public static Integer YEAR(Object dateObject) {
        return DateTimeFunctions.getCalendarFieldFromDate(dateObject, 1);
    }

    @JRExprFunction(name="MONTH", description="Returns the month of a given date. Date object can be a String, long value (millis) or Date instance itself.")
    @JRExprFunctionCategories(value={"DATE_TIME"})
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Date object", description="The object representing the date.")})
    public static Integer MONTH(Object dateObject) {
        return DateTimeFunctions.getCalendarFieldFromDate(dateObject, 2) + 1;
    }

    @JRExprFunction(name="DAY", description="Returns the day of a given date. Date object can be a String, long value (millis) or Date instance itself.")
    @JRExprFunctionCategories(value={"DATE_TIME"})
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Date object", description="The object representing the date.")})
    public static Integer DAY(Object dateObject) {
        return DateTimeFunctions.getCalendarFieldFromDate(dateObject, 5);
    }

    @JRExprFunction(name="WEEKDAY", description="Returns the day of the week for a given date. Date object can be a String, long value (millis) or Date instance itself.")
    @JRExprFunctionCategories(value={"DATE_TIME"})
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Date object", description="The object representing the date."), @JRExprFunctionParameter(name="Sunday is first day", description="Boolean flag to decide if sunday should be considered as first dayDefault is not.")})
    public static Integer WEEKDAY(Object dateObject) {
        return DateTimeFunctions.WEEKDAY(dateObject, false);
    }

    public static Integer WEEKDAY(Object dateObject, Boolean isSundayFirstDay) {
        Integer dayOfWeek = DateTimeFunctions.getCalendarFieldFromDate(dateObject, 7);
        if (dayOfWeek == null) {
            return null;
        }
        if (isSundayFirstDay.booleanValue()) {
            return dayOfWeek;
        }
        if (dayOfWeek == 1) {
            return 7;
        }
        return dayOfWeek - 1;
    }

    @JRExprFunction(name="HOUR", description="Returns the hour (0-23) of the day for a given date. Date object can be a String, long value (millis) or Date instance itself.")
    @JRExprFunctionCategories(value={"DATE_TIME"})
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Date object", description="The object representing the date.")})
    public static Integer HOUR(Object dateObject) {
        return DateTimeFunctions.getCalendarFieldFromDate(dateObject, 11);
    }

    @JRExprFunction(name="MINUTE", description="Returns the minute (0-59) of the hour for a given date. Date object can be a String, long value (millis) or Date instance itself.")
    @JRExprFunctionCategories(value={"DATE_TIME"})
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Date object", description="The object representing the date.")})
    public static Integer MINUTE(Object dateObject) {
        return DateTimeFunctions.getCalendarFieldFromDate(dateObject, 12);
    }

    @JRExprFunction(name="SECOND", description="Returns the second (0-59) of the minute for a given date. Date object can be a String, long value (millis) or Date instance itself.")
    @JRExprFunctionCategories(value={"DATE_TIME"})
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Date object", description="The object representing the date.")})
    public static Integer SECOND(Object dateObject) {
        return DateTimeFunctions.getCalendarFieldFromDate(dateObject, 13);
    }

    @JRExprFunction(name="DATE", description="Creates a date object using the specified information on day, month and year.")
    @JRExprFunctionCategories(value={"DATE_TIME"})
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Year", description="The year of the new date."), @JRExprFunctionParameter(name="Month", description="The month of the new date."), @JRExprFunctionParameter(name="Day", description="The day of the new date.")})
    public static Date DATE(Integer year, Integer month, Integer dayOfMonth) {
        if (year == null || month == null || dayOfMonth == null) {
            return null;
        }
        DateTime dt = new DateTime(year.intValue(), month.intValue(), dayOfMonth.intValue(), 0, 0, 0);
        return dt.toDate();
    }

    @JRExprFunction(name="DATEVALUE", description="Gives the corresponding numeric value (long milliseconds) for a specified date object.")
    @JRExprFunctionCategories(value={"DATE_TIME"})
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Date object", description="The object representing the date.")})
    public static Long DATEVALUE(Object dateObject) {
        Date convertedDate = DateTimeFunctions.convertDateObject(dateObject);
        return convertedDate != null ? Long.valueOf(convertedDate.getTime()) : null;
    }

    @JRExprFunction(name="TIME", description="Returns a text string representing a time value (hours, seconds and minutes). If no specific pattern is specified a default formatter is used.")
    @JRExprFunctionCategories(value={"DATE_TIME"})
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Hours", description="The hours for the new time value."), @JRExprFunctionParameter(name="Minutes", description="The minutes for the new time value."), @JRExprFunctionParameter(name="Seconds", description="The seconds for the new time value."), @JRExprFunctionParameter(name="Format pattern", description="The pattern to format the time value.")})
    public static String TIME(Integer hours, Integer minutes, Integer seconds) {
        return DateTimeFunctions.TIME(hours, minutes, seconds, null);
    }

    public static String TIME(Integer hours, Integer minutes, Integer seconds, String timePattern) {
        if (hours == null || minutes == null || seconds == null) {
            return null;
        }
        LocalTime lt = new LocalTime(hours.intValue(), minutes.intValue(), seconds.intValue());
        if (timePattern == null) {
            return lt.toString(DateTimeFormat.longTime());
        }
        try {
            DateTimeFormatter dtf = DateTimeFormat.forPattern((String)timePattern);
            return lt.toString(dtf);
        }
        catch (IllegalArgumentException ex) {
            return lt.toString(DateTimeFormat.longTime());
        }
    }

    @JRExprFunction(name="EDATE", description="Returns a date a number of months away.")
    @JRExprFunctionCategories(value={"DATE_TIME"})
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Date object", description="The object representing the date."), @JRExprFunctionParameter(name="Months", description="The number of months after the given date.")})
    public static Date EDATE(Object dateObject, Integer months) {
        Date convertedDate = DateTimeFunctions.convertDateObject(dateObject);
        if (convertedDate == null) {
            return null;
        }
        DateTime dt = new DateTime((Object)convertedDate);
        dt = dt.plusMonths(months.intValue());
        return dt.toDate();
    }

    @JRExprFunction(name="WORKDAY", description="Returns a date a number of workdays away. Saturday and Sundays are not considered working days.")
    @JRExprFunctionCategories(value={"DATE_TIME"})
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Date object", description="The object representing the date."), @JRExprFunctionParameter(name="Working days", description="The number of days after the given date.")})
    public static Date WORKDAY(Object dateObject, Integer workdays) {
        Date convertedDate = DateTimeFunctions.convertDateObject(dateObject);
        if (convertedDate == null) {
            return null;
        }
        DateTime cursorDT = new DateTime((Object)convertedDate);
        int remainingDays = workdays;
        while (remainingDays > 0) {
            int dayOfWeek = cursorDT.getDayOfWeek();
            if (dayOfWeek != 6 && dayOfWeek != 7) {
                --remainingDays;
            }
            cursorDT = cursorDT.plusDays(1);
        }
        return cursorDT.toDate();
    }

    @JRExprFunction(name="NETWORKDAYS", description="Returns the number of working days between two dates (inclusive).Saturday and Sundays are not considered working days.")
    @JRExprFunctionCategories(value={"DATE_TIME"})
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Start date", description="The initial date."), @JRExprFunctionParameter(name="End date", description="The end date.")})
    public static Integer NETWORKDAYS(Object startDate, Object endDate) {
        Date startDateObj = DateTimeFunctions.convertDateObject(startDate);
        Date endDateObj = DateTimeFunctions.convertDateObject(endDate);
        if (startDateObj == null || endDateObj == null) {
            return null;
        }
        DateTime cursorDateTime = new DateTime((Object)startDateObj);
        DateTime endDateTime = new DateTime((Object)endDateObj);
        int workingDays = 0;
        if (cursorDateTime.isAfter((ReadableInstant)endDateTime)) {
            DateTime tmp = cursorDateTime;
            cursorDateTime = endDateTime;
            endDateTime = tmp;
        }
        while (Days.daysBetween((ReadableInstant)cursorDateTime, (ReadableInstant)endDateTime).getDays() > 0) {
            int dayOfWeek = cursorDateTime.getDayOfWeek();
            if (dayOfWeek != 6 && dayOfWeek != 7) {
                ++workingDays;
            }
            cursorDateTime = cursorDateTime.plusDays(1);
        }
        return workingDays;
    }

    @JRExprFunction(name="DAYS", description="Returns the number of days between two dates.")
    @JRExprFunctionCategories(value={"DATE_TIME"})
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Start date", description="The initial date."), @JRExprFunctionParameter(name="End date", description="The end date.")})
    public static Integer DAYS(Object startDate, Object endDate) {
        Date startDateObj = DateTimeFunctions.convertDateObject(startDate);
        Date endDateObj = DateTimeFunctions.convertDateObject(endDate);
        if (startDateObj == null || endDateObj == null) {
            return null;
        }
        DateTime dt1 = new DateTime((Object)startDateObj);
        DateTime dt2 = new DateTime((Object)endDateObj);
        return Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
    }

    @JRExprFunction(name="DAYSINMONTH", description="Returns the number of days in a month.")
    @JRExprFunctionCategories(value={"DATE_TIME"})
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Selected date", description="The date to check.")})
    public static Integer DAYSINMONTH(Object dateObj) {
        Date date = DateTimeFunctions.convertDateObject(dateObj);
        if (date == null) {
            return null;
        }
        DateTime dt = new DateTime((Object)date);
        return dt.dayOfMonth().getMaximumValue();
    }

    @JRExprFunction(name="DAYSINYEAR", description="Returns the number of days in a year.")
    @JRExprFunctionCategories(value={"DATE_TIME"})
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Selected date", description="The date to check.")})
    public static Integer DAYSINYEAR(Object dateObj) {
        Date date = DateTimeFunctions.convertDateObject(dateObj);
        if (date == null) {
            return null;
        }
        DateTime dt = new DateTime((Object)date);
        return dt.dayOfYear().getMaximumValue();
    }

    @JRExprFunction(name="WEEKS", description="Returns the number of weeks between two dates.")
    @JRExprFunctionCategories(value={"DATE_TIME"})
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Start date", description="The initial date."), @JRExprFunctionParameter(name="End date", description="The end date.")})
    public static Integer WEEKS(Object startDate, Object endDate) {
        Date startDateObj = DateTimeFunctions.convertDateObject(startDate);
        Date endDateObj = DateTimeFunctions.convertDateObject(endDate);
        if (startDateObj == null || endDateObj == null) {
            return null;
        }
        DateTime dt1 = new DateTime((Object)startDateObj);
        DateTime dt2 = new DateTime((Object)endDateObj);
        return Weeks.weeksBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getWeeks();
    }

    @JRExprFunction(name="WEEKSINYEAR", description="Returns the number of weeks in a year.")
    @JRExprFunctionCategories(value={"DATE_TIME"})
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Selected date", description="The date to check.")})
    public static Integer WEEKSINYEAR(Object dateObj) {
        Date date = DateTimeFunctions.convertDateObject(dateObj);
        if (date == null) {
            return null;
        }
        DateTime dt = new DateTime((Object)date);
        return dt.weekOfWeekyear().getMaximumValue();
    }

    @JRExprFunction(name="WEEKNUM", description="Returns the week number of a given date.")
    @JRExprFunctionCategories(value={"DATE_TIME"})
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Selected date", description="The date to check.")})
    public static Integer WEEKNUM(Object dateObj) {
        Date date = DateTimeFunctions.convertDateObject(dateObj);
        if (date == null) {
            return null;
        }
        DateTime dt = new DateTime((Object)date);
        return dt.getWeekOfWeekyear();
    }

    @JRExprFunction(name="MONTHS", description="Returns the number of months between two dates.")
    @JRExprFunctionCategories(value={"DATE_TIME"})
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Start date", description="The initial date."), @JRExprFunctionParameter(name="End date", description="The end date.")})
    public static Integer MONTHS(Object startDate, Object endDate) {
        Date startDateObj = DateTimeFunctions.convertDateObject(startDate);
        Date endDateObj = DateTimeFunctions.convertDateObject(endDate);
        if (startDateObj == null || endDateObj == null) {
            return null;
        }
        DateTime dt1 = new DateTime((Object)startDateObj);
        DateTime dt2 = new DateTime((Object)endDateObj);
        return Months.monthsBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getMonths();
    }

    @JRExprFunction(name="YEARS", description="Returns the number of years between two dates.")
    @JRExprFunctionCategories(value={"DATE_TIME"})
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Start date", description="The initial date."), @JRExprFunctionParameter(name="End date", description="The end date.")})
    public static Integer YEARS(Object startDate, Object endDate) {
        Date startDateObj = DateTimeFunctions.convertDateObject(startDate);
        Date endDateObj = DateTimeFunctions.convertDateObject(endDate);
        if (startDateObj == null || endDateObj == null) {
            return null;
        }
        DateTime dt1 = new DateTime((Object)startDateObj);
        DateTime dt2 = new DateTime((Object)endDateObj);
        return Years.yearsBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getYears();
    }

    @JRExprFunction(name="ISLEAPYEAR", description="Checks if the given date occurs in a leap year.")
    @JRExprFunctionCategories(value={"DATE_TIME"})
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Selected date", description="The date to check.")})
    public static Boolean ISLEAPYEAR(Object dateObj) {
        Date date = DateTimeFunctions.convertDateObject(dateObj);
        if (date == null) {
            return null;
        }
        DateTime dt = new DateTime((Object)date);
        return dt.year().isLeap();
    }

    @JRExprFunction(name="DATEFORMAT", description="Format the specified date object using the chosen format pattern")
    @JRExprFunctionCategories(value={"DATE_TIME"})
    @JRExprFunctionParameters(value={@JRExprFunctionParameter(name="Selected date", description="The date to format."), @JRExprFunctionParameter(name="Format pattern", description="Format pattern to apply when printing the date.")})
    public static String DATEFORMAT(Date dateObj, String formatPattern) {
        if (dateObj == null) {
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)formatPattern);
        DateTime dt = new DateTime((Object)dateObj);
        return dt.toString(formatter);
    }

    private static Date convertDateObject(Object dateObject) {
        if (dateObject == null) {
            return null;
        }
        if (dateObject instanceof String) {
            SimpleDateFormat simpleFormat = new SimpleDateFormat();
            try {
                return simpleFormat.parse((String)dateObject);
            }
            catch (ParseException e) {
                return null;
            }
        }
        if (dateObject instanceof Long) {
            return new Date((Long)dateObject);
        }
        if (dateObject instanceof Date) {
            return (Date)dateObject;
        }
        return null;
    }

    private static Integer getCalendarFieldFromDate(Object dateObject, int field) {
        Date convertedDate = DateTimeFunctions.convertDateObject(dateObject);
        if (convertedDate == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(convertedDate);
        return cal.get(field);
    }
}

